#!/bin/sh
# 
#netConfig.sh --modDrv --hostName ezdvr001 --macStr 00:72:3f:28:0a:16 --ipStr 192.168.0.220 --maskStr 255.255.255.0 --gwStr 192.168.0.1 --dynamic 
#
#    hostName="Ezdvr001"
#    macStr="00:72:3f:28:0a:16"
#    ipStr="192.168.0.220"
#    maskStr="255.255.255.0"
#    gwStr="192.168.0.1"
#    ip_mode="0"
#
	while [ ! -z "$1" ]; do
		case $1 in
			"--hostName")  hostName=$2;  shift 2;;
			"--macStr")    macStr=$2;    shift 2;;
			"--ipStr")     ipStr=$2;     shift 2;;
			"--maskStr")   maskStr=$2;   shift 2;;
			"--gwStr")     gwStr=$2;     shift 2;;
			"--dynamic")   dynamicIP=y;  shift 1;;			
			"--modDrv")    modDrv=y;     shift 1;;			
			*)			
					echo "ERROR: too many arguments: $1";
					return 1;;
		esac
	done
#	
#	echo "$hostName  $macStr $ipStr $maskStr $gwStr $ip_mode"
#
#  
#
if [ "X${modDrv}" == "Xy" ]; then
   modprobe dw_stmmac
   echo "modprobe dw_stmmac"
fi

if [ "X${hostName}" != "X" ]; then
   hostname $hostName
   echo "hostname $hostName"
fi 

if [ "X${macStr}" != "X" ]; then
   ifconfig eth0 hw ether  $macStr
   echo "ifconfig eth0 hw ether  $macStr"
fi 

if [ "X${ipStr}" != "X" ]; then
   ifconfig eth0 $ipStr up
   echo "ifconfig eth0 $ipStr up"
fi 

if [ "X${maskStr}" != "X" ]; then
   ifconfig eth0 netmask $maskStr up
   echo "ifconfig eth0 $maskStr up"
fi 

if [ "X${gwStr}" != "X" ]; then
   route  add default gw $gwStr eth0
   echo "route  add default gw $gwStr eth0"
fi 

if [ "X${dynamicIP}" == "Xy" ]; then
   ifconfig eth0 -dynamic up
   echo "ifconfig eth0 -dynamic up"
fi 