#!/bin/sh

UPGRADE_FROM=$1/upgrade
UPGRADE_SH=$1/upgrade/App_Upgrade.sh
UPGRADE_TO=/ezdvr
BACK_TO=/ezdvr
UPGRAGE_LOG=${BACK_TO}/upgrade.log

echo $1
echo $2

if [ -d ${UPGRADE_FROM} ]; then
	 rm -rf ${UPGRADE_FROM}
fi
mkdir -p ${UPGRADE_FROM}
if [ -d $2 ]; then
   cp -rfp $2/*  ${UPGRADE_FROM}/
   if [ $? -ne 0 ];    then
      exit $? 
   fi   
else   
   tar -xf $2 -C ${UPGRADE_FROM}
   if [ $? -ne 0 ];    then
      exit $?  
   fi
fi   

#backup app
if [ ! -d $2 ]; then
   #mv -f  /ezdvr/ezdvr  /ezdvr/ezdvr_bak
   cp -f ${BACK_TO}/ezdvr ${BACK_TO}/ezdvr_bak
   if [ $? -eq 0 ];    then
      echo "1" > ${UPGRAGE_LOG}
   else
      exit $?  
   fi
   
   cp -f ${BACK_TO}/ezupgrade ${BACK_TO}/ezupgrade_bak
   if [ $? -eq 0 ];    then
      echo "2" > ${UPGRAGE_LOG}
   else
      exit $?  
   fi
   
   cp -f ${BACK_TO}/etc/ez_config.xml ${BACK_TO}/etc/ez_config.bak
   if [ $? -eq 0 ];    then
      echo "3" > ${UPGRAGE_LOG}
   else
      exit $?  
   fi
   
   cp -f ${BACK_TO}/app_start.sh ${BACK_TO}/app_start.bak
   if [ $? -eq 0 ];    then
      echo "4" > ${UPGRAGE_LOG}
   else
      exit $?  
   fi
fi

if [ -e ${UPGRADE_SH} ]
then
   chmod 777 ${UPGRADE_SH};
   if [ -x ${UPGRADE_SH} ]
   then
      echo "excute ${UPGRADE_SH} ...\n";
      ${UPGRADE_SH};
   		if [ "X$?" != "X0" ]; then 
					echo "\nERROR: Failed to excute ${UPGRADE_SH} ...\n"; 
					exit 30 
			else
			    echo "0" > ${UPGRAGE_LOG};
			fi
	 else
	    echo "err,can't excute ${UPGRADE_SH}\n";
	    exit 31
	 fi		
	 
else
   cp -rfp ${UPGRADE_FROM}/*  ${UPGRADE_TO}
   if [ $? -eq 0 ];    then
      echo "ezdvr done"
   else
      exit $?     
   fi
   
   mount | grep '/data'
   if [ $? -eq 0 ];    then  
      if [ ! -d /data/${UPGRADE_TO} ]; then
	       mkdir -p /data/${UPGRADE_TO}
      fi
 
      cp -rfp ${UPGRADE_FROM}/*  /data/${UPGRADE_TO}
      if [ $? -eq 0 ];    then
         echo "data done"
      else
         exit $?     
      fi
   fi  
  
   echo "0" > ${UPGRAGE_LOG}
fi
   
rm -r ${UPGRADE_FROM}
rm -f /tmp/ezdvr



