// DDRender.h: interface for the CDDRender class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_DDRENDER_H__011538A1_A2A1_11D5_976B_000102579221__INCLUDED_)
#define AFX_DDRENDER_H__011538A1_A2A1_11D5_976B_000102579221__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <ddraw.h>
#define MAX_CHANNEL 16

class CDDRender  
{
public:  
	void SettingResolution(UINT nWidth, UINT nHeight);
  //-----------------------------------------------------------------------------------------
  CDDRender();
  virtual ~CDDRender();
  //-----------------------------------------------------------------------------------------
  void DestroyDDraw();
  int Render(UINT nCh, unsigned char* pbuffer);
  BOOL Init( HWND hwnd, int nwidth, int nheight);
  void SetDisplaySize( int nwidth, int nheight );
  //-----------------------------------------------------------------------------------------

private:
  //-----------------------------------------------------------------------------------------
  LPDIRECTDRAW7			m_pDD;			// DirectDraw object
  LPDIRECTDRAWSURFACE7  m_pDDSPrimary;  // DirectDraw primary surface
  LPDIRECTDRAWSURFACE7  m_pDDSVideo;    // DirectDraw offscreen surface for video

  
  LPDIRECTDRAWCLIPPER   m_pClipper;     // DirectDraw Clipper for primary surface
  DDBLTFX				m_DDBltFx;      // DirectDraw Blt FX structure
  DWORD                 m_BltFlags;     // DirectDraw Blt flags variable
  //-----------------------------------------------------------------------------------------
  BOOL  m_bProgressive;
  BOOL  m_bIsInitialized;
  HWND  m_hVideoWnd;
  int   m_nWidth, m_nHeight, m_nMemoryHeight, m_nDoubleWidth;
  RECT  m_rcMemory, m_rcDisplay[MAX_CHANNEL];
  //-----------------------------------------------------------------------------------------    
  DWORD  DDColorMatch(IDirectDrawSurface7 * pdds, COLORREF rgb);
  //-----------------------------------------------------------------------------------------
};

#endif // !defined(AFX_DDRENDER_H__011538A1_A2A1_11D5_976B_000102579221__INCLUDED_)
