// XvidDecode.cpp: implementation of the CXvidDecode class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "XvidDecode.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#include "xvid.h"
#include "DDRender.h"

BYTE glBufStrh[30] = {0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x20, 0x02, 0x48, 0x0d, 0xc0, 0x00, 0x40, 0x00, 0x40,
					  0x00, 0x40, 0x00, 0x80, 0x00, 0x97, 0x53, 0x0a, 0x2c, 0x08, 0x3c, 0x28, 0x8c, 0x1f};

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CXvidDecode::CXvidDecode()
{
	m_hXvidDec = NULL;
}

CXvidDecode::~CXvidDecode()
{
	if( m_hXvidDec != NULL) {
		Xvid_Destroy();
	}
}

void CXvidDecode::Xvid_Init(UINT nMaxChannel)
{
	UINT i;

	if( m_hXvidDec != NULL) {
		Xvid_Destroy();
	}

	m_pFirstFrame = new bool[nMaxChannel];
	for( i=0; i<nMaxChannel; i++) {
		m_pFirstFrame[i] = TRUE;
	}

	xvid_gbl_init_t xvid_gbl_init;
	xvid_dec_create_t xvid_dec_create;

	xvid_gbl_init.version = XVID_VERSION;
	xvid_gbl_init.cpu_flags = 0;
	xvid_global (NULL, 0, &xvid_gbl_init, NULL);

	xvid_dec_create.version = XVID_VERSION;

	xvid_dec_create.width = 0;
	xvid_dec_create.height = 0;

	m_nMaxChannel = nMaxChannel;
	m_hXvidDec = new HANDLE[nMaxChannel];
	for ( i=0; i<nMaxChannel; i++)
	{
		if (xvid_decore(NULL, XVID_DEC_CREATE, &xvid_dec_create, NULL) < 0)
		{
			AfxMessageBox ("Decoder Initialization Failed");
		}

		m_hXvidDec[i] = xvid_dec_create.handle;
	}
}

void CXvidDecode::Decode_xvid(UINT nCh, UINT nWidth, UINT nHeight, BYTE* pbuf, BYTE* pOutBuf, DWORD nSize)
{
	static xvid_dec_stats_t xvid_dec_stats;
	static xvid_dec_frame_t xvid_dec_frame;
	DWORD nUsedBytes;
	int nstride;

	xvid_dec_frame.version = XVID_VERSION;
	xvid_dec_stats.version = XVID_VERSION;
	xvid_dec_frame.general = XVID_LOWDELAY;
	xvid_dec_frame.output.csp = XVID_CSP_YUY2;
	nstride = nWidth * 2;

	xvid_dec_frame.brightness = 0;

	if(m_pFirstFrame[nCh]){
		bool bInterlace = FALSE;
		if(nHeight >= 480){
			bInterlace = TRUE;
		}
		MakeMP4SeqHdr(nWidth, nHeight, bInterlace);
		xvid_dec_frame.bitstream = &glBufStrh[0];
		xvid_dec_frame.length = sizeof(glBufStrh);
		xvid_dec_frame.output.plane[0] = 0;
		xvid_dec_frame.output.stride[0] = nstride;

		xvid_dec_frame.general = XVID_LOWDELAY;
		nUsedBytes = xvid_decore (m_hXvidDec[nCh], XVID_DEC_DECODE,
			&xvid_dec_frame, &xvid_dec_stats);
		m_pFirstFrame[nCh] = FALSE;
	}
	if(!m_pFirstFrame[nCh]){
		xvid_dec_frame.bitstream = pbuf;
		xvid_dec_frame.length = nSize;
		xvid_dec_frame.output.plane[0] = pOutBuf;
		xvid_dec_frame.output.stride[0] = nstride;

		xvid_dec_frame.general = XVID_LOWDELAY;
		nUsedBytes = xvid_decore (m_hXvidDec[nCh], XVID_DEC_DECODE,
			&xvid_dec_frame, &xvid_dec_stats);
	}
}

void CXvidDecode::Xvid_Destroy()
{
	if(m_hXvidDec == NULL) {
		return;
	}

	for (UINT i=0; i<m_nMaxChannel; i++)
	{
		if(m_hXvidDec[i])	xvid_decore (m_hXvidDec[i], XVID_DEC_DESTROY, NULL, NULL);
	}

	delete[] m_hXvidDec;
	m_hXvidDec = NULL;

	delete[] m_pFirstFrame;
	m_pFirstFrame = NULL;
}

void CXvidDecode::MakeMP4SeqHdr(int szH, int szV, int bInterlace)
{
	glBufStrh[23] = 0x0a + (szH >> 12);
	glBufStrh[24] = ((szH >> 4) & 0xff);
	glBufStrh[25] = (((szH >> 0) & 0xf) << 4) +0x8 + ((szV >> 10) & 0x7);
	glBufStrh[26] = ((szV >> 2) & 0xff);
	if (bInterlace)
	{
		glBufStrh[27] = (((szV >> 0) & 0x3) << 6) + 0x38;
	}
	else
	{
		glBufStrh[27] = (((szV >> 0) & 0x3) << 6) + 0x28;
	}
}
