/* vim:set ft=cpp ts=4 sw=4 sts=4 sta ai bs=2: */
#if !defined(AFX_DECODER_H__8624A2C2_A822_11D5_9099_000102579221__INCLUDED_)
#define AFX_DECODER_H__8624A2C2_A822_11D5_9099_000102579221__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// Decoder.h : header file
//
#include <mmsystem.h>           // Multimedia Timer...
#include "DDRender.h"
#include "AVCodec.h"

#define I_PICTURE 0	// intra-coded
#define P_PICTURE 1	// predictive-coded
#define B_PICTURE 2	// bidirectionally-predictive-coded

#define MAX_CHANNEL 16

#define NTSC_RESOLUTION_720240	(0x00 + 0)		// 720 x 240
#define NTSC_RESOLUTION_360240	(0x00 + 1)		// 360 x 240
#define NTSC_RESOLUTION_720480	(0x00 + 2)		// 720 x 240

#define PAL_RESOLUTION_720240	(0x04 + 0)		// 720 x 288
#define PAL_RESOLUTION_360240	(0x04 + 1)		// 360 x 288
#define PAL_RESOLUTION_720480	(0x04 + 2)		// 720 x 576

/////////////////////////////////////////////////////////////////////////////
// CDecoder window

class CDecoder
{
// Construction
public:
  CDecoder();

// Attributes
public:

// Operations
public:

// Overrides
  // ClassWizard generated virtual function overrides
  //{{AFX_VIRTUAL(CDecoder)
  public:
  //}}AFX_VIRTUAL

// Implementation
public:
	CWnd* m_pControlImageDraw;
	void MemInit();
	void SetImageSize(UINT nResolution);
	BOOL SettingResolution(UINT nch);
	UINT m_nImageHeight;
	UINT m_nImageWidth;
	BOOL DecodePicture( UINT nch, int ntype, BYTE* pbybuf, DWORD dwLength);
	//--------------------------------------------------------------
	void  setDisplaySize(UINT nCh, int nwidth, int nheight);
	//--------------------------------------------------------------  
	void  Deinitialize();
	void  RedrawVideo(UINT nCh);  
	//--------------------------------------------------------------  
	virtual ~CDecoder();

	// Generated message map functions
protected:

private:
	BOOL m_bMemInit;
	BOOL m_bDDrawInit;
	DWORD m_dwLength[MAX_CHANNEL];
	// display picture pointer
	BYTE *m_pbyYUY2[MAX_CHANNEL];
	CDDRender* m_render[MAX_CHANNEL];
	CAVCodec m_avCodec;
	//--------------------------------------------------------------
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_DECODER_H__8624A2C2_A822_11D5_9099_000102579221__INCLUDED_)
