#include <string.h>
#include "H264SeqHdr.h"

static const unsigned char GL_BUF_SEQH_704x480[22] = {
	0x00, 0x00, 0x00, 0x01, 0x67, 0x42, 0x00, 0x1e, 0x9a, 0x74,
	0x05, 0x81, 0xec, 0x80, 0x00, 0x00, 0x00, 0x01, 0x68, 0xce, 0x3a, 0x80
};

static const unsigned char GL_BUF_SEQH_704x240[21] = {
	0x00, 0x00, 0x00, 0x01, 0x67, 0x42, 0x00, 0x1e, 0x9a, 0x74,
	0x05, 0x83, 0xf2,
	0x00, 0x00, 0x00, 0x01, 0x68, 0xce, 0x3a, 0x80
};

static const unsigned char GL_BUF_SEQH_352x240[21] = {
	0x00, 0x00, 0x00, 0x01, 0x67, 0x42, 0x00, 0x1e, 0x9a, 0x74,
	0x0b, 0x0f, 0xc8,
	0x00, 0x00, 0x00, 0x01, 0x68, 0xce, 0x3a, 0x80
};

static const unsigned char GL_BUF_SEQH_704x576[22] = {
	0x00, 0x00, 0x00, 0x01, 0x67, 0x42, 0x00, 0x1e, 0x9a, 0x74,
	0x05, 0x80, 0x93, 0x20,
	0x00, 0x00, 0x00, 0x01, 0x68, 0xce, 0x3a, 0x80
};

static const unsigned char GL_BUF_SEQH_704x288[22] = {
	0x00, 0x00, 0x00, 0x01, 0x67, 0x42, 0x00, 0x1e, 0x9a, 0x74,
	0x05, 0x81, 0x2c, 0x80,
	0x00, 0x00, 0x00, 0x01, 0x68, 0xce, 0x3a, 0x80
};

static const unsigned char GL_BUF_SEQH_352x288[21] = {
	0x00, 0x00, 0x00, 0x01, 0x67, 0x42, 0x00, 0x1e, 0x9a, 0x74,
	0x0b, 0x04, 0xb2,
	0x00, 0x00, 0x00, 0x01, 0x68, 0xce, 0x3a, 0x80
};

/*! \brief : FFMpeg  Decode Frame  ػ󵵿   Ͽ .(for I-Frame)
*  \param : buf  Ͱ  
*  \param : dwsize :   ũ
*  \param : width :  width
*  \param : height :  height
*  \return :  decoder Ѱϴ ( + Raw(dwSize))
*/
unsigned long MakeDecodeFrame(unsigned char* const buf, unsigned long dwSize, int width, int height)
{
	unsigned long dwHeaderSize;
	const unsigned char* header;

	if(width == 704 && height == 480){
		dwHeaderSize = sizeof(GL_BUF_SEQH_704x480);
		header = GL_BUF_SEQH_704x480;
	} else if(width == 704 && height == 240){
		dwHeaderSize = sizeof(GL_BUF_SEQH_704x240);
		header = GL_BUF_SEQH_704x240;
	} else if(width == 352 && height == 240){
		dwHeaderSize = sizeof(GL_BUF_SEQH_352x240);
		header = GL_BUF_SEQH_352x240;
	} else if(width == 704 && height == 576){
		dwHeaderSize = sizeof(GL_BUF_SEQH_704x576);
		header = GL_BUF_SEQH_704x576;
	} else if(width == 704 && height == 288){
		dwHeaderSize = sizeof(GL_BUF_SEQH_704x288);
		header = GL_BUF_SEQH_704x288;
	} else if(width == 352 && height == 288){
		dwHeaderSize = sizeof(GL_BUF_SEQH_352x288);
		header = GL_BUF_SEQH_352x288;
	} else {
		dwHeaderSize = 0;
		header = NULL;
	}

	memmove(buf + dwHeaderSize, buf, dwSize);
	memcpy(buf, header, dwHeaderSize);

	return (dwSize + dwHeaderSize);
}