// HttpInterface.h: interface for the CHttpInterface class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_HTTPINTERFACE_H__4A1FBD5B_E372_4CE6_8413_17972BB70F08__INCLUDED_)
#define AFX_HTTPINTERFACE_H__4A1FBD5B_E372_4CE6_8413_17972BB70F08__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "wininet.h"
#pragma comment(lib, "wininet.lib")

#include "winsock2.h"
#pragma comment(lib, "ws2_32.lib")

#include "Decoder.h"
#include "ReceiveDataParse.h"

#define MAX_CHANNEL_NAME 13

#define PACKET_FIRST_BYTE 0xFB
#define PACKET_SECOND_BYTE 0xFB
#define PACKET_THIRD_BYTE 0xFB

#define PACKET_START_BYTE 0xFC
#define PACKET_END_BYTE 0xFD

#pragma pack(push, 1)
typedef struct _FRAME_HEADER
{
	BYTE marker[2];
	unsigned long headersize;
	unsigned short version;
	
	unsigned long packetsize;	//  Ŷ (RAW_HEADER + M4_SIZE)
	
	BYTE info;
	BYTE recordReason;
	unsigned short videoLoss;
	BYTE model_info;
	
	unsigned long VE_STATUS0;
	unsigned long VE_STATUS1;
	unsigned long VE_STATUS2;
	unsigned long VE_STATUS3;
	unsigned long VE_STATUS4;
	unsigned long VE_STATUS5;
	unsigned long VE_STATUS6;
	unsigned long VE_STATUS7;
	unsigned long VE_STATUS8;
	unsigned long VE_STATUS9;
	unsigned long VE_STATUS10;
	unsigned long VE_STATUS11;
	
	BYTE dummy[15];
}FRAME_HEADER;

typedef struct _DVRINFO
{
	BYTE  nCHInfo;	//ä 
	BYTE  nPTZInfo;
	WORD  bmChannel;
	BYTE  reserved1;
	BYTE  reserved2;
	BYTE  strCHName[MAX_CHANNEL][MAX_CHANNEL_NAME];
}DVRINFO;

#pragma pack()

class CHttpInterface  
{
public:
	friend DWORD WINAPI SendCGICommandConnectThread(LPVOID lParam);
	friend UINT MpegThreadProc(LPVOID lParam);
public:
	void RedrawVideo(UINT nCH);
	void DisconnectedDVR();
	void ConnectDVR(CString strDVRIPAddress, CString strPort, CString strUser, CString strPassword);
	BOOL IsConnected()	{return m_bConnect;};
	CHttpInterface(CWnd* pWnd);
	virtual ~CHttpInterface();

private:
	void DisplayTime(timeval* time);
	HINTERNET m_hSendCGIInternetOpen;
	HINTERNET m_hSendCGIHttp;
	HINTERNET m_hSendCGIRequest;
	CString m_strSendCgiCommandQueryString;
	BOOL KillMpegThread();
	BOOL SendCGICommand(BYTE nCode);
	BOOL m_bGopCode[MAX_CHANNEL];
	CDecoder *m_pDecoder;
	void ImageDisplay(UINT nCH, LPSTR lpszData, DWORD dwDataLen, int type);
	BOOL ParseGOPData(LPSTR lpszReceiveData, DWORD dwReceiveDataLength);
	void ReceiveDataErrorMessage(BYTE nError);
	int m_nClientID;
	
	void PacketParse(BYTE* pszReceiveData, DWORD dwReceiveDataLength);
	HINTERNET m_hInternetOpen;
	HINTERNET m_hHttpOpenRequest;
	HINTERNET m_hInternetConnect;
	void CloseOpenedHandle();
	CString m_strPassword;
	CString m_strUser;
	INTERNET_PORT m_nDVRPort;
	CString m_strDVRIPAddress;
	BOOL HttpConnect();
	BOOL m_bThreadBreak;
	UINT MpegProcess();
	CWinThread* m_pMpegThread;
	UINT m_nResolution;
	BOOL m_bConnect;
	CWnd* m_pWnd;

	CReceiveDataParse m_DataParsing;
};

#endif // !defined(AFX_HTTPINTERFACE_H__4A1FBD5B_E372_4CE6_8413_17972BB70F08__INCLUDED_)
