/* vim:set ft=cpp ts=4 sw=4 sts=4 sta ai si cin bs=2: */
// ReceiveDataParse.cpp: implementation of the CReceiveDataParse class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ReceiveDataParse.h"

#include <winsock2.h>


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CReceiveDataParse::CReceiveDataParse()
{
	m_dwRemainBufferSize = 0;
	m_tempBuffer = NULL;
	memset(&m_payloaddata, 0, sizeof(PAYLOAD));
}

CReceiveDataParse::~CReceiveDataParse()
{

}

/* Էµ ͸  Start, End code ã Parsingϴ Լ
   return value : TRUE( ۸ ٽ ParsingؾѴ.), FALSE( ۸ ٽ Parsing  ʾƵ ȴ.)
   ParseData[OUT] : Start, End code ã Parsing ͸ Ѱش.
   pbyReceiveData[IN] : DVR  
   dwReceiveDataLength[IN] : pbyReceiveData ũ

   *** pbyReceiveData, dwReceiveDataLenght Է  Start, End code ã   ۸ 
   ٽ Parsing Ѵ.
*/
bool CReceiveDataParse::PacketParse(PARSE_DATA* ParseData, const BYTE *pbyReceiveData, DWORD dwReceiveDataLength)
{
	enum {MAX_FRAMEHEADER_SIZE = 1024};

	// PACKET_START_CODE(0xFB, 0xFB, 0xFB, 0xFC), PACKET_END_CODE(0xFB, 0xFB, 0xFB, 0xFD)
	const int MARKER_CODE_SIZE = 4;
	
	DWORD dwPacketLen;
	DWORD dwDataStartPoint = 0;

	if(dwReceiveDataLength > 0){
		memcpy(m_tempBuffer + m_dwRemainBufferSize, pbyReceiveData, dwReceiveDataLength);
		m_dwRemainBufferSize += dwReceiveDataLength;
	}

	if(m_dwRemainBufferSize > sizeof(PAYLOAD) + MARKER_CODE_SIZE)
	{
		for(DWORD i = 0 ; i < m_dwRemainBufferSize - MARKER_CODE_SIZE - sizeof(PAYLOAD); i++){
			/* StartCode ã  */
			if(m_tempBuffer[i] == PACKET_FIRST_BYTE && m_tempBuffer[i+1] == PACKET_SECOND_BYTE &&
				m_tempBuffer[i+2] == PACKET_THIRD_BYTE && m_tempBuffer[i+3] == PACKET_START_BYTE)
			{
				memcpy(&m_payloaddata, m_tempBuffer + i + MARKER_CODE_SIZE, sizeof(PAYLOAD));
				dwDataStartPoint = i + MARKER_CODE_SIZE + sizeof(PAYLOAD);
				dwPacketLen = ntohl(m_payloaddata.dwPacketLen);
				m_dwTotalSize = dwPacketLen + MARKER_CODE_SIZE;

				if(m_dwTotalSize > ( MAX_PES_SIZE + MAX_FRAMEHEADER_SIZE))
				{
					/* DVRκ ۵Ǵ Ŷ  .
					*   SMAGIC(4) + PAYLOAD_HEADER(6) + FRAME_HEADER + PES_DATA(MAX_PES_SIZE) + EMAGIC(4)
					*   PAYLOAD_HEADER->dwPacketLen = FRAME_HEADER + PES_DATA  ǹѴ.
					*  m_dwTotalSize   ũٸ . */
					TRACE(_T("TotalSize %u\n"), m_dwTotalSize);

					return FALSE;
				}

				if(m_dwTotalSize <= m_dwRemainBufferSize - dwDataStartPoint)
				{
					if(m_tempBuffer[dwDataStartPoint + dwPacketLen] == PACKET_FIRST_BYTE &&
						m_tempBuffer[dwDataStartPoint + dwPacketLen + 1] == PACKET_SECOND_BYTE &&
						m_tempBuffer[dwDataStartPoint + dwPacketLen + 2] == PACKET_THIRD_BYTE &&
						m_tempBuffer[dwDataStartPoint + dwPacketLen + 3] == PACKET_END_BYTE)
					{
        				ParseData->nDataInfo = m_payloaddata.nDataType;
        				ParseData->nDataSize = m_dwTotalSize - MARKER_CODE_SIZE;
						memcpy(ParseData->DataBuf, m_tempBuffer + dwDataStartPoint, ParseData->nDataSize);
						m_dwRemainBufferSize = m_dwRemainBufferSize - (dwDataStartPoint + ParseData->nDataSize);
						memmove(m_tempBuffer, m_tempBuffer + dwDataStartPoint + ParseData->nDataSize, m_dwRemainBufferSize);
						return TRUE;
					}
				}
			}
		}	// end for
	}

	return FALSE;
}

/* Parsing ޸𸮸 Ҵϰ ʱȭ ϴ Լ*/
void CReceiveDataParse::InitParse()
{
	m_tempBuffer = new BYTE[MAX_PES_SIZE];
}

/* Ҵ ޸𸮸 ϴ Լ*/
void CReceiveDataParse::DestroyParse()
{
	if(m_tempBuffer){
		delete m_tempBuffer;
		m_tempBuffer = NULL;
	}
}

/*  ClientID ȯϴ Լ
    return value : Payload ü Client ID 
*/
int CReceiveDataParse::GetClientID()
{
	return m_payloaddata.nClientID;
}
