/* vim:set ft=cpp ts=4 sw=4 sts=4 sta ai si cin bs=2: */
// ReceiveDataParse.h: interface for the CReceiveDataParse class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_RECEIVEDATAPARSE_H__294B696A_9A9F_44C4_B6AD_8BCC83854B64__INCLUDED_)
#define AFX_RECEIVEDATAPARSE_H__294B696A_9A9F_44C4_B6AD_8BCC83854B64__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define MAX_PES_SIZE			(512*1024)

// Data Type
#define	DEF_RESPONSE_DATA		1	//CGI Response
#define	DEF_AUDIO_LIVE			2	//Audio Live Data
#define	DEF_AUDIO_PLAYBACK		3	//Audio Playback Data
#define	DEF_AUDIO_BACKUP		4	//Audio Backup Data
#define	DEF_VIDEO_LIVE			10	//Video Live Data
#define	DEF_VIDEO_PLAYBACK		11	//Video Playback Data
#define	DEF_VIDEO_BACKUP		12	//Video Live Data
#define	DEF_VIDEO_LIVE_JPEG		13	//Video Live Data
#define	DEF_INFO_DATA			20	//DVR Information
#define DEF_MBACKUP_SIZE		30

/*
	Packet Start Code :  FB FB FB FC
	Packet End Code : FB FB FB FD
*/
#define PACKET_FIRST_BYTE 0xFB
#define PACKET_SECOND_BYTE 0xFB
#define PACKET_THIRD_BYTE 0xFB

#define PACKET_START_BYTE 0xFC
#define PACKET_END_BYTE 0xFD

#if defined (_MSC_VER) | defined (__WINSCW__)
#pragma pack(push, 1)
#define STRUCT_PACKING
#else
#define STRUCT_PACKING __attribute__((packed))
#endif
typedef struct _PAYLOAD
{
	BYTE  nClientID;			// Client ID
	BYTE  nDataType;			// ۵ Data 
	DWORD dwPacketLen;			// ۵  ũ
} STRUCT_PACKING PAYLOAD;	// 6byte

typedef struct _PARSE_DATA
{
	BYTE nDataInfo;					//   
	DWORD nDataSize;				//  
	BYTE DataBuf[MAX_PES_SIZE];		// Parsing  
} STRUCT_PACKING PARSE_DATA;
#ifdef _MSC_VER
#pragma pack()
#endif

class CReceiveDataParse
{
public:
	int GetClientID();
	void DestroyParse();
	void InitParse();
	bool PacketParse(PARSE_DATA* ParseData, const BYTE *pbyReceiveData = NULL, DWORD dwReceiveDataLength = 0);
	CReceiveDataParse();
	virtual ~CReceiveDataParse();
private:
	PAYLOAD m_payloaddata;
	DWORD m_dwTotalSize;
	DWORD m_dwRemainBufferSize;		// m_pRemainBuffer Size;

	BYTE* m_tempBuffer;				// m_pRemainBuffer   ۸ ġ 
};

#endif // !defined(AFX_RECEIVEDATAPARSE_H__294B696A_9A9F_44C4_B6AD_8BCC83854B64__INCLUDED_)
