// SimpleLiveViewerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SimpleLiveViewer.h"
#include "SimpleLiveViewerDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	public:
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSimpleLiveViewerDlg dialog

CSimpleLiveViewerDlg::CSimpleLiveViewerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSimpleLiveViewerDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSimpleLiveViewerDlg)
	m_strDVRIPAddress = _T("");
	m_strPort = _T("");
	m_strPassword = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSimpleLiveViewerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSimpleLiveViewerDlg)
	DDX_Control(pDX, IDC_COMBO_USER, m_ctrlUser);
	DDX_Text(pDX, IDC_EDIT_DVRADDRESS, m_strDVRIPAddress);
	DDX_Text(pDX, IDC_EDIT_PORT, m_strPort);
	DDX_Text(pDX, IDC_EDIT_PASSWORD, m_strPassword);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSimpleLiveViewerDlg, CDialog)
	//{{AFX_MSG_MAP(CSimpleLiveViewerDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_CONNECT, OnConnect)
	ON_BN_CLICKED(IDC_EXIT, OnExit)
	ON_WM_CLOSE()
	ON_CBN_EDITCHANGE(IDC_COMBO_USER, OnEditchangeComboUser)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSimpleLiveViewerDlg message handlers

BOOL CSimpleLiveViewerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_pHttpInterface = new CHttpInterface(this);
	m_ctrlUser.SetCurSel(0);
	UpdateData(FALSE);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSimpleLiveViewerDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSimpleLiveViewerDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		for(UINT i=0; i<MAX_CHANNEL; i++)
		{
			if(m_pHttpInterface)	m_pHttpInterface->RedrawVideo(i);
		}

		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSimpleLiveViewerDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CSimpleLiveViewerDlg::OnConnect() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);

	m_ctrlUser.GetWindowText(m_strUser);
	
	DVRConnect();
}

void CSimpleLiveViewerDlg::OnExit() 
{
	// TODO: Add your control notification handler code here
	PostMessage(WM_CLOSE);
}

void CSimpleLiveViewerDlg::DVRConnect()
{
	if(m_pHttpInterface->IsConnected())
		m_pHttpInterface->DisconnectedDVR();
	
	m_pHttpInterface->ConnectDVR(m_strDVRIPAddress, m_strPort, m_strUser, m_strPassword);
}

BOOL CSimpleLiveViewerDlg::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: Add your specialized code here and/or call the base class
	if(pMsg->message == WM_KEYDOWN) {
         if(pMsg->wParam == VK_RETURN) {
			 if(pMsg->hwnd == GetDlgItem(IDC_EDIT_PASSWORD)->m_hWnd){
				OnConnect();
			 }
			 return TRUE;
         }
         else if(pMsg->wParam == VK_ESCAPE) {
             return TRUE;
         }
 	}
	return CDialog::PreTranslateMessage(pMsg);
}

void CSimpleLiveViewerDlg::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	if(m_pHttpInterface->IsConnected())
		m_pHttpInterface->DisconnectedDVR();
	
	delete m_pHttpInterface;
	
	CDialog::OnClose();
}

void CSimpleLiveViewerDlg::OnEditchangeComboUser() 
{
	CString m_compareStr;
	int m_strUserLen;
	
	m_ctrlUser.LimitText(9); //ؽƮ 
	
	m_ctrlUser.GetWindowText(m_strUser);
	m_strUserLen = m_strUser.GetLength();
	m_compareStr = m_strUser.Right(1); //ֱ Էµ ؽƮ 
	
	if(!(m_compareStr >= "0" && m_compareStr <= "9" 
		|| m_compareStr >= "A" && m_compareStr <= "Z"
		|| m_compareStr >= "a" && m_compareStr <= "z" 
		|| m_compareStr == "_" || m_compareStr == ""))
	{ 
		AfxMessageBox("Only alphabet, number and '_' can be entered.");
		
		m_strUser.Delete(m_strUserLen-1, 1);
		m_ctrlUser.SetWindowText(m_strUser);
		
		m_ctrlUser.SetEditSel(m_strUserLen, m_strUserLen); //  Ŀ  ڷ ̵
	}	
}
