// #define ICARCH_WIN32
// #define ICARCH_IOS_ARM7

#include <PeerSDK.h>
using namespace PeerSDK;

#include <stdio.h>

Peer* m_peer = NULL;

int Finalize(int code)
{
    delete m_peer;

    Peer::Cleanup();
    return code;
}

void PEERSDK_CALLBACK OnErrorOccurred(void* tag, ErrorOccurredEventArgs const& e)
{
    printf("*** error occurred\n");
}

void PEERSDK_CALLBACK OnVideoLossChanged(void* tag, VideoLossChangedEventArgs const& e)
{
    for (int i = 0; i < e.Active().Count(); i++)
    {
        printf("[%02d] video loss\n", e.Active()[i]);
    }
    for (int i = 0; i < e.Deactive().Count(); i++)
    {
        printf("[%02d] video normal\n", e.Deactive()[i]);
    }
}

void PEERSDK_CALLBACK OnVideoMotionChanged(void* tag, VideoMotionChangedEventArgs const& e)
{
    for (int i = 0; i < e.Active().Count(); i++)
    {
        printf("[%02d] video motion\n", e.Active()[i]);
    }
    for (int i = 0; i < e.Deactive().Count(); i++)
    {
        printf("[%02d] video static\n", e.Deactive()[i]);
    }
}

int main()
{
    PeerResult r;

    r = Peer::Startup();
    if (!r)
    {
        printf("*** failed to initialize\n");
        return Finalize(-1);
    }

    m_peer = new Peer();
    r = m_peer->Connect("192.168.3.38", 80, "Admin", "123456", "", true);
    if (!r)
    {
        printf("*** failed to connect\n");
        return Finalize(-1);
    }

    for (int i = 0; i < m_peer->Channels().Count(); i++)
    {
        PeerChannel* channel = m_peer->Channels()[i];

        String s = channel->Name();
#if defined(ICARCH_WIN32)
        wprintf(L"[%02d] %s", i, (LPCWSTR)s);
#elif defined(ICARCH_IOS_ARM7)
#endif
        if (channel->Audio()->IsPresent())
            printf("    Has audio\n");
        else
            printf("    No audio\n");
    }

    m_peer->ErrorOccurred().Add(NULL, OnErrorOccurred);
    m_peer->VideoLossChanged().Add(NULL, OnVideoLossChanged);
    m_peer->VideoMotionChanged().Add(NULL, OnVideoMotionChanged);

    while (true)
    {
        char c = 0;
        scanf("%c", &c);
        if (c == 'q')
            break;
    }

    return Finalize(0);
}
