#pragma once

class DiagnosticTool
{
public:
    DiagnosticTool();
    ~DiagnosticTool();

private:
    PeerSDK::Peer* m_peer;

public:
    void Start(const char* host, int port , const char* user, const char* password);

private:
    PeerSDK::PeerResult Phase_Connect(const char* host, int port , const char* user, const char* password);
    PeerSDK::PeerResult Phase_LiveStream();
    PeerSDK::PeerResult Phase_LogList();
    PeerSDK::PeerResult Phase_RecordList();

private:
    void PrintStreamStatus();
    void UpdateStreamStatus();

private:
    PeerSDK::PeerStream* m_stream;
    int                  m_ifrmaes;
    int                  m_pfrmaes;
    int                  m_audiosamples;

private:
    static void PEERSDK_CALLBACK Live_ErrorOccurred(void* tag, PeerSDK::ErrorOccurredEventArgs const& e);
    static void PEERSDK_CALLBACK Live_VideoArrived(void* tag, PeerSDK::VideoArrivedEventArgs const& e);
    static void PEERSDK_CALLBACK Live_AudioArrived(void* tag, PeerSDK::AudioArrivedEventArgs const& e);
};
