﻿using System;
using System.Globalization;
using System.Windows;
using System.Windows.Data;
using PeerSDK.Wrapper;

namespace PeerSDK.Samples
{
    public partial class LogWindow : Window
    {
        public LogWindow(PeerLog[] logs)
        {
            Logs = logs;

            DataContext = this;

            InitializeComponent();
        }

        public PeerLog[] Logs { get; private set; }
    }

    [ValueConversion(typeof(bool), typeof(Visibility))]
    public class BoolVisibilityConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            bool type = (bool)value;
            bool v = Boolean.Parse(parameter as string);
            return type == v ? Visibility.Visible : Visibility.Collapsed;
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}