//
//  ViewController.m
//  XcodeDemo
//
//  Created by JR on 11/27/12.
//  Copyright (c) 2012 JR. All rights reserved.
//

#import "ViewController.h"

#include <PeerSDK.h>
using namespace PeerSDK;

void UpdateMessage(void* self, const char* message);

class MyPeer
{
public:
    MyPeer()
    {
        m_parent = NULL;
        m_peer   = NULL;
        m_stream = NULL;
    }
    
    ~MyPeer()
    {
        if (m_stream != NULL)
            m_stream->Dispose();
        m_stream = NULL;
        
        delete m_peer;
    }
    
public:
    bool Initialize(void* parent, const char* host, int port, const char* user, const char* password)
    {
        m_parent = parent;
        
        m_peer = new Peer();
        PeerResult r = m_peer->Connect(host, port, user, password, "", true);
        if (!r)
            return false;
        
        r = m_peer->CreateLiveStream(&m_stream);
        if (!r)
            return false;
        
        m_stream->VideoArrived().Add(this, OnStream_VideoArrived);
        m_stream->AudioArrived().Add(this, OnStream_AudioArrived);
        
        m_stream->Start();
        
        return true;
    }
    
private:
    static void OnStream_VideoArrived(void* tag, VideoArrivedEventArgs const& e)
    {
        MyPeer* self = (MyPeer*)tag;
        
        char message[200] = "";
        sprintf(message, "video [%02d] %d x %d (%02d:%02d:%02d)", e.Channel(), e.Width(), e.Height(), e.Time().Hour(), e.Time().Minute(), e.Time().Second());
        UpdateMessage(self->m_parent, message);
    }

    static void OnStream_AudioArrived(void* tag, AudioArrivedEventArgs const& e)
    {
        MyPeer* self = (MyPeer*)tag;
        
        char message[200] = "";
        sprintf(message, "audio [%02d] %02d:%02d:%02d)", e.Channel(), e.Time().Hour(), e.Time().Minute(), e.Time().Second());
        UpdateMessage(self->m_parent, message);
    }

private:
    void*       m_parent;
    Peer*       m_peer;
    PeerStream* m_stream;
};

@interface ViewController ()
{
    MyPeer m_peer;
}

@end

@implementation ViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view, typically from a nib.
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)dealloc {
    [__Host release];
    [__Port release];
    [__User release];
    [__Password release];
    [__Output release];
    [super dealloc];
}

- (IBAction)OnConnect:(id)sender {
    [self.view endEditing:YES];
    
    NSString* host     = __Host.text;
    NSInteger port     = [__Port.text intValue];
    NSString* user     = __User.text;
    NSString* password = __Password.text;
    
    bool r = m_peer.Initialize(self, [host UTF8String], port, [user UTF8String], [password UTF8String]);
    if (!r)
        return;
}

-(void)updateMessage:(const char*)message
{
    dispatch_sync(dispatch_get_main_queue(), ^{
        [__Output setText:[NSString stringWithUTF8String:message]];
    });
}

void UpdateMessage(void* self, const char* message)
{
    ViewController* s = (ViewController*)self;
    [s updateMessage:message];
}

@end
