/*
 * Copyright 2006 The Android Open Source Project
 *
 * JNI helper functions.
 */

#include "JNIHelp.h"
#include <string.h>
#include <assert.h>
#include <stdio.h>

/*
 * Register native JNI-callable methods.
 *
 * "className" looks like "java/lang/String".
 */
int jniRegisterNativeMethods(JNIEnv* env, const char* className,
    const JNINativeMethod* gMethods, int numMethods)
{
    jclass clazz;

    clazz = env->FindClass(className);
    if (clazz == NULL)
        return -1;
 
    if (env->RegisterNatives(clazz, gMethods, numMethods) < 0) 
        return -1;
        
    return 0;
}

void jniNewClassGlobalReference(JNIEnv* env, jclass& objectClazz, const char* className)
{
	jclass localRefCls = env->FindClass(className);
	objectClazz = (jclass) env->NewGlobalRef(localRefCls);
	env->DeleteLocalRef(localRefCls); 
}

jmethodID jniGetMethodID(JNIEnv* env, jclass clazzRef, const char* methodName, const char* methodSignture)
{
	return env->GetMethodID(clazzRef, methodName, methodSignture);	
}