#pragma once

class JObject
{
public:
	JObject(JNIEnv *env);
	JObject(JNIEnv *env, jobject classRef);
	JObject(JNIEnv *env, jobject classRef, jlong peerAddress);
	JObject(JNIEnv *env, jobject classRef, jlong peerAddress, jint index);
	JObject();
	virtual ~JObject();

public:
	jint     getIndex();
	jlong    getPeerAddress();
	jclass   getClassRef();
	JNIEnv*  getEnv();
	
	void     setEnv(JNIEnv* env);

protected:
	JNIEnv* mEnv;
    jclass mClassRef; // reference to java class

	jint mPeerAddress; // the address of the peer's address of java instace
	jint mIndex;
};
