#pragma once

#define MAX_DVR_CHANNELS 32

#include <jni.h>

#include <stdlib.h>
#include <wchar.h>

//-------- Log ------------//
#include "AndroidLog.h"
#include "JNIHelp.h"

//-------- PeerSDK --------//
#include "PeerSDK.h"


// ------- JNI ------//
#include "JObject.h"

#define DEFINE_REGISTER_CLASS(ClassMethod, Class) \
jint register_##ClassMethod(JavaVM* vm, void* reserved) { \
	JNIEnv* env = NULL; \
	jclass clazz = NULL; \
	if (vm->GetEnv((void**) &env, JNI_VERSION_1_4) != JNI_OK) { \
		return -1; \
	} \
	InitJNIGlobalRef(env); \
	clazz = env->FindClass(#Class); \
	if (clazz == NULL) { \
		return -1; \
	} \
	if (env->RegisterNatives(clazz, gMethods, \
			sizeof(gMethods) / sizeof(gMethods[0])) < 0) { \
		return -1; \
	} \
	return JNI_VERSION_1_4; \
} \


////////////////////////////////////////////////////////////////////////////////////////////////////

#define GET_NATIVE_ADDRESS_OF_NATIVEOBJECT(object, nativeObjectGetNativeAddressMethodID, value) \
static jmethodID  nativeObjectGetNativeAddressMethodID = 0; \
if (nativeObjectGetNativeAddressMethodID == 0) \
{ \
	jclass  localRefCls = env->FindClass("remote/demo/Native/NativeObject"); \
	if (localRefCls == NULL) \
	{ \
		LOGE("remote/demo/Native/NativeObject class not found"); \
		return; \
	} \
	nativeObjectGetNativeAddressMethodID = env->GetMethodID(localRefCls, "getNativeAddress","()J"); \
	env->DeleteLocalRef(localRefCls); \
} \
value = env->CallLongMethod(object, nativeObjectGetNativeAddressMethodID);


