package remote.demo;

import remote.demo.Native.NativeBaseObject;
import remote.demo.Native.PeerSDK.Peer.Peer;
import remote.demo.Native.PeerSDK.Peer.Stream.PeerStream;
import remote.demo.R;
import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;

public class RemoteDVRActivity extends Activity {
    
    static {
        System.loadLibrary("peersdk");
        System.loadLibrary("peersdk-jni");
    }

    public static final String TAG = "__RemoteDVRActivity__";

    Peer       mPeer   = null;
    PeerStream mStream = null;
    Handler    mHandler;

    @Override
    public void onCreate(Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
     
        mHandler = new Handler() {
        
            @Override
            public void handleMessage(Message msg) {

                switch (msg.what) {
                
                case 0x00:
                    ((TextView) findViewById(R.id.text_result0)).setText("channel=" + msg.what + ", pts=" + ((Long)msg.obj).toString());
                    break;
                    
                case 0x01:
                    ((TextView) findViewById(R.id.text_result1)).setText("channel=" + msg.what + ", pts=" + ((Long)msg.obj).toString());
                    break;
                    
                case 0x02:
                    ((TextView) findViewById(R.id.text_result2)).setText("channel=" + msg.what + ", pts=" + ((Long)msg.obj).toString());
                    break;
                    
                case 0x03:
                    ((TextView) findViewById(R.id.text_result3)).setText("channel=" + msg.what + ", pts=" + ((Long)msg.obj).toString());
                    break;
                }
            }
        };
        
        findViewById(R.id.button_connect).setOnClickListener(new View.OnClickListener() {
            
            @Override
            public void onClick(View v) {
                
                Connect(((EditText) findViewById(R.id.text_host)).getText().toString(),
                        ((EditText) findViewById(R.id.text_port)).getText().toString(),
                        ((EditText) findViewById(R.id.text_user)).getText().toString(),
                        ((EditText) findViewById(R.id.text_password)).getText().toString());
                
                v.setEnabled(false);
            }
        });
    }
    
    @Override
    public void onDestroy() {

        super.onDestroy();
        Dispose();
    }
    
    protected void Connect(final String host, final String port, final String user, final String password)
    {
        new Thread() {
            
            @Override
            public void run() {

                mPeer = new Peer();
                boolean result = mPeer.connect(host, Integer.parseInt(port), user, password, "", true);
                if (result)
                {
                    Log.i(TAG, "peer connect ok");
                    
                    mStream = new PeerStream();
                    mPeer.createLiveStream(mStream);
                    mStream.setVideoArrivedEventListener(new NativeBaseObject.VideoArrivedEventListener() {

                        @Override
                        public void onVideoArrived(int channel, long pts) {
                            Log.i(TAG, "onVideoArrived: channel=" + channel + ", pts=" + pts);
                            Message msg = Message.obtain();
                            msg.what = channel;
                            msg.obj = new Long(pts);
                            mHandler.sendMessage(msg);
                        }
                    });
                    
                    mStream.start();
                }
                else
                    Log.i(TAG, "peer connect -_-");
            }
        }.start();
    }
    
    protected void Dispose()
    {
        new Thread() {
            
            @Override
            public void run() {
                
                if (mStream != null)
                    mStream.release();

                if (mPeer != null)
                    mPeer.release();
            }
        }.start();
    }
    
    

}