#ifndef __RSNet_h__
#define __RSNet_h__



#include "RSNetParameter.h"

#include "RSNetProtocol.h"

#ifdef RSNET_EXPORTS
#define RSNET_API __declspec(dllexport)
#else
#define RSNET_API __declspec(dllimport)
#endif

#define RSNET_CALL __stdcall

//////////////////////////////////////////////////////////////////////////
//豸

//RSNetSearchDevParam.Callback
//devΪNULLFALSEȡٵøûص
//ע⣺ֻеȡ󣬲Ļص漰Դܻᷢ
typedef BOOL (RSNET_CALL* RSNetSearchDevCallback)(const SearchDevRsp* dev, void* userParam);

typedef struct 
{
	RSNetSearchDevCallback Callback;
	void* UserParam;
}RSNetSearchDevParam;

//////////////////////////////////////////////////////////////////////////
//http

//RSNetHttpReq.Callback
//bufΪNULLFALSEȡٵøûص
//ע⣺ֻеȡ󣬲Ļص漰Դܻᷢ
typedef BOOL (RSNET_CALL* RSNetHttpReqCallback)(const void* buf, int len, void* userParam);

typedef struct 
{
	char*    buf;//httpʽ
	int      len;//ݳ
	PCSTR    IP; //IPַ
	UINT     Port; //IE ˿
	UINT     timeout; //ʱʱ(s)
	RSNetHttpReqCallback Callback;
	void* UserParam;
	char szHeadFlag[32];   //ӦϢβʶ 
}RSNetHttpReq;

typedef struct
{
    char*    buf;//httpʽ
    int      len;//ݳ
    char*    IP; //IPַ
    UINT     Port; //IE ˿
    int      nRecvTimeout;
    int      nSendTimeOut;
    int      bReConnect;
    int      nReConnectCount;
    int      nIntervalTimeOut;
    char     szHeadFlag[32];   //ӦϢβʶ
    void*    UserParam;
    RSNetHttpReqCallback Callback;
}RSNetHttpReqEx;

typedef void* RSNetIDConnection;
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
//P2P
typedef BOOL (RSNET_CALL* RSNetP2PTunnelReqCallback)(const void* buf, int len, void* userParam);

typedef struct
{
    char*    pID;
    int      nMediaPort;
    int      bReConnect;
    int      nReConnectCount;
    int      nIntervalTimeOut;
    void*    UserParam;
    RSNetP2PTunnelReqCallback Callback;
}RSNetP2PTunnelReq;

typedef void* RSNetP2PTunnelConnection;
//////////////////////////////////////////////////////////////////////////

//Ϣص
//waram
//RSNetConnection msg
#define RSNetMsgConnectStart				0
#define RSNetMsgConnectSuccess				1
#define RSNetMsgConnectFail					2
#define RSNetMsgConnectClosed				3
#define RSNetMsgLoginRequest				100
#define RSNetMsgLoginSuccess				101
#define RSNetMsgLoginUserLogined			102
#define RSNetMsgLoginNoUserName				103
#define RSNetMsgLoginPasswordError			104
#define RSNetMsgLoginFail					105
#define RSNetMsgLoginNoRight                106
#define RSNetMsgIpFilter					107
#define RSNetMsgOverMaxUser                 108
#define RSNetMsgNotSupportLoginType         109

//RSNetPreview msg
#define RSNetMsgPreviewWaitLogin			200
#define RSNetMsgPreviewOpenStream			201
#define RSNetMsgPreviewOpenStreamSuccess	202
#define RSNetMsgPreviewOpenStreamFail		203
#define RSNetMsgPreviewStreamClosed			204
#define RSNetMsgPreviewDevOffLine           205
#define RSNetMsgPreviewDevOnLine            206  
#define RSNetMsgPreviewCloseVideo           207
#define RSNetMsgPreviewMaxPrevNumErr        208
//RSNetDownloadRecord RSNetDownloadRecordStatusCallback.code
#define RSNetMsgDownloadRecordClosed		290 //ؽ
#define RSNetMsgDownloadRecordOK			291 //һļ
#define RSNetMsgDownloadRecordNoFile		292 //һļ
#define RSNetMsgDownloadRecordFail			293 //ļʧ
#define RSNetMsgDownloadRecordStoreFail		294 //ļ洢ʧ
#define RSNetMsgDownloadRecordPercent		295 //param = percent
//RSNetRecordPlay msg
#define RSNetMsgRecordPlayClosed			300
#define RSNetMsgRecordPlayNoData			301
#define RSNetMsgRecordPlayWaitLogin			302
#define RSNetMsgRecordPlayOpenStream		303
#define RSNetMsgRecordPlayOpenStreamSuccess	304
#define RSNetMsgRecordPlayOpenStreamFail	305
#define RSNetMsgRecordPlayDevicePlayback    306
//RSNetDualtalk msg 
#define RSNetMsgDualtalkClosed				350
//RSNetRemoteUpgrade RSNetRemoteUpgradeCallback.code
#define RSNetMsgRemoteUpgradeClosed			390 //Ͽ
#define RSNetMsgRemoteUpgradeOK				391 //ļ
#define RSNetMsgRemoteUpgradeReadFileFail	392 //ȡļʧ
#define RSNetMsgRemoteUpgradeInvalidFile	393 //Ϸļ
#define RSNetMsgRemoteUpgradePercent		394 //param = percent
#define RSNetMsgRemoteUpgradeVerError		395 //ļ豸ƥǰ汾̫
#define RSNetMsgRemoteUpgrading				396 //豸
#define RSNetMsgRemoteUpgradeVerSame        397 //ļ汾豸汾ͬ,Ҫ
#define RSNetMsgRemoteUpgradeLanguageError  398 
//lparam = UserParam
#define RSNetTestBusy                       801
//////////////////////////////////////////////////////////////////////////
// RSNetGetLastError
#define RSNetSuccess					0
#define RSNetEDualtalkBusy				0xE1010001
#define RSNetEParam						0xE1010051
#define RSNetENoRight					0xE1010052

//////////////////////////////////////////////////////////////////////////
//豸

//RSNetConnectionParam.MotionAlarmRptCallback
typedef void (RSNET_CALL* RSNetAlarmRptCallback)(WORD type, void* data, UINT size, void* userParam);
//connection status callback function
typedef void (RSNET_CALL* RSNetConnectionCallback)(WPARAM wparam, LPARAM lparam);
typedef struct
{
	PCSTR IP;
	UINT Port;
	PCSTR UserName;
	PCSTR Password;
	HWND Wnd;
	UINT Message;
	void* UserParam;
	BOOL AutoReconnect;
	RSNetAlarmRptCallback AlarmRptCallback;
	BOOL AlarmRptDesired;
	RSNetConnectionCallback ConnCallback;
}RSNetConnectionParam;

enum{
    LOGIN_TYPE_IP = 0,
    LOGIN_TYPE_ID,//anlian id and urmet id
    LOGIN_TYPE_TUTK_ID,
    LOGIN_TYPE_LANGTAO_ID,
    LOGIN_TYPE_LOREX_ID
}LOGIN_TYPE;

typedef struct
{
    PCSTR IP;
    UINT Port;
    PCSTR UserName;
    PCSTR Password;
    HWND Wnd;
    UINT Message;
    void* UserParam;
    BOOL AutoReconnect;
    RSNetAlarmRptCallback AlarmRptCallback;
    BOOL AlarmRptDesired;
    RSNetConnectionCallback ConnCallback;
    int   nLoginType;//value from LOGIN_TYPE
    PCSTR IDServerName;
    BYTE  reserve[4];
}RSNetConnectionParamEx;

//Email test  
typedef void (RSNET_CALL* RSRemoteTestCallback)(WORD type, void* data, UINT size, void* userParam);
typedef struct
{
	WORD  type;
	void* data;
	UINT  dataSize;
	void* UserParam;
	RSRemoteTestCallback remoteTestCallback;
	UINT TimeOut;      //ʱʱ
}RSNetRemoteTestParam;

typedef void* RSNetConnection;


//////////////////////////////////////////////////////////////////////////
//Ԥ

//RSNetPreviewParam.Protocol
#define RSNetPreviewTcp		0
#define RSNetPreviewUdp		1

//RSNetPreviewParam.DataCallback
typedef void (RSNET_CALL* RSNetPreviewDataCallback)(void* data, UINT size, void* userParam);

typedef struct 
{
	PreviewParam Param;
	UINT Protocol; //TCP,UDP
	BOOL AutoReconnect;
	RSNetPreviewDataCallback DataCallback;
	void* UserParam;
	HWND Wnd;
	UINT Message;
}RSNetPreviewParam;

typedef void* RSNetPreview;


//////////////////////////////////////////////////////////////////////////
//¼ѯ

//RSNetQueryRecordParam.DetailCallback
typedef void (RSNET_CALL* RSNetQueryRecordDetailCallback)(const RecordDetailRsp* rsp, void* userParam);

//RSNetQueryRecordParam.DayOutlineCallback
typedef void (RSNET_CALL* RSNetQueryRecordDayOutlineCallback)(const RecordDayOutlineRsp* rsp, void* userParam);

typedef struct
{
	UINT Type; //MsgRecordDetail...
	QueryRecordReq Req;
	RSNetQueryRecordDetailCallback DetailCallback;
	RSNetQueryRecordDayOutlineCallback DayOutlineCallback;
	void* userParam;
}RSNetQueryRecordParam;


//////////////////////////////////////////////////////////////////////////
//¼

//RSNetDownloadRecordParam.StatusCallback
typedef void (RSNET_CALL* RSNetDownloadRecordStatusCallback)(UINT code, UINT param, void* userParam);

#ifndef RSFileType
#define RSFileType		1
#define RSAVIFileType	2
#endif

//RSNetDownloadRecordParam.LocalParam
typedef struct
{
	char FileName[MAX_PATH];
	UINT FileType;
}RSNetDownloadRecordLocalParam;

typedef struct
{
	UINT Channel;
	const RecordDetailRsp* DevRecordFile;
	const RSNetDownloadRecordLocalParam* LocalParam;
	RSNetDownloadRecordStatusCallback StatusCallback;
	void* UserParam;
}RSNetDownloadRecordParam;

typedef void* RSNetDownloadRecord;


//////////////////////////////////////////////////////////////////////////
//¼ط

//RSNetRecordPlayParam.DataCallback
typedef BOOL (RSNET_CALL* RSNetRecordPlayDataCallback)(void* data, UINT size, void* userParam);
typedef void (RSNET_CALL* RSNetRecordStatusCallback)(UINT code, void* userParam);
typedef struct
{
	UINT Channel;
	UINT Type; //NormalRecord...
	DateTime Begin;
	DateTime End;

	RSNetRecordPlayDataCallback DataCallback;
    RSNetRecordStatusCallback   StatusCallback;
	void* UserParam;
	HWND Wnd;
	UINT Message;
}RSNetRecordPlayParam;

typedef void* RSNetRecordPlay;


//////////////////////////////////////////////////////////////////////////
//Խ

//RSNetDualtalkParam.DataCallback
typedef void (RSNET_CALL* RSNetDualtalkDataCallback)(void* data, UINT size, void* userParam);

typedef struct
{
	RSNetDualtalkDataCallback DataCallback;
	void* UserParam;
	HWND Wnd;
	UINT Message;
}RSNetDualtalkParam;

typedef void* RSNetDualtalk;


//////////////////////////////////////////////////////////////////////////
//

//RSNetQueryParamParam.ParamCallback
typedef void (RSNET_CALL* RSNetParamCallback)(void* param, void* userParam);

//RSNetQueryParamParam.ListParamCallback
typedef void (RSNET_CALL* RSNetListParamCallback)(void* listParam, void* userParam); 

typedef struct
{
	UINT ParamType; //
	void* Req;
	UINT ParamSize; //ӦĽṹĴС
	RSNetParamCallback ParamCallback;
	UINT ListParamSize; //ӦĽṹĴС
	RSNetListParamCallback ListParamCallback;
	void* UserParam;
	UINT TimeOut;      //ʱʱ
}RSNetQueryParamParam;

typedef struct
{
	UINT ParamMainType; //Ϣ
	UINT ParamSubType; //Ϣ
	void* Req;
	void* Param;
	UINT ReqLen;
	UINT ParamSize; //ӦĽṹĴС
	RSNetParamCallback ParamCallback;
	UINT ListParamSize; //ӦĽṹĴС
	RSNetListParamCallback ListParamCallback;
	void* UserParam;
}RSNetQueryTemporaryParamParam;

typedef struct
{
	UINT ParamType; //
	void* Req;
	void* Param;
	UINT ParamSize; //ӦĽṹĴС
	void* ListParam;
	UINT ListParamSize; //ӦĽṹĴС
	UINT ListParamNum;
	UINT TimeOut;      //ʱʱ
}RSNetQueryParamParamEx;

typedef struct
{
	UINT ParamType;
	void* Param;
	void* ListParams;
	UINT ListParamNum;
	UINT TimeOut;      //ʱʱ
}RSNetSetParamParam;

typedef struct
{
	UINT ParamMainType; //Ϣ
	UINT ParamSubType; //Ϣ
	void* Param;
	UINT ParamSize; //ӦĽṹĴС
	void* ListParams;
	UINT ListParamNum;
	BOOL  bNeedSize; //ṹǰҪҪС
}RSNetSetParamParamEx;

//////////////////////////////////////////////////////////////////////////
//Զ

//RSNetRemoteUpgradeParam.Callback
typedef void (RSNET_CALL* RSNetRemoteUpgradeCallback)(UINT code, UINT param, void* userParam);

typedef struct
{
	PCSTR FileName;
	RSNetRemoteUpgradeCallback Callback;
	void* UserParam;
	int filetype;//if it's new upgrade, then set filetype = 3;
}RSNetRemoteUpgradeParam;

typedef void* RSNetRemoteUpgrade;
//////////////////////////////////////////////////////////////////////////
//ץͼ
typedef struct
{
	UINT Channel;
	void* UserParam;
	char FileName[MAX_PATH];
	JpegPara jpgParam;
}RSNetDevCaptureParam;
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
//
typedef struct
{
	UINT ParamMainType; //Ϣ
	UINT ParamSubType; //Ϣ
	void* Param;
	UINT ParamSize; //ӦĽṹĴС
}RSNetCmdParam;
//////////////////////////////////////////////////////////////////////////




#ifdef __cplusplus
extern "C" {
#endif

RSNET_API BOOL RSNET_CALL RSNetInit();
RSNET_API void RSNET_CALL RSNetRelease();

RSNET_API UINT RSNET_CALL RSNetGetLastError();

RSNET_API void RSNET_CALL RSNetSetEncription(BOOL bEncription);

//豸
RSNET_API void RSNET_CALL RSNetSearchDev(const RSNetSearchDevParam* param);

//豸IPϢ
RSNET_API BOOL RSNET_CALL RSNetSetDevInfo(const NetMDevInfoReq* param);
RSNET_API BOOL RSNET_CALL RSNetSetNewDevInfo(const NewNetMDevInfoReq* param);

//Http
RSNET_API void RSNET_CALL RSNetHttpReqDev(RSNetHttpReq* param);
RSNET_API RSNetIDConnection RSNET_CALL RSNetHttpReqDevStart(RSNetHttpReqEx* param);
RSNET_API void RSNET_CALL RSNetHttpReqDevStop(RSNetIDConnection* conn);

//豸
RSNET_API RSNetConnection RSNET_CALL RSNetConnectionStart(const RSNetConnectionParam* param);
RSNET_API RSNetConnection RSNET_CALL RSNetConnectionStartEx(const RSNetConnectionParamEx* param);
RSNET_API void RSNET_CALL RSNetConnectionStop(RSNetConnection* conn);
RSNET_API BOOL RSNET_CALL RSNetSetIPAndPort(RSNetConnection* conn,PCSTR strIP,UINT Port);

RSNET_API BOOL RSNET_CALL RSNetGetDevInfo(RSNetConnection conn, LoginRsp* info, UINT infoSize/*=sizeof(LoginRsp)*/);
RSNET_API BOOL RSNET_CALL RSNetGetDevInfoEx(RSNetConnection conn, void* info, UINT infoSize/*=sizeof(LoginRsp)*/);
//Ԥ
RSNET_API RSNetPreview RSNET_CALL RSNetStartPreview(RSNetConnection conn, const RSNetPreviewParam* param);
RSNET_API void RSNET_CALL RSNetStopPreview(RSNetConnection conn, RSNetPreview* preview);
RSNET_API ULONGLONG RSNET_CALL RSNetGetPreviewBitRate(RSNetConnection conn, RSNetPreview preview);
RSNET_API BOOL  RSNET_CALL RSNetForceIFrame(RSNetConnection conn,BYTE channel,BYTE codeStreamType );//Force I frame

//̨ type=MsgPTZUp...
RSNET_API BOOL RSNET_CALL RSNetPTZControl(RSNetConnection conn, UINT type, const PTZControlReq* req);

//Email,ddns,Remote reboot Test
RSNET_API BOOL RSNET_CALL RSNetRemoteTest(RSNetConnection conn, const RSNetRemoteTestParam* param);

//¼ѯ
RSNET_API BOOL RSNET_CALL RSNetQueryRecord(RSNetConnection conn, const RSNetQueryRecordParam* param);
//豸ץͼ
RSNET_API BOOL RSNET_CALL RSNetCapture(RSNetConnection conn, const RSNetDevCaptureParam* param);
//¼
RSNET_API RSNetDownloadRecord RSNET_CALL RSNetStartDownloadRecord(RSNetConnection conn, const RSNetDownloadRecordParam* param);
RSNET_API void RSNET_CALL RSNetStopDownloadRecord(RSNetDownloadRecord* downloadRecord);
//¼ط
RSNET_API RSNetRecordPlay RSNET_CALL RSNetStartRecordPlay(RSNetConnection conn, const RSNetRecordPlayParam* param);
RSNET_API void RSNET_CALL RSNetStopRecordPlay(RSNetRecordPlay* recordPlay);
RSNET_API void RSNET_CALL RSNetReqRecordData(RSNetRecordPlay recordPlay);
RSNET_API void RSNET_CALL RSNetReposRecordData(RSNetRecordPlay recordPlay, const ReposRecordDataReq* req);
RSNET_API void RSNET_CALL RSNetReplayRecordData(RSNetRecordPlay recordPlay);

//Խ
//RSNetStartDualtalkNULL, ԵRSNetGetLastErrorȡʧԭ
RSNET_API RSNetDualtalk RSNET_CALL RSNetStartDualtalk(RSNetConnection conn, const RSNetDualtalkParam* param);
RSNET_API void RSNET_CALL RSNetStopDualtalk(RSNetDualtalk* dualtalk);
RSNET_API void RSNET_CALL RSNetSendDualtalkData(RSNetDualtalk dualtalk, void* data, UINT size);

//
RSNET_API BOOL RSNET_CALL RSNetQueryParam(RSNetConnection conn, const RSNetQueryParamParam* param);
RSNET_API BOOL RSNET_CALL RSNetQueryParamEx(RSNetConnection conn, const RSNetQueryParamParamEx* param);
RSNET_API BOOL RSNET_CALL RSNetQueryTemporaryParam(RSNetConnection conn, const RSNetQueryTemporaryParamParam* param);
RSNET_API BOOL RSNET_CALL RSNetSetParam(RSNetConnection conn, const RSNetSetParamParam* param);
RSNET_API BOOL RSNET_CALL RSNetSetParamEx(RSNetConnection conn, const RSNetSetParamParamEx* param);

//Զ
RSNET_API RSNetRemoteUpgrade RSNET_CALL RSNetStartRemoteUpgrade(RSNetConnection conn, const RSNetRemoteUpgradeParam* param);
RSNET_API void RSNET_CALL RSNetStopRemoteUpgrade(RSNetRemoteUpgrade* remoteUpgrade);


//澯
RSNET_API void RSNET_CALL RSNetAlarmSubscribe(RSNetConnection conn, BOOL desired);

//
RSNET_API void RSNET_CALL RSNetSimpleCmd(RSNetConnection conn,RSNetCmdParam *param);

#ifdef __cplusplus
}
#endif


#endif;