#ifndef __RSPlay_h__
#define __RSPlay_h__

#ifdef RSPLAY_EXPORTS
#define RSPLAY_API __declspec(dllexport)
#else
#define RSPLAY_API __declspec(dllimport)
#endif

#define RSPLAY_CALL __stdcall

//ſ
#define PLAY_MODE_NORMAL			0x0001
#define PLAY_MODE_STOP				0x0002
#define PLAY_MODE_PAUSE				0x0003
#define PLAY_MODE_SLOW				0x0004
#define PLAY_MODE_SLOW4				0x0005	
#define PLAY_MODE_SLOW8				0x0006
#define PLAY_MODE_SLOW16			0x0007	
#define PLAY_MODE_FAST_FORWARD2		0x0010
#define PLAY_MODE_FAST_FORWARD4		0x0011
#define PLAY_MODE_FAST_FORWARD8		0x0012
#define PLAY_MODE_FAST_FORWARD16	0x0013
#define PLAY_MODE_FAST_FORWARD32	0x0014
#define PLAY_MODE_SINGLE_FRAME		0x0030

//audio setting
#define BIT_PER_SAMPLE				16
#define PLAY_AUDIO_SAMPLE_POOR		8000
#define HI3510_TALK_DARABLOCK_SIZE	80
	
typedef struct{ 
	long nWidth; // λΪأƵΪ0
	long nHeight; // ߣλΪأƵΪ0
	long nStamp; // ʱϢλ
	long nType; //
	long nFrameRate;// ʱͼ֡
}FRAME_INFO;

typedef struct{
    void* qImagebuf;
	void* qImageEvent;
}ImageHandle;

enum{
	IMAGE_RGB32 = 16,
	IMAGE_CAPTURE= 32,
	NSysPlay_PLAY = 64,
	SysPlay_PLAY = 128
};

typedef int (CALLBACK *DECODE_CALLBACK) (long hHandle, char *pData, long lSize, FRAME_INFO *pInfo, DWORD dwUser); 
typedef ImageHandle* (CALLBACK *IMAGEINFO_CALLBACK)(int nWidth,int nHeight,void* dwObject);
typedef void (CALLBACK* DRAW_FUN_CALLBACK) (HDC hDC, DWORD with, DWORD height, void* pUser, DWORD left, DWORD top);
typedef int (CALLBACK* DUAL_SPEAK_CALLBACK)(int size, const char* data, DWORD dwUser);
typedef void (CALLBACK *IMAGEEVENT_CALLBACK)(void* qImageEvent,UINT ImageType,char*mfName, void* dwUser);
typedef void (CALLBACK *IMAGEFILE_CALLBACK)(UINT ImageType,int nWidth,int nHeight,long lSize,UCHAR* buf,char*mfName, void* dwUser);

typedef struct {
	IMAGEINFO_CALLBACK ImageSizeCallback;
	IMAGEEVENT_CALLBACK ImageEventCallback;
	UINT ImageType;
	void* dwUser;
	void* pObject;
}IMAGE_INFO;

typedef struct {
	IMAGEFILE_CALLBACK ImageEventCallback;
	const char *recordfile_name;
	const char *pic_name;
	UINT fileType;
	UINT ImageType;
	void* dwUser;
}RSFILE_INFO;

typedef struct {
	const char *recordfile_name;
	const char *pic_name;
}RSFILE_INFOEx;

//
#define VOLUM_MIN	0
#define VOLUM_MAX	100

//
#define PLAY_UNKNOW_TYPE     -1    //no file
#define PLAY_LOCALFILE_TYPE  0     //local file
#define PLAY_NETFILE_TYPE    1     //net file
#define PLAY_NETSTREAM_TYPE  2     //net stream
#define PLAY_DUALTALK_TYPE	 3	   //dual talk
#define PLAY_SYNC_TYPE		 4     //sync play

//
#define DST_SPEAKERS		0	//  
#define SRC_WAVEOUT			1   //
#define SRC_SYNTHESIZER		2	//ϳ
#define SRC_COMPACTDISC     3	//CD
#define SRC_MICROPHONE		4   //˷

#define MAX_SET_OSD_NUM		5	//OSDĿ

typedef struct __osd_info_t
{
	char font[24];
	int font_width;
	int font_height;
	unsigned char osd_color_red;		//0-255
	unsigned char osd_color_green;		//0-255
	unsigned char osd_color_blue;		//0-255
	RECT osd_rect;

	char osd_string[128];
}osd_info_t;

typedef struct{
	int iRate;
	int iWidth;
	int iFormat;
	int iAmr_mode;
	int iAmr_format;
}AudioTalkConfig_t;

//RSPlaySetCallbackMessage message wparam
#define NET_FILE_DATA_NOT_ENOUGH	1
#define FILE_PLAY_END				11
//lparm = userParam

//record
#ifndef RSFileType
#define RSFileType		1
#define RSAVIFileType	2
#endif

enum {
	YUV_444 = 1,
	YUV_422,
	YUV_420,
	YUV_411,
	RGB_565,
	RGB_555,
	RGB_24,
	RGB_32,
	ADPCM,
	IMAGE_INIT = 512
};

enum{
    DEV_TYPE_RSNEW = 0,
    DEV_TYPE_HK,
    DEV_TYPE_RSOLD
};

//platform type
enum{
	MSVS_PLATFORM =0,
	QT_PLATFORM,
	IOS_PLATFORM
};

enum{
    DRAW_TYPE_DDRAW =0,
    DRAW_TYPE_D2D1
};

#ifdef __cplusplus
extern "C" {
#endif

typedef void (CALLBACK* PLAY_FUN_CALLBACK)(UINT message, void* userParam);
typedef void (CALLBACK* CROSS_DAY_CALLBACK)(UINT message, void* userParam);
typedef void (CALLBACK* PLAY_DATA_CALLBACK)(const char* data, const UINT width, const UINT height, void* userParam);
RSPLAY_API int RSPLAY_CALL RSPlayInitPlayLib(int platformType = MSVS_PLATFORM, int nDrawType = DRAW_TYPE_DDRAW);
RSPLAY_API int RSPLAY_CALL RSPlayDeinitPlayLib(void);

RSPLAY_API unsigned long RSPLAY_CALL RSPlayCreatePlayInstance(int play_type); 
RSPLAY_API int RSPLAY_CALL RSPlayDestroyPlayInstance(unsigned long player_id);

RSPLAY_API int RSPLAY_CALL RSPlaySetCallbackMessage(unsigned long player_id, HWND hwnd, UINT message, void* userParam); //NET_FILE_DATA_NOT_ENOUGH...

RSPLAY_API int RSPLAY_CALL RSPlaySetCallbackMessageEx(unsigned long player_id, PLAY_FUN_CALLBACK callback, void* userParam);

//Ļص
RSPLAY_API int RSPLAY_CALL RSPlaySetCrossDayCallbackMessageEx(unsigned long player_id, CROSS_DAY_CALLBACK callback, void* userParam);

RSPLAY_API int RSPLAY_CALL RSPlayAddSyncPlayInstance(unsigned long sync_play, unsigned long player_id);

RSPLAY_API int RSPLAY_CALL RSPlaySetNetPlayBufNum(unsigned long player_id, int num);
//һŴڵָĲʵУһνരȾģʽ
RSPLAY_API int RSPLAY_CALL RSPlaySetPlayWnd(unsigned long player_id, HWND hwnd);
//ָĲʵɾһŴڣһνരȾģʽ
RSPLAY_API int RSPLAY_CALL RSPlayDelPlayWnd(unsigned long player_id, HWND hwnd);

RSPLAY_API int RSPLAY_CALL RSPlaySetPlayPicSize(unsigned long player_id, int width, int height);
RSPLAY_API int RSPLAY_CALL RSPlayGetNetPlayBufNum(unsigned long player_id);
RSPLAY_API HWND RSPLAY_CALL RSPlayGetPlayWnd(unsigned long player_id);
RSPLAY_API int RSPLAY_CALL RSPlayGetPlayPicSize(unsigned long player_id, int *width, int *height);

RSPLAY_API int RSPLAY_CALL RSPlayOpenPlayFile(unsigned long player_id, const char *file_name);
RSPLAY_API int RSPLAY_CALL RSPlayOpenPlayFileList(unsigned long player_id,const char* fileList, size_t strBufLen, size_t count);
RSPLAY_API int RSPLAY_CALL RSPlayOpenPlayFileListEx(unsigned long player_id,const char* fileList, size_t count);
RSPLAY_API int RSPLAY_CALL RSPlayClosePlayFile(unsigned long player_id);
RSPLAY_API int RSPLAY_CALL RSPlayGetPlayFileTimeRange(unsigned long player_id, ULONGLONG& beginTime, ULONGLONG& endTime);
RSPLAY_API ULONGLONG RSPLAY_CALL RSPlayGetCurPlayedTime(unsigned long player_id);
RSPLAY_API int RSPLAY_CALL RSPlaySetCurPlayedTime(unsigned long player_id, ULONGLONG time);
RSPLAY_API int RSPLAY_CALL RSPlaySetCurPlayedTimeEX(unsigned long player_id, ULONGLONG time);
RSPLAY_API int RSPLAY_CALL RSPlayGetPosImage(unsigned long player_id, ULONGLONG time,IMAGE_INFO *imageInfo);

RSPLAY_API int RSPLAY_CALL RSPlayGetFrameRate(unsigned long player_id, BOOL bFrame_rate);
RSPLAY_API int RSPLAY_CALL RSPlayGetBitRate(unsigned long player_id, BOOL bBit_rate);
RSPLAY_API long RSPLAY_CALL RSPlayGetTotalFrames(unsigned long player_id);
RSPLAY_API long RSPLAY_CALL RSPlayRefreshImage(unsigned long player_id);
RSPLAY_API int RSPLAY_CALL  RSPlayHardwareStretch(unsigned long player_id,BOOL benable,HWND hwnd = NULL);
RSPLAY_API int RSPLAY_CALL RSPlayGetImageiBpp(unsigned long player_id);

RSPLAY_API int RSPLAY_CALL RSPlayStartPlay(unsigned long player_id);
RSPLAY_API int RSPLAY_CALL RSPlayStopPlay(unsigned long player_id);
RSPLAY_API int RSPLAY_CALL RSPlaySetPlayMode(unsigned long player_id, int play_mode);
RSPLAY_API int RSPLAY_CALL RSPlayGetPlayMode(unsigned long player_id);


RSPLAY_API int RSPLAY_CALL RSPlayStartlocalrecord(unsigned long player_id, const char *recordfile_name, UINT fileType, UINT deviceType = DEV_TYPE_RSNEW);
RSPLAY_API int RSPLAY_CALL RSPlaySwitchRecordFile(unsigned long player_id, const char *recordfile_name, UINT fileType, UINT deviceType = DEV_TYPE_RSNEW);
RSPLAY_API int RSPLAY_CALL RSPlayStoplocalrecord(unsigned long player_id, ULONGLONG& begintime, ULONGLONG& endtime);
RSPLAY_API int RSPLAY_CALL RSPlayStartlocalrecordFile(unsigned long player_id, RSFILE_INFO *fileinfo);
RSPLAY_API int RSPLAY_CALL RSPlayCreatePicbylocalFile(unsigned long player_id,RSFILE_INFOEx *fileinfo);

RSPLAY_API int RSPLAY_CALL RSPlayInputNetFrame(unsigned long player_id, void *buf, int size);
RSPLAY_API int RSPLAY_CALL RSPlayGetListFrameNum(unsigned long player_id);

RSPLAY_API int RSPLAY_CALL RSPlayOpenSound(unsigned long player_id);
RSPLAY_API int RSPLAY_CALL  RSPlayCloseSound(unsigned long player_id);
//Control the system volume,cannot use in win7 OS
RSPLAY_API int RSPLAY_CALL RSPlaySetPlayVolume(int volume);
RSPLAY_API int RSPLAY_CALL RSPlayGetPlayVolume();
RSPLAY_API int RSPLAY_CALL RSPlaySetMute(BOOL bMute);
RSPLAY_API BOOL RSPLAY_CALL RSPlayGetMute();
//
//Only control volume on one play instance
RSPLAY_API int RSPLAY_CALL RSPlaySetPlayVolume_s(unsigned long player_id,int volume);
RSPLAY_API int RSPLAY_CALL RSPlayGetPlayVolume_s(unsigned long player_id);
RSPLAY_API int RSPLAY_CALL RSPlaySetMute_s(unsigned long player_id,BOOL bMute);
RSPLAY_API BOOL RSPLAY_CALL RSPlayGetMute_s(unsigned long player_id);
RSPLAY_API int RSPLAY_CALL RSPlaySetPlayVolume_bysoft(unsigned long player_id,int volume);
//

RSPLAY_API int RSPLAY_CALL RSPlaySetMicPlayVolume(int volume);
RSPLAY_API int RSPLAY_CALL RSPlayGetMicPlayVolume();
RSPLAY_API int RSPLAY_CALL RSPlaySetMicMute(BOOL bMute);
RSPLAY_API BOOL RSPLAY_CALL RSPlayGetMicMute();

RSPLAY_API int RSPLAY_CALL RSPlaySetOsdString(unsigned long player_id, int index, osd_info_t *p_osd_info);
RSPLAY_API int RSPLAY_CALL RSPlayRemoveOsdstring(unsigned long player_id, int index);

RSPLAY_API int RSPLAY_CALL RSPlayCapturePicture(unsigned long player_id, char *file_name);
RSPLAY_API int RSPLAY_CALL RSPlayCapturePictureBuf(unsigned long player_id, char *buf);
RSPLAY_API int RSPLAY_CALL RSPlayCapturePictureCallUser(unsigned long player_id, void *usr);

RSPLAY_API int RSPLAY_CALL RSPlayGetSDKVesion(char *ver_string);
RSPLAY_API int RSPLAY_CALL RSPlayGetLastError(unsigned long player_id, char *err_string);

RSPLAY_API int RSPLAY_CALL RSPlayStartDualTalk(unsigned long player_id, AudioTalkConfig_t *pAudioTalk = NULL);
RSPLAY_API int RSPLAY_CALL RSPlayStopDualTalk(unsigned long player_id);
RSPLAY_API int RSPLAY_CALL RSPlayRegisterSetDualCallback(unsigned long player_id, DUAL_SPEAK_CALLBACK callback, DWORD dwUser);

RSPLAY_API int RSPLAY_CALL RSPlayGetCurrentFrameNo(unsigned long player_id); 
RSPLAY_API int RSPLAY_CALL RSPlayAdjustViewArea(unsigned long player_id, int left, int right, int top, int bottom);
//עָŴڵĻͼصһνരȾģʽ
RSPLAY_API int RSPLAY_CALL RSPlayRegisterDrawFun_s(unsigned long player_id, DRAW_FUN_CALLBACK DrawFun, void* pUser,HWND hwnd);
//עָʵĻͼصڵν뵥Ⱦģʽ
RSPLAY_API int RSPLAY_CALL RSPlayRegisterDrawFun(unsigned long player_id, DRAW_FUN_CALLBACK DrawFun, void* pUser);
//bEnable = 0, ʵʱ
//bEnable = 1, iMax = 0⽫֡ݵʱţ֡ҪƣҲnet_fileģʽ
//bEnable = 1, iMax1505000,iMaxΪõ֡
RSPLAY_API int RSPLAY_CALL  RSPlaySetCushionRange(unsigned long player_id, BOOL bEnable, int iMax);
RSPLAY_API int RSPLAY_CALL RSPlayRegisterDecCallback(unsigned long player_id, DECODE_CALLBACK DecCallback, DWORD dwUser);
RSPLAY_API int RSPLAY_CALL RSPlayImageCallback(unsigned long player_id,IMAGE_INFO *pInfo,HWND hwnd = NULL);
#define RE_NORMAL			0
#define RE_MIRROR_LEFTRIGHT	1
#define RE_MIRROR_UPDOWN	2
RSPLAY_API int RSPLAY_CALL RSPlaySetRenderEffect(unsigned long player_id, int type);

//enable 0:ƽ̵ ʵͼʾʵʱĬΪ0
RSPLAY_API void RSPLAY_CALL RSPlayRenderActualProportion(unsigned long player_id, int enable); 
//Ƿʹˮӡ
RSPLAY_API void RSPLAY_CALL RSUseWaterMarkDecorder(BOOL bUse);

//ǷʾˮӡFALSEʾƵ֤ʧܣƵܱ۸Ĺ
RSPLAY_API BOOL RSPLAY_CALL RSShowWaterMark(unsigned long player_id);

RSPLAY_API BOOL RSPLAY_CALL RSPlayRePaint(unsigned long play_id);
RSPLAY_API BOOL RSPLAY_CALL RSPlayNSynchroRePaint(unsigned long play_id);
/*add by huijun 20110801*/
typedef int (CALLBACK *CONVERT_STATUS_CALLBACK) (int progress,void* param); 
RSPLAY_API int RSPLAY_CALL RSPlay264ToAviStart(unsigned long play_id,PCSTR _264FileName,PCSTR aviFileName,void* param,CONVERT_STATUS_CALLBACK status_callback);
RSPLAY_API int RSPLAY_CALL RSPlay264ToAviStop(unsigned long play_id);
#ifdef __cplusplus
}
#endif

#endif // __Play_h__
