#if !defined(AFX_CALENDARWND_H__A5C3CD84_A1EB_11D1_A637_00A0C93A70EC__INCLUDED_)
#define AFX_CALENDARWND_H__A5C3CD84_A1EB_11D1_A637_00A0C93A70EC__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
// CalendarWnd.h : header file
//

#include "CalendarToolBarWnd.h"
#include "CalendarCaptionWnd.h"


#define WM_SELDATE_CHANGE		WM_USER + 900
/////////////////////////////////////////////////////////////////////////////
// CCalendarWnd window

class CCalendarWnd : public CWnd
{
	DECLARE_DYNAMIC(CCalendarWnd)

// Construction
public:
	CCalendarWnd();

// Attributes
public:
	COLORREF		m_clrBackColor;
	COLORREF		m_clrLightColor;
	COLORREF		m_clrShadowColor;
	COLORREF		m_clrTextColor;
	COLORREF		m_clrSelBackColor;
	COLORREF		m_clrSelTextColor;
	COLORREF		m_clrTodayBackColor;
	COLORREF		m_clrTodayTextColor;
	COLORREF		m_clrRecdayTextColor;	
	CFont*  m_pDayfont;
	int  			m_DayRecState[31];
protected:

	CCalendarToolBarWnd	m_wndToolbar;
	CCalendarCaptionWnd	m_wndCaption;
	CRect				m_rectDays;
	BOOL				m_bIsDropCalendar;
	CWnd*				m_pParent;

	COleDateTime		m_Date;
	int					m_iTrackedButton;
	int					m_iPressedButton;
	int					m_iTitleHeight;
	CRect				m_rectDayLocations [31];
	int					m_iDaysInMonth;
	int					m_iFirstDayOfWeek;

	COleDateTime		m_MinDate;
	COleDateTime		m_MaxDate;

	BOOL				m_bMultipleSel;
	BOOL				m_bAbsoluteSel;

	CList<int,int>		m_SelectedDays;
	CList<int,int>		m_MarkedDays;
	int					m_iStartMultiplySelection;
	int					m_iLastMultiplySelection;

	CFont				m_fntBold;

	enum BUTTON_STATE
	{
		FLAT,
		HILIGHT,
		PRESSED
	};

// Operations
public:
	BOOL SetDate (const COleDateTime& date);
	const COleDateTime& GetDate () const;

	void SetValidInterval (const COleDateTime& from, const COleDateTime& to);

	void EnableMultipleSelection (BOOL bMultipleSel = TRUE);

	void EnableAbsoluteSelection (BOOL bAbsoluteSel = TRUE)
	{
		m_bAbsoluteSel = bAbsoluteSel;
	}

	void OnToolbarNotifyClickButton (CCalendarToolBarWnd::BUTTON_ID iID);
	void SelectDayInWeek (int iDay, BOOL bClearOther);

	void UpdateColors ();

	void ClearSelectedDays ();
	void AddSelectedDay (int iDay);
	void RemoveSelectedDay (int iDay);
	BOOL IsDaySelected (int iDay) const;

	BOOL MarkDay(short iDayNum, BOOL bMarked);
	void UnMarkAllDays();
	void MarkRecDayInMonth(BOOL bHasRec,int iday);
	void ClearMarkAllRecDaysInMonth(BOOL bClearMark);
	int GetDaysInMonth (int iMonth, int iYear) const;

protected:
	int HitTest (POINT point) const;
	BOOL GetButtonRect (int iID, CRect& rect) const;
	void RebuildLocations ();

	BOOL HideDropCalendar (const COleDateTime* pDateNew = NULL);

	BOOL IsDateValid (const COleDateTime& date) const;

	BOOL IsLeftSelected (int iDay) const;
	BOOL IsTopSelected (int iiDay) const;
	BOOL IsRightSelected (int iiDay) const;
	BOOL IsBottomSelected (int iiDay) const;

	void AlignSelectedDays (const COleDateTime& oldDate);

	void OnSelectionChanged ();
	void OnDateChanged ();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CCalendarWnd)
	public:
	virtual BOOL Create(DWORD dwStyle, int x, int y, CWnd* pParentWnd);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CCalendarWnd();

	// Generated message map functions
protected:
	//{{AFX_MSG(CCalendarWnd)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnPaint();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CALENDARWND_H__A5C3CD84_A1EB_11D1_A637_00A0C93A70EC__INCLUDED_)
