#if !defined(AFX_CHECKLISTCTRL_H__B02295B1_44F0_46AE_985A_6067632408FB__INCLUDED_)
#define AFX_CHECKLISTCTRL_H__B02295B1_44F0_46AE_985A_6067632408FB__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// CheckListCtrl.h : header file
//
#include <vector>
using namespace std;
#include "CheckHeadCtrl.h"
/////////////////////////////////////////////////////////////////////////////
// CCheckListCtrl window
#define   WM_CHECK_ALL		300
class CCheckListCtrl : public CListCtrl
{
// Construction
public:
	CCheckListCtrl();

// Attributes
public:
	
// Operations
private:
	BOOL	m_blInited;
	CImageList	m_checkImgList;


public:
	BOOL Init();

protected:
	CCheckHeadCtrl	m_checkHeadCtrl;
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CCheckListCtrl)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CCheckListCtrl();

	// Generated message map functions
protected:
	//{{AFX_MSG(CCheckListCtrl)
	afx_msg void OnItemChanged(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDeleteitem(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDeleteallitems(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnInsertitem(NMHDR* pNMHDR, LRESULT* pResult);	
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
protected:
	afx_msg void CustDraw( NMHDR * pNotifyStruct, LRESULT * result );
	typedef struct {
		COLORREF cf;
		long id;
		long subId;
	}ColorStruct;
	enum RecType {ROW=0,COL,CELL};
	vector<ColorStruct> RowColors;
	vector<ColorStruct> ColColors;
	vector<ColorStruct> CellColors;
	COLORREF Gx;
	COLORREF Gy;
	COLORREF Rx;
	COLORREF Ry;
	
	bool GridMode;
	bool AltRowMode;
	bool MaskMode;
	long findDetails(long id,RecType rt = ROW,long subId=-1);
	COLORREF InvertColor(COLORREF cf);
	int m_iNumColumns;
public: 
	void SetRowColor(COLORREF cf, long row);
	void SetColColor(COLORREF cf, long col);
	void SetCellColor(COLORREF cf, long row, long col);
	void ClrRowColor(long row);
	void ClrColColor(long col);
	void ClrCellColor(long row,long col);
	void SetGridMode(bool TurnOn,COLORREF x=0,COLORREF y=0);
	void SetTextMask(bool TurnOn);
	void SetAltRowColors(bool TurnOn,COLORREF x=0,COLORREF y=0);
	void ResetColors(void);
	BOOL SetHeadings( const CString& strHeadings );
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CHECKLISTCTRL_H__B02295B1_44F0_46AE_985A_6067632408FB__INCLUDED_)
