

#include "stdafx.h"
#include "RSLibDemo.h"
#include "ConfigDlg.h"




IMPLEMENT_DYNAMIC(CConfigDlg, CDialog)

CConfigDlg::CConfigDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CConfigDlg::IDD, pParent)
{
	m_pServerInfo = NULL;
	m_pCurShowDlg = NULL;

}

CConfigDlg::~CConfigDlg()
{
}

void CConfigDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(CConfigDlg, CDialog)
	ON_BN_CLICKED(IDC_BTN_MAINSTREAM, &CConfigDlg::OnBnClickedBtnMainstream)
	ON_BN_CLICKED(IDC_BTN_RECDOWN, &CConfigDlg::OnBnClickedBtnRecdown)
	ON_BN_CLICKED(IDC_BTN_VIDEOOUTPUTSET, &CConfigDlg::OnBnClickedBtnVideooutputset)
	ON_BN_CLICKED(IDC_BTN_SYSTIMESET, &CConfigDlg::OnBnClickedBtnSystimeset)
END_MESSAGE_MAP()




BOOL CConfigDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	ServerInfoSync.Lock();
	m_pServerInfo = g_ServerInfoList.GetHead();
	ServerInfoSync.Unlock();

	
    m_videoSetDlg.SetSeverInfo(m_pServerInfo);
	m_recDownDlg.Create(IDD_DLG_RECDOWN,this);
	m_encodeDlg.Create(IDD_DLG_ENCODE,this);
	m_videoSetDlg.Create(IDD_DLG_OUTPUT,this);
	m_systimeDlg.Create(IDD_DLG_SETSYSTIME,this);
	CRect rc;
	GetClientRect(&rc);
	rc.top += 30;
	rc.bottom -= 50;
	rc.left += 150;
	rc.right -= 50;
	m_encodeDlg.MoveWindow(rc);
	m_recDownDlg.MoveWindow(rc);
	m_videoSetDlg.MoveWindow(rc);
	m_systimeDlg.MoveWindow(rc);

	m_systimeDlg.ShowWindow(SW_HIDE);
	m_videoSetDlg.ShowWindow(SW_HIDE);
	m_recDownDlg.ShowWindow(SW_HIDE);
	m_encodeDlg.ShowWindow(SW_SHOW);
	m_pCurShowDlg = &m_encodeDlg;

	
	return TRUE;  // return TRUE unless you set the focus to a control
}

void CConfigDlg::OnBnClickedBtnMainstream()
{
	m_pCurShowDlg->ShowWindow(SW_HIDE);
	m_encodeDlg.ShowWindow(SW_SHOW);
	m_pCurShowDlg = &m_encodeDlg;
}

void CConfigDlg::OnBnClickedBtnRecdown()
{
	m_pCurShowDlg->ShowWindow(SW_HIDE);
	m_recDownDlg.ShowWindow(SW_SHOW);
	m_pCurShowDlg = &m_recDownDlg;
}

void CConfigDlg::OnBnClickedBtnVideooutputset()
{
	m_pCurShowDlg->ShowWindow(SW_HIDE);
	m_videoSetDlg.ShowWindow(SW_SHOW);
	m_pCurShowDlg = &m_videoSetDlg;
	m_videoSetDlg.QueryParamters(m_pServerInfo);
}

void CConfigDlg::OnBnClickedBtnSystimeset()
{
	m_pCurShowDlg->ShowWindow(SW_HIDE);
	m_systimeDlg.ShowWindow(SW_SHOW);
	m_pCurShowDlg = &m_systimeDlg;
	m_systimeDlg.SetSeverInfo(m_pServerInfo);
}
