// LocalPlayer.cpp
//

#include "stdafx.h"
#include "RSLibDemo.h"
#include "LocalPlayer.h"


// CLocalPlayer Dialog

IMPLEMENT_DYNAMIC(CLocalPlayer, CDialog)

CLocalPlayer::CLocalPlayer(CWnd* pParent /*=NULL*/)
: CDialog(CLocalPlayer::IDD, pParent)
, m_recPath(_T(""))
,m_nLastPos(0)
,m_bMute(FALSE)
{

}

CLocalPlayer::~CLocalPlayer()
{
}

void CLocalPlayer::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_REC_PATH, m_recPath);
	DDX_Control(pDX, IDC_PLAY_WND, m_PlayWnd);
	DDX_Control(pDX, IDC_SLIDER1, m_SliderSound);
	DDX_Control(pDX, IDC_SLIDER2, m_SliderPlay);
	DDX_Control(pDX, IDC_STATIC_TIME, m_StaticTime);
}


BEGIN_MESSAGE_MAP(CLocalPlayer, CDialog)

	ON_BN_CLICKED(IDC_BTN_FILE_FIND, &CLocalPlayer::OnBnClickedBtnFileFind)
	ON_BN_CLICKED(IDC_PLAY, &CLocalPlayer::OnBnClickedPlay)
	ON_BN_CLICKED(IDC_STOP, &CLocalPlayer::OnBnClickedStop)
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_PAUSE, &CLocalPlayer::OnBnClickedPause)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BTN_MUTE, &CLocalPlayer::OnBnClickedBtnMute)
END_MESSAGE_MAP()

void CLocalPlayer::OnBnClickedBtnFileFind()
{
	char szFileName[512]={0};
	CString strFilter = "264 File(*.264)|*.264|";
	strFilter+= "AVI File (*.avi)|*.avi|All Files (*.*)|*.*|";
	CFileDialog dlg(TRUE,NULL,NULL,OFN_PATHMUSTEXIST|OFN_FILEMUSTEXIST|OFN_ALLOWMULTISELECT, strFilter);

	char* lpFile; 
	BOOL bFirstFile = TRUE;
	dlg.m_ofn.lpstrTitle = "Load file";
	dlg.m_ofn.lpstrInitialDir = "C:\\";
	dlg.m_ofn.nMaxFile=2562;         
	lpFile = new char[1000*256];         
	dlg.m_ofn.lpstrFile=lpFile;         
	dlg.m_ofn.lpstrFile[0]=NULL;    
	if ( IDOK == dlg.DoModal())
	{
		m_recPath = dlg.GetPathName();
		UpdateData(FALSE);
		OnBnClickedStop();
	}
	delete[] lpFile;  
}

void CLocalPlayer::OnBnClickedPlay()
{

	if (m_nPlayID == 0)
	{
		m_nPlayID = RSPlayCreatePlayInstance(PLAY_LOCALFILE_TYPE);
		RSPlaySetPlayWnd(m_nPlayID, m_PlayWnd.GetSafeHwnd());
		RSPlaySetCallbackMessage(m_nPlayID, this->GetSafeHwnd(), FILE_PLAY_END, NULL);
		if(m_recPath.IsEmpty())
		{
			return;
		}

		if (RSPlayOpenPlayFile(m_nPlayID, m_recPath) != S_OK)
		{
			return;
		}

		ULONGLONG beginTime, endTime;
		if (RSPlayGetPlayFileTimeRange(m_nPlayID, beginTime, endTime) == S_OK)
		{
			m_nBegintime = beginTime/1000000;
			m_nTotaltime = (endTime-beginTime)/1000000;
			if (m_nTotaltime == 0)
			{
				OnBnClickedStop();
				return;
			}
			m_SliderPlay.SetRange(0, (int)m_nTotaltime);
			m_SliderPlay.SetPos( 0);
			m_SliderPlay.SetPageSize(1);
			m_SliderPlay.EnableWindow(TRUE);
			int iHour = 0;
			int iMin = 0;
			int iSec = 0;

			if (m_nTotaltime >= 3600)
			{
				iHour = (int)m_nTotaltime/3600;
				iMin = (int)m_nTotaltime%3600;
				if (iMin >= 60)
				{
					iSec = iMin%60;
					iMin = iMin/60;
				}
				else
				{
					iSec = iMin;
					iMin = 0;
				}
			}
			else if (m_nTotaltime >= 60 && m_nTotaltime < 3600)
			{
				iHour = 0;
				iMin = (int)m_nTotaltime/60;
				iSec = (int)m_nTotaltime%60;
			}
			else
			{
				iHour = 0;
				iMin = 0;
				iSec = (int)m_nTotaltime;
			}
			strCurTime = "00:00:00";
			strTotalTime.Format("%02d:%02d:%02d", iHour, iMin, iSec);
			CString strTime;
			strTime = strCurTime+"/"+strTotalTime;
		}

		RSPlayOpenSound(m_nPlayID);
		int volume = RSPlayGetPlayVolume();
		m_SliderSound.SetPos(volume);
		RSPlayStartPlay(m_nPlayID);
		TRACE("Play starting.....");
		m_bPause = FALSE;
		SetTimer(ID_TIMER_GET_PLAYTIME,1000,NULL);
		SetTimer(ID_TIMER_SET_VOLUME,100,NULL);
	}
	else
	{
		if (m_bPause)
		{
			m_bPause = FALSE;
			RSPlaySetPlayMode(m_nPlayID,PLAY_MODE_NORMAL);
		}
	}
}

BOOL CLocalPlayer::OnInitDialog()
{
	CDialog::OnInitDialog();
	m_nPlayID = 0;
	m_nBegintime = 0;
	m_nTotaltime = 0;
	m_bPause = TRUE;

	CString strActiveFile,strDisableFile,strFile;
	m_SliderPlay.SetCustomerSetSize(TRUE);
	strFile = theApp.m_strAppPath + SKINPATH+"progress_slider_backgnd.bmp";
	strActiveFile = theApp.m_strAppPath + SKINPATH+"progress_slider_foregnd.bmp";
	m_SliderPlay.SetBitmapChannel( strFile, strActiveFile,strFile, FALSE );
	strFile = theApp.m_strAppPath + SKINPATH+"skin_slider_progress01.bmp";
	strActiveFile = theApp.m_strAppPath + SKINPATH+"skin_slider_progress02.bmp";
	strDisableFile = theApp.m_strAppPath + SKINPATH+"skin_slider_progress03.bmp";
	m_SliderPlay.SetBitmapThumb( strFile,strActiveFile,strDisableFile, TRUE);
	m_SliderPlay.SetMarginTop(4);
    m_SliderPlay.EnableWindow(FALSE);
	return TRUE;  // return TRUE unless you set the focus to a control
}

void CLocalPlayer::OnBnClickedStop()
{
	// TODO: ڴӿؼ֪ͨ
	if (m_nPlayID != 0)
	{
		//KillTimer(ID_TIMER_GET_PLAYTIME);
		RSPlayCloseSound(m_nPlayID);
		RSPlayStopPlay(m_nPlayID);
		RSPlayClosePlayFile(m_nPlayID);
		RSPlayDestroyPlayInstance(m_nPlayID);
		m_nPlayID = NULL;
		m_PlayWnd.Invalidate();
		KillTimer(ID_TIMER_SET_VOLUME);
		KillTimer(ID_TIMER_GET_PLAYTIME);
		m_SliderSound.SetPos(0);
		m_SliderPlay.SetPos(0);
		m_SliderPlay.EnableWindow(FALSE);
	}
}

void CLocalPlayer::OnClose()
{
	OnBnClickedStop();
	CDialog::OnClose();
}

void CLocalPlayer::OnBnClickedPause()
{
	if (m_nPlayID != NULL)
	{
		RSPlaySetPlayMode(m_nPlayID,PLAY_MODE_PAUSE);
		RSPlayCloseSound(m_nPlayID);
		RSPlayOpenSound(m_nPlayID);
	}
	m_bPause = TRUE;
}


void CLocalPlayer::OnTimer(UINT_PTR nIDEvent)
{
	if(nIDEvent == ID_TIMER_SET_VOLUME)
	{
		int volume = m_SliderSound.GetPos();
		RSPlaySetPlayVolume(volume);
	}
	else if(ID_TIMER_GET_PLAYTIME == nIDEvent)
	{
		GetPlayedTime();
	}
	CDialog::OnTimer(nIDEvent);
}

void CLocalPlayer::GetPlayedTime()
{
	ULONGLONG time = RSPlayGetCurPlayedTime(m_nPlayID);
	if (time != 0)
	{
		int iHour = 0;
		int iMin = 0;
		int iSec = 0;
		ULONGLONG iPlaytime = (time+500000)/1000000-m_nBegintime;
		if (iPlaytime >= 3600)
		{
			iHour = iPlaytime/3600;
			iMin = iPlaytime%3600;
			if (iMin >= 60)
			{
				iSec = iMin%60;
				iMin = iMin/60;
			}
			else
			{
				iSec = iMin;
				iMin = 0;
			}
		}
		else if (iPlaytime >= 60 && iPlaytime < 3600)
		{
			iHour = 0;
			iMin = iPlaytime/60;
			iSec = iPlaytime%60;
		}
		else
		{
			iHour = 0;
			iMin = 0;
			iSec = iPlaytime;
		}

		strCurTime.Format("%02d:%02d:%02d", iHour, iMin, iSec);
		CString strTime;
		strTime = strCurTime+"/"+strTotalTime;
		m_StaticTime.SetWindowText(strTime);
		m_SliderPlay.SetPos(iPlaytime);
	}
}


void CLocalPlayer::OnBnClickedBtnMute()
{
	m_bMute = !m_bMute;
	BOOL bMute = RSPlayGetMute();
	RSPlaySetMute(m_bMute);
}


LRESULT CLocalPlayer::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	// TODO: Add your specialized code here and/or call the base class	
	switch(message)
	{
	case WM_BITMAPSLIDER_MOVED:
		{
			if(wParam == IDC_SLIDER2)
			{
				ULONGLONG iPosime = (lParam+m_nBegintime)*1000000;
				RSPlaySetCurPlayedTime(m_nPlayID,iPosime);	
				RSPlayStopPlay(m_nPlayID);
				if (m_bMute)
				{
					RSPlayCloseSound(m_nPlayID);
				}
				RSPlayStartPlay(m_nPlayID);
				if (m_bMute)
				{
					RSPlayOpenSound(m_nPlayID);
				}

				SetTimer(ID_TIMER_GET_PLAYTIME,1000,NULL);
			}
		}
		break;
	case  FILE_PLAY_END:
		OnBnClickedStop();
		break;
	default:
		break;		
	}
	return CDialog::WindowProc(message, wParam, lParam);
}