// MyMenu.cpp : ʵļ
//

#include "stdafx.h"
#include "MyMenu.h"
#include "RSLibDemo.h"
//#include "..\RSLibDemo.h"
// CMyMenu

// CMyMenu Ϣ
CMyMenu::CMyMenu(int nWidth, int nHeight)
{
	m_nWidth  = nWidth;
	m_nHeight = nHeight;
// 	m_Bitmap.LoadBitmap(IDB_MENU_BK);
// 	m_BmpCheck.LoadBitmap(IDB_MENU_CHECK);
	CString strFile;
	strFile = theApp.m_strSkinPath +"MenuBK.bmp";

	HBITMAP hBitmap = (HBITMAP)LoadImage(NULL, strFile, IMAGE_BITMAP, 0, 0, LR_DEFAULTCOLOR|LR_LOADFROMFILE |LR_CREATEDIBSECTION);
	if( NULL != hBitmap)
	{
		m_Bitmap.Attach(hBitmap);
	}

	strFile = theApp.m_strSkinPath +"MenuCheck.bmp";
	hBitmap = (HBITMAP)LoadImage(NULL, strFile, IMAGE_BITMAP, 0, 0, LR_DEFAULTCOLOR|LR_LOADFROMFILE |LR_CREATEDIBSECTION);
	if( NULL != hBitmap)
	{
		m_BmpCheck.Attach(hBitmap);
	}
}
CMyMenu::CMyMenu(HBITMAP hBitmap, int nWidth, int nHeight)
{
	ASSERT(hBitmap != NULL);
	m_nWidth  = nWidth;
	m_nHeight = nHeight;
	m_Bitmap.Attach(hBitmap);
//	m_BmpCheck.LoadBitmap(IDB_MENU_CHECK);
	CString strFile;
	strFile = theApp.m_strSkinPath +"MenuCheck.bmp";
	HBITMAP hBitmap1 = (HBITMAP)LoadImage(NULL, strFile, IMAGE_BITMAP, 0, 0, LR_DEFAULTCOLOR|LR_LOADFROMFILE |LR_CREATEDIBSECTION);
	if( NULL != hBitmap1)
	{
		m_BmpCheck.Attach(hBitmap1);
	}
}
CMyMenu::CMyMenu(LPCTSTR lpszBkImage, int nWidth, int nHeight)
{
	m_nWidth  = nWidth;
	m_nHeight = nHeight;

	if(lpszBkImage != NULL)
	{
#if 0
		CImage img;
		HRESULT hr;
		hr = img.Load(lpszBkImage);
		if(FAILED(hr))
			return;
		m_Bitmap.Attach(img.Detach());	
#else
		HBITMAP hBitmap = (HBITMAP)LoadImage(NULL, lpszBkImage, IMAGE_BITMAP, 0, 0, LR_DEFAULTCOLOR|LR_LOADFROMFILE |LR_CREATEDIBSECTION);
		if( hBitmap == NULL)
			return;
		m_Bitmap.Attach(hBitmap);
#endif		
	}
	else
	{
		CString strFile;
		strFile = theApp.m_strSkinPath +"MenuBK.bmp";
		HBITMAP hBitmap = (HBITMAP)LoadImage(NULL, strFile, IMAGE_BITMAP, 0, 0, LR_DEFAULTCOLOR|LR_LOADFROMFILE |LR_CREATEDIBSECTION);
		if( NULL != hBitmap)
		{
			m_Bitmap.Attach(hBitmap);
		}
		else
		{
			AfxMessageBox("Failed to load image! CMyMenu(LPCTSTR lpszBkImage, int nWidth, int nHeight)");
			return;
		}        
	}
	//m_BmpCheck.Attach(::LoadBitmap(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_MENU_CHECK)));
//	m_BmpCheck.LoadBitmap(IDB_MENU_CHECK);
	CString strFile;
	strFile = theApp.m_strSkinPath +"MenuCheck.bmp";
	HBITMAP hBitmap = (HBITMAP)LoadImage(NULL, strFile, IMAGE_BITMAP, 0, 0, LR_DEFAULTCOLOR|LR_LOADFROMFILE |LR_CREATEDIBSECTION);
	if( NULL != hBitmap)
	{
		m_Bitmap.Attach(hBitmap);
	}
}

void CMyMenu::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct)
{
	LPDRAWITEMSTRUCT lpDIS = lpDrawItemStruct;
	CDC* pDC = CDC::FromHandle(lpDIS->hDC);
	CRect  rectItem;
	rectItem.SetRect(lpDIS->rcItem.left, lpDIS->rcItem.top, lpDIS->rcItem.right, lpDIS->rcItem.bottom);

	MenuItemData* pItem = (MenuItemData*)(lpDIS->itemData);
	// ÿһITEM, ҪƵײͼƬ
	
	BITMAP bm;
	::GetObject(m_Bitmap.m_hObject, sizeof(BITMAP), &bm);
  //  TRACE("-->>>> bm=(%d,%d) <<<<---\n", bm.bmWidth, bm.bmHeight);

	CDC memDC;
	memDC.CreateCompatibleDC(pDC);
	CBitmap  bmp;
	bmp.CreateCompatibleBitmap(pDC, rectItem.Width(), rectItem.Height());
	CBitmap *pOldBitmap = memDC.SelectObject(&bmp);
	memDC.FillSolidRect(CRect(0,0, rectItem.Width(), rectItem.Height()), DLG_BK_COLOR);
	memDC.DrawState(CPoint(0,0), CSize(rectItem.Width(), rectItem.Height()), &m_Bitmap, DST_BITMAP, 0);
	if( lpDIS->itemState & ODS_CHECKED )
	{
		memDC.DrawState(CPoint(2,2), CSize(14, 14), &m_BmpCheck, DST_BITMAP, 0);
	}
	// ڴDC
	CFont  font;
	font.CreatePointFont(8, "", pDC);
	CFont* pFont = pDC->SelectObject(&font);
	memDC.SelectObject(pFont);
	pDC->SelectObject(pFont);
	SetTextColor(memDC, RGB(255,255,255));
/*
	CFont  font;
	LOGFONT logfont;
	memset(&logfont, 0, sizeof(LOGFONT));
	strcpy_s(logfont.lfFaceName,"");
	logfont.lfWidth = 6;
	logfont.lfHeight = 10;
	logfont.lfWeight = FW_NORMAL;
	font.CreateFontIndirect(&logfont);
	memDC.SelectObject(&font);
*/
	// ұ߾δС
	CRect rectRight(bm.bmWidth, 0, rectItem.Width(), rectItem.Height());
	memDC.FillSolidRect(&rectRight, DLG_BK_COLOR);
	rectRight.DeflateRect(1,1);//(bm.bmWidth+1, 1, rectItem.Width(), rectItem.Height()-1);	
	if( pItem->hIcon != NULL)
	{
	}

	if( 0 == pItem->nType ) // Ƿָ;ܱѡ;
	{
		CPen  penLine(PS_SOLID, 1, RGB(197,194,184));
		CPen* pOldPen = memDC.SelectObject(&penLine);
		
		memDC.MoveTo(CPoint(rectRight.left, (rectRight.top+rectRight.bottom)/2));
		memDC.LineTo(CPoint(rectRight.right, (rectRight.top+rectRight.bottom)/2)); 
		memDC.SelectObject(pOldPen);

	}
	else if( 1 == pItem->nType)
	{
		if( lpDIS->itemState & ODS_SELECTED )
		{
			if( !(lpDIS->itemState & ODS_DISABLED))
			{
				CBrush  brush(RGB(189, 203,231));
				CBrush *pOldBrush = memDC.SelectObject(&brush);
				CPen  penLine(PS_SOLID, 1, RGB(49, 106, 197));
				CPen* pOldPen = memDC.SelectObject(&penLine);
				memDC.Rectangle(&rectRight);
				memDC.SelectObject(pOldBrush);
				memDC.SelectObject(pOldPen);
			}
			rectRight.left += 12;
			memDC.SetBkMode(TRANSPARENT);
			CRect rectRightSelect = rectRight;

			SetTextColor(memDC, RGB(0,0,0));
			//rectRightSelect.OffsetRect(1, -1);
			if( lpDIS->itemState & ODS_DISABLED)
				SetTextColor(memDC, RGB(192,192,192));
			memDC.DrawText(pItem->ItemTitle, rectRightSelect, DT_LEFT|DT_VCENTER|DT_SINGLELINE);
			
		}

		else
		{
			if( lpDIS->itemState & ODS_DISABLED)
				SetTextColor(memDC,  RGB(192,192,192));

			//memDC.FillSolidRect(&rectRight, RGB(250, 250, 250));
			rectRight.left += 12;

			memDC.SetBkMode(TRANSPARENT);
			memDC.DrawText(pItem->ItemTitle, rectRight, DT_LEFT|DT_VCENTER|DT_SINGLELINE);
		}
	}
	else
	{
	}

	pDC->BitBlt(rectItem.left, rectItem.top, rectItem.Width(), rectItem.Height(), &memDC, 0, 0, SRCCOPY);
	
	memDC.SelectObject(pOldBitmap);
	bmp.DeleteObject();
	memDC.DeleteDC();
}

void CMyMenu::MeasureItem(LPMEASUREITEMSTRUCT lpMeasureItemStruct)
{
	LPMEASUREITEMSTRUCT lpMIS = lpMeasureItemStruct;
	MenuItemData* pItem = (MenuItemData*)(lpMIS->itemData);
	if( -1 == pItem->nType )
	{
		lpMIS->itemHeight = 0;
		lpMIS->itemWidth  = 0;
	}
	else if( 0 == pItem->nType )
	{
		lpMIS->itemHeight = 4;
		lpMIS->itemWidth = m_nWidth;
	}
	else if( 1 == pItem->nType )
	{
		lpMIS->itemHeight = m_nHeight;
		lpMIS->itemWidth = m_nWidth;
	}
}


