// SysTime.cpp : ʵļ
//

#include "stdafx.h"
#include "RSLibDemo.h"
#include "SysTime.h"


// CSysTime Ի

IMPLEMENT_DYNAMIC(CSysTime, CDialog)

CSysTime::CSysTime(CWnd* pParent /*=NULL*/)
	: CDialog(CSysTime::IDD, pParent)
{
	m_pServer = NULL;
   ZeroMemory(&m_TimeReq,sizeof(m_TimeReq));
}

CSysTime::~CSysTime()
{
}

void CSysTime::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COM_TIMEZONE, m_com_TimeZone);
	DDX_Control(pDX, IDC_DATE_YEAR, m_SysDate);
	DDX_Control(pDX, IDC_DATE_TIME, m_SysTime);
}

static void RSNET_CALL SearchListParamCallback(void* listParam, void* userParam)
{
	CSysTime* pThis = (CSysTime*)userParam;
	pThis->DataCopy((TimeSyncReq*)listParam);
}

BEGIN_MESSAGE_MAP(CSysTime, CDialog)
	ON_BN_CLICKED(IDC_SAVE, &CSysTime::OnBnClickedSave)
	ON_BN_CLICKED(IDC_QUERY, &CSysTime::OnBnClickedQuery)
END_MESSAGE_MAP()


// CSysTime Ϣ

BOOL CSysTime::OnInitDialog()
{
	CDialog::OnInitDialog();
    CString str,strMap;
	int count = 0;
	for (int i=12; i>0;--i)
	{
		if (i == 4 || i == 3)
		{
           str.Format("GMT-%02d:30",i);
		   strMap.Format("GMT-%d:30",i);
		   m_com_TimeZone.AddString(str);
		   m_timeMap.SetAt(strMap,count++);
		}
		str.Format("GMT-%02d:00",i);
		strMap.Format("GMT-%d:00",i);
		m_com_TimeZone.AddString(str);
		m_timeMap.SetAt(strMap,count++);
	}
	
    for (int i=1; i< 14; ++i)
    {
		str.Format("GMT+%02d:00",i);
		strMap.Format("GMT+%d:00",i);
		m_com_TimeZone.AddString(str);
		m_timeMap.SetAt(strMap,count++);
		if (i == 3 || i == 4 || i == 6 || i == 9 || i == 5)
		{
			str.Format("GMT+%02d:30",i);
			strMap.Format("GMT+%d:30",i);
			m_com_TimeZone.AddString(str);
			m_timeMap.SetAt(strMap,count++);
			if (i == 5)
			{
				str.Format("GMT+%02d:45",i);
				strMap.Format("GMT+%d:45",i);
				m_com_TimeZone.AddString(str);
				m_timeMap.SetAt(strMap,count++);
			}
		}
    }
    
	m_com_TimeZone.SetCurSel(0);
	return TRUE;
}

void CSysTime::OnBnClickedSave()
{
	ASSERT(m_pServer != NULL);

	SYSTEMTIME sTime;
	memset(&sTime, 0, sizeof(sTime));
	m_SysDate.GetTime(&sTime);
	m_TimeReq.Time.Year = sTime.wYear;
	m_TimeReq.Time.Month = sTime.wMonth;
	m_TimeReq.Time.Day = sTime.wDay;

	m_SysTime.GetTime(&sTime);
	m_TimeReq.Time.Hour = sTime.wHour;
	m_TimeReq.Time.Minute = sTime.wMinute;
	m_TimeReq.Time.Second = sTime.wSecond;

	int index = -1;
	index = m_com_TimeZone.GetCurSel();
    CString strKey;
	int count = 0;
	POSITION pos = m_timeMap.GetStartPosition();
	while(pos)
	{
		m_timeMap.GetNextAssoc(pos,strKey,count);
		if (count == index)
		{
           memcpy(m_TimeReq.TimeZone,strKey,strKey.GetLength()+1);
		   break;
		}
	}

	RSNetSetParamParamEx param = {0};
	param.ParamMainType = MsgSyncTimeCtl;
	param.ParamSubType = MsgSyncSetTime;
	param.ParamSize = sizeof(m_TimeReq);
	param.Param = &m_TimeReq;
	if(RSNetSetParamEx(m_pServer->pNetConnection,&param))
	{
		AfxMessageBox("Set Params success !");
		return ;
	}

	AfxMessageBox("Set Params failded !");
}

void CSysTime::OnBnClickedQuery()
{
	ASSERT(m_pServer != NULL);

	RSNetQueryTemporaryParamParam param = {0};
    ZeroMemory(&m_TimeReq,sizeof(m_TimeReq));

	param.ParamMainType = MsgSyncTimeCtl;
	param.ParamSubType = MsgSyncGetTime;
	param.ParamSize = sizeof(m_TimeReq);
	//param.Param = &m_TimeReq;
	//param.ParamSize = 0;
    //param.ListParamSize = sizeof(m_TimeReq);
	//param.Req =NULL;
	param.UserParam = this;
	param.ParamCallback = SearchListParamCallback;
	if(RSNetQueryTemporaryParam(m_pServer->pNetConnection,&param))
	{
		int index = -1;
		m_timeMap.Lookup(m_TimeReq.TimeZone,index);
		if (index == -1)
		{
			index = 0;
		}

		m_com_TimeZone.SetCurSel(index);
		SYSTEMTIME sTime;
		memset(&sTime, 0, sizeof(sTime));
		sTime.wYear = m_TimeReq.Time.Year;
		sTime.wMonth = m_TimeReq.Time.Month;
		sTime.wDay = m_TimeReq.Time.Day;
		sTime.wHour = m_TimeReq.Time.Hour;
		sTime.wMinute = m_TimeReq.Time.Minute;
		sTime.wSecond = m_TimeReq.Time.Second;
		m_SysDate.SetTime(&sTime);
        m_SysTime.SetTime(&sTime);

		AfxMessageBox("Query Params success !");
		return ;
	}

    AfxMessageBox("Query Params failed !");
}

void CSysTime::SetSeverInfo(SERVER_INFO *pInfo)
{
	ASSERT(pInfo != NULL);

	m_pServer = pInfo;
}

void CSysTime::DataCopy(TimeSyncReq *pReq)
{
	ASSERT(pReq != NULL);
	memcpy(&m_TimeReq,pReq,sizeof(m_TimeReq));
}