/*********************************

  		RS NetParamether
		mai 20110224

*********************************/

#ifndef __RS_NETPARAMETHER_H__
#define __RS_NETPARAMETHER_H__

#include "RSNetProtocol.h"
//#include "RSPLParameter.h" //RSPL_MAXNAMELEN

#define ParamToNet 1 // caiwang213 20110603
#define NetToParam 0
#define CheckParam 2
#define ParamToNetDefault 3 //default parameter 20141017
#define ParamError (-2)

#define RS_Open 1
#define RS_Close 0


/* ******************** *
   
	Ϣ

* ******************** */

//TvSystem
#define RS_PAL 0
#define RS_NTSC 1
typedef struct {
	UINT StructSize; //ýṹС

	//ϵͳ
	BYTE DeviceName[MaxNameLen];
	UINT DeviceID;
    
	BYTE TvSystem; /*ͷʽ: <RS_PAL, RS_NTSC>*/
	
	//ϵͳϢ
	BYTE DeviceType[MaxNameLen]; //豸
	BYTE MacAddr[MaxNameLen];    
	BYTE SoftwareVer[MaxNameLen]; //ϵͳ汾
	BYTE HardwareVer[MaxNameLen]; //Ӳ汾
	BYTE IEVer[MaxNameLen]; 	  //IE汾ͺ		/*Yiguang 11.06.15*/
	BYTE IpAddr[MaxIpLen];
	
	UINT MobilePort;//ֻ˿
	UINT Port;
	UINT WebPort;
	
	BYTE DdnsHostStatus[MaxNameLen];	
	BYTE HddStatus[MaxNameLen];
	
	BYTE P2pKeyID[12];
    BYTE P2pUID[40];  // kguardû
	BYTE Language;    // ӦLANGUAGE_Eֵ
	BYTE Audio;				/*0: close; 1: open*/
	BYTE MicInVolume;	/* С(0 - 100) */
	BYTE LineOutVolume; /* С(0 - 100) */
	BYTE AdecEncoding;	/*  0, PT_G711U;1,PT_G711A */
    BYTE AgentVer[16];  //agent 汾(lorex)
	//BYTE reservel[40];
}RSNet_SystemBaseInfo_t;



/* ******************** *
   
		Ӳ

* ******************** */

//HddState
#define RS_HDDS_NONE 		0
#define RS_HDDS_UNFORMAT 	1
#define RS_HDDS_OK 	    	2
#define RS_HDDS_BAD 		3
#define RS_HDDS_RONLR 		4
#define RS_HDDS_BACKUP  	5   //
#define RS_HDDS_INVALID 	6

//OverWrite
#define RS_OverWrite_Close 	0
#define RS_OverWrite_Auto 	1
#define RS_OverWrite_1Hour 	2
#define RS_OverWrite_3Hours 3
#define RS_OverWrite_1Day 	4
#define RS_OverWrite_7Days 	5
#define RS_OverWrite_30Days 6
#define RS_OverWrite_90Days 7

typedef struct{
	UINT StructSize; //ýṹС
	UINT HddMask; 		 //Ӳ

	/*Ӳ״̬*/
	unsigned long long HddState;  
	unsigned long long HddTotalSize;/*λ:ֽ*/
	unsigned long long HddFreeSize;
	unsigned long long HddFreeRecord; //ʣ¼ʱ
}RSNet_SoleHddInfo_t;

typedef struct {
	UINT StructSize; //ýṹС

	//Ӳ
	/*Զѡ*/
    BYTE  OverWrite;       
	BYTE RecordState;
	BYTE SupportOneHdd;
	BYTE reservel;
	
	UINT Redundancy;      /*32bit, ÿbitӦһӲԣ=0, ̣ =1,  */
	UINT OverWritePeriod; /*ڣСʱΪλ*/
	BYTE RecordChn[16][32];
}RSNet_HddInfo_t;




/* ******************** *
   
		

* ******************** */

//Protocol
#define RS_PelcoD 0
#define RS_PelcoP 1

//Baudrate
#define RS_Baudrate_1200 0
#define RS_Baudrate_2400 1
#define RS_Baudrate_4800 2
#define RS_Baudrate_9600 3

//DataBit
#define RS_DataBit_8 0
#define RS_DataBit_7 1
#define RS_DataBit_6 2
#define RS_DataBit_5 3

//StopBit
#define RS_StopBit_1 0
#define RS_StopBit_2 1

//Check
#define RS_CheckBit_None  0
#define RS_CheckBit_Odd   1
#define RS_CheckBit_Even  2
#define RS_CheckBit_Mark  3
#define RS_CheckBit_Space 4

//KbSwitch
#define RS_SerialKB  0
#define RS_SerialChn 1

typedef struct {
	UINT StructSize; //ýṹС

    /*Э*/
    BYTE Protocol;   
    /**/
    BYTE Baudrate;
    /*λ*/
    BYTE DataBit;
    /*ֹͣλ*/
    BYTE StopBit;
    /*У*/
    BYTE Check;
	/*PS:ݲʹã͸ͨORѡ 0:̣1:͸ͨ  */
	BYTE KbSwitch;
	BYTE reservel[2];
}RSNet_SerialInfo_t;




//û

#define RS_MAX_USER_NUMBER 7
//#define RS_USERRIGHT_MAX_PAGE 128


// ÿûϢ

//UserStatus
#define RS_UserLiveOff 0
#define RS_UserLiveOn  1

/*
//ûȨ޸λʾ
enum RSNet_UserPageRight{
	RS_LIVE_PAGE = 0,
	RS_OUTPUT_PAGE,
	RS_RECPARA_PAGE,
	RS_SCHEDULE_PAGE,
	RS_RECSEARCH_PAGE,
	RS_NETWORK_PAGE,
	RS_DDNS_PAGE,
	RS_EMAIL_PAGE,
	RS_MOBILE_PAGE,
	RS_NTP_PAGE,
	RS_HDD_PAGE,
	RS_ALARM_PAGE,
	RS_PTZ_PAGE,
	RS_PTZ_CTRL,
	RS_SERIAL_PAGE,
	RS_GENERAL_PAGE,
	RS_MOTION_PAGE,
	RS_VERSION_PAGE,
	RS_STOP_RECORD,
	RS_MAINTAIN_PAGE,
	RS_REBOOT,
	RS_POWER_OFF,
	RS_ABNORMAL_PAGE,
	RS_LOG_PAGE,
	RS_MAINSTREAM_PAGE,
	RS_SUBSTREAM_PAGE,
	RS_START_RECORD,
	RS_VIDEOCOVER_PAGE,
	RS_BACKTOFACTORYSET_PAGE,
};
*/


typedef struct 
{
	UINT StructSize; 	//ýṹС
	UINT UserMask; 	// ΪMAX_USER_NUM

	BYTE Password[8];		// û
	BYTE Password2[8];		// ûȷ
	BYTE UserName[10];		// û

	BYTE HaveSwitch;	// ¼뿪	<RS_Open, RS_Close>

	BYTE HaveUser;		// ûǷʹ <RS_Open, RS_Close> 

	BYTE UserStatus;		// û״̬		//1Ϊ,0Ϊ
	BYTE reservel[3];

	UserRightWrap au8UserRights; //λ¼ 1ΪȨЧ
	BYTE c32Password[32];		// û
	BYTE c32Password2[32];		// ûȷ
}RSNet_SoleUserInfo_t;

typedef struct {
	UINT StructSize; 	//ýṹС
	UINT MaxUerNum; 	//ܹû
	UINT DeviceID;
	char DeviceName[36];
}RSNet_UserSet_t;




//DST
//TimeMode
#define RS_TimeMode_24 0
#define RS_TimeMode_12 1

//DateMode
#define RS_DateMode_MDY 0
#define RS_DateMode_YMD 1
#define RS_DateMode_DMY 2

//Offset
#define RS_Dst1Hour 0
#define RS_Dst2Hour 1

//DstMode
#define RS_DstWeek 0
#define RS_DstDate 1


//StartMonth, EndMonth
#define RS_DstMonth_January 	0
#define RS_DstMonth_February 	1
#define RS_DstMonth_March 		2
#define RS_DstMonth_April 		3
#define RS_DstMonth_May 		4
#define RS_DstMonth_June 		5
#define RS_DstMonth_July 		6
#define RS_DstMonth_August 		7
#define RS_DstMonth_September 	8
#define RS_DstMonth_October 	9
#define RS_DstMonth_November 	10
#define RS_DstMonth_December 	11

//StartWeek, EndWeek
#define RS_DstFristWeek 	0
#define RS_DstSecondWeek 	1
#define RS_DstThirdWeek 	2
#define RS_DstFourthWeek 	3
#define RS_DstFifthWeek 	4

//StartWeekDay, EndWeekDay
#define RS_DstSunday		0
#define RS_DstMonday 		1
#define RS_DstTuesday		2
#define RS_DstWednesday 	3
#define RS_DstThursday		4
#define RS_DstFriday		5
#define RS_DstSaturday		6


typedef struct {
	UINT StructSize; //ýṹС

    DateTime time; //ϵͳʱ
    /*ʱʽ*/
    BYTE TimeMode;
    /*ڸʽ0ΪMM/DD/YY1ΪYY-MM-DD2ΪDD/MM/YY*/
    BYTE DateMode;
    /*ʱ<RS_Close, RS_Open>*/
    BYTE Dst;
	/* Dstƫʱֵ0-1hour1-2hour */
    BYTE Offset;
    /*ʱģʽ0-Week1-Date*/
    BYTE DstMode;
	/*ʼ£12:0---11*/
    BYTE StartMonth;    
    /*ʼܣ0-һܣ1-ڶܣ2-ܣ3-,4-*/
    BYTE StartWeek;
	/*ʼڼ0-Sun,1-Mon, ...6-Sat*/
	BYTE StartWeekDay;
	/*£12:0---11*/
    BYTE EndMonth;
    /*ܣ0-һܣ1-ڶܣ2-ܣ3-*/
    BYTE EndWeek;
	/*ڼ0-Sun,1-Mon, ...6-Sat*/
	BYTE EndWeekDay;

	BYTE StartSecond;
	BYTE EndSecond;
	BYTE reservel[3];

	/*Dst ʼʱ䣬*/
    BYTE StartDate[4];
	/*Dst ʼʱ䣬ʱ*/
    BYTE StartHour[4];
	/*Dst ʱ䣬 */
    BYTE EndDate[4];
	/*Dst ʱ䣬ʱ */
    BYTE EndHour[4];
}RSNet_DSTSet_t;       // ˽ṹǶ׳ṹԱЭ

//Ntp

/*NtpIPAddr  NTPַ*/
#define RS_Ntp_windows   0
#define RS_Ntp_nist 	 1
#define RS_Ntp_ntp 		 2
#define RS_Ntp_lorexddns 3
/*Ӧʾ
time.windows.com
time.nist.gov
pool.ntp.org
ntp.lorexddns.net
*/

//TimeZone
//PS:b12 = GMT-12:00
//PS:f8  = GMT+8:00
//PS:b0430  = GMT-4:30
#define RS_TimeZone_GMT_b12 	0  
#define RS_TimeZone_GMT_b11 	1 
#define RS_TimeZone_GMT_b10 	2 
#define RS_TimeZone_GMT_b09 	3 
#define RS_TimeZone_GMT_b08 	4 
#define RS_TimeZone_GMT_b07 	5 
#define RS_TimeZone_GMT_b06 	6 
#define RS_TimeZone_GMT_b05 	7 
#define RS_TimeZone_GMT_b0430 	8 
#define RS_TimeZone_GMT_b04 	9 
#define RS_TimeZone_GMT_b0330 	10 
#define RS_TimeZone_GMT_b03 	11 
#define RS_TimeZone_GMT_b02 	12 
#define RS_TimeZone_GMT_b01 	13 
#define RS_TimeZone_GMT 		14
#define RS_TimeZone_GMT_f01 	15 
#define RS_TimeZone_GMT_f02 	16 
#define RS_TimeZone_GMT_f03 	17 
#define RS_TimeZone_GMT_f0330 	18 
#define RS_TimeZone_GMT_f04 	19 
#define RS_TimeZone_GMT_f0430 	20 
#define RS_TimeZone_GMT_f05 	21 
#define RS_TimeZone_GMT_f0530 	22 
#define RS_TimeZone_GMT_f0545 	23 
#define RS_TimeZone_GMT_f06 	24 
#define RS_TimeZone_GMT_f0630 	25 
#define RS_TimeZone_GMT_f07 	26 
#define RS_TimeZone_GMT_f08 	27 
#define RS_TimeZone_GMT_f09 	28 
#define RS_TimeZone_GMT_f0930 	29 
#define RS_TimeZone_GMT_f10 	30 
#define RS_TimeZone_GMT_f11 	31 
#define RS_TimeZone_GMT_f12 	32 
#define RS_TimeZone_GMT_f13 	33 


//IPCͨ״̬
typedef struct {
	UINT StructSize; //ýṹС
	UINT ChannelMask;//ͨ

	/*IPַ*/   
	BYTE IPAddr[4];
	/*ý˿*/
	UINT Port;
	/*½û*/
	BYTE UserName[36];
	/*½û*/
	BYTE UserPW[36];    
	/*Ӧǰ豸Ǹͨ,ǰdvrжͨ*/
	BYTE ChnNo;
	/*0:raysharp,1:hikvison,2:sony*/
	BYTE Protocol;	
	/*Ƿãֻ*/
	BYTE Enable;
	/*ǰipӦǰ豸ͨ*/
	BYTE ChnMax;
	/*ǰipͨϵ״̬, ֻ*/
	BYTE IPChnStatus;
	BYTE Version;
	BYTE switchmode; /*0 Զģʽ 1 ֶģʽ*/
	BYTE reservel;

	unsigned long long u64devType;  //豸
	BYTE macAddr[36];    //mac ַ
	BYTE IpcName[36];    //豸ƣֻ

	char DevType[36];	      /*豸*/
    char Manufacturer[36];  /**/
	char SoftVersion[36];   /*̼汾*/	
	BYTE mask[4];		  /**/
    char DevAlias[36];   /* IP Cameraı */
	BYTE AliasPos;       /* IPCڷŵλ, 0-ϣ1-ϣ2-£3-£4-ʾ */
    BYTE reserve2[3];
	BYTE sIPAddr[64];
	BYTE GateWay[4]; 	   /**/
	BYTE dns1[4];
	BYTE dns2[4];
	UINT IEport;
	BYTE switchflag;      /*˽ipc  1  0 ʾû*/
	BYTE portnum;        /* [0  -MAX_POE_NUM) */
	BYTE reserved[6];
}RSNet_SoleIPCSet_t;

typedef struct {
	UINT StructSize; //ýṹС

//	/*˿*/
//	UINT  NtpPort;
//	/*-λ:ӣֵ65535*/
//	UINT SyncPeriod;
	/*ַ*/
	BYTE NtpIPAddr[4];
	/*NTP ñʶ<RS_Close, RS_Open>*/
	BYTE UseNtp;
    /* ʱ*/
    BYTE TimeZone;
	BYTE NtpSerFlag;
	BYTE reserver;
	UINT NtpPort;
	UINT SyncPeriod;

}RSNet_NtpSet_t;  // ˽ṹǶ׳ṹԱЭ

// ͨϢ
typedef struct {
	UINT StructSize; //ýṹС
	RSNet_DSTSet_t DstSet;
	RSNet_NtpSet_t NtpSet;
	UINT           LanguageMask;
	BYTE           Language;    // ӦLANGUAGE_Eֵ
	BYTE           VideoFormat;
	BYTE           AutoLogout;
	BYTE           AllFlickerCtrl;
	BYTE		   DateMode;    /*ڸʽ0ΪMM/DD/YY1ΪYY-MM-DD2ΪDD/MM/YY*/
	BYTE           TimeMode;    /*ʱʽ0Ϊ24Сʱƣ1Ϊ12Сʱ*/
	BYTE           LastLanguage;
	BYTE           ShowWizard;
    BYTE           hybirdEnable;//ǷûDVR
}RSNet_GeneralInfoSet_t;

//ʾ
typedef struct {
	UINT StructSize; //ýṹС
	UINT ChannelMask; //ͨ

	BYTE Chroma; 		//ɫ, <0-63><0 - 255>
	BYTE Brightness; 	//, <0-63><0 - 255>
	BYTE contrast; 	//Աȶ, <0-63><0 - 255>
	BYTE saturation; 	//Ͷ, <0-63><0 - 255>

	BYTE DefaultColor; 	//ָɫĬֵ
	BYTE Sharpness; 	 /* <0 - 255> */
	BYTE ColorMode:2;   /*0:0-63 1:0-255*/
    BYTE DisplayRule:4; //ݲͬIPCЭʾͬ
    BYTE ShowDefault:1; //Զ˸IPCǷʾĬϰť
    BYTE reserved:1;
	BYTE reserved2;
}RSNet_SoleColorSet_t;

//Ƶڵ
#define MAX_VIDEOCOVER_NUM  32
//˽ṹ岻Ǻ޸,ֱӴ
typedef struct {/**/
	UINT StructSize; //ýṹС

	int CoverSwitch; //ڵǷ, <RS_Open, RS_Close>
    int x, y, w, h;
}RSNet_VideoCoverArea_t;


typedef struct {
	UINT StructSize; //ýṹС
	UINT ChannelMask; 		 //ͨ
	
	BYTE VideoCoverSwitch;/* ͨǷƵڵ, <RS_Open, RS_Close>*/
	BYTE VideoCoverNum;	/* ֧ƵڵĿ,0:4飬Ŀʵֵ֧Ŀ*/
	BYTE reservel[2];
	RSNet_VideoCoverArea_t VideoCoverArea[4]; //ֱӴ, б
}RSNet_SoleVideoCover_t;





//PTZ

/* Serialһ
//Protocol
#define RS_PelcoD 0
#define RS_PelcoP 1

//Baudrate
#define RS_Baudrate_1200 0
#define RS_Baudrate_2400 1
#define RS_Baudrate_4800 2
#define RS_Baudrate_9600 3

//DataBit
#define RS_DataBit_8 0
#define RS_DataBit_7 1
#define RS_DataBit_6 2
#define RS_DataBit_5 3

//StopBit
#define RS_StopBit_1 0
#define RS_StopBit_2 1

//Check
#define RS_CheckBit_None  0
#define RS_CheckBit_Odd   1
#define RS_CheckBit_Even  2
#define RS_CheckBit_Mark  3
#define RS_CheckBit_Space 4
*/

#define RS_MAX_CRUISE_POINT 256
typedef struct {
	UINT StructSize; //ýṹС
	UINT ChannelMask; 		 //ͨ

    /*Э*/
    BYTE Protocol;
    /**/
    BYTE Baudrate;
    /*λ*/
    BYTE DataBit;
    /*ֹͣλ*/
    BYTE StopBit;
    /*У*/
    BYTE Check;
	/* PTZ ԶѲ RS_Close, RS_Open*/
	BYTE EnablePtzCruise;
    BYTE reservel[2];
    /*,UIϵADDRESSΧΪ1-255*/
    UINT Number;
    ///*ͨѯʱ, ΧΪ1--255, ע⵱ʱΪ0 ʱʾԤõδ! */
   BYTE ChnCruiseTime[RS_MAX_CRUISE_POINT];	

}RSNet_SolePTZSet_t;

typedef struct {
	UINT StructSize; //ýṹС

    /* PTZ ԶѲ RS_Close, RS_Open*/
    UINT  EnablePtzCruise;     /*This para is reserved for another page later!*/
}RSNet_PTZSet_t;



//OSD
//Position
#define RS_PositionLeftUp 	 0
#define RS_PositionLeftDown  1
#define RS_PositionRightUp 	 2
#define RS_PositionRightDown 3

/* Ԥҳ,˽ṹDVRʹ*/

typedef struct {
	UINT StructSize; //ýṹС
	UINT ChannelMask; 		 //ͨ

    /*ͨλ 0-ϣ1-£2-ϣ3-*/
    BYTE Position;

    /*Ԥosd RS_Open, RS_Close*/
    BYTE Preview;

    /*ֳʱOSD RS_Open, RS_Close*/
    BYTE PreviewTimeSet;

    /*¼ʱOSD RS_Open, RS_Close*/
    BYTE RecordTimeSet;

    /*ͨ*/
    BYTE ChnName[20];

	BYTE FlickerCtrl;   //nvripc˸ 0 :50HZ 1:60HZ
    BYTE reserve[7];
    BYTE honeyChnName[64]; //honeywellͨ,֧8(utf-8)
}RSNet_SoleOsdSet_t;

typedef struct {
	UINT StructSize; //ýṹС

    /*ֳʱOSD RS_Open, RS_Close*/
    BYTE PreviewTimeSet;
    /*¼ʱOSD RS_Open, RS_Close*/
    BYTE RecordTimeSet;
	BYTE FlickerCtrl;   //nvripc˸ 0 :50HZ 1:60HZ
    BYTE reservel;
}RSNet_OsdSet_t;


//
//NetworkMode
#define RS_DHCP   0
#define RS_PPPOE  1
#define RS_Static 2

//PPPoEState
#define PPPOE_CONNECTING   0
#define PPPOE_SUCCESS      1
#define PPPOE_FAIL         2
/* ҳṹ */
typedef struct {
	UINT StructSize; //ýṹС

    /*IPַ*/
    BYTE IPAddr[4];
    /**/
    BYTE NetMask[4];
    /**/
    BYTE GateWay[4];
    /*ͻ˶˿ں*/
    UINT Port;
    /*Web˿ں*/
    UINT WebPort;
    /*ʽ<RS_DHCP, RS_PPPOE, RS_Static>*/
    BYTE NetworkMode;
    /* UPNP     RS_Open, RS_Close*/
    BYTE UseUPNP;
	/*ֻ˿*/
	WORD MobilePort;
    /*DNS1*/
    BYTE dns1[4];
    /*DNS2*/
    BYTE dns2[4];
    //ppoe
    /*PPPOEû*/
    BYTE PPPOEuser[MaxNameLen];
    /*PPPOEû*/
	BYTE Password[MaxNameLen];

    //3GϢ
	BYTE APN[MaxNameLen];
	BYTE DialCode[MaxNameLen];
	BYTE WirelessUser[MaxNameLen];
	BYTE WirelessPwd[MaxNameLen];
	
	BYTE EncodeFlag; //Enable:1 Disable:0
	/*WAN ڹ: 0 WAN  ;1  LAN*/
	BYTE WANWkIn;
	
	/*PPPOE state  0:connecting.. 1:success 2:fail */
	BYTE PPPoEState;
	/*PPPoE IP */
	BYTE PPPoEIPaddr[4];
	BYTE BandWidth;
	BYTE  RtspAuthType;/*rtsp authority type(0:none 1:basic 2:digest)*/
	BYTE  UseVideoPwd; /* Ƶܿ */
    WORD IpKBPort;     /*ip̶˿ں*/  //honywellר
    BYTE reserve[8];
}RSNet_NetworkBaseSet_t;



//sub_bitrate, mobile_bitrate
typedef enum{
	RS_SubBitrate_8	= 0,
	RS_SubBitrate_16,
	RS_SubBitrate_24,
	RS_SubBitrate_32,
	RS_SubBitrate_48,
	RS_SubBitrate_64,
	RS_SubBitrate_80,
	RS_SubBitrate_96,
	RS_SubBitrate_128,
	RS_SubBitrate_160,
	RS_SubBitrate_192, //10
	RS_SubBitrate_224,
	RS_SubBitrate_256,	
	RS_SubBitrate_320,	
	RS_SubBitrate_384,	
	RS_SubBitrate_448,	
	RS_SubBitrate_512,	
	RS_SubBitrate_768,	
	RS_SubBitrate_1024,	
	RS_SubBitrate_1536, //19
}RS_SubBitrate_e;

//
typedef struct {
	UINT StructSize; //ýṹС
	UINT ChannelMask; //ͨ
	//
	UINT sub_bitrate;
	
	BYTE sub_video; 	/* Ƿ,<RS_Close, RS_Open>*/ 

	/*RS_Encode720P
	  RS_EncodeD1
	  RS_EncodeHD1,
	  RS_EncodeCIF*/
	BYTE sub_resolution; //DVRΪCIFIPCΪD1ݲṩ޸

	/*PAL = 1~25, NTSC = 1~30֡,
	  ֻһͨ֡, ͨΪPAL=1~5, NTSC=1~6
	  ѡӦû0ֵ*/ 
	BYTE sub_fps;  

	BYTE sub_audio;/*¼:<RS_Close, RS_Open>*/
	
	BYTE Ipc_state; //ipc״̬
	BYTE ResolutionType; // 0:720p 1:D1
	BYTE VBR;
	/*IPCʹ*/
	BYTE BitrateType; /* 0 :1:2:  */
	BYTE VideoQuality; /* ͼ0: 1:2:3:4:5:*/
	BYTE IFrameInterval; /* I ֡Χ1-100   */
	unsigned short CustomSubBitrate; /* Զ */
	/*IPCʹ END */
}RSNet_SoleSubStreamSet_t;

//ֻ
typedef struct {
	UINT StructSize; //ýṹС
	UINT ChannelMask; //ͨ

	//ֻ
	UINT mobile_bitrate;

	BYTE mobile_video; 	/* Ƿ,<RS_Close, RS_Open>*/ 

	/*RS_Encode720P
	  RS_EncodeD1
	  RS_EncodeHD1,
	  RS_EncodeCIF*/
	BYTE mobile_resolution;/*PS:ʱֻΪCIF, ݲṩ޸*/

	/*PAL = 1~25, NTSC = 1~30֡,
	  ֻһͨ֡, ͨΪPAL=1~5, NTSC=1~6
	  ѡӦû0ֵ*/ 
	BYTE mobile_fps;  

	BYTE mobile_audio; /* ǷƵ,<RS_Close, RS_Open>*/

	BYTE Ipc_state; //ipc״̬
	/*IPCʹ*/
	BYTE BitrateType; /* 0 :1:2:  */
	BYTE VideoQuality; /* ͼ0: 1:2:3:4:5:*/
	BYTE IFrameInterval; /* I ֡Χ1-100   */
	unsigned short CustomSubBitrate; /* Զ */
	/*IPCʹ END */
	BYTE reserve[2];
}RSNet_SoleMobileStreamSet_t;

//honeywell frame rate only
typedef enum
{
    FrameRate_4, // 0
    FrameRate_5,
    FrameRate_8,
    FrameRate_10,
    FrameRate_12,
    FrameRate_15, // 5
    FrameRate_20,
    FrameRate_25,
    FrameRate_30 // 8
} FrameRate_e;

typedef struct
{
    WORD w;
    WORD h;
}TI_IPC_SResolute;

typedef struct
{
    TI_IPC_SResolute r1;
    TI_IPC_SResolute r2;
}TI_IPC_DResolute;

typedef struct
{
    TI_IPC_SResolute r1;
    TI_IPC_SResolute r2;
    TI_IPC_SResolute r3;
}TI_IPC_TResolute;

#define MAX_RESOLUTION_NUM 8
typedef struct
{
    BYTE steamnum; // 0 -  1-˫ 2-
    BYTE resindx;  // ֱõ
    BYTE reserve1[3];
    BYTE singleResNum;
    BYTE doubleResNum;
    BYTE triResNum;
    TI_IPC_SResolute sr[MAX_RESOLUTION_NUM]; // ֱʷΧ
    TI_IPC_DResolute dr[MAX_RESOLUTION_NUM]; // ˫ֱʷΧ
    TI_IPC_TResolute tr[MAX_RESOLUTION_NUM]; // ֱʷΧ
}TI_IPC_Resolute;

/* HonneyWell */
typedef struct
{
    UINT StructSize;
    UINT ChannelMask;
    BYTE StreamMode;	/*ģʽ:0Ϊ1Ϊ˫*/
    BYTE RefreshRate;	/*ˢƵʣ0:60HZ1:50HZ*/
    BYTE Resolution;	/*ResRangeֵ*/
    BYTE MainFps;		/*֡ʶӦFrameRangeֵ*/
    BYTE SubFps;		/*֡ʶӦFrameRangeֵ*/
    BYTE Audio:1;  		/*Ƶ: 0-أ1-*/
    BYTE TIFlag:1;      /*ʶǷΪTI豸: 1-, 0-*/
    BYTE reserved:6;
    WORD MainBit;		/**/
    WORD SubBit;		/**/
    WORD FrameRange[3];	/*[0]Ϊ[1]Ϊ[2]ΪֻλȡӦFrameRate_e*/
    TI_IPC_Resolute ResRange;/*Χ*/
}RSNetSZ_SoleStreamset_t;

//DDNS

//ServerAddr
#define RS_DDNS_MYQ_SEE     0
#define RS_DDNS_LTSCCTV     1
#define RS_DDNS_SystemPort  2
#define RS_DDNS_3322        3
#define RS_DDNS_DYNDNS      4
#define RS_DDNS_EASTERNDNS  5
#define RS_DDNS_NEWDDNS     6
#define RS_DDNS_NIGHTOWLDVR 7
#define RS_DDNS_LOREXDDNS   8

typedef struct {
	UINT StructSize; //ýṹС

    /*HOST֣16ֽ*/
    BYTE HostName[MaxNameLen];
    /*û16ֽ*/
    BYTE UserName[MaxNameLen];
    /*û룬8ֽ*/
    BYTE UserPW[MaxNameLen];
	/*ÿһbit  ӦһDDNS ,1:ǰʹ,0:ǰûʹ
	  һ£DDNSַѡȫ
	 ڿͻ汾ʱԼDDNS
	 λʾDDNSѡ*/
    UINT DDNSUseFlag;
    /*ַѡ*/
    BYTE ServerAddr;
    /*DDNSñʶ<RS_Close, RS_Open>*/
    BYTE UseDDNS;
    BYTE P2pState;      //豸p2p״̬()
    BYTE reservel;

	BYTE DDNSID[12];
    BYTE P2pKeyID[MaxNameLen]; //P2P ID(ĺ)
	UINT extendDDNS;    //DDNS,֮ǰ32(DDNSUseFlag)
}RSNet_DDNSSet_t;


//PPPOE
typedef struct {
	UINT StructSize; //ýṹС

    /*PPPOEû*/
    BYTE PPPOEuser[MaxNameLen];
    /*PPPOEû*/
    BYTE Password[MaxNameLen];
    /*DNS1*/
    BYTE dns1[4];   // ·ϵPPPOE
    /*DNS2*/
    BYTE dns2[4];
}RSNet_PPPoESet_t;




//Email
/* Emailҳṹ*/
//intervaltime
#define RS_IntervalTime_60  0
#define RS_IntervalTime_180 1
#define RS_IntervalTime_300 2
#define RS_IntervalTime_600 3
typedef struct {
	UINT StructSize; //ýṹС

    /*SMTP*/
    BYTE SMTP[MaxNameLen];
    /*˵ַ*/
    BYTE SendEmail[MaxNameLen];
    /**/
    BYTE SendEmailPW[MaxNameLen];
    /*ռ˵ַ, ʱֻеһռ˵ַ*/
    BYTE RecvEmail[3][MaxNameLen];
    /*˿ں*/
    UINT Port;
    /*Ƿʹemail,<RS_Close, RS_Open>*/
    BYTE EmailSwitch;
    /*SSLأ<RS_Close, RS_Open>*/
    BYTE SSLSwitch;
    /*ʼͼ*/
    BYTE intervaltime;
	BYTE reservel;
}RSNet_EmailSet_t;

typedef struct {
	UINT StructSize; 	//ýṹС
	int MotionScheduleHour[16][8];
	int AlarmScheduleHour[16][8];
	int EventScheduleHour[8];
	BYTE reservel[4];
	int MotionScheduleHourEx[32][8];
	int AlarmScheduleHourEx[32][8];

}RSNet_EmailScheduleSet_t;

typedef struct {
	UINT StructSize; 	//ýṹС
	UINT ChannelMask; 	//ͨ
	
	BYTE  EmailScHalfHour[8][48];  // ¼ƻʾһ
}RSNetNew_SoleEmailScheduleset_t;

typedef struct {
	UINT StructSize; 	//ýṹС

	BYTE  EventScHalfHour[8][48];     // 7days and 48 halfhours
}RSNetNew_EmailScheduleset_t;



//Mobile
typedef struct {
	UINT StructSize; //ýṹС
	//ֻ
    BYTE MobileUserName[MaxNameLen];/* û16ֽ*/    
    BYTE MobileUserPwd[MaxNameLen];/* û룬16ֽ*/     
    UINT MobilePort; /* ˿*/ 
	BYTE reservel[4];
}RSNet_MobileSet_t;


//Router Lan 
typedef struct {
	UINT StructSize; //ýṹС
    BYTE IPAddr[4];  /* IPַ */
    BYTE NetMask[4]; /* */
    BYTE SSID[MaxNameLen];  /* ʶ */    
    BYTE Passwd[MaxNameLen];/*  */     
	BYTE SecureType;        /* ȫѡ */
	BYTE WiFiChannel; /*ͨѡ*///add by st 20120509
	BYTE WpaAlgorithm;
	BYTE reservel[17];
}RSNet_RouterLanSet_t;

//ƶ

//Sensitivity
#define RS_Sensitivity_8 0
#define RS_Sensitivity_7 1
#define RS_Sensitivity_6 2
#define RS_Sensitivity_5 3
#define RS_Sensitivity_4 4
#define RS_Sensitivity_3 5
#define RS_Sensitivity_2 6
#define RS_Sensitivity_1 7

//AlarmOutTime
//ӦMotion,Abnormal,IOAlarm
#define RS_AlarmTime_10s 0
#define RS_AlarmTime_20s 1
#define RS_AlarmTime_40s 2
#define RS_AlarmTime_60s 3
#define RS_AlarmTime_30s 4
#define RS_AlarmTime_1min 5
#define RS_AlarmTime_2min 6


//BuzzerMooTime
//ӦMotion,Abnormal,IOAlarm
#define RS_BuzzerTime_Off 0
#define RS_BuzzerTime_10s 1
#define RS_BuzzerTime_20s 2
#define RS_BuzzerTime_40s 3
#define RS_BuzzerTime_60s 4


//¼ʱ RecordDelayTime
//ӦMotion,IOAlarm
#define RS_RecordDelayTime_10   0
#define RS_RecordDelayTime_30   1
#define RS_RecordDelayTime_1Min 2
#define RS_RecordDelayTime_2Min 3
#define RS_RecordDelayTime_5Min 4

#define MAX_ALARMOUT_NUM 16

typedef struct
{
    short x;
    short y;
    short w;
    short h;
}RSNet_Rect_t;

/* ƶҳṹ */

typedef struct {
	UINT StructSize; //ýṹС
	UINT ChannelMask; 	//ͨ

	/*8ȼ*/
	BYTE Sensitivity;
	/*Ƿƶ<RS_Close, RS_Open>*/
	BYTE ChnSwitch;
	/*Send Email <RS_Close, RS_Open>*/
	BYTE SendEmail;
	/*ʱ*/
	BYTE BuzzerMooTime;
	/*Record Channel, ͨ¼񣬰λ¼*/
	UINT RecordChannel;
	/*¼ʱʱ*/
	BYTE RecordDelayTime;
	/*Record channel switch ¼ܿ <RS_Close, RS_Open>*/
	BYTE Record;
	/*Show Message <RS_Close, RS_Open>*/
	BYTE ShowMessage;
	/*FullScreen  ȫ<RS_Close, RS_Open>*/
	BYTE FullScreen;
	/*ã18032ֽڱʾÿλʾһ*/
	BYTE RegionSetting[32];	/* LoginRsp MotionModeֶ:0,ʹõǰֶ*/
	/*   ֻ LoginRsp MotionMode==2ʱ,ֵЧ*/
	BYTE MbRow; 
	/*  ֻ LoginRsp MotionMode==2ʱ,ֵЧ*/
	BYTE MbCol;
	/*Alarm Out <RS_Close, RS_Open>*/
	BYTE AlarmOut;
	/*ʱ*/
	BYTE AlarmOutTime;
	BYTE AlarmOutManager[MAX_ALARMOUT_NUM];
	/*ã20032ֽڱʾÿλʾһ*/
    //BYTE RegionSetting3531[200];  /* LoginRsp MotionModeֶ:12,ʹõǰֶ*/
    union {
        struct {
            BYTE RegionSetting3531[200];  /* LoginRsp MotionModeֶ:12,ʹõǰֶ*/
        }BlockRegion;
        struct
        {
            BYTE MotionNum[4];  /* ӦǷãΪ1ãΪ0 */
            RSNet_Rect_t Rect[4];
        }RectRegion;
    };
}RSNet_SoleMotionSet_t;





//쳣
/*
   쳣,ͨʽ
0videoloss
1:HddInvalidAlarm
2:HddNoSpaceAlarm
*/
typedef struct {
	UINT StructSize; 	//ýṹС
	UINT EventTypeMask; 	//ͨ

	//쳣Ƿ RS_Close, RS_Open
	BYTE Enable;
	/*ʱ*/
	BYTE BuzzerMooTime;

	/*Ƿʾ־λ <RS_Close, RS_Open>*/
	BYTE ShowMessage;
	/*Send Email <RS_Close, RS_Open>*/
	BYTE SendEmail;

	/*Alarm Out ܿ<RS_Close, RS_Open>*/
	BYTE AlarmOut;
	/*ʱ*/
	BYTE AlarmOutTime;
	BYTE reservel[2];
	/*ж̵ʱAlarm Out <RS_Close, RS_Open>*/
	BYTE AlarmOutManager[MAX_ALARMOUT_NUM];

}RSNet_SoleAbnormalSet_t;


//IO

//IoAlarmSet
#define RS_IOAlarm_NO    0
#define RS_IOAlarm_NC    1
#define RS_IOAlarm_Close 2

typedef struct {
	UINT StructSize; 	//ýṹС
	UINT ChannelMask; 	//ͨ

	//IOڱ״̬
	BYTE IoAlarmSet;
	/*Alarm Out ܿ<RS_Close, RS_Open>*/
	BYTE AlarmOut;
	/*ʱ*/
	BYTE AlarmOutTime;
	/*ʱ*/
	BYTE BuzzerMooTime;
	/*Record Channel, ͨ¼PS:λ¼, 1:, 0:*/
	UINT RecordChannel;
	/*¼ʱ*/
	BYTE RecordDelayTime;
	/*Ƿʾ־λ <RS_Close, RS_Open>*/
	BYTE ShowMessage;
	/*Send Email <RS_Close, RS_Open>*/
	BYTE SendEmail;
	/*FullScreen  ȫ<RS_Close, RS_Open>*/
	BYTE FullScreen;
	/*ж̵ʱAlarm Out <RS_Close, RS_Open>*/
	BYTE AlarmOutManager[MAX_ALARMOUT_NUM];
	/*Record channel switch ¼ܿ <RS_Close, RS_Open>*/
	BYTE Record;
	/*Yiguang 2012.02.16 Դѡ,0-IPC;1-ض*/
	BYTE AlarmIO;
	BYTE reservel[2];
}RSNet_SoleIOAlarmSet_t;


/*ģʽƻҳ,EyeHome-Host汾Ч*/
/*ֵ֧Ŀ8*/
#define MAX_AREA_NUMBER         8
/*ģʽĿƷʽ,0-ƻ;1-ֶ*/
//ControlWay
#define RS_SCHEDULE_CONTROL   	0
#define RS_MANUAL_CONTROL	  	1

/*ģʽΪֶʱģʽ,0-ģʽ;1-˯ģʽ;2-ڼģʽ;ע:ģʽĿƷʽΪƻʱ,账ֵ*/
//ControlMode
#define RS_MANUAL_LEAVEHOME		0
#define RS_MANUAL_SLEEP			1
#define RS_MANUAL_ATHOME		2

typedef struct {
	UINT StructSize;
    BYTE ControlWay;            /*Ʒʽ,0-ƻ,1-ֶ*/
    BYTE ControlMode;           /*ֶʱģʽ,0-ģʽ;1-˯ģʽ;2-ڼģʽ*/
	BYTE ModeSchedule[8][24];   /*ƻʱģʽ,0-ģʽ;1-˯ģʽ;2-ڼģʽ*/
	BYTE AreaSwitch[4];         /*ģʽ,ֽ0-ģʽ;1-˯ģʽ;2-ڼģʽ;ÿֽڵ07λֱʾ18Ŀ״̬,0-;1-*/   	
	BYTE Reserved[6];
}RSNet_TELALARM_AreaParameter_t;

/*,ÿĲ,ϵͳ֧8,EyeHome-Host汾Ч*/
typedef struct {
	UINT StoreSize;
	BYTE Name[20];
	BYTE AlarmOut;				/*Alarm Out ܿ<RS_Close, RS_Open>*/
	BYTE AlarmOutTime[8];		/*ʱ*/
	BYTE BuzzerMooTime[8];		/*ʱ*/
	BYTE DialNumber[8];			/*ĺ*/
	UINT RecordChannel[8];		/*Record Channel, ͨ¼PS:λ¼, 1:, 0:*/
	UINT FullScreen[8];			/*FullScreen  ȫ<RS_Close, RS_Open>*/
	BYTE RecordDelayTime[8];	/*¼ʱ*/
	BYTE ShowMessage;			/*Ƿʾ־λ <RS_Close, RS_Open>*/
	BYTE SendEmail;				/*Send Email <RS_Close, RS_Open>*/
	BYTE Record;				/*Record channel switch ¼ܿ <RS_Close, RS_Open>*/
	BYTE Reserved[4];
}RSNet_TELALARM_SoleAreaParameter_t;

/*̽,EyeHome-Host汾Ч*/
#define MAX_WIRE_SENSOR_NUMBER  4       /*ֵ֧̽Ŀ*/
#define MAX_WIRELESS_SENSOR_NUMBER  12  /*ֵ֧̽Ŀ*/

#define RS_TRIGGLE_NC    0
#define RS_TRIGGLE_NO    1

#define RS_ALARMTYPE_DOOR   0           /*ŴŴ*/
#define RS_ALARMTYPE_RAY    1           /*ⴥ*/
#define RS_ALARMTYPE_SILENT 2           /**/
#define RS_ALARMTYPE_FIRE   3           /*𾯱*/
#define RS_ALARMTYPE_GAS    4           /*б*/

typedef struct {
	UINT StoreSize;
    BYTE Triggle;                   /**/
    BYTE AlarmType;                 /**/
    BYTE Area;                      /**/
    BYTE AlarmDisplay;              /*Ƿʾ*/
	BYTE Reserved[4];
}RSNet_TELALARM_SoleWireSensor_t;

typedef struct {
	UINT StoreSize;
    BYTE LearnCode;                 /*ǷѾ*/
    BYTE AlarmType;                 /**/
    BYTE Area;                      /**/
    BYTE AlarmDisplay;              /*Ƿʾ*/
	BYTE Reserved[4];
}RSNet_TELALARM_SoleWirelessSensor_t;

/*绰,EyeHome-Host汾Ч*/
#define MAX_PHONENUMBER_GROUP   5   /*ֵ֧ĵ绰*/

typedef struct {
	UINT StoreSize;
	BYTE Name[20];                  /*û*/
	BYTE Number[40];                /**/
	BYTE DialTime;                  /*ŵĴ*/
	BYTE Reserved[3];
}RSNet_SolePhoneNumberSetting_t;


//ܷ
/****************  huoxiaolong20110512  *****************************/

typedef struct{
	UINT StructSize;//ýṹС
	/*켣ȣ*/
	BYTE ContrailLength;
    BYTE reservel[3];
}RSNet_IntelligentSet_t;



typedef struct{
	UINT StructSize; 	//ýṹС
	BYTE AlarmOut;
	/*Show Message */
	BYTE ShowMessage;
	/*Send Email */
	BYTE SendEmail;
	/*FullScreen */
	BYTE FullScreen;
	/*Record Channel*/
	BYTE Record;
	/*Record Delay Time*/
	BYTE RecordDelayTime;/*¼ʱʱʱ:30s1min,2min,5min*/
	BYTE BuzzerMooTime;/*Уʱ:0,10204060s*/
	BYTE AlarmOutTime;/*ʱ:10204060s*/
	BYTE AlarmOutManager[MAX_ALARMOUT_NUM];
	UINT RecordChannel;
	BYTE reservel[4];

}RSNet_SoleIntAlarmSet_t;


#define RS_MAX_RULENUM  4

#define RS_Intelligent_Tripwire  0
#define RS_Intelligent_Perimeter 1
#define MAX_PERIMETER_POINT 8
#define MAX_TRIPWIRE  2
typedef struct{
	UINT StructSize; 	//ýṹС
	/*ʹܿ*/
	BYTE RuleEnable;
	/*ͣ0-ߣ1-ܽ*/
	BYTE RuleType;
	/**/
	BYTE Direction;
	/*ܽƽǶֵ*/
	short Forbidden;
	BYTE reservel[3];
}RSNet_RuleNum_t;

//Ľṹadded by zgm 20110118
typedef struct{
	short x;//X
	short y;//Y
	short RuleNum;//
	short ForbiddenDirection;//ƽǶ
	BYTE reservel[4];
}RSNet_Point_t;

typedef struct{
	UINT StructSize; 	//ýṹС
	UINT ChannelMask; 	//ͨ
	/*ܿ0-رգ1-*/
	BYTE Enable;
	BYTE reservel[3];
	RSNet_SoleIntAlarmSet_t IntAlarm;
	/**/
	RSNet_Point_t TriWire[2 * RS_MAX_RULENUM];//add 20110118
	/*ܽ*/
	RSNet_Point_t Perimeter[MAX_PERIMETER_POINT * RS_MAX_RULENUM];//add 20110118
	/*ÿͨ*/
	RSNet_RuleNum_t RuleNumber[RS_MAX_RULENUM];
	//RSNet_SoleIntAlarmSet_t IntAlarm;
}RSNet_SoleIntelligentSet_t;

//level
#define  RS_level_1 0
#define  RS_level_2 1
#define  RS_level_3 2
#define  RS_level_4 3
#define  RS_level_5 4

//Avdtype
#define RS_MAXAVDTYPE_NUM   8

#define RS_Avdtype_BrightAbnormal   0
#define RS_Avdtype_ClarityAbnormal  1
#define RS_Avdtype_ColorAbnormal    2
#define RS_Avdtype_NoiseAbnormal    3
#define RS_Avdtype_MenuFreeze       4
#define RS_Avdtype_Nosignal         5
#define RS_Avdtype_StageChange      6
#define RS_Avdtype_Interfere        7
#define RS_Avdtype_PtzLoseControl   8
typedef struct{
	UINT StructSize; 	//ýṹС
	/*AVDͿ*/
	BYTE TypeEnable;
	/*5 ȼ1-ͣ5-*/
	BYTE level;
	BYTE reservel[2];
}RSNet_Avdtype_t;   




typedef struct{
	UINT StructSize; 	//ýṹС
	/*Alarm Out */
	BYTE AlarmOut;
	/*Show Message */
	BYTE ShowMessage;
	/*Send Email */
	BYTE SendEmail;
	/*FullScreen */
	BYTE FullScreen;
	/*Record Channel*/
	BYTE Record;
	/*Record Delay Time*/
	BYTE RecordDelayTime;/*¼ʱʱʱ:30s,1min,2min,5min*/
	BYTE AlarmOutTime;/*ʱ:10204060s*/
	BYTE BuzzerMooTime;/*Уʱ:010204060s*/
	UINT RecordChannel;
	BYTE AlarmOutManager[MAX_ALARMOUT_NUM];
	BYTE reservel[4];

}RSNet_SoleAvdAlarmSet_t;



typedef struct{
	UINT StructSize; 	//ýṹС
	UINT ChannelMask; 	//ͨ
	/*ͨأ0-رգ1-*/
	BYTE Enable;
	BYTE reservel[3];
	/*ͨѵʱ䣬СΪ1룬Ϊ60*/
	ULONG  RotateTime;
	RSNet_Avdtype_t Avdtype[RS_MAXAVDTYPE_NUM];
	RSNet_SoleAvdAlarmSet_t AvdAlarm;
}RSNet_SoleIntAvdSet_t;
//ȱ

//MediaConType
#define RSPlat_UDP 0
#define RSPlat_TCP 1
#define RSPL_MAXNAMELEN 36

#define RSPL_FORM_SHOW *(UINT*)"PLEn"
#define RSPL_FORM_HIDE 0x00000000
typedef struct{
	UINT StructSize;   		//ýṹС
	
	//RsPlatform
	BYTE PuID[RSPL_MAXNAMELEN];
	BYTE PlatformAddr[RSPL_MAXNAMELEN]; //ַ
	UINT PlatformPort;     //˿
	BYTE PlatformSelect;
	BYTE PlatformEnable;
	BYTE MediaConType;     //0(udp) 1(tcp)
	BYTE reservel[1];
	UINT PlatFormShowTag; //Ƿʾƽ̨ҳ
}RSNet_PlatformSet_t;

//HUAWEI_Platform
#define RSPL_STATUS_OFFLINE  	0
#define RSPL_STATUS_ONLINE 		1

typedef struct{
	UINT StructSize;   		//ýṹС
	
	BYTE Enable;			/* RS_Open, RS_Close*/
	BYTE CenterStatus;		/*RSPL_STATUS_OFFLINE, RSPL_STATUS_ONLINE*/

	BYTE ProtocolType;		/* RSPlat_UDP, RSPlat_TCP */
	BYTE DelayTime;			/*ʱʱ 0100 s */

	BYTE MainDevID[24];
	BYTE CenterIP[16];
	UINT CenterPort;
}RSNet_HuaweiPlatformSet_t;

typedef struct{
	UINT StructSize;   		//ýṹС
	UINT ChannelMask;		//ͨ
	
	BYTE LensEnable;
	BYTE AlarmInEnable;
	BYTE AlarmOutEnable;
	BYTE SerialEnable;

	BYTE LensStatus;		/*RSPL_STATUS_OFFLINE, RSPL_STATUS_ONLINE*/
	BYTE AlarmInStatus;		/*RSPL_STATUS_OFFLINE, RSPL_STATUS_ONLINE*/
	BYTE AlarmOutStatus;	/*RSPL_STATUS_OFFLINE, RSPL_STATUS_ONLINE*/
	BYTE SerialStatus;		/*RSPL_STATUS_OFFLINE, RSPL_STATUS_ONLINE*/
	
	BYTE Reservel[8];
	
	BYTE LensID[24];
	BYTE LensName[48];

	BYTE AlarmInID[24];
	BYTE AlarmInName[48];
	
	BYTE AlarmOutID[24];
	BYTE AlarmOutName[48];
	
	BYTE SerialID[24];
	BYTE SerialName[48];
}RSNet_SoleHuaweiPlatformSet_t;


//
//main_resolution, sub_resolution
#define RS_EncodeD1   0
#define RS_EncodeHD1  1
#define RS_EncodeCIF  2
#define RS_Encode720P 3
#define RS_Encode960P 4

//new define of resolution mode (added 2014-05-13)
typedef enum
{
    RSMode_D1 = 0,          //D1ģʽ
    RSMode_D1_960H,         //D1960Hģʽ
    RSMode_CIF,             //CIFģʽ
    RSMode_CIF_DISABLE_FPS, //CIFǲ֡
    RSMode_720P,            //720Pģʽ
    RSMode_720P_960P,       //720P960H
    RSMode_1080P,           //1080Pģʽ
    RSMode_720P_1080P,      //720P1080Pģʽ
    RSMode_VI_AUTO_DETECT,  //Ŀǰֻ֧720P960HԶʶ
    RSMode_1080P_720P_WX,   //IEʾ1080P,720PWD1,WHD1,WCIF
    RSMode_720P_WX          //IEʾ720PWD1,WHD1,WCIF
}ResolutionMode_e;

//main_bitrate
typedef enum{
	RS_MainBitrate_32    =	0,
	RS_MainBitrate_48,	
	RS_MainBitrate_64,	
	RS_MainBitrate_80,	
	RS_MainBitrate_96,	
	RS_MainBitrate_128,	
	RS_MainBitrate_160,	
	RS_MainBitrate_192,	
	RS_MainBitrate_224,	
	RS_MainBitrate_256,	
	RS_MainBitrate_320,	
	RS_MainBitrate_384,	
	RS_MainBitrate_448,	
	RS_MainBitrate_512,	
	RS_MainBitrate_640,	
	RS_MainBitrate_768,	
	RS_MainBitrate_896,	
	RS_MainBitrate_1024 = 17,	
	RS_MainBitrate_1280,	
	RS_MainBitrate_1536,	
	RS_MainBitrate_1792,	
	RS_MainBitrate_2048 = 21,	
	RS_MainBitrate_4096 = 22,	//4M
	RS_MainBitrate_5120 = 23,	//5M
	RS_MainBitrate_6144 = 24,	//6M
	RS_MainBitrate_8192 = 25,	//8M
}RS_MainBitrate_e;

//SWAN ͻʹ
#define RS_MainBitrate_Normal	RS_MainBitrate_4096;
#define RS_MainBitrate_Good		RS_MainBitrate_5120;
#define RS_MainBitrate_Better	RS_MainBitrate_6144;
#define RS_MainBitrate_Best		RS_MainBitrate_8192;

/* ҳṹ */

typedef struct
{
	UINT StructSize; //ýṹС

	BYTE ResolutionMode; /*0-D1, 1-960*/
	
	BYTE StreamType;   // 0 main 1 sub
	BYTE reservel[2];
}RSNet_MainStreamSet_t;

typedef struct{
	UINT StructSize; //ýṹС
	UINT ChannelMask; //ͨ

	/*: */
	UINT main_bitrate;
	
	/*
	  RS_Encode720P-720P
	  RS_EncodeD1-ϸ
	  RS_EncodeHD1-ḻ
	  RS_EncodeCIF-ͨ*/
	BYTE main_resolution;
	
	/* 	ͨ¼֡:
		PAL:1~25 NTSC:30֡
		ѡӦû0ֵ 
		PAL400NTSC480*/
	BYTE main_fps;	
	
	BYTE main_audio;/*¼:<RS_Close, RS_Open>*/	
	BYTE main_resolution960; 

	BYTE ResolutionType; // 0:720p 1:D1
	BYTE VBR; 
	/*IPCʹ*/
	BYTE BitrateType; /* 0 :1:2:  */
	BYTE VideoQuality; /* ͼ0: 1:2:3:4:5:*/
	unsigned short CustomMainBitrate; /* Զ */
	BYTE IFrameInterval; /* I ֡Χ1-100   */
	/*IPCʹ END */
	BYTE reserve[1];
}RSNet_SoleMainStreamSet_t;


//¼
//RecordMood
#define RS_RecordSchedule 0  //ƻ¼
#define RS_RecordAlaways  1  //¼
#define RS_RecordManual   2  //ֶ¼

//PackTime
#define RS_PackTime_15Min 0
#define RS_PackTime_30Min 1
#define RS_PackTime_45Min 2
#define RS_PackTime_60Min 3

//PreRecordTime
#define RS_PreRecordTime_0s  0
#define RS_PreRecordTime_10s 1

typedef struct {
	UINT StructSize; 	//ýṹС
	UINT ChannelMask; 	//ͨ

	/*ͨĴ򿪹رգһͨӦ<RS_Close, RS_Open>*/
    BYTE ChnCloseOrOpen;    //Qt ui ͨ¼񿪹
	BYTE RecordStreamMode;  // main,sub    
    BYTE PreRecSwitch;      //Qt ui ͨԤ¼񿪹
    BYTE reserved;
}RSNet_SoleRecordSet_t;

typedef struct {
	UINT StructSize; 	//ýṹС

    BYTE RecordMode;/*¼ģʽ:0-ʱ¼1-¼2-ֶ¼*/
    BYTE PackTime;/*¼ʱ䣬0-15ӣ1-30ӣ2-45ӣ3-60*/    
    BYTE PreRecordTime;/*Ԥ¼Ԥ¼ʱ:010s*/
	BYTE RedundanceRec;      //Ƿ¼:0-close 1-open
}RSNet_RecordSet_t;



//¼ƻ

//hour
/*Ϊ0ʾ¼Ϊ2ʾ¼1-¼*/
#define RS_NoRecord     0
#define RS_AlarmRecord  1
#define RS_NormalRecord 2

#define RS_NormalScheduleMode 0
#define RS_SmartScheduleMode 1

#define RS_ScheduleResolution_720P	0
#define RS_ScheduleResolution_D1   1
#define RS_ScheduleResolution_CIF  2
typedef struct {
	UINT StructSize; 	//ýṹС
	UINT ChannelMask; 	//ͨ
	
	//MainStream, For MainStream Record Schedule
	int NormalHour[8]; 
	int MotionHour[8];
	int AlarmHour[8];
	int IntelligentHour[8];
	
	//Smart汾
	BYTE SmartScheduleEnable; //1:Ϊsmart,֮Ϊû
	BYTE ScheduleMode; 
	BYTE reservel[2];
	BYTE SmartNormalResolution[8];
	BYTE SmartAlarmResolution[8]; 
	int SmartNormalHour[8]; 
	int SmartAlarmHour[8];
	
	//SubStream, For SubStream Record Schedule
	int SubNormalHour[8]; 
	int SubMotionHour[8];
	int SubAlarmHour[8];
	int SubIntelligentHour[8];
	
	BYTE HalfHour[8][48]; // 7days and 48 halfhours	
	/* bit 0 Ϊͨ¼bit 1 Ϊ¼bit 2Ϊ¼bit 3
	 * ӦbitλΪ1ʾãΪ0ʾ
	 */
	
}RSNet_SoleScheduleSet_t;

//¼ƻ Qt v2
typedef struct
{
    UINT StructSize; 	//ýṹС
    UINT ChannelMask; 	//ͨ

    BYTE HalfHour[8][48]; // 7days and 48 halfhours
    /* bit 1ΪPEA¼, bit 2 ΪAVD¼, bit 3 ΪOSC¼
     * ӦbitλΪ1ʾãΪ0ʾ
     */
}RSNet_SoleIntelliRecSchedule_t;


//ϵͳάҳ
//maintainperiod1
#define RS_EveryDay 0
#define RS_EveryWeek 1
#define RS_EveryMonth 2

//maintainperiod2
#define RS_Monday 		0
#define RS_Tuesday		1
#define RS_Wednesday 	2
#define RS_Thursday		3
#define RS_Friday		4
#define RS_Saturday		5
#define RS_Sunday		6

typedef struct {
	UINT StructSize; 	//ýṹС

	//Զά
    /*άľʱ䣬ʱ*/
    BYTE time[4];
    
    BYTE automaintain; /*Զάأ<RS_Open, RS_Close>*/

	/*ά
	  RS_EveryDay
	  RS_EveryWeek
	  RS_EveryMonth
	 */
	BYTE maintainperiod1; 
	/*άڶ0--6ÿܼܵ7--37ÿµļ
	  RS_Monday 		
	  RS_Tuesday		
	  RS_Wednesday 	
	  RS_Thursday		
	  RS_Friday		
	  RS_Saturday		
	  RS_Sunday		
	 */
    BYTE maintainperiod2; 
	
	/*Ĭû¼û
	255:ʾôι
	0-off; 1-admin, 2~7ʾ6ͨû
	 */
	BYTE defaultuserid;
	BYTE EnabledUserList;/*	ѿ0bit-admin; 1~6bitʾ6ͨû*/
	BYTE EnableUser;/*ǷĬû*/
    BYTE TimeFormat;  //(0)24Сʱ,(1)12Сʱ
    BYTE reservel;
    BYTE UserName[8][32];

}RSNet_MaintainSet_t;

//3G
typedef struct {
	UINT StructSize;
	UINT SignalLevel;
	BYTE SignalType[32];
	BYTE IpAddr[16];
}RSNet_SystemBase3GInfo_t;

//ϵͳ
//ȱ




//Ӳ̹
//<ӲϢ>ͬһṹ


//߼

//Զ

//ָĬ
//λֵ


typedef struct {
	UINT StructSize;
	BYTE DevicePuid[64];
	UINT Result;
}RSNet_TuobaoInfo_t;


typedef struct {
	UINT StructSize; 	//ýṹС

	BYTE DisplaySet_flag;
	BYTE RecordSet_flag;
	BYTE NetworkSet_flag;
	BYTE AlarmSet_flag;
	BYTE DeviceSet_flag;
	BYTE SystemSet_flag;
	BYTE AdvanceSet_flag;
	BYTE reservel[1];
}RSNet_DefaultSet_t;


typedef struct
{
	UINT StructSize; 	// ýṹС

	BYTE Switch;         	// ǷҪWIFIĿ
	BYTE EncryptType;		// ܷʽ  0 - 1:WEP 2:WPA-PSK 3:WPA2-PSK 4:WPA-AUTO
	BYTE AuthMode;			// ֤ģʽ 	WEP֤ģʽ:1:OPEN, 2:SHARED   WPA֤ģʽ:3-TKIP, 4-AES 

	BYTE Reserve1[1];
	
	//Կ.
	//ps:WEP֤ģʽ,볤ֻ5/10/13/26 ֳ.
	//WPA֤
	//Կȱ֤ģʽĹ򳤶ȲЧwifi
	BYTE Pwd[32];
	BYTE SSID[32];
}RSNet_WifiSet_t;


////wifiȵܲݽṹ
typedef struct
{
	UINT StructSize; 	// ýṹС
	UINT ChannelMask;
	
	BYTE MacAddr[6];	
	BYTE reserve1[2];

	BYTE SSID[32];
	BYTE Protocol[16];	  	// 802.11ģʽ
	
	BYTE EncryptType;		// ܷʽ  0: 1:WEP 2:WPA-PSK 3:WPA2-PSK 4:WPA-AUTO
	BYTE AuthMode;			// ֤ģʽ 	WEP֤ģʽ:1:OPEN, 2:SHARED   WPA֤ģʽ:3-TKIP, 4-AES 
	
	BYTE SignalQuality;   	//źǿ
	BYTE Frequency;       	// Ƶ 

}RSNet_SoleWifiSet_t;


//عܹ
typedef struct {
	UINT StructSize; //ýṹС
	/*¼Ƶ*/
	BYTE RecordCarNumber;
	/*Ԥʾ*/
	BYTE PreviewCarNumber;
	/*¼GPS*/
	BYTE RecordGps;
	/*ٶȲԴ*/
	BYTE SpeedSource;
	/*ƺ*/
	BYTE CarNumber[MaxNameLen];
	/*Ѵ*/
	UINT Pulse;
	/*ʱػʱ*/
	BYTE DelayTime;
	BYTE Reserved[11];	
}RSNet_VehicleMng_t;


#define RSNet_OD_NUM 3
//StaticOrDynamic
#define RS_ViewMode_Static	0
#define RS_ViewMode_Dynamic	1
//OutputMode
#define RS_OutputMode_Single	0
#define RS_OutputMode_Quarter	1
#define RS_OutputMode_Ninth		2
#define RS_OutputMode_Sixth		3
#define RS_OutputMode_Thirtysecond		4

//IsVoutOrSpot
#define RS_Output_Vout   0
#define RS_Output_Spot	 1
//Resolution
#define RS_Resolution_800_600		0
#define RS_Resolution_1024_768		1
#define RS_Resolution_1280_1024		2
#define RS_Resolution_1440_900		3
#define RS_Resolution_HDMI			4
//InitGuiDev
#define RS_InitGuiDev_VOUT		0
#define RS_InitGuiDev_VGA		1
#define RS_InitGuiDev_AUTO		2

typedef struct{
	struct tag_ChannelSelect{
		unsigned char twentychn[20]; //ʮ
		unsigned char sixteenchn[16]; //ʮ
		unsigned char eightchn[8]; //1+7
		unsigned char sixchn[6]; //1+5
		unsigned char fourchn[4]; //Ļ
		unsigned char ninechn[9]; //Ż
		unsigned char onechn;    //һ
		unsigned char thirtysixchn[36];
		unsigned char reserve[28];
	}ChannelSelect;/*ԤֻͨѡһԤģʽ*/
	unsigned char Margin[4];  /*0:߾, 1:ұ߾, 2:ϱ߾, 3:±߾, 2Ϊλ*/
	unsigned char PollingTime;/*ѯʱ: ֵ:0~3000ʾѯ*/
	unsigned char StaticOrDynamic;/*0-static1-dynamic(ûֶ)*/
	unsigned char OutputMode;/*Ԥģʽ:0-һ棬1-Ļ棬2-Ż棬3-ʮ*/
	unsigned char spotAudio;/*Ƶͨѡ:0-ر, 1-ch1, 2-ch2, 3-ch3, 4-ch4 ... ... 16-ch16*/
	unsigned char reserve[24];/*ֽ*/
}RSNet_OutputAttr_t;

typedef struct{
	UINT StructSize; //ýṹС
	
	RSNet_OutputAttr_t OutputAttr[RSNet_OD_NUM]; /*voattr[0]-OD_VOUT, voattr[1]-OD_VSPOT, voattr[2]-OD_VGA*/
	unsigned char Transparency;/*͸ ֵ0~128 ֵԽԽ͸*/
	unsigned char IsVoutOrSpot;/*0-Vout,1-Spot*/
	unsigned char Resolution;/*4Ϊ豸*/
	unsigned char InitGuiDev;/*ʱĬGUI ʾ豸:0-VOUT, 1-VGA ,2-AUTO*/
	unsigned char OutputDev;/*豸:0-CVBS,1-VGA,2-HDMI*/
	unsigned char reserve1[15];/*ֽ*/
}RSNet_OutputSet_t;

//IRCutMode
#define IRCUTMODE_AUTO   0
#define IRCUTMODE_DAY    1
#define IRCUTMODE_NIGHT  2

//IRCutSensitive
#define SENSITIVE_LENGTH_HIGHT 0
#define SENSITIVE_LENGTH_MIDD  1
#define SENSITIVE_LENGTH_LOW   2

//Flip
#define FLIP_CLOSE 0
#define FLIP_OPEN  1

//Mirror
#define MIRROR_CLOSE  0
#define MIRROR_OPEN   1

typedef struct {
	UINT StoreSize;
	UINT ChannelMask;

	BYTE IRCutMode;            //0:auto;1:day;2:night
	BYTE IRCutDelay;           //0~30;unit:s 
	BYTE IRCutSensitive;       //0:Hight;1:Midd;2:Low 
	//predefine Ԥ壬δʵ 
	BYTE Mirror;        	//ˮƽת  	0:close; 1:open	
	
	BYTE Flip;           	//ֱת 	0:close; 1:open

	BYTE Rotate;    /* 0~ת;1~˳ʱת902~˳ʱת1803~˳ʱת270 */

	BYTE reservel[2];
}RSNet_SoleCameraSet_t;

//shenzhen ipc image control
/* ShutterSpeed */
typedef enum
{
    RS_Shutter_Speed_1_25 = 0,
    RS_Shutter_Speed_1_30,
    RS_Shutter_Speed_1_50,
    RS_Shutter_Speed_1_60,
    RS_Shutter_Speed_1_100,
    RS_Shutter_Speed_1_120 = 5,
    RS_Shutter_Speed_1_150,
    RS_Shutter_Speed_1_180,
    RS_Shutter_Speed_1_200,
    RS_Shutter_Speed_1_240,
    RS_Shutter_Speed_1_250 = 10,
    RS_Shutter_Speed_1_300,
    RS_Shutter_Speed_1_360,
    RS_Shutter_Speed_1_480,
    RS_Shutter_Speed_1_500,
    RS_Shutter_Speed_1_600 = 15,
    RS_Shutter_Speed_1_700,
    RS_Shutter_Speed_1_1000,
    RS_Shutter_Speed_1_1500,
    RS_Shutter_Speed_1_2500,
    RS_Shutter_Speed_1_5000 = 20,
    RS_Shutter_Speed_1_10000,
    RS_Shutter_Speed_1_12000
}NET_SHUTTER_SPEED_E;

/* ͼ ҳ½ṹ */
typedef struct
{
    UINT StructSize;
    UINT ChannelMask;

    BYTE IRCutMode;			/* 0:auto;1:day;2:night;3: ƵԶ */
    BYTE IRCutDelay;		/* 1~36;unit:s */
    BYTE IRCutSensitive;	/* 0:Hight;1:Midd;2:Low */
    BYTE Mirror;        	/* ˮƽת  	0:close; 1:open	*/

    BYTE Flip;           	/* ֱת 	0:close; 1:open */
    BYTE Rotate;			/* 0~ת;1~˳ʱת902~˳ʱת1803~˳ʱת270 */

    /* ⲹ */
    BYTE BackLightMode; /* 0:disable, 1:enable */
    BYTE BackLightLevel; /* 0:low, 1:middle, 2:high */

    /* 3D */
    BYTE R3dnrMode; /* 0:disable, 1:auto, 2:manual */
    BYTE R3dnrThreshTarget; /* the thresh value when manual [1,0xff] */

    /* ֿ̬ */
    BYTE DwdrMode;  /* 0:disable, 1:enable */
    BYTE DwdrStrength;	/* ֵΧ[1,0xff]  */

    /*  */
    BYTE GainControlMode; /* 0:off, 1:low, 2:middle, 3:high */

    /* ƽ */
    BYTE WBMode; /* 0:auto, 1:manual, 2:indoor */
    BYTE Rgain;	/* ֵΧ[1,0xff]  */
    BYTE Ggain; /* ֵΧ[1,0xff]  */

    BYTE Bgain; /* ֵΧ[1,0xff]  */

    /* */
    BYTE ShutterMode; /* 0 auto, 1 manual  */
    BYTE reserve[2];
    int  eShutterSpeed; /* the ShutterUsecs value when manual
                                            50HZ 1/25
                                            60HZ, disable 1/30
                                        */
    BYTE FlickerCtrl;   /* ˸  0:50HZ   1:60HZ  2:disable */

    BYTE reverser2[71];
}RSNetNew_CameraSet_t;

///////////////////////////////////////////////////////////////////////////
//ؼݽṹ, ṩ˾ڲʵֹؼʹáṩ
///////////////////////////////////////////////////////////////////////////

typedef struct {
	UINT StructSize; 	//ýṹС
	
	BYTE Mac[6];
	BYTE reservel[2];
	BYTE model[32];
	BYTE serialNum[32];
}RSNet_KeyConf_t;

//////////////////////////////////////
//IPڰ˲ݽṹ
#define MAX_IPFILTER_NUM 16

#define FILTERSWITCH_OPEN  0
#define FILTERSWITCH_RELYON_ENABLE 1
#define FILTERSWITCH_CLOSE   2

typedef struct {
	UINT StructSize;
	
	BYTE FilterSwitch; //0 еIP ļ(IPͨУ1IP (SingleLock Ƿ) -1 IP IP)

	BYTE reserve[3];
}RSNet_IPFilter_t;

typedef struct {
	UINT StructSize;
	UINT ChannelMask;
	
	BYTE IPAddr[4];
	BYTE Enable;//IPַ鿪 RS_OPEN  1 ; RS_CLOSE 0 

	BYTE reservel[3];
}RSNet_SoleIPFilter_t;

//////////////////////////////////////
//RTSP
//////////////////////////////////////

//enAuthMode
#define RTSP_HTTP_AUTH_NONE   0
#define RTSP_HTTP_AUTH_BASIC  1
#define RTSP_HTTP_AUTH_DIGEST 2

typedef struct {
	UINT StructSize;

	UINT RtspPort;
	UINT enAuthMode;//֤ģʽ 
	UINT RtspEnable;
	char  RtspUserName[32];
	char  RtspPassword[32];
	
	BYTE Checkflag;  /*1 = true, 0 = false */
	BYTE resever[3];
}RSNet_Rtsp_t;


//////////////////////////////////////
//FTP
//////////////////////////////////////
#define    FTP_RECTYP_NORMAL  1                                           
#define    FTP_RECTYP_ALARM   2                                                 
#define    FTP_RECTYP_ALL     3     

#define    FTP_LAST_ONE_H   0                                           
#define    FTP_LAST_TWO_H   1                                                 
#define    FTP_LAST_FOUR_H  2 
#define    FTP_LAST_ONE_D   3            
typedef struct
{
	UINT StructSize;
	UINT ChannelMask;
	BYTE TimeMode;    /*ϴ¼ʱ*/
	BYTE ReqTypeMask; /*룺һλӦһͣλʾ0ʾر*/
	BYTE RecType;     /*1:¼,2:¼,3:¼*/
	BYTE Reserve;
}RSNet_SoleFtpSet_t;

typedef struct
{
	UINT StructSize;
	BYTE FtpIpAddr[16];
	BYTE FtpLoginName[64];
	BYTE FtpLoginPwd[64];
	UINT FtpPort;	
	BYTE UseFtp;
	BYTE Reserved[3];
	UINT SendFileSize;   //  ֽ ΪСλ
	BYTE FilePath[96];   // дļļ·
}RSNet_FtpSet_t;

#define LOCKNUM_MAX      12
#define NET_LOCKID_LEN   16
//LockFlag
#define LOCKSTATE_LOCK   1
#define LOCKSTATE_UNLCOK 0

typedef struct{
	UINT StructSize;
	UINT ChannelMask;
	
	BYTE LockFlag;
	BYTE Reservel[3];
	
	BYTE LockId[NET_LOCKID_LEN];	
}RSNet_SoleElecLockSet_t;


typedef struct
{
	UINT StructSize;
	UINT ChannelMask;
	BYTE DriveName[16];
	BYTE TimeTrigger;
	BYTE Enable;
	BYTE MotionEnable;	
	BYTE Reserved[5];
	BYTE RecvEmail[3][36];  //ռ˵ַ
}RSNet_CloudStorageSet_t;

typedef struct {
	UINT StructSize;
    /*SMTP*/
    BYTE SMTP[36];

    /*˵ַ*/
    BYTE SendEmail[36];

    /**/
    BYTE SendEmailPW[36];

    /*ռ˵ַ*/
    BYTE RecvEmail[3][36];

    /*˿ں*/
    UINT Port;

    /*SSLأ0--رգ1--*/
    BYTE SSLSwitch;

    /*Ƿʹemail,0--رգ1--*/
    BYTE EmailSwitch;

    /*ʼͼ*/
    BYTE intervaltime;/*0:60,1:180,2:300,3:600s*/
    BYTE reserve[1];
} RSNet_cloudemailsetting_t;

//typedef struct 
//{
//	UINT StructSize;
//	BYTE p2pUid[36];
//	BYTE p2pUser[36];
//	BYTE p2pPwd[36];
//	BYTE resev[4];
//} RSNet_P2pMobileSet_t;

// άɨP2p ID ṹ
typedef struct 
{
	UINT StructSize;

	BYTE QrCodeID[48];
	BYTE reserved[24];
}RSNet_P2pQrCodeIdSet_t;

typedef struct{
	UINT StructSize;
	UINT ChannelMask;
	
	BYTE RecordEnable;
	BYTE MotionEnable;
	BYTE IoAlarmEnable;
	BYTE Reservel[9];
}RSNet_SoleDevAllStatusSet_t;

typedef struct {
	UINT StructSize;
	
	BYTE IDNumber[24];
	BYTE KeyContent[2048]; 
	BYTE reserver[4];
}RSNet_LorexP2pParamSet_t;

typedef struct {
	UINT StructSize;

	BYTE AutoUpgradeEnable; 
	BYTE AutoUpgradePrompt; 
    BYTE Reserve[10];
    BYTE DeviceType[MaxNameLen]; //豸
    BYTE SoftwareVer[MaxNameLen]; //ϵͳ汾	
}RSNet_FtpAutoUpgrade_t;

// MasterSwitch 
#define MASTER_SWITCH_OFF     0
#define MASTER_SWITCH_ON      1
#define MASTER_SWITCH_FORBID  2
typedef struct {
	UINT StructSize;

	BYTE MasterSwitch;   // 0 - رֶ¼ 1- ֶ¼  2- ô˿
	BYTE Reserve[15];   // Ԥֽڣֶͨؿ
}RSNet_ManualRecordSet_t;	

#define LOGNUM_MAX  15*20
typedef enum{
		SYSTEM_LOG = 0,
		PARAMETER_LOG,
		/*PTZ_LOG,*/
		ALARM_LOG,
		STORAGE_LOG,
		ALLTYPE_LOG,
}LogType_E;

typedef struct {
	char  event[32];		///< event description
	char time[32];
}RSNet_Log_t;

typedef struct {
	UINT StructSize;
	UINT begintime[6];
	UINT endtime[6];
	UINT logtype;
}RSNet_LimitLogSet_t;

typedef struct {
	UINT StructSize;
	UINT lognum;
	RSNet_Log_t  Loglist[LOGNUM_MAX];
}RSNet_QureyLogSet_t;

#if 1
typedef struct {
	UINT StructSize;
	BYTE Audio;			/*0: close; 1: open */
	BYTE MicInVolume;	/* С(0 - 10) */
	BYTE LineOutVolume; /* С(0 - 10) */
	BYTE AdecEncoding;	/*  0, PT_G711U;1,PT_G711A */
	BYTE Reserve[16];   
}RSNet_VoiceSet_t;
#endif

// MsgParamSystemIDCtrl
typedef struct {
	UINT StructSize;

	UINT SystemID;
	BYTE Reserve[16];
}RSNet_SystemIDCtrl_t;

//IPCFRAMEINFO_S
typedef struct {
	UINT FrameRate;   //ǰ֡,1~30
	UINT BitRate;     // Bit rate

	unsigned long long FrameSelect;  //λȡ֡
}IPCFRAMEINFO_S;

typedef struct {
	UINT StructSize;
	UINT ChannelMask;

	BYTE OsdMask;   	// osdʾ     0:no 1:yes
	BYTE TimeMask;  	// timeʾ  0:no, 1:yes
	BYTE Frequency;     // Ƶ        0:60hz, 1:50hz
	BYTE StreamType;    //ͣ   0:sigle, 1:double

	BYTE EncodeType;   //ǰ,    when sigle streame; 0:D1,  1:720P,  2:1080P, when double streame; 0:1080p+cif,  1:720P+D1,  2:720p+cif
	BYTE Reserve[3];

	IPCFRAMEINFO_S FrameInfo;     //֡Ϣ
	IPCFRAMEINFO_S FrameInfoExt;  //when is sigle streame ,it is no vaild
}RSNet_SoleIPCFrameSet_t;

typedef struct
{
	UINT StructSize;
	
	BYTE DriveName[16];
    BYTE RecvEmail[3][36];
    BYTE Account[3][64];
    BYTE AccountPW[3][64];
	BYTE Enable;
	BYTE ServerType;
	BYTE SnapEnable;
	BYTE VideoEnable;
}RSNet_NewCloudStorageSet_t;

typedef struct
{
	UINT StructSize;

	UINT ChnNoChoice; // λȡӦͨ־λ
	BYTE TimeTrigger;
	BYTE MotionSnapEnable;
	BYTE Reserved[2];
}RSNet_UploadPhotoSet_t;

typedef struct
{
	UINT StructSize;
	
    UINT MotionScheduleHour[32][8];//ͨ,7,Сʱλȡ
    BYTE MotionVideoChannel;
	BYTE Reserved[3];
}RSNet_UploadVideoSet_t;

typedef struct
{
    UINT StructSize;
    UINT ChannelMask;       //ͨ
    BYTE HalfHour[8][48];   // 7days and 48 halfhours
    BYTE Reserved[16];
}RSNet_SoleUploadVideoSet_t;

typedef struct 
{    
	UINT StructSize;

	BYTE key[3][64];      /*ûKEY*/
    BYTE secret[3][64];   /*ûKEY*/
    BYTE Enable;
    BYTE CloudType;       /*ƶ˷ͣ0-DROPBOX,1-GOOGLE*/
    BYTE TimeTrigger;
    BYTE MotionEnable;
    BYTE DriveName[32];   /*ϴĿ¼*/
    UINT Channel;
    BYTE FTPPATH[36];     /*FTP·*/    
}RSNet_NormalCloudStorageInfo_t;

typedef struct 
{
	UINT StructSize;

	BYTE SMTP[36];        /*SMTP*/
    BYTE SendEmail[36];   /*˵ַ*/
    BYTE SendEmailPW[36]; /**/
    BYTE RecvEmail[3][36];/*ռ˵ַ*/
    UINT Port;           /*˿ں*/
    BYTE SSLSwitch;   /*SSLأ0--رգ1--*/
    BYTE EmailSwitch; /*Ƿʹemail,0--رգ1--*/
    BYTE intervaltime;/*ʼͼ0:60,1:180,2:300,3:600s*/ 
	BYTE reserve[11];
}RSNet_NormalCloudStorageEmail_t; 

typedef struct{
	UINT StructSize;

	BYTE FtpIpAddr[16];
	BYTE FtpLoginName[32];
	BYTE FtpLoginPwd[32];
	UINT FtpPort;
	BYTE FilePath[64]; 
	BYTE Reserved[64];
}RSNet_NomalCloudStorageFtp_t;

typedef struct{
    short x1;
    short y1;
    short x2;
    short y2;
}Net_Line_S;

/* ߼-ܽ */
typedef struct {
	UINT StructSize;
	UINT ChannelMask;

    BYTE ChnSwitch;          /*0-رգ1-*/
    BYTE BuzzerMooTime;      /*Уʱ:010204060s*/
    BYTE AlarmOutTime;       /*ʱ:010204060s*/
    BYTE RecordDelayTime;    /*¼ʱʱʱ:010204060s*/
    BYTE AlarmOutManager[4];   /*ֻһģAlarmOutManager[0]*/
    UINT RecordChannel;
    BYTE Record;               /*Record channel switch*/
    BYTE ShowMessage;          /*Show Message */
    BYTE SendEmail;            /*Send Email */
    BYTE FullScreen;           /*FullScreen */
    BYTE RuleSwitch;         /*ÿͨһֽڱʾ80-رգ1-ʹ*/
    BYTE RuleType;           /*ÿͨһֽڱʾ8-ͣ0-ߣ1-ܽ*/
    BYTE LineTwoWay;         /*ÿͨһֽڱʾ8-˫0-1-˫*/
	BYTE reserver[5];
    Net_Line_S RuleLine[32];	/*ÿͨ64,32ߣǰֻʹõ1ߣ
    															  ܽ8ɱպͼ */
}RSNet_SolePerimeterLine_t;

/* ߼-Ƶ */
typedef struct{
	UINT StructSize;
	UINT ChannelMask;

    BYTE ChnSwitch;                   /*0-رգ1-*/
    BYTE ChnCruiseTime;               /*ѯʱ*/
    BYTE BuzzerMooTime;               /*Уʱ:010204060s*/
    BYTE AlarmOutTime;                /*ʱ:010204060s*/
    UINT CheckTypeSwitch;             /*Ϳ*/
    BYTE AlarmOutManager[4];            /*ֻһģAlarmOutManager[0]*/
    UINT RecordChannel;
    BYTE Record;                        /*Record channel switch*/
    BYTE RecordDelayTime;             /*¼ʱʱʱ:010204060s*/
    BYTE ShowMessage;                   /*Show Message */
    BYTE SendEmail;                     /*Send Email */
    BYTE FullScreen;                    /*FullScreen */
	BYTE CheckType;                   /**/
    BYTE reserve[10];
}RSNet_SoleVideoDiagnostics_t;

/* ߼-Ʒʧ*/
typedef struct{
	UINT StructSize;
	UINT ChannelMask;

    BYTE ChnSwitch;          /*0-رգ1-*/
    BYTE BuzzerMooTime;      /*Уʱ:010204060s*/
    BYTE AlarmOutTime;       /*ʱ:010204060s*/
    BYTE RecordDelayTime;    /*¼ʱʱʱ:010204060s*/
    BYTE AlarmOutManager[4];   /*ֻһģAlarmOutManager[0]*/
    UINT RecordChannel;
    BYTE Record;               /*Record channel switch*/
    BYTE ShowMessage;          /*Show Message */
    BYTE SendEmail;            /*Send Email */
    BYTE FullScreen;           /*FullScreen */

    BYTE RuleSwitch;         /*ÿͨһֽڱʾ80-رգ1-ʹ*/
    BYTE RuleType;           /*ÿͨһֽڱʾ8-ͣ0-1-ʧ*/
    BYTE RuleScene;          /*ÿͨһֽڱʾ8-ͣ0-ڳ1-*/
    BYTE reserve[5];
    BYTE RuleRectEnable[8];  /*ÿͨ8ÿ4.ÿһλһʹܣĿǰֻǰλ*/
    Net_Line_S RuleRect[32];	/*ÿ4,ÿͨ8432*/
}RSNet_SoleGoodsLostLegacy_t;

typedef struct 
{
	UINT StructSize;

	UINT KeyID;
	BYTE BoardID[16];
	BYTE reaserver[8];
}RSNet_IDset_t;


/*********************************************************************
 * Description:New NVR Device Param Adapter 
 * 8 Bytes Alignment 
 * add by zy 20140213
 * ******************************************************************/


/* stream */
typedef struct 
{
	BYTE FrameRateMin;/*ֵ֧֡ʷΧMin,Ϊ0δ*/
	BYTE FrameRateMax;/*ֵ֧֡ʷΧMax,Ϊ0δ*/
	BYTE reserver[2];
	WORD ResolutionWidth;/*ֵ֧ķֱʣΪ0δ*/
	WORD ResolutionHight;/*ֵ֧ķֱʣΪ0δ*/
	UINT BitrateRange;   /*λȡ RS_MainBitrate_eRS_SubBitrate_e1:ʾ֧֣0:ʾ֧֣ȷӦ*/
}RSNetNew_ResolutionRateRange_t;

typedef struct 
{
	UINT StructSize;
	UINT ChannelMask;
	
	BYTE BitRateMode;    //stream mode:0-Ԥ 1-Զ
	BYTE Bitrate;        // ӦСμRS_MainBitrate_e
	WORD CustomBitrate;   // ԶֵԤֵbitrate޷ǰIPCʱʹ 

	BYTE BitrateType; /* 0 :1:2:  */
	BYTE VideoQuality; /* ͼ0: 1:2:3:4:5:*/
	BYTE AudioSwitch;    //ǰ豸ƵǷ 0: close 1: open
	BYTE Num;/*ֵ֧ķֱʸ,ѡ8*/
	
	BYTE IFrameInterval; /* I ֡Χ1-100   */
	BYTE Fps;      
	BYTE ResolutionsetIndex; /* whice one resolution index has been choose to set */
	BYTE HaveAudio;/*ǰ豸Ƿ֧Ƶ룬0֧֣1֧*/
	RSNetNew_ResolutionRateRange_t Range[8];
	BYTE reserver2[8];
	
}RSNetNew_SoleStreamset_t;

/* preview  */
#define NET_STD_RES_X 704
#define NET_STD_RES_Y 576
typedef struct 
{
	UINT StructSize;
	UINT ChannelMask;
    
	/* ChannelNameͨλãNET_STD_RES_X * STD_RES_Yֵ */
	WORD ChnNamePosX; 
	WORD ChnNamePosY; 
	/* Dateʱλãͬ */
    WORD DateTimePosX;
    WORD DateTimePosY;
	
	char   ChnName[40];        /*ͨ*/
    BYTE ShowChnNameFlag;    /* OSDǷʾͨ1-ʾ0-ʾ */
    BYTE ShowDateTimeFlag;   /* OSDǷʾ  1-ʾ0-ʾ */
    BYTE TimeMode:4; /* ʱģʽ0Ϊ24Сʱƣ1Ϊ12Сʱ*/
    BYTE DateMode:4; /* ģʽ:0ΪMM/DD/YYYY1ΪYYYY-MM-DD2ΪDD/MM/YYYY*/
                                                            
	BYTE FlickerCtrl;  // ipc ˸ 0:50 Hz 1:60Hz 2 disable
    BYTE DisplayRule;   //ݲͬIPCЭʾͬ
    BYTE  reserve1[15];

}RSNetNew_SoleLivingset_t;

/* output */

typedef struct 
{
    BYTE VideoIndex[32]; /* ÿͨڵĴںţ±ΪͨţֵΪں */
    BYTE StreamType[32]; /* ÿͨԤͣ 0-1- */

    UINT Margin[4];
    UINT AutoSEQTime; /* ѭʱ */
    BYTE PreviewMode; /* Ԥģʽ0-ϵͳԤģʽ1-ûԶģʽ */
	BYTE SplitMode;   /* ģʽUIṩ */
	BYTE CurrentPage; /* Ԥͨڷʱжҳò¼ǰҳ */
	BYTE SeletedVideo; /* ǰѡдڵ */
	BYTE IsEnlarged;   /* ¼ǰѡеĴǷ˫ķŴ״̬ */
	BYTE SpotAudio;
    BYTE reserve[14];
}Net_voattr_t; // outputset ӽṹ

typedef struct 
{
	UINT StructSize;

	Net_voattr_t voattr[4];     /*voattr[0]-HDMI, voattr[1]-VGA, voattr[2]-VOUT, voattr[3]-VSPOT*/ 
	UINT transparency;      /*͸*/
	BYTE IsVoutOrSpot;    /*0-Vout,1-Spot*/
	BYTE vgaresolution;   /*VGA ֱ*/
	BYTE initGuiDev;      /*ʱĬGUI ʾ豸:0-VOUT, 1-VGA ,2-AUTO*/
	BYTE ChangeResolutionFlag;/* REVERT_VGARESOLUTION:    0:޸Ķ, 1:иĶ, 2:ѻָ*/
	BYTE oldvgaresolution;    /*ǰķֱ*/
	BYTE AutoSEQFlag;     /*¼ǷѯԱϴ״̬*/
	BYTE OutputDev;       /*豸:0-HDMI,1-VGA,2-VOUT*/
	BYTE voice;
	BYTE EnablePreview[32];        /*Ԥ 0-ر, 1- */
	BYTE reserve[16];    /*ֽ*/
}RSNetNew_Outputset_t;

/* KB setting */
typedef struct 
{
	UINT StructSize;

	BYTE Protocol; /*Эͣ0-Pelco-D1-Pelco-P*/
	BYTE Baudrate; /*ʣ0-12001-24002-48003-9600*/
	BYTE DataBit;  /*λ0-81-72-63-5*/
	BYTE StopBit;  /*ֹͣλ0-11-2*/
	BYTE Check;    /*У飬0-None1-Odd2-Even3-Mark4-Space*/
	BYTE reserver[7];
}RSNetNew_KBset_t;

/* Ftp upgrade */
typedef struct 
{
	UINT StructSize;

	BYTE FtpAddr[16];
	BYTE UserName[32];
	BYTE UserPwd[32];
	BYTE FtpPath[64];
	BYTE ProductName[32];
	UINT FtpPort;
	BYTE FtpUpgradeEnableFlag;/*0==false,  1 == true*/
	BYTE FtpUpgradeTips;      /*0 == false,  1 == true*/
	BYTE resev[6];
}RSNetNew_FtpUpgradset_t;

/* Version info */
typedef struct 
{
	UINT StructSize;
	BYTE reverser[4];

	char DeviceType[24];
	char AppVer[24];/* ϵͳʱʹ*/
	char UbootVer[24];
	char KernelVer[24];
	char RootfsVer[24];
	char SlaveUbootVer[24];
	char SlaveKernelVer[24];
	char SlaveRootfsVer[24];
	char LogoVer[24];
	char MacAddr[24];
	char SerialNum[24];
	char SWVertion[24];/*UI ʾʹ*/
	char IEVertion[24];
	char HWVertion[24];
	char KBVertion[24];
}RSNetNew_StateParamset_t;

/* device abilities */
// typedef enum
// {
//     PROTO_TYPE_RS = 0,
//     PROTO_TYPE_HIK,
//     PROTO_TYPE_DAUA,
//     PROTO_TYPE_HH,
//     PROTO_TYPE_ONVIF,
//     PROTO_TYPE_NULL
// }Net_PROTO_TYPE_E;

/* new device abilities */
typedef enum 
{
	PROTO_TYPE_RS = 0,
	PROTO_TYPE_RSSZ,   /*TI˽Э*/
	PROTO_TYPE_SAMSUNG,/**/
	PROTO_TYPE_ONVIF = 4,  /*onvif */
	PROTO_TYPE_NULL,
} PROTO_TYPE_E;

typedef enum
{
	ABILITY_TYPE_MAINSTREAM,
	ABILITY_TYPE_SUBSTREAM,
	ABILITY_TYPE_SNAPSTREAM,
	ABILITY_TYPE_OSD,
	ABILITY_TYPE_COLOR,
	ABILITY_TYPE_TIME,
	ABILITY_TYPE_COVER,
	ABILITY_TYPE_MOTIONSET,
	ABILITY_TYPE_MOTIONAREA,
	ABILITY_TYPE_IO,/*ǰ豸Ƿ֧IO*/
	ABILITY_TYPE_PTZ,
	ABILITY_TYPE_TIIPC/*ǷΪTI豸*/
}Net_ABILITY_TYPE_E;

typedef enum _IPChnStatus_{
	IPCS_BOTTOM   = -1,
	IPCS_NETWRONG = 0,/*޷ӵIPC*/
	IPCS_UNAUTHER = 1,/*û֤ʧ*/
	IPCS_ONLINE   = 2,/*ʾ¼ɹ*/
	IPCS_CONNECT  = 3/**/
}IPChnStatus_e;

/* honeywellƷֱ */
typedef enum
{
	Res_720x576, // 0 ʾΪH264:720x576
	Res_1280x720,
	Res_1920x1080,
	Res_1600x1200,
	Res_2048x1536,
	Res_2592x1920, // 5
	Res_3264x2448,
	Res_3664x2748,
	Res_720x576_176x144,
	Res_720x480_320x192,
	Res_720x480_352x288, // 10 ʾΪH264:720x576,H264:352x288
	Res_720x480_720x480,
	Res_720x576_352x288, 
	Res_1280x720_176x144,
	Res_1280x720_320x192,
	Res_1280x720_352x288, // 15
	Res_1280x720_640x480,
	Res_1280x720_720x576,
	Res_1280x960_720x576, 
	Res_1920x1080_176x144,
	Res_1920x1080_320x192, // 20
	Res_1920x1080_352x288,
	Res_1920x1080_720x576,
	Res_1280x720_720x576_J352x288, // JH264:ȥ_,J滻ΪJPEG:
	Res_1280x720_640x480_J352x288 // 24 ʾΪH264:1280x720,H264:640x480,JPEG:352x288
} ResRange_e;

#endif
