/********************************************************************
	ļ	ͻ豸ͨѶЭ
	created by  2011.1.8
*********************************************************************/
#ifndef __RSNetProtocol_h__
#define __RSNetProtocol_h__

#pragma pack(4)

#define RS_DVR_D9104	0x5253000000010100ULL
#define RS_DVR_D9104B	0x5253000000010101ULL
#define RS_DVR_D9108	0x5253000000010200ULL
#define RS_DVR_D9108B	0x5253000000010201ULL
#define RS_DVR_D9016	0x5253000000010300ULL
#define RS_DVR_D9116	0x5253000000060300ULL

#define RS_DVR_D9216H	0x5253000000020300ULL

#define RS_DVR_D9316H	0x5253000000020301ULL
#define RS_DVR_ID9316H	0x5253000001020300ULL

#define RS_DVR_D9604L   0x5253000100010100ULL
#define RS_DVR_D9608L	0x5253000100020200ULL
#define RS_DVR_D9616L	0x5253000100020300ULL

#define RS_DVR_NORMAL		0x0000000000000000ULL  
#define RS_DVR_D9608H		0x5253000100020201ULL
#define RS_DVR_D9616H		0x5253000100020301ULL
#define RS_NVR_N1004   		0x5253030200010100ULL
#define RS_HOME_H1002H  	0x5253020100010100ULL
#define RS_HOME_H1002M 		0x5253020100010101ULL
#define RS_DVR_D9608B		0x5253000100020202ULL
#define RS_DVR_D9616B		0x5253000100020302ULL
//#define RS_DVR_D9716L	    0x5253000100050300ULL
#define RS_DVR_D9708L	    0x5253000100060200ULL
#define RS_DVR_D9704L	    0x5253000100060100ULL
#define RS_DVR_D9704BP      0x5253000300060100ULL
#define RS_DVR_D9708BP      0x5253000300060200ULL
//2013.2.2
#define RS_DVR_D9704		0x5253000300060100ULL
#define RS_DVR_D9708S		0x5253000300070200ULL
//2013.02.03
#define RS_DVR_D9716L		0x5253000300050300ULL
#define RS_DVR_D9708		0x5253000300060200ULL
#define RS_DVR_D9116S		0x5253000300070300ULL
//2013.08.13
#define RS_DVR_D9704SDI		0x5253000500050100ULL
#define RS_DVR_D9708SDI		0x5253000500050200ULL
#define RS_DVR_D9704LNRSDI	0x5253000500070101ULL
#define RS_DVR_D9708LNRSDI	0x5253000500050201ULL
#define RS_DVR_D9716LNRSDI	0x5253000500050301ULL
#define RS_DVR_D9604170		0x5253000100090100ULL
#define RS_DVR_D9104170		0x5253000000090100ULL
#define RS_DVR_D9108170		0x5253000000090200ULL

#define RS_IPC_TI       	0x5253040200030000ULL
#define RS_IPC_GM       	0x5253040200040000ULL
#define RS_IPC_3518C      	0x5253040200050000ULL


#define RS_MDVR_D5704 		0x5253010100010100ULL

#define RS_DECODER_A9001	0x5253050100010100ULL
#define MaxIpLen	16
#define MaxNameLen	36
#define MAX_NET_PARAMS_LEN  32


//////////////////////////////////////////////////////////////////////////
//MsgHead.Version
#define MsgHeadV1	0 
#define MsgHeadV2   2

//MsgHead.AckFlag
#define AckSuccess					0
#define AckFail						1
#define AckNoMsgType 				2
#define AckLoginUserLogined			10
#define AckLoginNoUserName			11
#define AckLoginPasswordError		12
#define AckLoginIPFilerError		13
#define AckDualtalkBusy				20
#define AckAuthorityFail			50
#define AckParamError				51
#define AckUpgrading				60
#define AckUpgradeVersionError		61
#define AckPreviewNoStream          62
#define AckUpgradeVersionSame       63
#define AckUpgradeLanguageError     64 
#define AckOverMaxPrevNumErr		65 
#define AckOverMaxUser              66
#define AckInUserInterface          67

//MsgHead.MsgType
#define MsgSearchDev			11
#define MsgDevNetCfg            12
#define MsgLogin				31
#define MsgHeartbeat			32
#define MsgTcpPreview			71
#define MsgGetUdpAddr			81
#define MsgStartUdpPreview		82
#define MsgStopUdpPreview		83
#define MsgReqIFrame		    87
#define MsgPTZControl			101
#define MsgQueryRecord			111
#define MsgRecordPlay			121
#define MsgRecordPlayFeedback	122
#define MsgReposRecordData		123
#define MsgDownloadRecordFile	131
#define MsgDualtalk				141
#define MsgQueryParam			211
#define MsgSetParam				216
#define MsgDefaultParam         217     //Ĭϲ
#define MsgStatusRequest		890		//״̬ϱ
#define MsgAlarmReport			891
#define MsgAlarmSubscribe		896
#define MsgRemoteUpgrade		5139

#define MsgEmailTest            301
#define MsgDDNSTest             302
#define MsgRemoteReboot         303
#define MsgSyncTimeCtl          304
#define MsgColorCtrl            305
#define MsgRemoteCapture        306
#define MsgGainSnaptReport      307
#define MsgQueryLog             308
#define MsgHddFormat            309
#define MsgSearchRemoteDev		310   //NVRãԶ豸
#define MsgSetRemoteDevNet		311   //NVRãԶ˻
#define MsgAddAllDevice         312   // һӹϢ
#define MsgFtpUpgrade           320   //Ftp Զ
#define MsgActivateCloud        321   // Ӳ֤
#define MsgDevicePlayback       322   // طŻ
#define MsgFtpWriteFileTest     323   // ftpдļϢ
#define MsgQueryLog_IPC         324   //ipcר
#define MsgIsFormatHdd          325   //ʽӲط()
#define MsgNoStreamType         326   //no
#define MsgCloudCheck           327   //kguard cloud check

//޸Ĺؼ
#define MsgQueryKeyConf			400
#define MsgSetKeyConf			401

#define MsgReqVideoActivation   402
#define MsgGetDDNSID            403

//
#define PPPOE_SET_MSG           411

//MsgHead.MsgSubType
#define MsgNoSubType	0

//MsgPTZControl sub type
#define MsgPTZUp			1
#define MsgPTZDown			2
#define MsgPTZLeft			3
#define MsgPTZRight			4
#define MsgPTZUpLeft		5
#define MsgPTZUpRight		6
#define MsgPTZDownLeft		7
#define MsgPTZDownRight		8
#define MsgPTZZoomIn		11 //
#define MsgPTZZoomOut		12 //С
#define MsgPTZFocusNear		13 //ǰ
#define MsgPTZFocusFar		14 //
#define MsgPTZIRISOpen		15 //Ȧ
#define MsgPTZIRISClose		16 //ȦС
#define MsgPTZAutoScan		21
#define MsgPTZCruise		51
#define MsgPTZSetPreset		91
#define MsgPTZClearPreset	92
#define MsgPTZCallPreset	93
#define Open_Screen_PTZ     97
#define Close_Screen_PTZ    98
//MsgQueryRecord sub type
#define MsgRecordDetail		 101
#define MsgRecordDayOutline	 102
#define MsgRecordDayHalfHour 103

//MsgRecordPlayFeedback sub type
#define MsgRecordDataInsufficient		121
#define MsgRecordDataEnough				122

//MsgAlarmReport sub type
#define MsgSnaptMotion                  188
#define MsgVLossAlarm                   189
#define MsgDevStatReport                190
#define MsgMotionAlarm			        191
#define MsgIOAlarm				        192
#define MsgAIAlarm				        193
#define MsgIntelligentAlarm		        194
#define MsgAvdAlarm				        195
#define MsgRecordAlarm          		201
#define MsgHddAlarm             		202
#define MsgFtpUpgradeAlarm              203   // Ftp 澯
#define MsgOscAlarm		                204
#define MsgIntelPeaAlarm                205
#define MsgOscRuleAlarm                 206

//MsgAlarmSubscribe sub type
#define MsgAlarmDesired			        196
#define MsgAlarmRefused			        198
#define MsgAIData                       199
#define MsgTelModuleAlarm               210
#define MsgRemoteCHStatusReport         211
#define MsgRecordStatusReport			212
#define MsgHddStatusReport				213
#define MsgGpsInfoReport                214


//.SubType
#define MsgParamOsd				        501
#define MsgParamSystemBase		        502
#define MsgParamHdd				        503
#define MsgParamSerial			        504
#define MsgParamUser 			        505
#define MsgParamDst 			        506
#define MsgParamMainStream 	            507
#define MsgParamColor 			        508
#define MsgParamVideoCover 		        509
#define MsgParamPtz 			        510
#define MsgParamNetworkBase 	        511
#define MsgParamDDNS 			        512
#define MsgParamPPPOE 			        513
#define MsgParamEmail 			        514
#define MsgParamNtp 			        515
#define MsgParamMotion 			        516
#define MsgParamAbnormal 		        517
#define MsgParamIOAlarm 		        518
#define MsgParamRecord 			        519
#define MsgParamSchedule 		        520
#define MsgParamDefault 		        521
#define MsgParamIntelligent             522
#define MsgParamIntavd                  523 

#define MsgParamGeneral                 524
#define MsgParamMaintain                525
#define MsgParamSubStream               526
#define MsgParamMobile                  527
#define MsgParamEmailSchedule           528
#define MsgParamPlatform                529
#define MsgParamIpc                     530
#define MsgParamIpcIOAlarm              531
#define MsgParamIpcWifi                 532
#define MsgParam3G                      533
#define MsgParamRouterLan               534
#define MsgParamRouterWan               535
#define MsgParamTuobao                  537
#define MsgParamVehicleMng              538
#define MsgParamOutput			        539
#define MsgParamTelAlarmArea            540
#define MsgParamTelAlarmWireSensor      541
#define MsgParamTelAlarmWirelessSensor  542
#define MsgParamPhoneNumberSetting      543
#define MsgParamCameraSet               544
#define MsgParamMobileStream            545
#define MsgParamHuaweiPlatform          546
#define MsgParamIPFilter                547
#define MsgParamRtsp                    548
#define MsgParamFtp                     549
#define MsgParamElecLock             	550
#define MsgParamCloudStorage            551
#define MsgParamCloudEmail              552

//#define MsgParamP2pMobile               553
#define MsgParamP2pQrCodeID             553
#define MsgParamDevAllStatusSet         554   // URMET ͻԶ̿ͨϢ
#define MsgParamLorexP2pParam           555   // Lorexͻ
#define MsgParamFtpAutoUpgrade          556   // 
#define MsgParamManualRecord            557   // ֶ¼

#define MsgParamSystemIDCtrl             558  // 豸id
#define MsgParamIPCFrameInfo             559  // nvrȡipc֡Ϣ
#define MsgParamNewCloudStorage          560
#define MsgParamUpLoadPhoto              561
#define MsgParamUpLoadVideo              562
#define MsgParamCloudStorageInfo         563
#define MsgParamCloudStorageEmail        564
#define MsgParamCloudStorageFTP          565
#define MsgParamPerimeterLine            566
#define MsgParamVideoDiagnostics         567
#define MsgParamGoodsLostLegacy          568
/***********************************
 * new nvr param  adapter message
 **********************************/
#define MsgParamModifyMainStream         570
#define MsgParamModifySubStream          571
#define MsgParamModifyMobileStream       572
#define MsgParamModifyLiving             573
#define MsgParamModifyOutput             574
#define MsgParamModifyKBSet              575
#define MsgParamModifyFtpUpgrade         576 
#define MsgParamModifyState              577
#define MsgParamModifyEmailSchedule      578
#define MsgParamLogDeletes				 579
#define MsgParamLogTerm					 580
#define MsgParamVoice					 581
#define MsgParamIDSet                    582
#define MsgParamStreamSet                583 //honeywell only. (20140516)
#define MsgParamSoleUploadVideo          584 //Ƶϴ 7day*48halfhour
#define MsgParamIntelliRec               585 //¼ƻ(Qt v2)
#define MsgParamIPCImageSet              587 //IPCͼ
#define MsgParamRenewFactory             588 //shenzhen new factory

//shen zhen ipc image control
#define MsgParamModifyCameraSet          583

// sub type
#define MsgRemoteUpgradeData	761
#define MsgRemoteUpgradeEnd		762
#define MsgRemoteUpgradePartEnd 763
#define MsgRemoteUpgradeWriteFlashInProgress 764
#define MsgRemoteUpgradeWriteFlashEnd 765


#define MsgRSPlatform           800

//sync time sub type
#define MsgSyncSetTime          331
#define MsgSyncGetTime          332

//MsgStatusAlarmRequest	Sub Type 
#define MsgDevAllStatusReq			610
#define MsgRemoteCHStatusReq		611  //ѯԶͨ״̬,ҪָNVRӵIPC״̬

//Msg PEA , GoodsLost Sub Type
#define MsgPeaAlarmReq              612
#define MsgGoodsLostAlarmReq        613
//ֻȡ豸״̬,lorexͬʱȡ״̬ͼ
#define MsgDevStatusOnlyReq         614
#define MsgGetRemoteParam           615 //ȡlorex http


typedef struct
{
	BYTE Version : 2; //Ϣͷ汾
	BYTE ExtSize : 6; //ϢͷչСʵչС = ExtSize * 4
	BYTE Reserved;
	WORD AckFlag; //ϢӦ
	WORD MsgType; //Ϣ
	WORD MsgSubType; //Ϣ
	UINT MsgSize;  //ϢͷݴС
	UINT Seq;   //ϢкţʶһϢΨһԣ󷽴Ӧԭֵ
}MsgHead; //Ϣͷsizeof(MsgHead) = 16


//////////////////////////////////////////////////////////////////////////
//豸
// MsgType=MsgSearchDev
//Ӧ MsgSize=sizeof(SearchDevRsp)

#define SearchDevPort	9333

//SearchDevRsp.NetworkMode
#define NetworkModeDHCP		0
#define NetworkModePPPOE	1
#define NetworkModeManual	2

typedef struct
{
	char IP[MaxIpLen]; //IP
	char HostName[MaxNameLen]; //
	char NetMask[MaxIpLen]; //
	char GateWay[MaxIpLen]; //
	char DNS1[MaxIpLen]; //dns1
	char DNS2[MaxIpLen]; //dns2

	UINT Port; //ͻ豸˿
	UINT IEPort; //IE˿

	UINT NetworkMode; //ʽ

	char DevType[MaxNameLen - 8]; //豸
	unsigned long long DevTypeULL;
	char DevVer[MaxNameLen]; //豸汾
	UINT DeviceID;  //
   	char DeviceName[MaxNameLen]; //豸ƣ޸        
	char MacAddr[MaxNameLen]; //豸MACַ

	UINT ChannelNum; //ͨ
	
	unsigned char Version;//汾
	char cNetInterface;// 0 eth0 1 eth1
	char reserved[2];
}SearchDevRsp;


//////////////////////////////////////////////////////////////////////////
//¼
// MsgType=MsgLogin, MsgSize=sizeof(LoginReq)
//Ӧ ɹAckFlag=AckSuccess,MsgSize=sizeof(LoginRsp) ʧAckFlag=AckLoginUserLogined,AckLoginNoUserName,AckLoginPasswordError,AckFail

//VideoFormat
#define RS_PAL  0
#define RS_NTSC 1

typedef struct
{
	char UserName[MaxNameLen];
	char Password[MaxNameLen];
	UINT UserKey; //״ε¼Ϊ0ϴγɹ¼صUserKeyԷռûûѵ¼Ĵ󷵻
	UINT AlarmReportDesired : 1;
	UINT Reserved : 23;
	UINT Language : 8; /* 1,2.Ӣ */
}LoginReq;


//ûȨ޸λʾ
typedef struct
{
	UINT UserSetRight;// ,̹,Զ̵,ϵͳά,־鿴,Ѳ,ѯ
//	UINT ManualRecordChannel;  //ֶ¼ͨ 
	UINT PreviewChannel;     //Ԥͨ
	UINT PlayBackChannel;       //طͨ
	UINT BackupChannel;        //ͨ
	UINT PtzControlChannel;     //̨ͨ
	BYTE UserPreview;        //ԤȨ
//	BYTE UserManualRecord;   //ֶ¼Ȩ
	BYTE UserPlayBack;        //¼طȨ
	BYTE UserBackup;          //Ȩ
	BYTE UserPtzControl;       //̨Ȩ
	
	BYTE MainStream:1;       //Ȩޣλȡֵ        
	BYTE SbuStream:1;		//Ȩޣλȡֵ        
	BYTE MobileStream:1;	//Ȩޣλȡֵ     
	BYTE Reser:5;
         
	BYTE Reserved[15];
}UserRightWrap;
C_ASSERT(sizeof(UserRightWrap) == 40);

typedef enum
{
	PLATF_SWITCH_RS_PLATFORM = 0,
	PLATF_SWITCH_HUAWEI_PLATFORM,
}PlatformSwitch_E;

typedef struct
{
	unsigned long long DevType; //豸
	char DevVer[MaxNameLen]; //豸汾
	char DeviceName[MaxNameLen]; //豸ƣ޸        
	char MacAddr[MaxNameLen]; //豸MACַ
	UINT DeviceID;  //
 
 	UserRightWrap UserRight; //ûȨ

	UINT UserKey; //ûԿ
	WORD TotalFPS; //豸D1ģʽÿ֡TotalFPS=100, 4CIF 25f/s2HD1 25f/s1D1 25f/s
 	BYTE ChannelNum; //ͨ
 	BYTE VideoFormat; //ͷʽ

 	BYTE AlarmInNum;  //
 	BYTE AlarmOutNum; //(̵)
	BYTE AIAnalyzeCap; //Ƿ֧ܷ
	BYTE AIAnalyzeChannels; //ܷ·

	BYTE SerialNum;	//豸ʹôڵĿûо0(ǲôͨѶ)
	BYTE ISAdmin;   //ǷǹԱ
	BYTE AudioNum;         //Ƶͨ
	BYTE ResolutioFrameFix;//֡ʷֱǷ̶:0-ɵ,1-̶2-չΪߵ

	BYTE PreviewOff;       //ԤǷԹرգҪD90160-ԣ1-
	BYTE VideoCoverNum;    //ֵ֧ͨƵڵҪD9016
	BYTE SupportSpot;      //Ƿ֧spotӿڵع
	BYTE SubStreamMin;     //СȡֵΧӦֵƷʵֵ

	BYTE SubStreamMax;     //:0     1     2     3     4    5     6     7    8       9       10      11     12
	BYTE PlatformSupport; //0(֧ƽ̨) 1(֧ƽ̨)
	
    WORD ChnInfoSize;		//ʾ¼ṹͨϢDevChnInfoṹĴС
							//汾ʹͨϢṹ塣ΪϢMsgRemoteCHStatusReqȡͨϢ

	BYTE SubStreamRestrict; // 0() 1 ()
	BYTE DualtalkShowTag;  //0(ʾ:ֶ֧ܲԽ) 1(ʾֶ֧Խ)
	BYTE RouterShowTag;    //Ƿʾ·ɲҳ
	BYTE LANShowTag;		//Ƿʾ·Lanҳ

	UINT PlatFormShowTag;   //Ƿʾƽ̨òҳ棬Value Show Plat*(UINT*)"PLEn" Hide Plat0x00000000 
	char ProductName[24];
	UINT PlatFormSwitch;   //PlatformSupport = 1PlatFormShowTag = "PLEn" жϴƽ̨֧, λʾʹ PlatformSwitch_E , ȫΪ0ΪĬϵRS_PLATFORM
	
	BYTE VideoActivateSwitch; // Ƿ֧ ûѡͨƵС
	BYTE MotionMode;          //0ɵģʽ1  44*36 ʽģʽ
    BYTE ResolutionMode;      //0 D1ģʽ,1D1960Pģʽ, 2CIFģʽ, 3CIFǲ֡
                              //4 720P 5720P960, 61080pģʽ, 7720P1080Pģʽ
	BYTE HidePhonePage;        //0أ1
	
	BYTE UpgradeType;         //0 豸 1 豸
	BYTE ElecLockFlag;         //0 δ״̬ 1 ״̬
 	WORD TotalFPS_960;			//豸960ģʽÿ֡TotalFPS=100, 4CIF 25f/s2HD1 25f/s1D1 25f/s

	// one byte
	BYTE WifiStatus:1;           //0 ûм⵽wifiģ, 1 ģ
	BYTE RtspPageEnable:1;           //ǷRTSPҳ濪 0ر, 1 
	BYTE FtpPageFlag:1;          //Ftpܱʶ1 д˹ܣ0Ϊû
	BYTE c32PasswordFlag:1;     // ʹóʶ1Ϊʹ32ֽڵ룬0Ϊʹ
	BYTE UrmetDevStatusFlag:1;   // ;UEMETͻ 豸״̬Ϣҳʾʶ	
	BYTE FileSystemFlag:1;       // ;0 ˼ϵͳ 1 ϵͳ
	BYTE KguardP2pUidFlag:1;      // 0 ʾUid, 1ʾUid
	BYTE EmailFlagSwitch:1;     // EmailScheduleFlag ʶλĿƿǷЧ1Ч0:Ч.
	
	BYTE EmailScheduleFlag:1;     // Ƿ¼ƻҳ棬0 1
	BYTE PtzHiddenFlag:1;	     // ǷPTZܣ 0 (), 1 (ر)
                                 // Ϊͬʱǰ豸汾3gܣû3g	
	BYTE c3GFlagSwitch:1;         // 3GFlag ʶλĿƿǷЧ1Ч0:Ч.
	BYTE c3GFlag:1;               // 0 3G, 1 3G 
	BYTE RecordTypeFlag:1;	 //ط¼ͱ־ 
	BYTE SystemIDCtrl:1;     // systemID 	
	BYTE FtpPcSendFlag:1;     // FtpץͼƬܱ־λ 0 ر  1 	
	BYTE CloudStorageFlag:1;  // ƴ洢0 ر 1  	
	
	BYTE AutoMaintenance:1;   //Զάҳأ0  1 
	BYTE CloudSGSerSwitch:4;  //  ƴ洢
	BYTE ShieldColorSetFlag:1; 
	BYTE IntelligentAnalysis:1;  // ܷҳ棬0 close 1 open
	BYTE RemoteUpgradeMode:1;   // 0: old Mode, 1: new Mode

	BYTE CloudeSGType:4;      // 0 dropbox and google 1: only dropbox 2: only google
	BYTE CloudeStorageMode:1; // 0:old param struct , 1: new param struct
	BYTE VBRFlag:1;
	BYTE RemoteFtpUpgradeSupport:1;  // 0:not support , 1: support to upgrade
	BYTE MainStreamMutex:1; 

	BYTE NewAapterQTParamFlag:1;  // Qt־λ
	BYTE PtzSupported:1;		  // only for nvr set IPC ptz param 
	BYTE PasswordSwitch:2;        //First bits for this function, Second for password switch
	BYTE NvrFlag:2;               //n1104:0,others:1
    BYTE MaintainUserEnabled:1;   //just in compatible with former version
    BYTE MdStreamFlag:1;         //Ȩ޿

	BYTE MaxPOENum;
    BYTE UiType;             //ui 1.0, 2.0, 3.0, 3.1
    BYTE ChipNum;            //豸оƬ
    UINT ProtocolType;       //ÿһλһЭ飬0֧֣1֧

    BYTE QueryRHMIFlag:1;    //ѯ¼Ӳ̡ƶ⡢IO״̬ʱlorex(flir)
    BYTE compatUpgrade:1;    //lorexͻ˼ͻȡ豸״̬
    BYTE supportMutiEmail:3; //Ƿֶ֧ʼ.0:1ʼ;1:3ʼ(lorex)
    BYTE showVersionFlag:1;  //Ƿʾ汾Ϣʾ(lorex).0:ʾ;1:ʾ
    BYTE honeyNewChName:1;   //honeywell OSDͨ,֧8(utf-8)
    BYTE pppoeFlag:1;        //0 PPPoE, 1 PPPoE
    BYTE maxChFps;           //ͨ֡.1:720P 15FPS; 2:1080P 15FPS;ĬΪ0
    WORD maxTotalFPS;        //ͨ֡ܺ
    BYTE hybirdDVRFlag:4;    //dvr־
    BYTE reserved:4;
    BYTE IPChNum;            //dvr IPCͨ
    BYTE reserved2[2];

    char p2pId[32];         //P2P Id(OWLֻ)
    BYTE reserver3[48];
}LoginRsp;
C_ASSERT(sizeof(LoginRsp) == 328);




//////////////////////////////////////////////////////////////////////////
//
// MsgType=MsgHeartbeat
//Ӧ 


//////////////////////////////////////////////////////////////////////////
//

//PackHead.Version
#define PackHeadV1		0
#define PackHeadV2      1

#define MaxPackSizeV1	1400
#define MaxPackSize		(1024*8)

//PackHead.Type
#define FramePack				0 //ֵ֡İ
#define ReposPack				1 //طʱضλ͵ضλ
#define NoDataPack				2 //طʱʾǰطʱѾû¼
#define FileEndPack				3 //¼ʱʾһļ

typedef struct
{
	BYTE Version : 2; //ͷ汾
	BYTE ExtSize : 6; //ͷչСʵչС = ExtSize * 4
	BYTE Type;
	WORD PackNum;
	UINT FrameNo;
	WORD PackNo; //0,1,2,3...
	WORD PackSize;
}PackHead; //ͷ, sizeof(PackHead) = 12


//////////////////////////////////////////////////////////////////////////
//Ԥ

//Type
#define PreviewMain	0
#define PreviewSub	1
#define PreviewMobile 2

//Content
#define PreviewComposite	0
#define PreviewVideoOnly	1

typedef struct
{
	UINT Channel; //ͨ 0,1,2,3...
	BYTE Type; //
	BYTE Content; //Ƶ
    BYTE timepos; //ȡ¼ʱ㣺0 ǰʱ 1 ¼ʱ
    BYTE bufsize; //֡ݴС,ʵʴС = bufsize*1024*10; 
}PreviewParam;


//////////////////////////////////////////////////////////////////////////
//TCPԤ
// MsgType=MsgTcpPreview, MsgSize=sizeof(TcpPreviewReq)
//Ӧ ɹAckFlag=AckSuccess ʧAckFlag=AckFail

typedef struct
{
	PreviewParam Param;
	UINT UserKey;
}TcpPreviewReq;


//////////////////////////////////////////////////////////////////////////
//UDP̽
// MsgType=MsgGetUdpAddr
//Ӧ MsgSize=size(GetUdpAddrRsp)

typedef struct
{
	struct sockaddr_in ClientAddr;
	UINT socketfd;
	BYTE Addr[44];
}GetUdpAddrRsp;


//////////////////////////////////////////////////////////////////////////
//UDPʼԤ
// MsgType=MsgStartUdpPreview, MsgSize=sizeof(UdpStartPreviewReq)
//Ӧ ɹAckFlag=AckSuccess, MsgSize=sizeof(UdpStartPreviewRsp) ʧAckFlag=AckFail

typedef struct
{
	GetUdpAddrRsp Rsp;
	PreviewParam Param;
}UdpStartPreviewReq;

typedef struct
{
	UINT UdpPreviewKey;
}UdpStartPreviewRsp;


//////////////////////////////////////////////////////////////////////////
//UDPֹͣԤ
// MsgType=MsgStopUdpPreview, MsgSize=sizeof(UdpStopPreviewReq)
//Ӧ 

typedef struct
{
	UINT UdpPreviewKey;
}UdpStopPreviewReq;


//////////////////////////////////////////////////////////////////////////
//ǿI֡
// MsgType=MsgForceIFrame, MsgSize=sizeof(PreviewParam)
//ҪӦ
typedef struct 
{       
	UINT Channel; //ͨ 0,1,2,3...
	BYTE Type;    //,ͬԤ
	BYTE Reserved[7];
} IFrameReq;

//////////////////////////////////////////////////////////////////////////
//̨
// MsgType=MsgPTZControl, MsgSubtype=MsgPTZUp..., MsgSize=sizeof(PTZControlReq)
//Ӧ ɹAckFlag=AckSuccess, ʧAckFlag=AckFail

#define PTZMinSpeed			0
#define PTZMaxSpeed			100
#define PTZMinCruiseNo		0
#define PTZMaxCruiseNo		63
#define PTZMinPresetIndex	1
#define PTZMaxPresetIndex	255

//Flag
#define PTZControlStart	0
#define PTZControlStop	1

typedef struct
{
	UINT Flag;
	UINT Speed;
}PTZControlNormal;

typedef struct
{
	UINT Flag;
	UINT No;
}PTZControlCruise;

typedef struct
{
	UINT Index;
}PTZControlPreset;

typedef struct
{
	UINT Channel;
	union
	{
		PTZControlNormal Normal; //MsgPTZUp...MsgPTZAutoScan
		PTZControlCruise Cruise; //MsgPTZCruise
		PTZControlPreset Preset; //MsgPTZSetPreset...MsgPTZCallPreset
	};
}PTZControlReq;

//////////////////////////////////////////////////////////////////////////
//ɫʿ
typedef struct
{
	UINT Channel;
	BYTE Chroma;       /* ɫ, <0 - 63> */
	BYTE Brightness;   /* , <0 - 63> */
	BYTE Contrast;     /* Աȶ, <0 - 63> */
	BYTE Saturation;   /* Ͷ, <0 - 63> */
	BYTE reservel[20];
}ColorCtrlReq;

//////////////////////////////////////////////////////////////////////////
//ʱṹ

typedef struct
{
	WORD Year; //2011
	BYTE Month; //1 ~ 12
	BYTE Day; //1 ~ 31
	BYTE Hour; //0 ~ 23
	BYTE Minute; //0 ~ 59
	BYTE Second; //0 ~ 59
	BYTE Reserved;
}DateTime;


//////////////////////////////////////////////////////////////////////////
//¼ѯ

//RecordType
//#define NormalRecord	0x1
//#define AlarmRecord		0x2
//#define AllRecord		0xFFFFFFFF //Only for req, equal to NormalRecord|AlarmRecord...

#define NoRecord      0x0
#define NormalRecord  0x1
#define AlarmRecord   0x2
#define MotionRecord  0x4
#define IORecord      0x8
#define PEARecord     0x10
#define AVDRecord     0x20
#define OSCRecord     0x40
#define AllIntelliRec 0x80
#define INE_ALL_RECORD	(PEARecord|AVDRecord|OSCRecord)
#define AllRecord     0xFFFFFFFF

typedef struct
{
	UINT Channel;
	DateTime Begin;
	DateTime End;
	UINT Type; //RecordType
}QueryRecordReq;

//ַʽѯ,Ӧʱ,ʱ¼,ҲӦسɹAckFlag=AckSuccess, MsgSize=0

// MsgType=MsgQueryRecord, MsgSubtype=MsgRecordDetail, MsgSize=sizeof(QueryRecordReq)
//Ӧ ɹAckFlag=AckSuccess, MsgSize=n*sizeof(RecordDetailRsp) ʧAckFlag=AckFail

typedef struct
{
	UINT StructSize; //sizeof(RecordDetailRsp)
	DateTime Begin;
	DateTime End;
	UINT Type; //RecordType
	UINT Size; //ļС
}RecordDetailRsp;

// MsgType=MsgQueryRecord, MsgSubtype=MsgRecordDayOutline, MsgSize=sizeof(QueryRecordReq)
//Ӧ ɹAckFlag=AckSuccess, MsgSize=n*sizeof(RecordDayOutlineRsp) ʧAckFlag=AckFail

typedef struct
{
	UINT StructSize; //sizeof(RecordDayOutlineRsp)
	WORD Year; //2011
	BYTE Month; //1 ~ 12
	BYTE Day; //1 ~ 31
	BYTE Hour; //0 ~ 23
	BYTE Minute; //0 ~ 59
	BYTE Second; //0 ~ 59
	BYTE Type;
}RecordDayOutlineRsp;

typedef struct
{
	UINT StructSize; //sizeof(RecordDayHalfHourRsp)
	WORD Year;       //2011
	BYTE Month;      //1 ~ 12
	BYTE Day;        //1 ~ 31
	BYTE HarfHour;   //0 ~ 47
	BYTE Minute;     //0 ~ 59
	BYTE Second;     //0 ~ 59
	BYTE Type;
}RecordDayHalfHourRsp;


//////////////////////////////////////////////////////////////////////////
//¼
// MsgType=MsgDownloadRecordFile, MsgSize=sizeof(DownloadRecordFileReq)+n*sizeof(RecordDetailRsp)
//Ӧ ɹAckFlag=AckSuccess ʧAckFlag=AckFail
//: file1,FileEndPack; file2,FileEndPack; ... filen,FileEndPack
typedef struct
{
	UINT StructSize; //sizeof(DownloadRecordFileReq)
	UINT UserKey;
	UINT Channel;
}DownloadRecordFileReq;


//////////////////////////////////////////////////////////////////////////
//¼ط

//ʼط
// MsgType=MsgRecordPlay, MsgSize=sizeof(RecordPlayReq)
//Ӧ ɹAckFlag=AckSuccess, ʧAckFlag=AckFail, Ӧ󲻷,ͳһյMsgRecordDataInsufficient

typedef struct
{
	UINT UserKey;
	UINT Channel;
	UINT Type; //RecordType
	DateTime Begin;
	DateTime End;
	BYTE ExactFrame[40]; //40 == sizeof(RSFrameHead)
}RecordPlayReq;

//طŷ
// MsgType=MsgRecordPlayFeedback, MsgSubType=MsgRecordDataInsufficient,MsgRecordDataEnough
//ҪӦ

//ضλ¼
// MsgType=MsgReposRecordData, MsgSize=sizeof(ReposRecordDataReq)
//ҪӦ,յϢ,ֹ֮ͣǰ(Ƿһİ֮),ŷReposPack,Ƿµ
typedef struct
{
	DateTime Begin;
	DateTime End;
}ReposRecordDataReq;

// ڽʱ,ᷢʹϢ
// MsgType=MsgHeartbeat
//ҪӦ


//////////////////////////////////////////////////////////////////////////
//Խ
// MsgType=MsgDualtalk, MsgSize=sizeof(DualtalkReq)
//Ӧ ɹAckFlag=AckSuccess ʧAckFlag=AckFail
typedef struct
{
	UINT UserKey;
}DualtalkReq;


//////////////////////////////////////////////////////////////////////////
//־ѯ

//LogType
#define LOG_TYPE_IO         0x0
#define LOG_TYPE_MD         0x1
#define LOG_TYPE_HDD        0x2
#define LOG_TYPE_VLOSS      0x3
#define LOG_TYPE_OPERA      0x4  // ѯʹ
#define LOG_TYPE_ALARM      0x5  // ѯʹ, iomdƵʧӲ     
#define LOG_TYPE_ALL        0x6  // ѯʹ, ȫ

//Operation type
#define LOG_OPT_FIRST  0x0
#define LOG_OPT_NEXT   0x1
#define LOG_OPT_PREV   0x2 
#define LOG_OPT_LAST   0x3
typedef struct
{   
    DateTime Begin;
    DateTime End;
    UINT Type; 
    UINT Operation;  // û:һʾ;һҳ;һҳ;һҳ
    UINT ExpectNum;  // ϣصĸ
}QueryLogReq;

/*DVRʹ*/
typedef struct
{
    UINT StructSize; //sizeof(QueryLogRsp)
    UINT Channel;
    UINT Type;
    DateTime Point;
    BYTE Reserved[4];
}QueryLogRsp;

/*IPCʹ*/
typedef struct
{
	UINT StructSize;
	char event[64];		///< event description
	BYTE Reserved[4];
}QueryLogRsp_IPC;

//////////////////////////////////////////////////////////////////////////
//

//Element : ElementSize + ExtensibleStruct + zero or more List
//List : ListSize + one or more Element
//ExtensibleStruct : StructSize + other member define
//ע: ElementٱһǿյExtensibleStructֻһStructSize=4Ľṹʾյ)ǿյListElementʾյģ壩Ӧɾȥ
//		ListٱһһElement

//Ӧ ɹAckFlag=AckSuccess ʧAckFlag=AckFail AckFlag=AckParamError, Ȩ޲AckFlag=AckAuthorityFail



typedef struct
{
	UINT StructSize;
	UINT ChannelMask;
}ChannelParamReq;

//////////////////////////////////////////////////////////////////////////
//澯ϱ
//ֱϱͻӦ
//
//MsgType=MsgAlarmReport
//ƶ: MsgSubType = MsgMotionAlarm, MsgSize = sizeof(MotionAlarmRpt)
//IO: 	MsgSubType = MsgIOAlarm, MsgSize = sizeof(MotionIORpt)
//ܷ: MsgSubType = MsgAIAlarm, MsgSize = sizeof(MotionAIRpt)

//Status
#define AlarmOn  1 
#define AlarmOff 0 

typedef struct
{
	UINT Channel;
	UINT Status;
	DateTime AlarmTime;
    char RecState;               /* ¼״̬ */
    char CurRecType;             /* ǰ¼ */
    char MDSchedule;             /* ƶƻ*/
	char MDRecEnable;           /* ǷMD¼ */
}MotionAlarmRpt;


typedef struct
{
	UINT Channel;
	UINT Status;
	DateTime AlarmTime;
    char RecState;               /* ¼״̬ */
    char CurRecType;             /* ǰ¼ */
    char AlarmSchedule;          /* IOƻ*/
	char Reserved[1];
}IOAlarmRpt;

typedef struct{
    short x1;
    short y1;
    short x2;
    short y2;
}Net_Rule_Line_S;

typedef struct
{
	UINT Channel;
	UINT Status;
	DateTime AlarmTime;
}IntelligentAlarmRpt;


/* ܽ */
typedef struct {

    BYTE ChnSwitch;          /*0-رգ1-*/
    BYTE RuleSwitch;         /*ÿͨһֽڱʾ80-رգ1-ʹ*/
    BYTE RuleType;           /*ÿͨһֽڱʾ8-ͣ0-ߣ1-ܽ*/
    BYTE LineTwoWay;         /*ÿͨһֽڱʾ8-˫0-1-˫*/
    BYTE reserver[4];
    Net_Rule_Line_S RuleLine[32];	/*ÿͨ64,32ߣǰֻʹõ1ߣ
                                 ܽ8ɱպͼ */
}SolePEALineMsg;

typedef struct
{
    SolePEALineMsg RuleLine[32];

}SolePEAAlarmRpt;


/* Ʒʧ*/
typedef struct{
    BYTE ChnSwitch;         		 /*0-رգ1-*/
    BYTE RuleSwitch;        	     /*ÿͨһֽڱʾ80-رգ1-ʹ*/
    BYTE reserve[6];
    BYTE RuleRectEnable[8];  	   /*ÿͨ8ÿ4.ÿһλһʹܣĿǰֻǰλ*/
    Net_Rule_Line_S RuleRect[32];	   /*ÿ4,ÿͨ8432*/
}SoleGoodsLostMsg;

typedef struct
{
    SoleGoodsLostMsg RuleLostLegacy[32];

}SoleGoodsLostAlarmRpt;

typedef struct
{
	UINT Channel;
	UINT Status;
	DateTime AlarmTime;
}AvdAlarmRpt;

typedef struct
{
	UINT Channel;
	UINT Status;
	DateTime AlarmTime;
}VLossAlarmRpt;


//MsgDevStatReport
//MsgNormalStatusReq
typedef struct
{
	UINT Channel;
	UINT Status;
	DateTime AlarmTime;
	
	UINT ProtocolType;
	UINT Abilities;
}DevStatRpt;

typedef struct
{
	UINT Channel;
	UINT Status;
	UINT AreaNum;
	UINT SensorNum; 
	DateTime AlarmTime;
}TelModuleAlarmRpt;


//AIType
#define AIPerimeterAlarm 0 //ܽ籨
#define AITripwireAlarm 1 //߱

typedef struct
{
	UINT Channel;
	UINT Status;
	UINT AIType;
	DateTime AlarmTime;
}AIAlarmRpt;

/*ͨʵʱܷ*/
#define MAX_AI_POS_COUNT  16
typedef struct  
{
	/*ͨ*/
	BYTE Channel;
	/**/
	BYTE RuleNo;
	/*ʹܿ*/
	BYTE RuleEnable;
	/*ͣ0-ߣ1-ܽ*/
	BYTE RuleType;
	/**/
	BYTE Direction;
	/*λ*/
	BYTE reservel[3];
	/*߻ֵ߽ܽʹǰĸԪż±Ϊx꣬±Ϊy*/
	unsigned short aiPoints[MAX_AI_POS_COUNT]; 
} AIDataRpt;

//MsgRecordStatusReport
//¼澯Ͷ
#define RECORDSTATUSTYPE_NORMAL      0 
#define RECORDSTATUSTYPE_MANUAL      1 
#define RECORDSTATUSTYPE_MOTION      2 
#define RECORDSTATUSTYPE_IO          3 
#define RECORDSTATUSTYPE_MOTION_IO   4  //ƶIO澯
#define RECORDSTATUSTYPE_MOTION_END  5  //ƶֹͣ  
#define RECORDSTATUSTYPE_IO_END      6  //IOֹͣ 
typedef struct
{
	UINT Type;  //
	DateTime AlarmTime;//ʱ
	
	UINT ChannelNum;     //Ӧ澯ͨ Ϊ0xffffffffΪͨ
	BYTE RecordStatus;   //¼״̬  1 ʼ¼ 0 ֹͣ¼
	BYTE reservel[3];
    UINT AllChanRecState;    //ͨ¼״̬	
}RecordStatusRpt;

typedef enum{
	RSNET_HDDSTATUS_NULL		= 0,
	RSNET_HDDSTATUS_OK			= 1,
	RSNET_HDDSTATUS_UNFORMAT	= 2,
	RSNET_HDDSTATUS_FERROR		= 3,
	RSNET_HDDSTATUS_FULL		= 4,
}RS_HDDSTATUS_E;

//MsgHddStatusReport
typedef struct
{
	
	BYTE HddStatus;	//Ӳ״̬ȡRS_HDDSTATUS_Eֵ
	BYTE reserve[3];
	char HddSN[32];		//̳к
	DateTime AlarmTime;	//ʱ
}HddStatusRpt;



//////////////////////////////////////////////////////////////////////////
//Ϊ˱ЭļĶԣGpsϢϸʱ
//ҲPuInfoHead_tGpsINfo_tRSFrame.hļп 
//RSInfo
#define RSPuInfoTag *(unsigned int*)"RSI"
#define RSPuInfoTypeGPS 'G'
#define RSPuInfoTypeRepos 'R'
#define RSPuInfoTypeEnd 'E'

typedef struct __PuInfoHeadRpt_t
{
	unsigned int Tag : 24;
	unsigned int Type : 8;
	unsigned int InfoSize;
	unsigned long long Time; //(microseconds) Time/1000,000 = the number of seconds after January 1, 1970 UTC
}PuInfoHeadRpt_t;

//pu_info_head_t.type = RSPuInfoTypeGPS, pu_info_head_t.info_size = sizeof(gps_info_t)
typedef struct __GpsInfoRpt_t
{
	double Longitude;
	double Latitude;
	float Speed;
	float SensorSpeed;          //ٶȣΪѡģ飬ֵܸЧ
	float Azimuth;    			// Ϊ0˳ʱ뷽 0~360
	int Signal3G;               //3Gź
	unsigned int TotalMileage;  //  г
	int Temperature;
	char LatitudeDir;       	// ϱ 'N' or 'S'
	char LongitudeDir;      	//  'E' or 'W'
	char Rectified;             // ǷѾ
	char Status;   				//״̬, 'A' ΪЧλ, 'V'ΪЧվ棬ǰҰϷǸ3š
	unsigned char IgnitionFlag; //־λ1:0Ϩ
	char Reserved[3];
	double LongitudeOffset;
	double LatitudeOffset;
}GpsInfoRpt_t;

//GPSϢϸṹ
//MsgGpsInfoReport
typedef struct 
{
	PuInfoHeadRpt_t stHeadRpt;
	GpsInfoRpt_t stBodyRpt;
	
	DateTime AlarmTime;
}GpsInfoPacketRpt;


//////////////////////////////////////////////////////////////////////////
//״̬

// MsgType=MsgStatusRequest, MsgSubtype	= MsgDevAllStatusReq; MsgSize=0
//Ӧ ɹAckFlag=AckSuccess, MsgSize=sizeof(DevAllStatusRpt) ʧAckFlag=AckFail

typedef enum {
	RECORD_STATUS_STOP_E = 0,
	RECORD_STATUS_NORMAL_E,
	RECORD_STATUS_MANUAL_E,   
	RECORD_STATUS_MOTION_E,
	RECORD_STATUS_IOALARM_E,
	RECORD_STATUS_MOTION_IO_E,
    RECORD_STATUS_MAX_E
}RS_RECORD_STATUS_E;

typedef struct
{
	DateTime AlarmTime;
	
	UINT RecordEnable;	//¼ʹܣλʾ, λΪͨ0
	UINT RecordStatus;	//¼״̬λʾ, λΪͨ0

	UINT MotionEnable;	//ƶʹܣλʾ, λΪͨ0
	UINT MotionStatus;	//ƶ״̬λʾ, λΪͨ0
	
	UINT IOEnable;		//IO澯ʹܣλʾ, λΪͨ0
	UINT IOStatus;		//IO澯״̬λʾ, λΪͨ0
	
	UINT VLossStatus;	//Ƶʧ״̬λʾ, λΪͨ0
	
	BYTE HddStatus[8];	//¼״̬ȡRS_HDDSTATUS_Eֵ
	BYTE HddSN[8][32];	//̳к
	
	//32ͨĲͬ¼״̬ıʶ, ȡ RS_RECORD_STATUS_E ֵ
	BYTE RecordAllStatus[32]; 
    BYTE FtpNewVersFlag;    //Ƿµļʶ:1 ;0 û, 2: 
                            //5: emergency(lorex ר),IEʾ
    BYTE reserve[7];
	BYTE IntelligentStatus[32];
}DevAllStatusRpt;

/* lorex httpҪݵԶ˵Ĳ 2014-10-13*/
typedef struct
{
    BYTE OldVersion[8];     //ɰ汾
    BYTE NewVersion[8];     //°汾
    BYTE model[16];         //豸ͺ
    BYTE message[256];      //ʾ
    BYTE reserved[32];
}HttpUpgsRemoteParam_S;

// MsgType=MsgStatusRequest, MsgSubtype	= MsgRemoteCHStatusReq; MsgSize=0
//Ӧ ɹAckFlag=AckSuccess, MsgSize=MAX_CHN_NUM * sizeof(RemoteChnStatusRpt) ʧAckFlag=AckFail

//MsgRemoteCHStatusReport
//MsgRemoteCHStatusReq
typedef struct
{
	unsigned long long DevType;  /* 豸 */
	char CurChnName[20];         /* 豸 */

	char CurChnState;            /* ǰͨ豸״̬ */
    char RecState;               /* ¼״̬ */
    char CurRecType;             /* ǰ¼ */
    char MDState;                /* Motion״̬ */

    char IOState;                /* IO״̬ */
    char VLossState;             /* Ƶʧ״̬ */
	char HddState;               /* Ӳ״̬ */
    char MDSchedule;             /* ƶƻ*/

    char AlarmSchedule;          /* ƻ*/
	
    unsigned char ChannelNum;		/*ǰ豸ӵеͨ*/
    char Reserever[2];
	
    UINT ProtocolType;/*ǰЭͣӦPROTO_TYPE_E*/
	UINT Abilities;   /*ÿһλһ0֧֣1֧֣ӦNet_ABILITY_TYPE_E*/
}DevChnInfo;
C_ASSERT(sizeof(DevChnInfo) == 48);

//MsgRemoteCHStatusReport
//MsgRemoteCHStatusReq
typedef struct
{
	int StructSize;
	char reser[4];
	DevChnInfo ChnInfo;
}RemoteChnStatusRpt;

// MsgFtpUpgradeAlarm 澯ظ
#define FTPUPGRADE_SUCCESS    0
#define FTPUPGRADE_UPGRADEING 1
#define FTPUPGRADE_PRE_REBOOT 2 
#define FTPUPGRADE_ERROR      3 

typedef struct {
	BYTE UpgradeProcess;  // ɽ 100 Ϊ	
	BYTE UpgradeStatus;    // ǰ״̬
	BYTE reserved[2];	
}FtpUpgradeRpt;



//////////////////////////////////////////////////////////////////////////
//澯
// MsgType=MsgAlarmSubscribe, MsgSubType=MsgAlarmDesired, MsgAlarmRefused
//Ӧ ɹAckFlag=AckSuccess ʧAckFlag=AckFail


//////////////////////////////////////////////////////////////////////////
//Զ

#ifdef _WIN32

#define UPGRADE_PACKET_MAGIC    0x08122515
#define SOFTWARE_VERSION_LEN    7
#define MAX_DEVICENAME_LEN 128

/**/
#define GEN_DVR16H  "DVR16H"
#define GEN_DVR16D1 "DVR16D1"
#define GEN_DVR8D1  "DVR8D1"
#define GEN_DVR4D1  "DVR4D1"
#define GEN_DVR16CIF	"DVR16C"
#define GEN_DVR8CIF "DVR08C"
#define GEN_DVR4CIF	"DVR04C"


typedef struct _upgradefileheaderentry_{
	/*ﶨİ汾ųǰַ־ģ
	潫ַ־ͬʱ4ֽڶ*/
	char version[(SOFTWARE_VERSION_LEN + 1 +  3) / 4 * 4]; 
	unsigned long start;/*ļڵƫ*/
	unsigned long len;/*ݵĳ*/
}upgradefileheaderentry_t;

typedef struct _upgradefileheader_{
	unsigned long magic;/*ṹ*/
	unsigned long crc;/*CRCֵǸýṹ򼰳ݵCRCУֵ*/
	unsigned short version;
	unsigned short Language_flag; /*1:CHINESE ONLY 0:MLANG */ 
	upgradefileheaderentry_t boot;
	upgradefileheaderentry_t kernel;
	upgradefileheaderentry_t rootfs;
	upgradefileheaderentry_t app;
	upgradefileheaderentry_t slave_boot;
	upgradefileheaderentry_t slave_kernel;
	upgradefileheaderentry_t slave_rootfs;
	upgradefileheaderentry_t logo;
}upgradefileheader_t;

typedef struct _upgradefileheaderEx_{
	unsigned long magic;
	unsigned long crc;
	unsigned short version;
	unsigned short Language_flag; /*1:CHINESE ONLY 0:MLANG */ 
	upgradefileheaderentry_t boot;
	upgradefileheaderentry_t kernel;
	upgradefileheaderentry_t rootfs;
	upgradefileheaderentry_t app;
	upgradefileheaderentry_t slave_boot;
	upgradefileheaderentry_t slave_kernel;
	upgradefileheaderentry_t slave_rootfs;
	upgradefileheaderentry_t logo;
	upgradefileheaderentry_t www;
}upgradefileheaderEx_t;

typedef struct _Newupgradefileheader_{
	unsigned long magic;/*ṹ*/
	unsigned long crc;/*CRCֵǸýṹ򼰳ݵCRCУֵ*/
	unsigned short version;/*ṹ汾*/
	unsigned short Language_flag; /*1:CHINESE ONLY 0:MLANG */ 
	upgradefileheaderentry_t boot;
	upgradefileheaderentry_t kernel;
	upgradefileheaderentry_t rootfs;
	upgradefileheaderentry_t app;
	upgradefileheaderentry_t slave_boot;
	upgradefileheaderentry_t slave_kernel;
	upgradefileheaderentry_t slave_rootfs;
	upgradefileheaderentry_t logo;
	upgradefileheaderentry_t www;
	upgradefileheaderentry_t fpga;
}Newupgradefileheader_t;

/******new upgrade    filetype = 3******/
typedef struct _upgradefileheaderentry_ex_
{
	/*ﶨİ汾ųǰַ־ģ
	 潫ַ־ͬʱ4ֽڶ*/
	char         version[(SOFTWARE_VERSION_LEN + 1 +  3) / 4 * 4];
	unsigned int bufStart;/*ļڵƫ*/
	unsigned int bufLen;/*ݵĳ*/
	unsigned int partname;  //ļƣbitmapʾ
	unsigned int partStart; //ļflashʼַ	
	unsigned int partLen; //ļflashĳ
    char         reserve[64]; //ֽ
}upgradefileheaderentry_ex_t;

typedef struct {
    unsigned int StructSize;
    char         DeviceType[MAX_DEVICENAME_LEN];
}RS_UpgradeExtInfo_t;

typedef struct _upgradefileheader_ex_
{
    unsigned int   upgradeTag; //ʶ־ǰİ
    unsigned int   crc;/*CRCֵǸýṹ򼰳ݵCRCУֵ*/
    unsigned short version;/*ṹ汾*/
    unsigned short Language_flag; /*1:CHINESE ONLY, 0 MLANG*/
    int            partnum;  //Ҫļ	
    char           aPacketPreFix[64];  //ļͷУ
    char           reserve[64]; //ֽ
}upgradefileheader_ex_t;

typedef struct {
    upgradefileheader_ex_t UpGradeHead;
    RS_UpgradeExtInfo_t    UpgradeExtInfo;
}RSMode_UpgradeFileHeader_EX_t;
/******end new upgrade******/

// MsgType=MsgRemoteUpgrade, MsgSize=sizeof(RS_UpgradeReq)
//Ӧ ɹAckFlag=AckSuccess, MsgSize=RS_UpgradeRsp ʧAckFlag=AckUpgrading,AckUpgradeVersionError,AckFail

#define OldMaxUpgradeFileHead 1024
#define MaxUpgradeFileHead 1024*5

typedef struct
{
	UINT UserKey;
	BYTE FileHead[MaxUpgradeFileHead];
}RS_UpgradeReq;

typedef struct 
{
	unsigned long UpgradeBitmap;
	unsigned long UpgradeFileSize;
}RSNewMode_UpradeRsp;

#define MaxUpgradeModules  32
typedef struct
{
	upgradefileheaderentry_t NeedUpgrade[MaxUpgradeModules];
}RS_UpgradeRsp;

//ݴ 
//MsgType=MsgRemoteUpgrade, MsgSubType=MsgRemoteUpgradeData,MsgSize=MaxUpgradeFileHead
#define MaxUpgradeDataSize	4096 //һģܻСMaxUpgradeDataSize

//һģ鴫
// MsgType=MsgRemoteUpgrade, MsgSubType=MsgRemoteUpgradePartEnd
//ҪӦ

//
// MsgType=MsgRemoteUpgrade,MsgSubType=MsgRemoteUpgradeEnd, MsgSize=sizeof(RemoteUpgradeEndCheck)
//Ӧ ɹAckFlag=AckSuccess, ʧAckFlag=AckFail ,MsgSize=sizeof(RemoteUpgradeEndWriteFlash)

typedef struct
{
	ULONG Crc;
}RemoteUpgradeEndCheck;

typedef struct
{
    BYTE WriteFlashFlag; //Ƿдflashʾ  1:   0: 
    BYTE reserved[3];
}RemoteUpgradeEndWriteFlash;

//Ӧ MsgType=MsgRemoteUpgrade,MsgSubType=MsgRemoteUpgradeWriteFlashInProgress, MsgSize=sizeof(WriteFlashProgress)  (0 < progress <= 100)
//Ӧ MsgType=MsgRemoteUpgrade,MsgSubType=MsgRemoteUpgradeWriteFlashEnd ʾ
typedef struct 
{
    unsigned char Progress;//ʾ
    char reserved[3];
}WriteFlashProgress;
#endif

//Email
typedef struct
{
	WORD Ssl;
	WORD Port;
	BYTE Server[MaxNameLen];
	BYTE Sender[MaxNameLen];  
	BYTE Receiver[MaxNameLen];
	BYTE Password[MaxNameLen];
    BYTE TestType;            //0: ͨ, 1: Kguard ʼ
    BYTE Reserved[15];
} EmailTestReq;

//DDNS
typedef struct
{
	BYTE Serveraddr;
	BYTE Hostname[MaxNameLen];
	BYTE Username[MaxNameLen];
	BYTE Password[MaxNameLen];
	BYTE Reserved[15];
} DDNSTestReq;

typedef struct
{
	int  RetVal;
	BYTE RetMsg[500];
} TestRsp;

//Ӳ̸ʽ
#define HDDFORMAT_SUCCESS            0
#define HDDFORMAT_FORMATTING         1 
#define HDDFORMAT_FAIL               2 
#define CANNOT_HDDFORMAT_RECDOWNLOAD 3
typedef struct
{
	UINT HddBitmap;
	UINT ChannelBitmap;	//ֻʽͨ
		
	BYTE Reserved[12];
} HddFormatReq;

typedef struct 
{
	BYTE HddNO;     // ʽ̺ 
	BYTE HddFormatProcess; //  ʽ  10ȡһθʽȣ״̬
	BYTE HddFormatStatue;  // ʽ״̬ 0-ʽɹ 1ڸʽ 2 ʽʧ

	 BYTE Reserved[13];
}HddFormatRsp;
//////////////////////////////////////////////////////////////////////////
//ʱͬ
#define MaxTimeZoneSize  10
typedef struct 
{   
    DateTime Time;
    char     TimeZone[MaxTimeZoneSize];
    char     Reserved[42];
}TimeSyncReq;

//////////////////////////////////////////////////////////////////////////
//Զץͼ
typedef struct 
{
	/*ע⣺ͼѹֱΪVGAʱ֧0=CIF, 1=QCIF, 2=D1ץͼ
	ֱΪ3=UXGA(1600x1200), 4=SVGA(800x600), 5=HD720p(1280x720),6=VGA,7=XVGA, 8=HD900p
	ֵ֧ǰֱʵץͼ*/
	UINT    StructSize;
	WORD	wPicSize;				/* 0=CIF, 1=QCIF, 2=D1 3=UXGA(1600x1200), 4=SVGA(800x600), 5=HD720p(1280x720),6=VGA*/
	WORD	wPicQuality;			/* ͼƬϵ 0- 1-Ϻ 2-һ */
} NET_DVR_JPEGPARA, *LPNET_DVR_JPEGPARA, JpegPara;

typedef struct 
{
	UINT StructSize; //sizeof(RemoteCaptureReq)
	UINT UserKey;  //User key
	UINT Channel;  //Channel No.
	JpegPara jpgPara;//Picture quality parameters
} RemoteCaptureReq;

typedef struct
{
	UINT picSize;
	BYTE Reserved[16];
} RemoteCaptureRsp;

///////////////////////////////////////////////////////////////////////////
//Snapt Report
//Request
typedef struct 
{
	UINT UserKey;
	WORD reserved1;
	WORD reserved2;
} SnaptReportReq;

typedef struct 
{
	DateTime snaptTime; 
	UINT     picSize;
}SnaptCommInfo;
//Motion Report
typedef struct
{
	SnaptCommInfo cmInfo;
	WORD          ch; //0,1,2
	WORD          reserved;
} SnaptMotionReport;

//////////////////////////////////////////////////////////////////////////
//Զ豸̬
//NVR

// MsgType=MsgDevNetCfg, MsgSubType=MsgNoSubType, MsgSize=sizeof(NetMDevInfoReq)
//Ӧ ɹAckFlag=AckSuccess, MsgSize=sizeof(NetMDevInfoRsp) ʧAckFlag=AckFail, MsgSize=sizeof(NetMDevInfoRsp);
#define MAX_UNAME_LEN 10
#define MAX_PWD_LEN   14

struct NetMDevInfoReq //
{
   BYTE msgid[16];  //message id
   BYTE user[MAX_UNAME_LEN]; //user name (for device's authority)
   BYTE pwd[MAX_PWD_LEN];    //password  (for device's authority)
   BYTE cip[4];     //current device ip
   
   BYTE ip[4];     //the device ip what the client wants to change into
   BYTE mask[4];   //the device net mask
   BYTE gw[4];      //the device default gateway
   BYTE dns1[4];    //DNS1
   BYTE dns2[4];    //DNS2
   WORD mport;      //media port   
   WORD wport;      //web port
   BYTE reserved[4];
};

// New NetMDevInfoReq, Ϊ˼ ɰ汾
struct NewNetMDevInfoReq //
{
	NetMDevInfoReq DevInfoReq;//ɰ汾ṹ  
	unsigned long long  devTypeULL;            
	BYTE macAddr[36];   //豸MACַ      
};

struct NetMDevInfoRsp //豸ظ
{
	BYTE msgid[16];  //󷽸msgid,豸ԭֵ
};


//////////////////////////////////////////////////////////////////////////
//ѯԶ豸״̬
//NVR

// MsgType=MsgSearchRemoteDev, MsgSubType=MsgNoSubType, MsgSize=sizeof(SearchRemDevReq)
//Ӧ ɹAckFlag=AckSuccess, MsgSize=n*sizeof(SearchRemDevRe) ʧAckFlag=AckFail, MsgSize=0;

typedef struct
{
	UINT UserKey;
}SearchRemDevReq;

typedef struct
{
    UINT StructSize;		//sizeof(SearchRemDevRe)
    BYTE IPAddr[4];			/*IPַ*/
    BYTE Netmask[4];
    BYTE GateWay[4];
    BYTE Dns1[4];
    BYTE Dns2[4];

    UINT Port;				/*ý˿*/
    UINT WebPort;

    BYTE DevType[8];
    char UserName[36];		/*½û*/
    char UserPW[36];		/*½û*/
    char DeviceName[36];	/*豸ƣ޸*/

    BYTE Protocol;		  //0:RS, 1:HiK, 2:DaH, 3:HH, 4:Onvif
    BYTE ChnMax;			/*ǰipӦǰ豸ͨ*/
    BYTE Version ;
    BYTE switchmode; /*0 Զģʽ 1 Զģʽ*/

    BYTE MacAddr[36];
    BYTE switchflag; /*1  0 ʾû*/
    BYTE portnum;    /* [0  -MAX_POE_NUM) */
    BYTE reserved[2];
	unsigned long long DevTypeULL;

	//onvifЭ飬ieԶϢ
	char hardware[36];
	char software[36];
	char devicetype[24];
	char manufacturer[36];
    BYTE reserved2[4];
}SearchRemDevRep;


//////////////////////////////////////////////////////////////////////////
//Զ豸
//NVR

// MsgType=MsgSetRemoteDevNet, MsgSubType=MsgNoSubType, MsgSize=n*sizeof(SetRemDevNetReq)
//Ӧ ɹAckFlag=AckSuccess, MsgSize=n*sizeof(SetRemDevNetRep) ʧAckFlag=AckFail, MsgSize=0;
typedef struct
{
	UINT StructSize;		//sizeof(SetRemDevNetRe)

	UINT UserKey;
	
	BYTE TargetIPAddr[4];			/*ĿIPַ*/
	UINT TargetPort;				/*Ŀý˿*/    
	
    /*IPַ*/
    BYTE IPAddr[4];
    /**/
    BYTE NetMask[4];
    /**/
    BYTE GateWay[4];
    /*ͻ˶˿ں*/
    UINT Port;
    /*Web˿ں*/
    UINT WebPort;
    /*DNS1*/
    BYTE Dns1[4];
    /*DNS2*/
    BYTE Dns2[4];
	
	char UserName[36];		/*޸Ĳ½û*/    
	char UserPW[36];		/*޸Ĳ½û*/    
	
	BYTE MacAddr[36];
	unsigned long long DevTypeULL;
	BYTE Version ;
	BYTE reserved[3];
}SetRemDevNetReq;

typedef struct
{
	UINT StructSize;		//sizeof(SetRemDevNetRep)
	UINT ErrCode;			//0ɹΪsdkش
}SetRemDevNetRep;


//////////////////////////////////////////////////////////////////////////
//Ƶ
// MsgType=MsgReqVideoActivation;MsgSize=sizeof(VideoActivationReq);Ϣ
//Ӧ ɹAckFlag=AckSuccess,MsgSize= 0  ʧ AckFlag=AckFail;
typedef struct
{
	UINT StructSize;
	UINT ChannelBitmap; 
}VideoActivationReq;

// ErrCode 
#define E_SUCCESS    0        /** < succeed > **/
#define E_FAILED     -1       /** < failed  > **/
#define E_CONTENT    -101     /** < content failed > **/
#define E_CONNECT    -102     /** < connect failed > **/
#define E_SEND       -103     /** < send faile > **/
#define E_RECV       -104     /** < recv faile > **/
typedef struct 
{
	char InfoFlag;  //жӲ֤ת· :0 ͻ· ,1 EmaliTest·ߣ
	char ErrCode;   //  
	char reserve[2];
	char RetMsgInfo[500];
}ActivateCloudRsp;

//FtpWriteFile
typedef struct
{
	BYTE FtpAddr[MaxNameLen];
	UINT FtpPort;
	BYTE Username[MaxNameLen];
	BYTE Password[MaxNameLen];
	BYTE CloudSGFtpTestFlag;
	BYTE Reserved[15];
} FtpWriteFileTestReq;

typedef struct
{
	char ddnsid[MaxNameLen];
	int ErrCode;
}GetDDNSIDRsp;

#pragma pack()

#endif
