// CalendarWnd.cpp : implementation file
//

#include "stdafx.h"
#include "CalendarWnd.h"
#include "..\RSDvrClient.h"
#include "..\LeftPlayBackBar.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCalendarWnd

IMPLEMENT_DYNAMIC(CCalendarWnd,CWnd)

static const int iRows = 6;
static const int iColumns = 7;

CCalendarWnd::CCalendarWnd()
{
	m_iTrackedButton = 0;
	m_iPressedButton = 0;
	m_bIsDropCalendar = FALSE;
	m_bMultipleSel = FALSE;
	m_bAbsoluteSel = FALSE;
	m_iStartMultiplySelection = -1;
	m_iLastMultiplySelection = -1;
	memset(m_DayRecState,0,sizeof(int)*31);

	SetValidInterval ((DATE) 0, (DATE) 0);
	m_Date = COleDateTime::GetCurrentTime ();

	m_clrBackColor = ::GetSysColor (COLOR_WINDOW);
	m_clrTextColor = ::GetSysColor (COLOR_WINDOWTEXT);
	m_clrSelBackColor = ::GetSysColor (COLOR_3DFACE);
	m_clrSelTextColor = ::GetSysColor (COLOR_BTNTEXT);
	m_clrLightColor = ::GetSysColor (COLOR_3DHILIGHT);
	m_clrShadowColor = ::GetSysColor (COLOR_3DDKSHADOW);
	m_clrTodayBackColor = ::GetSysColor (COLOR_INFOBK);
	m_clrTodayTextColor = ::GetSysColor (COLOR_INFOTEXT);
	m_clrRecdayTextColor = RGB(13,90,13);
	m_pDayfont = NULL;
	m_pDayfont = new CFont;
	m_pDayfont->CreatePointFont(100,"",NULL);

	TCHAR szLocaleData [100];
	::GetLocaleInfo (LOCALE_USER_DEFAULT, LOCALE_IFIRSTDAYOFWEEK, szLocaleData, 100);

	//-----------------------------------------------------------
	// m_iFirstDayOfWeek should be 0 - Sunday, 1 - Monday, ....:
	//-----------------------------------------------------------
	m_iFirstDayOfWeek = (szLocaleData [0] - _T('0') + 1) % 7;

	if (m_iFirstDayOfWeek < 0 || m_iFirstDayOfWeek >= 7)
	{
		ASSERT (FALSE);
		m_iFirstDayOfWeek = 1;
	}
}
//****************************************************************************************
CCalendarWnd::~CCalendarWnd()
{
	SAFE_DELETE(m_pDayfont);
}

BEGIN_MESSAGE_MAP(CCalendarWnd, CWnd)
	//{{AFX_MSG_MAP(CCalendarWnd)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_PAINT()
	ON_WM_ERASEBKGND()
	ON_WM_KEYDOWN()
	ON_WM_CREATE()
	ON_WM_KILLFOCUS()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCalendarWnd message handlers

void CCalendarWnd::OnLButtonDown(UINT nFlags, CPoint point) 
{
	ASSERT (m_pParent != NULL);

//	SetFocus ();

	CRect rectClient;
	GetClientRect (rectClient);

	if (!rectClient.PtInRect (point))
	{
		ReleaseCapture ();
		HideDropCalendar ();
		return;
	}

	m_iTrackedButton = m_iPressedButton = HitTest (point);

	int iStartMultiplySelection = m_iTrackedButton;
	int iLastMultiplySelection = m_iTrackedButton;

	if ((nFlags & MK_SHIFT) != 0)	// Shift is hold
	{
		iStartMultiplySelection = 0;
		for (int iDay = m_iTrackedButton - 1; iDay > 1; iDay --)
		{
			if (IsDaySelected (iDay))
			{
				iStartMultiplySelection = iDay;
				break;
			}
		}

		if (iStartMultiplySelection == 0)
		{
			iStartMultiplySelection = m_iTrackedButton;

			iLastMultiplySelection = 0;
			for (int iDay = m_iTrackedButton + 1; iDay <= m_iDaysInMonth; iDay ++)
			{
				if (IsDaySelected (iDay))
				{
					iLastMultiplySelection = iDay;
					break;
				}
			}

			if (iLastMultiplySelection == 0)
			{
				iLastMultiplySelection = m_iTrackedButton;
			}
			else
			{
				while (IsDaySelected (++iLastMultiplySelection));
				iLastMultiplySelection --;
			}
		}
		else
		{
			while (IsDaySelected (--iStartMultiplySelection));
			iStartMultiplySelection ++;
		}

		ClearSelectedDays ();

	}
	else if ((nFlags & MK_CONTROL) == 0)	// Ctrl is released
	{
		ClearSelectedDays ();
	}

	CRect rect;
	if (GetButtonRect (m_iTrackedButton, rect))
	{
		rect.InflateRect (3, 3);
		InvalidateRect (rect);
		HCURSOR m_Cursor = AfxGetApp()->LoadCursor(IDC_CURSOR_LMDOWN);
		::SetCursor(m_Cursor);
	}

	if (m_bMultipleSel)
	{	
		if ((nFlags & MK_SHIFT) != 0)
		{
			m_iStartMultiplySelection = iStartMultiplySelection;
			m_iLastMultiplySelection = iLastMultiplySelection;
			AddSelectedDay (m_iStartMultiplySelection);
		}
		else
		{
			m_iStartMultiplySelection = -1;
			m_iLastMultiplySelection = -1;
		}

		OnMouseMove (nFlags, point);
	}

	UpdateWindow ();

	CWnd::OnLButtonDown (nFlags, point);
}
//****************************************************************************************
void CCalendarWnd::OnLButtonUp(UINT nFlags, CPoint point) 
{
	ReleaseCapture();

	m_iStartMultiplySelection = -1;
	m_iLastMultiplySelection = -1;

	m_iTrackedButton = HitTest (point);

	if (m_iTrackedButton == m_iPressedButton &&
		m_iTrackedButton > 0)
	{
		COleDateTime date (
			m_Date.GetYear (),
			m_Date.GetMonth (),
			m_iTrackedButton,
			m_Date.GetHour (),
			m_Date.GetMinute (),
			0);
		
		if (HideDropCalendar (&date))
		{
			return;
		}

		if (m_bMultipleSel)
		{
			if (nFlags & MK_CONTROL)
			{
				if (IsDaySelected (m_iTrackedButton))
				{
					RemoveSelectedDay (m_iTrackedButton);
				}
				else
				{
					AddSelectedDay (m_iTrackedButton);
				}
			}
			else
			{
				AddSelectedDay (m_iTrackedButton);
			}

			if (m_Date != date)
			{
				m_Date = date;
				OnDateChanged();
			}
			HCURSOR m_Cursor = AfxGetApp()->LoadCursor(IDC_CURSOR_LMUP);
			::SetCursor(m_Cursor);
		}
		else
		{
			if (m_Date != date)
			{
				for (int i = 0; i < 2; i ++)
				{
					CRect rect = m_rectDayLocations [m_Date.GetDay () - 1];
					rect.InflateRect (3, 3);
					InvalidateRect (rect);

					m_Date = date;
				}

				OnDateChanged();
			}
		}
	}

	int iRedraw1 = m_iPressedButton;
	int iRedraw2 = m_iTrackedButton;

	m_iPressedButton = 0;
	m_iTrackedButton = 0;

	if (iRedraw1 > 0)
	{
		InvalidateRect (m_rectDayLocations [iRedraw1 - 1]);
	}

	if (iRedraw2 > 0)
	{
		InvalidateRect (m_rectDayLocations [iRedraw2 - 1]);
	}

	UpdateWindow ();
	CWnd::OnLButtonUp (nFlags, point);
}
//****************************************************************************************
void CCalendarWnd::OnMouseMove(UINT nFlags, CPoint point) 
{
	int iPrevTrackButton = m_iTrackedButton;
	m_iTrackedButton = HitTest (point);

	if (m_bMultipleSel &&
		(nFlags & MK_SHIFT) && (nFlags & MK_LBUTTON) &&
		m_iStartMultiplySelection != -1 && m_iTrackedButton > 0 &&
		m_iStartMultiplySelection != m_iTrackedButton)
	{
		int iDay;
		int iDay1 = (m_iTrackedButton > m_iStartMultiplySelection) ? 
					m_iStartMultiplySelection : m_iTrackedButton;
		int iDay2 = (m_iTrackedButton > m_iStartMultiplySelection) ? 
					m_iTrackedButton : m_iStartMultiplySelection;

		if (m_iLastMultiplySelection > m_iTrackedButton)
		{
			for (iDay = m_iTrackedButton + 1; iDay <= m_iLastMultiplySelection; iDay ++)
			{
				RemoveSelectedDay (iDay);
			}
		}

		for (iDay = iDay1; iDay <= iDay2; iDay ++)
		{
			AddSelectedDay (iDay);
		}

		m_iLastMultiplySelection = m_iTrackedButton;
		m_iPressedButton = 0;
	}

	if (m_iTrackedButton != iPrevTrackButton)
	{
		CRect rect;
		
		if (m_iPressedButton == 0 ||
			iPrevTrackButton == m_iPressedButton)
		{
			if (GetButtonRect (iPrevTrackButton, rect))
			{
				rect.InflateRect (3, 3);
				InvalidateRect (rect);
			}
		}

		if (m_iPressedButton == 0 ||
			m_iTrackedButton == m_iPressedButton)
		{
			if (GetButtonRect (m_iTrackedButton, rect))
			{
				rect.InflateRect (3, 3);
				InvalidateRect (rect);
			}
		}

		if (m_iTrackedButton != 0)
		{
			if (iPrevTrackButton == 0)
			{
				SetCapture ();
			}
		}
		else
		{
			if (m_iPressedButton == 0)
			{
				ReleaseCapture ();
			}
		}
		HCURSOR m_Cursor = AfxGetApp()->LoadCursor(IDC_CURSOR_LMUP);
		::SetCursor(m_Cursor);
	}

	UpdateWindow ();
	CWnd::OnMouseMove (nFlags, point);
}
//****************************************************************************************
void CCalendarWnd::OnPaint() 
{
	ASSERT (m_pParent != NULL);
	CPaintDC dcPaint (this); // device context for painting

	CRect rectClient;
	GetClientRect (&rectClient);

	//-------------------------------------------------------------------	
	// If possible, we paint to a off-screen DC and BitBlt the results to
	// the screen (reduces flicker).
	//-------------------------------------------------------------------
	CDC*		pDC = &dcPaint;
	BOOL		m_bMemDC = FALSE;
	CDC			dcMem;
	CBitmap		bmp;
	CBitmap*	pOldBmp = NULL;

	if (dcMem.CreateCompatibleDC (&dcPaint) &&
		bmp.CreateCompatibleBitmap (&dcPaint, rectClient.Width (),
								  rectClient.Height ()))
	{
		//-------------------------------------------------------------
		// Off-screen DC successfully created. Better paint to it then!
		//-------------------------------------------------------------
		m_bMemDC = TRUE;
		pOldBmp = dcMem.SelectObject (&bmp);
		pDC = &dcMem;
	}

	pDC->SetBkMode (TRANSPARENT);
//	CFont* pOldFont = (CFont*) pDC->SelectStockObject (DEFAULT_GUI_FONT);
	CFont* pOldFont = (CFont*) pDC->SelectObject(m_pDayfont);
	//-----------------
	// Fill background:
	//-----------------
	pDC->FillSolidRect (&rectClient, m_clrBackColor);

	//------------------------------------
	// Draw 3-d border around the control:
	//------------------------------------
	if (m_bIsDropCalendar)
	{
		pDC->Draw3dRect (	&rectClient,
						::GetSysColor (COLOR_3DHILIGHT),
						::GetSysColor (COLOR_3DDKSHADOW));
		
		rectClient.InflateRect (-1, -1);
		pDC->Draw3dRect (	&rectClient,
						::GetSysColor (COLOR_3DHILIGHT),
						::GetSysColor (COLOR_3DSHADOW));
	}
	else
	{
		pDC->Draw3dRect (	&rectClient, 
						::GetSysColor (COLOR_3DDKSHADOW),
						::GetSysColor (COLOR_3DHILIGHT));
		
		rectClient.InflateRect (-1, -1);
		pDC->Draw3dRect (	&rectClient,
						::GetSysColor (COLOR_3DSHADOW),
						::GetSysColor (COLOR_3DLIGHT));
	}

	//----------------------------
	// Get first day of the month:
	//----------------------------
	COleDateTimeSpan day (1, 0, 0, 0);
	COleDateTime dateCurr = m_Date;
	while (dateCurr.GetDay () > 1)
	{
		dateCurr -= day;
	}

	//-----------
	// Draw days:
	//-----------

	COleDateTime today = COleDateTime::GetCurrentTime ();

	for (int iDay = 1; iDay <= m_iDaysInMonth; iDay ++)
	{
		BOOL bIsDayHasRec = m_DayRecState[iDay-1];
		CRect rt;
		if (bIsDayHasRec)
		{
			GetButtonRect (iDay, rt);
			pDC->Draw3dRect (rt, m_clrShadowColor, m_clrLightColor);
			rt.InflateRect(-1,-1);
			pDC->FillSolidRect (rt, m_clrRecdayTextColor);
			pDC->SetTextColor (m_clrTextColor);
		}
		else
		{
			pDC->SetTextColor (m_clrTextColor);
		}
		CString strDay;
		strDay.Format (_T ("%d"), iDay);

		BOOL bIsSelectedDay = IsDaySelected (iDay);
		BOOL bIsDayMarked = (m_MarkedDays.Find (iDay) != NULL);

		BOOL bIsToday = (iDay == today.GetDay () &&
							m_Date.GetMonth () == today.GetMonth () &&
							m_Date.GetYear () == today.GetYear ());

		COleDateTime date (m_Date.GetYear (), m_Date.GetMonth (), iDay, 0, 0, 0);
		BOOL bIsIllegalDay = !IsDateValid (date);
		BOOL bHighlight = FALSE;

		CRect rect;
		if (GetButtonRect (iDay, rect) && dcPaint.RectVisible (rect))
		{
			if (bIsSelectedDay)
			{
				CRect rectSelect = rect;

				pDC->FillSolidRect (rectSelect, m_clrSelBackColor);
				if (bIsDayHasRec)
				{
					pDC->SetTextColor (m_clrRecdayTextColor);
				}
				else
				{
					pDC->SetTextColor (m_clrSelTextColor);
				}
				

				if (!m_bMultipleSel)
				{
					bHighlight = TRUE;
				}
				else
				{
					CPen penDark (PS_SOLID, 1, m_clrShadowColor);
					CPen* pOldPen = (CPen*) pDC->SelectObject (&penDark);

					if (!IsLeftSelected (iDay))
					{
						pDC->MoveTo (rect.left, rect.top);
						pDC->LineTo (rect.left, rect.bottom);
					}

					if (!IsTopSelected (iDay))
					{
						pDC->MoveTo (rect.left, rect.top);
						pDC->LineTo (rect.right, rect.top);
					}

					CPen penLight (PS_SOLID, 1, m_clrLightColor);
					pDC->SelectObject (&penLight);

					if (!IsRightSelected (iDay))
					{
						pDC->MoveTo (rect.right, rect.top);
						pDC->LineTo (rect.right, rect.bottom);
					}

					if (!IsBottomSelected (iDay))
					{
						pDC->MoveTo (rect.left, rect.bottom - 1);
						pDC->LineTo (rect.right, rect.bottom -  1);
					}

					pDC->SelectObject (pOldPen);
				}
			}
			else if (bIsToday)
			{
				pDC->FillSolidRect (rect, m_clrTodayBackColor);		
				if (bIsDayHasRec)
				{
					pDC->Draw3dRect (rect, m_clrShadowColor, m_clrLightColor);
					rect.InflateRect(-1,-1);
					pDC->FillSolidRect (rect, m_clrRecdayTextColor);
					pDC->SetTextColor (m_clrTextColor);
				}
				else
				{
					pDC->SetTextColor (m_clrTodayTextColor);
				}

				bHighlight = TRUE;
			}

			if (bIsIllegalDay)
			{
				pDC->SetTextColor (::GetSysColor (COLOR_GRAYTEXT));
			}

			
			CFont* pFonfCurr = NULL;
			if (bIsDayMarked)
			{
				pFonfCurr = pDC->SelectObject (&m_fntBold);
			}

			pDC->DrawText (strDay, rect, DT_SINGLELINE | DT_VCENTER | DT_CENTER);

			if (pFonfCurr != NULL)
			{
				pDC->SelectObject (pFonfCurr);
			}

			if (bIsSelectedDay || bIsIllegalDay || bIsToday)	// Restore default color
			{
				pDC->SetTextColor (m_clrTextColor);
			}

			//---------------------
			// Define button state:
			//---------------------
			BUTTON_STATE btnState = FLAT;

			if (iDay == m_iPressedButton)
			{
				if (iDay == m_iTrackedButton)
				{
					btnState = PRESSED;
				}
				else
				{
					btnState = HILIGHT;
				}
			}
			else if (iDay == m_iTrackedButton && m_iPressedButton == 0)
			{
				btnState = HILIGHT;
			}
			else if (bIsToday || bHighlight)
			{
				btnState = PRESSED;
			}

			//------------------------------------
			// Draw 3-d border around of the cell:
			//------------------------------------
			switch (btnState)
			{
			case PRESSED:
				pDC->Draw3dRect (rect, m_clrShadowColor, m_clrLightColor);
				rect.OffsetRect (1, 1);
				break;

			case HILIGHT:
				pDC->Draw3dRect (rect, m_clrLightColor, m_clrShadowColor);
				break;
			}
		}
	}

	pDC->SelectObject (pOldFont);

	if (m_bMemDC)
	{
		//--------------------------------------
		// Copy the results to the on-screen DC:
		//-------------------------------------- 
		CRect rect;
		dcPaint.GetClipBox (rect);
		dcPaint.BitBlt (rect.left, rect.top, rect.Width(), rect.Height(),
					   &dcMem, rect.left, rect.top, SRCCOPY);

		dcMem.SelectObject(pOldBmp);
	}
}
//****************************************************************************************
BOOL CCalendarWnd::OnEraseBkgnd(CDC* pDC) 
{
	return TRUE;
}
//****************************************************************************************
void CCalendarWnd::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	ASSERT (m_pParent != NULL);

	if (nChar == VK_ESCAPE)
	{
		ReleaseCapture ();
		HideDropCalendar ();
	}
}
//****************************************************************************************
int CCalendarWnd::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	//----------------
	// Create toolbar:
	//----------------
	CRect rectToolbar (0, 0, 0, 0);
	if (!m_wndToolbar.Create (rectToolbar, this, 1))
	{
		TRACE (_T ("CCalendarWnd: Can't create toolbar!\n"));
		return -1;
	}

	UpdateColors ();

	//----------------
	// Create caption:
	//----------------
	CRect rectCaption (0, 0, 0, 0);
	if (!m_wndCaption.Create (rectCaption, this, 2))
	{
		TRACE (_T ("CCalendarWnd: Can't create caption window!\n"));
		return -1;
	}

	m_wndCaption.m_bEnabled = m_bMultipleSel;
	m_wndCaption.m_iFirstDayOfWeek = m_iFirstDayOfWeek;

	//------------------------------------
	// Create bold font (for marked days):
	//------------------------------------
	CFont* pFontDefault = CFont::FromHandle ((HFONT) ::GetStockObject (DEFAULT_GUI_FONT));
	ASSERT (pFontDefault != NULL);

	LOGFONT lf;
	pFontDefault->GetLogFont (&lf);
	lf.lfWeight = FW_EXTRABOLD;
	lf.lfUnderline = TRUE;

	m_fntBold.CreateFontIndirect (&lf);

	//-------------------------
	// Calculate calendar size:
	//-------------------------
	CRect rectClient;
	GetClientRect (&rectClient);

	CClientDC dc (this);
	CFont* pOldFont = (CFont*) dc.SelectStockObject (DEFAULT_GUI_FONT);

	TEXTMETRIC tm;
	dc.GetTextMetrics (&tm);

	int iTextHeight = tm.tmHeight * 3 / 2;
	int iColumnWidth = tm.tmMaxCharWidth * 2;

	m_iTitleHeight = iTextHeight * 2;

	int iWndHeight =	m_iTitleHeight + 
						m_wndToolbar.GetHeight () +
						iTextHeight * (iRows + 1);

	int iWndWidth = iColumnWidth * (iColumns + 1);

	SetWindowPos (	NULL, -1, -1,
						iWndWidth, iWndHeight,
						SWP_NOMOVE | SWP_NOZORDER);

	m_iDaysInMonth = GetDaysInMonth (
						m_Date.GetMonth (),
						m_Date.GetYear ());
	RebuildLocations ();
	dc.SelectObject (pOldFont);

	return 0;
}
//****************************************************************************************
BOOL CCalendarWnd::Create(DWORD dwStyle, int x, int y, CWnd* pParentWnd)
{
	static CString strClassName;

	if (strClassName.IsEmpty ())
	{
		strClassName = AfxRegisterWndClass (0, AfxGetApp()->LoadStandardCursor(IDC_ARROW));
	}

	m_pParent = pParentWnd;
	ASSERT (m_pParent);
	ASSERT (m_pParent->GetSafeHwnd () != NULL);

	m_bIsDropCalendar = (dwStyle & WS_POPUP);
	return CWnd::CreateEx (m_bIsDropCalendar ? WS_EX_PALETTEWINDOW : 0, 
							strClassName, _T (""),
							dwStyle, 
							x, y,
							100, 100, 
							m_bIsDropCalendar ? NULL : pParentWnd->GetSafeHwnd (),
							NULL);
}
//****************************************************************************************
int CCalendarWnd::HitTest (POINT point) const
{
	for (int iDay = 1; iDay <= m_iDaysInMonth; iDay ++)
	{
		COleDateTime date (m_Date.GetYear (), m_Date.GetMonth (), iDay, 0, 0, 0);

		CRect rect;
		if (IsDateValid (date) && GetButtonRect (iDay, rect) && 
			rect.PtInRect (point))
		{
			return iDay;
		}
	}

	return 0;
}
//****************************************************************************************
BOOL CCalendarWnd::GetButtonRect (int iID, CRect& rect) const
{
	if (iID < 1 || iID > m_iDaysInMonth)
	{
		return FALSE;
	}

	rect = m_rectDayLocations [iID - 1];
	return TRUE;
}
//****************************************************************************************
void CCalendarWnd::RebuildLocations ()
{
	// Get first day of the month:
	COleDateTime dateCurr (m_Date.GetYear (), m_Date.GetMonth (), 1, 0, 0, 0);
	COleDateTimeSpan day (1, 0, 0, 0);

	int y = m_rectDays.top;

	int iRowHeight = m_rectDays.Height () / iRows;
	int iColumnWidth = m_rectDays.Width () / iColumns;

	while (dateCurr.GetMonth () == m_Date.GetMonth ())
	{
		int iWeekDay = dateCurr.GetDayOfWeek () - m_iFirstDayOfWeek;
		if (iWeekDay < 1)
		{
			iWeekDay += 7;
		}

		int iDay = dateCurr.GetDay ();
		
		int x = m_rectDays.left + iColumnWidth * (iWeekDay - 1);

		m_rectDayLocations [iDay - 1] = 
			CRect (x, y, x + iColumnWidth, y + iRowHeight);

		if (iWeekDay == 7)
		{
			y += iRowHeight;
			x = m_rectDays.left;
		}
		else
		{
			x += iColumnWidth;
		}

		dateCurr += day;
	}
}
//****************************************************************************************
void CCalendarWnd::OnKillFocus(CWnd* pNewWnd) 
{
	ASSERT (m_pParent != NULL);
	ReleaseCapture ();

	CRect rect;
	if (GetButtonRect (m_iTrackedButton, rect))
	{
		rect.InflateRect (3, 3);
		InvalidateRect (rect);
	}

	m_iStartMultiplySelection = -1;
	m_iLastMultiplySelection = -1;
	m_iPressedButton = 0;
	m_iTrackedButton = 0;

	HideDropCalendar ();
}
//****************************************************************************************
BOOL CCalendarWnd::HideDropCalendar (const COleDateTime* pDateNew)
{
	if (!m_bIsDropCalendar)
	{
		return FALSE;
	}

// 	ASSERT (m_pParent != NULL);
// 	if (m_pParent->IsKindOf (RUNTIME_CLASS (CBCGDateTimeCtrl)))
// 	{
// 		CBCGDateTimeCtrl* pDTWnd = (CBCGDateTimeCtrl*) m_pParent;
// 		pDTWnd->HideDropCalendar (pDateNew);
// 
// 		return TRUE;
// 	}

	return FALSE;
}
//*****************************************************************************************
BOOL CCalendarWnd::IsDateValid (const COleDateTime& date) const
{
	if (date.GetStatus () == COleDateTime::invalid)
	{
		return FALSE;
	}

	COleDateTime dateEmpty;

	if (m_MinDate != dateEmpty && date < m_MinDate)
	{
		return FALSE;
	}

	if (m_MaxDate != dateEmpty && date > m_MaxDate)
	{
		return FALSE;
	}

	return TRUE;
}
//****************************************************************************************
void CCalendarWnd::SetValidInterval (const COleDateTime& from, const COleDateTime& to)
{
	m_MinDate = from;
	m_MaxDate = to;

	COleDateTime minAllowedDate (1990, 1, 1, 0, 0, 0);
	COleDateTime maxAllowedDate (2090, 12, 31, 23, 59, 59);
	COleDateTime emptyDate;

	m_MinDate = max (m_MinDate, minAllowedDate);

	if (m_MaxDate != emptyDate)
	{
		m_MaxDate = min (m_MaxDate, maxAllowedDate);
	}
	else
	{
		m_MaxDate = maxAllowedDate;
	}

	if (m_hWnd != NULL)
	{
		Invalidate ();
	}
}
//****************************************************************************************
BOOL CCalendarWnd::SetDate (const COleDateTime& date)
{
	if (!IsDateValid (date))
	{
		return FALSE;
	}

	COleDateTime oldDate = m_Date;

	BOOL bIsMonthChanged = (m_Date.GetMonth () != date.GetMonth () ||
		m_Date.GetYear () != date.GetYear ());

	m_Date = date;
	m_iDaysInMonth = GetDaysInMonth (
						m_Date.GetMonth (),
						m_Date.GetYear ());


	AlignSelectedDays (oldDate);
	RebuildLocations ();

	//---------------------
	// Redraw days + title:
	//---------------------
	m_wndCaption.SetDate (m_Date);

	if (m_hWnd != NULL)
	{
		InvalidateRect (m_rectDays);
		UpdateWindow ();
	}

// 	if (bIsMonthChanged && m_hWnd != NULL)
// 	{
// 		CBCGCalendarCtrl* pParent = (CBCGCalendarCtrl*) GetParent ();
// 		if (pParent != NULL && pParent->IsKindOf (RUNTIME_CLASS (CBCGCalendarCtrl)))
// 		{
// 			pParent->FireOnMonthChanged ();
// 		}
// 	}

	OnDateChanged ();
	return TRUE;
}
//****************************************************************************************
const COleDateTime& CCalendarWnd::GetDate () const
{
	return m_Date;
}
//****************************************************************************************
void CCalendarWnd::OnSize(UINT nType, int cx, int cy) 
{
	CWnd::OnSize(nType, cx, cy);

	//----------------------------
	// Adjust toolbar and caption:
	//----------------------------
	m_wndToolbar.AlignInParentClientArea ();

	m_wndCaption.SetWindowPos (NULL, 2, 2, cx - 4, m_iTitleHeight, SWP_NOZORDER);
	
	CRect rectToolbar;
	m_wndToolbar.GetClientRect (&rectToolbar);

	//----------------------------
	// Define days area rectangle:
	//----------------------------
	m_rectDays = CRect (10, m_iTitleHeight + 5, 
						cx - 10, cy - rectToolbar.Height () - 5);

	RebuildLocations ();
}
//****************************************************************************************
void CCalendarWnd::ClearSelectedDays ()
{
	while (!m_SelectedDays.IsEmpty ())
	{
		int iDay = m_SelectedDays.RemoveHead ();
		ASSERT (iDay >= 1 && iDay <= 31);

		CRect rect = m_rectDayLocations [iDay - 1];
		rect.InflateRect (3, 3);
		InvalidateRect (rect);
	}

	UpdateWindow ();
	OnSelectionChanged ();
}
//****************************************************************************************
void CCalendarWnd::AddSelectedDay (int iDay)
{
	ASSERT (iDay >= 1 && iDay <= 31);

	BOOL bInserted = FALSE;

	for (POSITION pos = m_SelectedDays.GetHeadPosition (); pos != NULL;)
	{
		POSITION posSave = pos;
		int iSelDay = m_SelectedDays.GetNext (pos);

		if (iSelDay == iDay)	// Already in list,
		{						// do norhing!
			return;
		}

		if (iSelDay > iDay)
		{
			m_SelectedDays.InsertBefore (posSave, iDay);
			bInserted = TRUE;
			break;
		}
	}

	if (!bInserted)
	{
		m_SelectedDays.AddTail (iDay);
	}

	CRect rect = m_rectDayLocations [iDay - 1];
	rect.InflateRect (3, 3);
	InvalidateRect (rect);

	OnSelectionChanged ();
}
//****************************************************************************************
void CCalendarWnd::RemoveSelectedDay (int iDay)
{
	ASSERT (iDay >= 1 && iDay <= 31);

	for (POSITION pos = m_SelectedDays.GetHeadPosition (); pos != NULL;)
	{
		POSITION posSave = pos;
		if (m_SelectedDays.GetNext (pos) == iDay)
		{
			m_SelectedDays.RemoveAt (posSave);

			CRect rect = m_rectDayLocations [iDay - 1];
			rect.InflateRect (3, 3);
			InvalidateRect (rect);
			return;
		}
	}

	OnSelectionChanged ();
}
//****************************************************************************************
BOOL CCalendarWnd::IsDaySelected (int iDay) const
{
	if (iDay < 1 && iDay > m_iDaysInMonth)
	{
		return FALSE;
	}

	if (!m_bMultipleSel)
	{
		return (iDay == m_Date.GetDay ());
	}

	for (POSITION pos = m_SelectedDays.GetHeadPosition (); pos != NULL;)
	{
		if (m_SelectedDays.GetNext (pos) == iDay)
		{
			return TRUE;
		}
	}

	return FALSE;
}
//****************************************************************************************
void CCalendarWnd::OnToolbarNotifyClickButton (CCalendarToolBarWnd::BUTTON_ID iID)
{
	int iDay = m_Date.GetDay ();
	int iMonth = m_Date.GetMonth ();
	int iYear = m_Date.GetYear ();
	int iHour = m_Date.GetHour ();
	int iMin = m_Date.GetMinute ();

	int iDir = 0;

	switch (iID)
	{
	case CCalendarToolBarWnd::PREV_MONTH:
		iMonth --;
		iDir = -1;
		if (iMonth == 0)
		{
			iMonth = 12;
			iYear --;
		}
		break;

	case CCalendarToolBarWnd::NEXT_MONTH:
		iDir = 1;
		iMonth ++;
		if (iMonth == 13)
		{
			iMonth = 1;
			iYear ++;
		}
		break;

	case CCalendarToolBarWnd::PREV_YEAR:
		iYear --;
		iDir = -1;
		break;

	case CCalendarToolBarWnd::NEXT_YEAR:
		iDir = 1;
		iYear ++;
		break;

	case CCalendarToolBarWnd::TODAY:
		{
			COleDateTime today = COleDateTime::GetCurrentTime ();
			iDay = today.GetDay ();
			iMonth = today.GetMonth ();
			iYear = today.GetYear ();
		}
		break;

	default:
		return;
	}

	int iDaysInMonth = GetDaysInMonth (iMonth, iYear);
	if (iDay > iDaysInMonth)
	{
		iDay = iDaysInMonth;
	}

	COleDateTime date (iYear, iMonth, iDay, iHour, iMin, 0);
	if (iDir > 0 && date > m_MaxDate)
	{
		date = m_MaxDate;
	}

	if (iDir < 0 && date < m_MinDate)
	{
		date = m_MinDate;
	}

	if (m_Date == date ||
		!SetDate (date))
	{
		MessageBeep (-1);
	}
	else
	{
		m_iDaysInMonth = iDaysInMonth;
	}
	ClearMarkAllRecDaysInMonth(TRUE);
}
//**************************************************************************************
BOOL CCalendarWnd::IsLeftSelected (int iDay) const
{
	ASSERT (iDay >= 1 && iDay <= 31);

	if (iDay == 1)
	{
		return FALSE;
	}

	COleDateTime date (	m_Date.GetYear (), m_Date.GetMonth (), iDay,
						0, 0, 0);
	
	if (date.GetDayOfWeek () == 1)	// Almost left
	{
		return FALSE;
	}

	return IsDaySelected (iDay - 1);
}
//**************************************************************************************
BOOL CCalendarWnd::IsRightSelected (int iDay) const
{
	ASSERT (iDay >= 1 && iDay <= 31);

	if (iDay == m_iDaysInMonth)
	{
		return FALSE;
	}

	COleDateTime date (	m_Date.GetYear (), m_Date.GetMonth (), iDay,
						0, 0, 0);
	
	if (date.GetDayOfWeek () == 7)	// Almost right
	{
		return FALSE;
	}

	return IsDaySelected (iDay + 1);
}
//**************************************************************************************
BOOL CCalendarWnd::IsTopSelected (int iDay) const
{
	ASSERT (iDay >= 1 && iDay <= 31);

	int iTopDay = iDay - 7;
	if (iTopDay < 1 || iTopDay > m_iDaysInMonth)
	{
		return FALSE;
	}

	return IsDaySelected (iTopDay);
}
//**************************************************************************************
BOOL CCalendarWnd::IsBottomSelected (int iDay) const
{
	ASSERT (iDay >= 1 && iDay <= 31);

	int iBottomDay = iDay + 7;
	if (iBottomDay < 1 || iBottomDay > m_iDaysInMonth)
	{
		return FALSE;
	}

	return IsDaySelected (iBottomDay);
}
//**************************************************************************************
void CCalendarWnd::AlignSelectedDays (const COleDateTime& oldDate)
{
	if (m_bAbsoluteSel)
	{
		return;
	}

	int iMonth = m_Date.GetMonth ();
	int iYear = m_Date.GetYear ();

	int iOldMonth = oldDate.GetMonth ();
	int iOldYear = oldDate.GetYear ();

	//-------------------------
	// Save current selections:
	//-------------------------
	CList<int,int>	oldSelectedDays;
	for (POSITION pos = m_SelectedDays.GetHeadPosition (); pos != NULL;)
	{
		oldSelectedDays.AddTail (m_SelectedDays.GetNext (pos));
	}

	m_SelectedDays.RemoveAll ();

	COleDateTime oldFirstDayInMonth (iOldYear, iOldMonth, 1, 0, 0, 0);
	int iOldFirstDayInMonthWeek = oldFirstDayInMonth.GetDayOfWeek ();

	COleDateTime newFirstDayInMonth (iYear, iMonth, 1, 0, 0, 0);
	int iNewFirstDayInMonthWeek = newFirstDayInMonth.GetDayOfWeek ();

	int iDelta = iNewFirstDayInMonthWeek - iOldFirstDayInMonthWeek;

	for (POSITION pos = oldSelectedDays.GetHeadPosition (); pos != NULL;)
	{
		int iOldSeldDay = oldSelectedDays.GetNext (pos);
		int iNewSeldDay = iOldSeldDay - iDelta;

		if (iNewSeldDay > 0 && iNewSeldDay <= m_iDaysInMonth)
		{
			m_SelectedDays.AddTail (iNewSeldDay);
		}
	}
}
//**************************************************************************************
void CCalendarWnd::EnableMultipleSelection (BOOL bMultipleSel)
{
	if (m_bMultipleSel == bMultipleSel)
	{
		return;
	}

	m_bMultipleSel = bMultipleSel;
	m_SelectedDays.RemoveAll ();

	if (GetSafeHwnd () != NULL)
	{
		m_wndCaption.m_bEnabled = m_bMultipleSel;
		m_wndCaption.Invalidate ();
		m_wndCaption.UpdateWindow ();

		Invalidate ();
		UpdateWindow ();
	}
}
//**************************************************************************************
void CCalendarWnd::SelectDayInWeek (int iWeekDay, BOOL bClearOther)
{
	if (bClearOther)
	{
		m_SelectedDays.RemoveAll ();
	}

	int iMonth = m_Date.GetMonth ();
	int iYear = m_Date.GetYear ();

	for (int iDay = 1; iDay <= m_iDaysInMonth; iDay ++)
	{
		COleDateTime date (iYear, iMonth, iDay, 0, 0, 0);
		if (date.GetDayOfWeek () == iWeekDay)
		{
			if (IsDaySelected (iDay))
			{
				RemoveSelectedDay (iDay);
			}
			else
			{
				AddSelectedDay (iDay);
			}
		}
	}

	Invalidate ();
	UpdateWindow ();

	OnSelectionChanged ();
}
//***************************************************************************************
void CCalendarWnd::UpdateColors ()
{
	m_wndToolbar.m_clrBackColor = RGB(84,84,84);
//	m_wndToolbar.m_clrBackColor = m_clrBackColor;
	m_wndToolbar.m_clrTextColor = m_clrTextColor;
	m_wndToolbar.m_clrLightColor = m_clrLightColor;
	m_wndToolbar.m_clrShadowColor = m_clrShadowColor;

	if (GetSafeHwnd () != NULL)
	{
		Invalidate ();
		UpdateWindow ();
	}
}
//***************************************************************************************
void CCalendarWnd::OnSelectionChanged ()
{
// 	if (m_hWnd != NULL)
// 	{
// 		CBCGCalendarCtrl* pParent = (CBCGCalendarCtrl*) GetParent ();
// 		if (pParent != NULL && pParent->IsKindOf (RUNTIME_CLASS (CBCGCalendarCtrl)))
// 		{
// 			pParent->FireOnSelectionChanged ();
// 		}
// 	}
}
//***************************************************************************************
void CCalendarWnd::OnDateChanged()
{
 	if (m_hWnd != NULL)
	{
		::PostMessage(GetParent()->GetSafeHwnd(), WM_SELDATE_CHANGE,GetDlgCtrlID(), NULL );
	}
}
//***************************************************************************************
BOOL CCalendarWnd::MarkDay(short iDayNum, BOOL bMarked) 
{
	if (!bMarked)
	{
		POSITION pos = m_MarkedDays.Find (iDayNum);
		if (pos == NULL)
		{
			return FALSE;
		}

		m_MarkedDays.RemoveAt (pos);
	}
	else
	{
		if (m_MarkedDays.Find (iDayNum) == NULL)
		{
			m_MarkedDays.AddTail ((int) iDayNum);
		}
	}

	if (GetSafeHwnd () != NULL)
	{
		ASSERT (iDayNum >= 1 && iDayNum <= 31);

		CRect rect = m_rectDayLocations [iDayNum - 1];
		rect.InflateRect (3, 3);
		InvalidateRect (rect);
		UpdateWindow ();
	}

	return TRUE;
}
//***************************************************************************************
void CCalendarWnd::UnMarkAllDays() 
{
	while (!m_MarkedDays.IsEmpty ())
	{
		int iDay = m_MarkedDays.RemoveHead ();
		ASSERT (iDay >= 1 && iDay <= 31);

		if (GetSafeHwnd () != NULL)
		{
			CRect rect = m_rectDayLocations [iDay - 1];
			rect.InflateRect (3, 3);
			InvalidateRect (rect);
		}
	}

	if (GetSafeHwnd () != NULL)
	{
		UpdateWindow ();
	}
}


int CCalendarWnd::GetDaysInMonth (int iMonth, int iYear) const
{
	static int nMonthLen [] = 
	{	
		31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 
	};

	int nRes = nMonthLen [iMonth - 1];
	if (iMonth == 2 && iYear % 4 == 0 && 
		(iYear % 100 != 0 || iYear % 400 == 0))
	{
		nRes = 29;
	}

	return nRes;
}

void CCalendarWnd::MarkRecDayInMonth(BOOL bHasRec,int iday)
{
	if ((iday>30)||(iday<0))
	{
		return;
	}
	if (bHasRec)
	{
		m_DayRecState[iday] = 1;
	}
	InvalidateRect(m_rectDayLocations[iday],TRUE);
}

void CCalendarWnd::ClearMarkAllRecDaysInMonth(BOOL bClearMark)
{
	if (bClearMark)
	{
		memset(m_DayRecState,0,sizeof(int)*31);
	}
	for(int i=0;i<31;i++)
	{
		InvalidateRect(m_rectDayLocations[i],TRUE);
	}
}