// EncodeSetDlg.cpp 
//
#include "stdafx.h"
#include "RSLibDemo.h"
#include "MainStreamDlg.h"
#include "../Include/bitrate.h"
#include "ConfigDlg.h"


IMPLEMENT_DYNAMIC(CMainStreamDlg, CDialog)

CMainStreamDlg::CMainStreamDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMainStreamDlg::IDD, pParent)
	, m_bEnable(FALSE)
	,m_AudioChNum(0)
{
	m_ChNum = 0;
	m_selPre = 0;
	m_iCombSub = 0;
}

CMainStreamDlg::~CMainStreamDlg()
{
}

void CMainStreamDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_CH, m_comboCh);
	DDX_Control(pDX, IDC_COMBO_MAINRESOLUTION, m_MainSolution);
	DDX_Control(pDX, IDC_COMBO_MIANFPS, m_MainFps);
	DDX_Control(pDX, IDC_COMBO_MAINBITRATE, m_MainBitRate);
}


BEGIN_MESSAGE_MAP(CMainStreamDlg, CDialog)

	ON_BN_CLICKED(ID_BTN_SET, &CMainStreamDlg::OnBnClickedBtnSet)
	ON_BN_CLICKED(ID_BTN_QUERY, &CMainStreamDlg::OnBnClickedBtnQuery)
	ON_CBN_SELCHANGE(IDC_COMBO_MIANFPS, &CMainStreamDlg::OnCbnSelchangeComboMianfps)
	ON_CBN_SELCHANGE(IDC_COMBO_MAINRESOLUTION, &CMainStreamDlg::OnCbnSelchangeComboMainresolution)
	ON_CBN_SELCHANGE(IDC_COMBO_CH, &CMainStreamDlg::OnCbnSelchangeComboCh)

END_MESSAGE_MAP()

void CMainStreamDlg::OnBnClickedBtnSet()
{
	OnSelectChange(m_selPre);
	int ret = FALSE;
	RSNetSetParamParam param;
	ZeroMemory(&param, sizeof(param));

	param.ParamType = MsgParamMainStream;
	param.ListParams = m_SoleMainStream_t;
	param.ListParamNum = m_ChNum;

	if (m_pServerInfo != NULL)
	{
		//Call the set method
		ret = RSNetSetParam(m_pServerInfo->pNetConnection,&param);
		if(ret == 1)
		{
			AfxMessageBox("Set main stream params successed!");
		}
		else
		{
			AfxMessageBox("Set main stream params failed!");
		}
	}
}

void CMainStreamDlg::OnBnClickedBtnQuery()
{
	int ret = FALSE;
	//fill the Query parameters
	RSNetQueryParamParamEx param;
	ZeroMemory(&param, sizeof(param));
	ZeroMemory(m_SoleMainStream_t, sizeof(m_SoleMainStream_t));
	/*the struct of "RSNet_SoleMainStreamSet_t" used to store the mainstream parameters*/
	param.ListParamSize = sizeof(RSNet_SoleMainStreamSet_t); 
	param.ListParamNum = m_ChNum;
	param.ListParam = m_SoleMainStream_t;
	param.ParamType = MsgParamMainStream;

	ChannelParamReq req;
	req.StructSize = sizeof(req);
	req.ChannelMask = 0xFFFF;
	param.Req = &req;

	//Call the Qurey method
	if (RSNetQueryParamEx(m_pServerInfo->pNetConnection, &param))
	{
		m_selPre = 0;
		m_comboCh.SetCurSel(0);
		OnSelectChange(0, false);
		AfxMessageBox("Query main stream params successed!");
	}
	else
	{
		AfxMessageBox("Query main stream params failed!");
	}
}

BOOL CMainStreamDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	m_pServerInfo = ((CConfigDlg*)GetParent())->m_pServerInfo;
	m_devType = m_pServerInfo->DevLoginRsp.DevType;
	m_TvSystem = m_pServerInfo->DevLoginRsp.VideoFormat;
	maxFps = m_pServerInfo->DevLoginRsp.TotalFPS;
	m_AudioChNum = m_pServerInfo->DevLoginRsp.AudioNum;

	m_ChNum = m_pServerInfo->DevLoginRsp.ChannelNum;
	for(int i=0;i<m_ChNum;i++) {
		CString strCh;
		strCh.Format("%s%d","CH",i+1);
		m_comboCh.InsertString(i,strCh);
	}
	m_comboCh.SetCurSel(0);

	CString strLoad;
	if(m_devType == RS_DVR_D9016)
	{
		strLoad.Format("%s","CIF");
		m_MainSolution.InsertString(0,strLoad);
	}
	else
	{
		strLoad.Format("%s","D1");
		m_MainSolution.InsertString(0,strLoad);
		strLoad.Format("%s","HD1");
		m_MainSolution.InsertString(1,strLoad);
		strLoad.Format("%s","CIF");
		m_MainSolution.InsertString(2,strLoad);
	}
	m_MainSolution.SetCurSel(0);

	int i = 0;

	int iBitRate = 32;
	m_mBitRate[0] = iBitRate;

	for (i=1; i<5; i++)
	{
		m_mBitRate[i] = iBitRate + 16*i;
	}

	iBitRate = 128;
	for (i=5; i< 10 ; i++)
	{
		m_mBitRate[i] = iBitRate + 32*(i-5);
	}

	iBitRate = 320;
	for (i=10; i<14; i++)
	{
		m_mBitRate[i] = iBitRate + 64*(i-10);
	}

	iBitRate = 640;
	for (i=14; i<18; i++)
	{
		m_mBitRate[i] = iBitRate + 128*(i-14);
	}

	iBitRate = 1280;
	for (i=18; i<MaxArrayNum; i++)
	{
		m_mBitRate[i] = iBitRate + 256*(i-18);
	}

	m_MainBitRate.SetCurSel(0);
	int nMaxFrameNum = 25;
	if (m_TvSystem == 1)
	{
		nMaxFrameNum  = 30;
	}

	if(m_devType == RS_DVR_D9016)
	{
		strLoad.Format("%d",nMaxFrameNum);
		m_MainFps.InsertString(0,strLoad);

	}
	else if(m_devType == RS_DVR_D9216H || 
		m_devType == RS_DVR_D9316H ||
		m_devType == RS_DVR_ID9316H )
	{
		for(i=0;i< nMaxFrameNum;i++)
		{
			strLoad.Format("%d",i+1);
			m_MainFps.InsertString(i,strLoad);
		}
	}
	else
	{
		for(i=0;i< nMaxFrameNum;i++)
		{
			strLoad.Format("%d",i+1);
			m_MainFps.InsertString(i,strLoad);
		}
	}
	m_MainFps.SetCurSel(0);
	OnCbnSelchangeComboMainresolution();
	//SetAudioCtrls();
	OnBnClickedBtnQuery();
	UpdateData(FALSE);
	return TRUE;
}

ULONGLONG CMainStreamDlg::GetDevType(SERVER_INFO* pServerInfo)
{
	if(pServerInfo->DevLoginRsp.DevType == RS_DVR_D9016)
	{
		return RS_DVR_D9016;
	}

	return RS_DVR_NORMAL;
}
void CMainStreamDlg::OnSelectChange(int n, BOOL flag)
{
	if (flag)
	{		
		UpdateData(TRUE);
		int mainfps = m_SoleMainStream_t[m_selPre].main_fps;
		if(m_devType == RS_DVR_D9016)
		{
			if(m_TvSystem == RS_PAL)
			{
				m_SoleMainStream_t[m_selPre].main_fps = 25;
			}
			else
			{
				m_SoleMainStream_t[m_selPre].main_fps = 30;
			}

		}
		else
		{
			m_SoleMainStream_t[m_selPre].main_fps = ( m_MainFps.GetCurSel() + 1 ) & 0xFF;
		}
		CString str;
		int nRate = m_MainBitRate.GetCurSel();

		char a[5];
		::GetWindowText(m_MainBitRate.GetSafeHwnd(), a, 5);
		nRate = atoi(a);
		for (int i=0; i<MaxArrayNum; i++)
		{
			if (m_mBitRate[i] == nRate)
			{
				m_SoleMainStream_t[m_selPre].main_bitrate = i & 0xFF;
				break;
			}
		}

		//m_SoleMainStream_t[m_selPre].main_audio = m_MainAudio.GetCurSel() & 0xFF;

		int mainres = m_SoleMainStream_t[m_selPre].main_resolution;
		if(m_devType == RS_DVR_D9016)
		{
			mainres = 2;
			m_SoleMainStream_t[m_selPre].main_resolution = 2;
		}
		else
		{
			m_SoleMainStream_t[m_selPre].main_resolution = m_MainSolution.GetCurSel() & 0xFF;
		}

		if (!MainFpsChange())
		{
			OnBnClickedBtnQuery();
		}
	}
	m_selPre = n;
	if(RS_DVR_D9016 != m_devType)
	{
		m_MainSolution.SetCurSel( m_SoleMainStream_t[n].main_resolution & 0xFF );
	}
	else
	{
		m_MainSolution.SetCurSel(0);
	}
	m_MainFps.SetCurSel( (m_SoleMainStream_t[n].main_fps & 0xFF) - 1);
	OnCbnSelchangeComboMianfps();

	CString str;
	str.Format("%d", m_mBitRate[m_SoleMainStream_t[n].main_bitrate & 0xFF]);
	int i = m_MainBitRate.FindString(0, str);
	m_MainBitRate.SetCurSel( i );
	//m_MainAudio.SetCurSel( m_SoleMainStream_t[n].main_audio & 0xFF );
	UpdateData(FALSE);
}

BOOL CMainStreamDlg::MainFpsChange()
{
	int bs = 0;
	switch(m_TvSystem)
	{
	case RS_PAL:	
		{
			int total = 0;

			for (int i=0; i<m_ChNum; i++)
			{
				if (m_SoleMainStream_t[i].main_resolution == 0)
				{
					bs = 4;
				}
				else if (m_SoleMainStream_t[i].main_resolution == 1)
				{
					bs = 2;
				}
				else
					bs = 1;

				total += m_SoleMainStream_t[i].main_fps * bs;

			}

			if ( maxFps - total < 0)
			{
				CString strCaption;
				MessageBox("Warning", "The total of Fps cannot more than MaxFps !", MB_OK);
				return false;
			}
		}
		break;
	case RS_NTSC:	
		{
			int total = 0;
			for (int i=0; i<m_ChNum; i++)
			{
				if (m_SoleMainStream_t[i].main_resolution == 0)
				{
					bs = 4;
				}
				else if (m_SoleMainStream_t[i].main_resolution == 1)
				{
					bs = 2;
				}
				else
					bs = 1;

				total += m_SoleMainStream_t[i].main_fps * bs;
			}

			if ( maxFps - total < 0)
			{
				CString strCaption;
				MessageBox("Warning", "The total of Fps cannot more than MaxFps !", MB_OK);
				return false;
			}
		}
		break;
	}
	return true;
}

void CMainStreamDlg::OnCbnSelchangeComboMianfps()
{
	int n = m_MainFps.GetCurSel();
	int m = m_MainSolution.GetCurSel();
	if(m_devType == RS_DVR_D9016)
	{
		m = 2;
	}
#ifdef _LOREX_

#else
	m_MainBitRate.ResetContent();	
#endif

	CString strLoad;

	switch(m_TvSystem)
	{
	case RS_PAL:
		if (m == 0)			//D1
		{
			int j = 0;
			for (int i=D1_PAL_BITRATE[n][0]; i<D1_PAL_BITRATE[n][1] + 1; i++)
			{
				strLoad.Format("%d", m_mBitRate[i]);
				m_MainBitRate.InsertString(j,strLoad);
				j++;
			}
		}
		else if (m == 1)	//HD1
		{
			int j = 0;
			for (int i=HD1_PAL_BITRATE[n][0]; i<HD1_PAL_BITRATE[n][1] + 1; i++)
			{
				strLoad.Format("%d", m_mBitRate[i]);
				m_MainBitRate.InsertString(j,strLoad);
				j++;
			}
		}
		else				//CIF
		{
			int j = 0;
			if(m_devType == RS_DVR_D9016)
			{
				n = 24;
				for (int i=CIF9016_PAL_BITRATE[n][0]; i<CIF9016_PAL_BITRATE[n][1] + 1; i++)
				{
					strLoad.Format("%d", m_mBitRate[i]);
					m_MainBitRate.InsertString(j,strLoad);

					j++;
				}
			}
			else
			{
				for (int i=CIF_PAL_BITRATE[n][0]; i<CIF_PAL_BITRATE[n][1] + 1; i++)
				{
					strLoad.Format("%d", m_mBitRate[i]);
					m_MainBitRate.InsertString(j,strLoad);
					j++;
				}
			}

		}
		break;
	case RS_NTSC:
		if (m == 0)			//D1
		{
			int j = 0;
			for (int i=D1_NTSC_BITRATE[n][0]; i<D1_NTSC_BITRATE[n][1] + 1; i++)
			{
				strLoad.Format("%d", m_mBitRate[i]);
				m_MainBitRate.InsertString(j,strLoad);
				j++;
			}
		}
		else if (m == 1)	//HD1
		{
			int j = 0;
			for (int i=HD1_NTSC_BITRATE[n][0]; i<HD1_NTSC_BITRATE[n][1] + 1; i++)
			{
				strLoad.Format("%d", m_mBitRate[i]);
				m_MainBitRate.InsertString(j,strLoad);
				j++;
			}
		}
		else	//CIF
		{
			int j = 0;
			if(m_devType == RS_DVR_D9016)
			{
				n = 29;
				for (int i=CIF9016_NTSC_BITRATE[n][0]; i<CIF9016_NTSC_BITRATE[n][1] + 1; i++)
				{
					strLoad.Format("%d", m_mBitRate[i]);
					m_MainBitRate.InsertString(j,strLoad);
					j++;
				}
			}
			else
			{
				for (int i=CIF_NTSC_BITRATE[n][0]; i<CIF_NTSC_BITRATE[n][1] + 1; i++)
				{
					strLoad.Format("%d", m_mBitRate[i]);
					m_MainBitRate.InsertString(j,strLoad);
					j++;
				}
			}
		}
		break;
	}
	m_MainBitRate.SetCurSel(0);
}

void CMainStreamDlg::OnCbnSelchangeComboMainresolution()
{
	m_MainBitRate.ResetContent();
	OnCbnSelchangeComboMianfps();
}

void CMainStreamDlg::OnCbnSelchangeComboCh()
{
	int i = m_comboCh.GetCurSel();
	OnSelectChange(i);
	SetAudioCtrls();

}
void CMainStreamDlg::SetAudioCtrls()
{
	UpdateData(TRUE);
	/*int i = m_comboCh.GetCurSel();
	if(m_AudioChNum == 0)
	{
		m_MainAudio.ShowWindow(SW_SHOW);
		GetDlgItem(IDC_STATIC_MAINAUDIO)->ShowWindow(SW_SHOW);
	}
	else
	{
		if(i < m_AudioChNum)
		{
			m_MainAudio.ShowWindow(SW_SHOW);
			GetDlgItem(IDC_STATIC_MAINAUDIO)->ShowWindow(SW_SHOW);

		}
		else
		{
			m_MainAudio.SetCurSel(0);
			m_MainAudio.ShowWindow(SW_HIDE);
			GetDlgItem(IDC_STATIC_MAINAUDIO)->ShowWindow(SW_HIDE);
		}
	}*/

	UpdateData(FALSE);
}