#pragma once


// CRecScheduleCtrl

typedef enum{
    NORMAL_TYPE = 0,
    MOTION_TYPE = 1,
    ALARM_TYPE = 2
}RECORD_TYPE;

class CRecScheduleCtrl : public CStatic
{
	DECLARE_DYNAMIC(CRecScheduleCtrl)

public:
	CRecScheduleCtrl();
	virtual ~CRecScheduleCtrl();
    void setScheduleData(BYTE* pData, int nSize);
    void getScheduleData(BYTE* pData, int nSize);
    void setCurrentType(RECORD_TYPE nType) { m_nCurrentType = nType; }
    void setPartsInTwoHour(int n);

protected:
    //{{AFX_MSG(CCheckGroupCtrl)
    afx_msg void OnPaint();
    afx_msg BOOL OnEraseBkgnd(CDC* pDC);
    afx_msg void OnSize(UINT nType, int cx, int cy);
    afx_msg void OnMouseMove(UINT nFlags, CPoint point);
    afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
    afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
    //}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
    void drawData(CDC& dc, const CRect& rect);
    void drawScale(CDC& dc, const CRect& rect);
    void drawMoveRect(CDC& dc, const CRect& rect);
    void updateScheduleData();

    CPen        m_PenLine;
    COLORREF    m_nBackGroundColor;
    COLORREF    m_nLineColor;
    CBitmap     m_bitmapBackGround;

    int         m_nRecordType;
    int         m_nRecordCount;
    RECORD_TYPE m_nCurrentType;
    int         m_nPartsInTwoHour;
    BOOL        m_bSaved;
    BOOL        m_bLButtonDown;
    CPoint      m_startPoint;
    CPoint      m_endPoint;

    BYTE        m_nHalfHour[8][48];
};


