// VideoSet.cpp : ʵļ
//

#include "stdafx.h"
#include "RSLibDemo.h"
#include "VideoSet.h"
#include "ChannelCopyDlg.h"

// CVideoSet Ի

IMPLEMENT_DYNAMIC(CVideoSet, CDialog)

CVideoSet::CVideoSet(CWnd* pParent /*=NULL*/)
	: CDialog(CVideoSet::IDD, pParent)
{
    m_pServer = NULL;
	m_chanSel = 0;
}

CVideoSet::~CVideoSet()
{
}

void CVideoSet::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COM_RESOLUTION, m_com_resolut);
	DDX_Control(pDX, IDC_COM_MODE, m_com_mode);
	DDX_Control(pDX, IDC_COM_GUIDEV, m_com_guidev);
	DDX_Control(pDX, IDC_SLIDER_TRANSP, m_slid_transparent);
	DDX_Control(pDX, IDC_COM_VIDEOSET, m_com_SelVideo);
	DDX_Control(pDX, IDC_BTN_CHNSELECT, m_btnChCopy);
}


BEGIN_MESSAGE_MAP(CVideoSet, CDialog)
	ON_BN_CLICKED(IDC_SAVE, &CVideoSet::OnBnClickedSave)
	ON_CBN_SELCHANGE(IDC_COM_VIDEOSET, &CVideoSet::OnCbnSelchangeComVideoset)
	ON_BN_CLICKED(IDC_BTN_CHNSELECT, &CVideoSet::OnBnClickedBtnChnselect)
	ON_MESSAGE(WM_COPY_DATA,OnCopyData)
END_MESSAGE_MAP()


// CVideoSet Ϣ
BOOL CVideoSet::OnInitDialog()
{
	CDialog::OnInitDialog();

    m_com_resolut.AddString(_T("800*600"));
	m_com_resolut.AddString(_T("1024*768"));
	m_com_resolut.AddString(_T("1280*1024"));
	m_com_resolut.AddString(_T("1440*900"));
	m_com_resolut.SetCurSel(0);

	m_com_mode.AddString(_T("Vout"));
	m_com_mode.AddString(_T("Spot"));
	m_com_mode.SetCurSel(0);

	m_com_guidev.AddString(_T("VOUT"));
	m_com_guidev.AddString(_T("VGA"));
	m_com_guidev.AddString(_T("AUTO"));
	m_com_guidev.SetCurSel(0);

	m_slid_transparent.SetRange(0,128);
	int nChNum = m_pServer->DevLoginRsp.ChannelNum;
	if (nChNum == 4)
	{
		m_com_SelVideo.AddString("1");
		m_com_SelVideo.AddString("4");
	}
	else if (nChNum == 8)
	{
		m_com_SelVideo.AddString("1");
		m_com_SelVideo.AddString("4");
		m_com_SelVideo.AddString("9");
	}
	else if (nChNum == 16)
	{
		m_com_SelVideo.AddString("1");
		m_com_SelVideo.AddString("4");
		m_com_SelVideo.AddString("9");
		m_com_SelVideo.AddString("16");
	}
	m_com_SelVideo.SetCurSel(0);
	return TRUE;
}


void CVideoSet::QueryParamters(void *param)
{
	m_pServer = (SERVER_INFO *)param;
	if (m_pServer != NULL)
	{
		ZeroMemory(&m_outputSet,sizeof(m_outputSet));
		RSNetQueryParamParamEx param = {0};
		//ZeroMemory(listParam, sizeof(listParam));
		param.Param = &m_outputSet;
		param.ParamSize = sizeof(RSNet_OutputSet_t);
		param.ParamType = MsgParamOutput;

		if (RSNetQueryParamEx(m_pServer->pNetConnection, &param))
		{
			m_com_resolut.SetCurSel(m_outputSet.Resolution);
            m_com_mode.SetCurSel(m_outputSet.IsVoutOrSpot);
			m_com_guidev.SetCurSel(m_outputSet.InitGuiDev);
			m_slid_transparent.SetPos(m_outputSet.Transparency);
		}
	}
}


void CVideoSet::OnBnClickedSave()
{
	m_outputSet.Resolution = m_com_resolut.GetCurSel();
	m_outputSet.IsVoutOrSpot = m_com_mode.GetCurSel();
	m_outputSet.InitGuiDev = m_com_guidev.GetCurSel();
	m_outputSet.Transparency = m_slid_transparent.GetPos();

	RSNetSetParamParam param;
	ZeroMemory(&param, sizeof(param));
	param.ParamType = MsgParamOutput;
	param.Param = &m_outputSet;
	if (RSNetSetParam(m_pServer->pNetConnection, &param))
	{
		GetDlgItem(IDC_STA_TIP)->SetWindowText("Video save succeed!\n");
	}
	else
	{
		GetDlgItem(IDC_STA_TIP)->SetWindowText("Video save failed!\n");
	}
}

void CVideoSet::OnCbnSelchangeComVideoset()
{
	m_chanSel = m_com_SelVideo.GetCurSel();

}

void CVideoSet::OnBnClickedBtnChnselect()
{
	if (m_pServer == NULL)
	{
		return ;
	}

	CChannelCopyDlg dlg;
	CRect rectBtn;
	int nChNum = m_pServer->DevLoginRsp.ChannelNum;
	m_btnChCopy.GetWindowRect(&rectBtn);
	dlg.point.x = rectBtn.left;
	dlg.point.y = rectBtn.bottom;
	dlg.m_ChNum = nChNum;
	dlg.m_hParamWnd = GetSafeHwnd();
	dlg.m_selMode = m_chanSel;
	if (dlg.DoModal() == IDOK)
	{
		int copy = dlg.m_CopyCh;
		if (m_chanSel == 0) //1
		{
			BYTE a[2] = {0};
			a[0] = m_outputSet.OutputAttr[0].ChannelSelect.onechn;
			SetVideoChnInfo(a,nChNum,dlg.m_CopyCh,1);
			for (int i=0; i<3; ++i)
			{
				m_outputSet.OutputAttr[i].ChannelSelect.onechn = a[0];
				m_outputSet.OutputAttr[i].OutputMode = m_chanSel;
			}
			
		}
		else if (m_chanSel == 1) // 4
		{
			for (int i=0; i<3; ++i)
			{
				ZeroMemory(m_outputSet.OutputAttr[i].ChannelSelect.fourchn,4);
				SetVideoChnInfo(m_outputSet.OutputAttr[i].ChannelSelect.fourchn,nChNum,dlg.m_CopyCh,4);
				m_outputSet.OutputAttr[i].OutputMode = m_chanSel;
			}
			
		}
		else if (m_chanSel == 2) // 9
		{
			for (int i=0; i<3; ++i)
			{
				ZeroMemory(m_outputSet.OutputAttr[i].ChannelSelect.ninechn,9);
				SetVideoChnInfo(m_outputSet.OutputAttr[i].ChannelSelect.ninechn,nChNum,dlg.m_CopyCh,9);
				m_outputSet.OutputAttr[i].OutputMode = m_chanSel;
			}
			
		}
		else if (m_chanSel == 3) // 16
		{
			for (int i=0; i<3; ++i)
			{
				ZeroMemory(m_outputSet.OutputAttr[i].ChannelSelect.sixteenchn,16);
				SetVideoChnInfo(m_outputSet.OutputAttr[i].ChannelSelect.sixteenchn,nChNum,dlg.m_CopyCh,16);
				m_outputSet.OutputAttr[i].OutputMode = m_chanSel;
			}
			
		}
	}
      GetDlgItem(IDC_STA_TIP)->SetWindowText("");
}


void CVideoSet::SetVideoChnInfo(BYTE info[],int num,int data,int maxchn)
{
	int count = 0;
	for (int i=0; i<num; ++i)
	{
		if ((data>>i)&1)
		{
           info[count++] = i;
		   if (count >= maxchn)
		   {
			   break;
		   }
		}
	}

}

void CVideoSet::SetSeverInfo(SERVER_INFO *pInfo)
{
	//ASSERT(pInfo != NULL);

	m_pServer = pInfo;
}

LRESULT CVideoSet::OnCopyData(WPARAM wParam, LPARAM lParam)
{
	int code = (int)wParam;
	if (COPYDATA_MIN == code)
	{
		int chan = (int)lParam;
		CString str;
		str.Format("%d channels is not selected",chan);
        GetDlgItem(IDC_STA_TIP)->SetWindowText(str);
	}
	else if (COPYDATA_MAX == code)
	{
        GetDlgItem(IDC_STA_TIP)->SetWindowText("Select the number of channels has reached the upper limit");
	}
	return 0;
}