#include "global.h"
#include "stdafx.h"



BOOL JudgeNumSetString(char* pszString)
{
	if(!pszString || !*pszString)
		return FALSE;
	char *pPos = pszString++;
	if(*pPos == '-')
		pPos++;
	while(*pPos)
	{
		if(!isdigit(*pPos))
			return FALSE;
		pPos++;
	}
	return TRUE;
}


BOOL CheckPassword(CString StrTemp) 
{
	for(LPTSTR   p=   CharNext(StrTemp);   p[0]   !=   '\0';   p   =   CharNext(p))   
	{   
//		TRACE("%c***%d***%d\n", p[0], p, &p);
		if((int)p[0] > 0   &&   (int)p[0] <= 127)   
		{   
//			TRACE("%c---%d\n", p[0], p[0]);
			if((int)p[0] >= 0x30   && (int)p[0] <= 0x39)   
			{   
				continue;
			}   
			else   if(((int)p[0] >= 0x41 && (int)p[0] <= 0x5a)   ||   ((int)p[0] >= 0x61)   &&   ((int)p[0] <= 0x7a))   
			{   
				continue;  
			}  
			else
				return FALSE;
		}
		else
			return FALSE;
	}
	return TRUE;
}

BOOL GetDiskDrive(CString strDrive[], int &count)
{
	const DWORD MAXPATH = 256;
	
	char szTemp[1024];   
	memset(szTemp, 0, sizeof(szTemp));
	DWORD dw = GetLogicalDriveStrings(1024, szTemp);
	
	char szWinDrv[MAXPATH];
	if ( GetWindowsDirectory(szWinDrv, MAXPATH) ==0 )
	{
		return FALSE;
	}
	memset(szWinDrv+3,0,sizeof(szWinDrv)-3);
	
	char szDrive[100];
	count = 0;
	for (int i=0;i<=(int)dw-4;i=i+4)
	{
		memset(szDrive,0,sizeof(szDrive));
		strncpy_s(szDrive,szTemp+i,3);
		int  driveType = GetDriveType(szDrive);
		//	if ( driveType != DRIVE_FIXED)	
		//		continue;
		if ( driveType == DRIVE_REMOVABLE)	
			continue;
		if ( driveType == DRIVE_CDROM )
			continue;
		if ( _stricmp(szWinDrv,szDrive)==0 )
			continue;
		
		szDrive[2] = '\0';
		strDrive[count] =  szDrive;				
		count++;
	}
	
	if(count >0)
		return TRUE;
	return FALSE;
}


CString  GetAppPath()
{
	TCHAR   FILENAME[1024];   
	::GetModuleFileName(NULL,FILENAME,1023);   
	CString   pathname;   
	pathname=FILENAME;   
	int   nPos = pathname.ReverseFind('\\');   
	pathname = pathname.Left(nPos+1);
	return pathname;
}

void CreateFoler(CString strPath)
{
	CString strTemp;
	int iPreItem = 0; 
	int iNextItem = 1;
	while(1)
	{
		iPreItem = strPath.Find("\\",iPreItem);
		iNextItem = strPath.Find("\\",iPreItem+1);
		if (iNextItem == -1)
		{
			break;
		}
		strTemp = strPath.Mid(0,iNextItem+1); 
		TRACE("strTemp=%s\n",strTemp);
		CreateDirectory(strTemp, NULL);	
		iPreItem = iNextItem;
	}
}

int  CompareTime(SYSTEMTIME posTime,SYSTEMTIME cmpTime)
{
	if(posTime.wYear<cmpTime.wYear)
		return -1;
	else if(posTime.wYear>cmpTime.wYear)
		return 1;

	if(posTime.wMonth <cmpTime.wMonth)
		return -1;
	else if(posTime.wMonth>cmpTime.wMonth)
		return 1;

	if(posTime.wDay <cmpTime.wDay)
		return -1;
	else if(posTime.wDay>cmpTime.wDay)
		return 1;

	if(posTime.wHour<cmpTime.wHour)
		return -1;
	else if(posTime.wHour>cmpTime.wHour)
		return 1;
	
	if(posTime.wMinute<cmpTime.wMinute)
		return -1;  
	else if(posTime.wMinute>cmpTime.wMinute)
		return 1;
	
	if(posTime.wSecond<cmpTime.wSecond)
		return -1;  
	else if(posTime.wSecond>cmpTime.wSecond)
		return 1;
	
	return 0;
}

int  CompareWeekDay(weekDay beginWeek,weekDay endWeek)
{
	if(beginWeek.Month<endWeek.Month)
		return -1;
	else if(beginWeek.Month>endWeek.Month)
		return 1;

	if(beginWeek.Week <endWeek.Week)
		return -1;
	else if(beginWeek.Week>endWeek.Week)
		return 1;

	if(beginWeek.WeekDay <endWeek.WeekDay)
		return -1;
	else if(beginWeek.WeekDay>endWeek.WeekDay)
		return 1;

	return 0;
}






CRect RectSizeWithConstantRatio( CRect* rcScreen,CSize sizePicture,BOOL bCenter)
{
	CRect rect(rcScreen); 
	double dWidth = rcScreen->Width(); 
	double dHeight = rcScreen->Height(); 
	double dAspectRatio = dWidth/dHeight; 
	double dPictureWidth = sizePicture.cx; 
	double dPictureHeight = sizePicture.cy; 
	double dPictureAspectRatio = dPictureWidth/dPictureHeight; 
	//If the aspect ratios are the same then the screen rectangle // will do otherwise we need to calculate the new rectangle 
	if (dPictureAspectRatio == dAspectRatio) 
	{ 
		int nNewHeight = (int)(dWidth/dPictureWidth*dPictureHeight); 
		int nCenteringFactor = (rcScreen->Height() - nNewHeight) / 2; 
		rect.SetRect( 0,nCenteringFactor,(int)dWidth,nNewHeight + nCenteringFactor); 
	} 
	else if (dPictureAspectRatio > dAspectRatio) 
	{
		int nNewWidth = (int)(dHeight/dPictureHeight*dPictureWidth); 
		int nCenteringFactor = (rcScreen->Width() - nNewWidth) / 2; 
		rect.SetRect( nCenteringFactor, 0,nNewWidth + nCenteringFactor,(int)(dHeight)); 
	} 
	return rect;
};

void GetSplitRectByNum(CRect* pRectList,CRect rectOrg,int nRows,int nCols)
{
	int nSubWidth  = rectOrg.Width()/nCols;
	int nSubHeight = rectOrg.Height()/nRows;
	int nLeaWidth = rectOrg.Width()%nCols;
	int nLeaHeight = rectOrg.Height()%nRows;

	for(int i=0; i<nRows*nCols; i++)
	{
		int nInRows = i/nCols;
		int nInCols = i%nCols;		
		pRectList[i].left   = rectOrg.left + nSubWidth * nInCols;
		pRectList[i].top    = rectOrg.top  + nSubHeight * nInRows;
		if (nInRows == nRows-1)
		{
			pRectList[i].bottom = pRectList[i].top + nSubHeight +nLeaHeight;
		}
		else
		{
			pRectList[i].bottom = pRectList[i].top + nSubHeight ;
		}

		if (nInCols == nCols- 1)
		{
			pRectList[i].right  = pRectList[i].left + nSubWidth+nLeaWidth;
		}
		else
		{
			pRectList[i].right  = pRectList[i].left + nSubWidth;
		}					
	}
}


void SplitRectByNum(CRect rectOrg, int nNum,CRect* pRectList,LPCRECT lpDeRect,int nSplitType)
{
	int Rows;
	int Cols;
	switch(nNum)
	{
	case 1:	
		{
			Rows = Cols = 1;
			GetSplitRectByNum(pRectList,rectOrg,Rows,Cols);
		}

		break;
	case 4:
		{	
			Rows = Cols = 2;
			GetSplitRectByNum(pRectList,rectOrg,Rows,Cols);			
		}
		break;
	case 6: 
		{
			Rows = Cols = 3;
			CRect rectlist[MAX_PREVIEW_WND_NUM];
			GetSplitRectByNum(rectlist,rectOrg,Rows,Cols);	

			GetRectFromList(pRectList[0],0,4,rectlist);	
			GetRectFromList(pRectList[1],2,2,rectlist);	

			for(int i=2; i<nNum; i++)
			{
				pRectList[i] = rectlist[i+3];			
			}
		}	
		break;
	case 8:  
		{
			Rows = Cols = 4;
			CRect rectlist[MAX_PREVIEW_WND_NUM];
			GetSplitRectByNum(rectlist,rectOrg,Rows,Cols);	

			GetRectFromList(pRectList[0],0,10,rectlist);	
			GetRectFromList(pRectList[1],3,3,rectlist);	
			GetRectFromList(pRectList[2],7,7,rectlist);	
			for(int i=3; i<nNum; i++)
			{
				pRectList[i] = rectlist[i+8];			
			}
		}
		break;

	case 9:
		{
			Rows = Cols = 3;
			GetSplitRectByNum(pRectList,rectOrg,Rows,Cols);			
		}
		break;
	case 10:  
		{
			if (nSplitType==0)
			{
				Rows = Cols = 5;
				CRect rectlist[MAX_PREVIEW_WND_NUM];
				GetSplitRectByNum(rectlist,rectOrg,Rows,Cols);	

				GetRectFromList(pRectList[0],0,18,rectlist);	
				GetRectFromList(pRectList[1],4,4,rectlist);	
				GetRectFromList(pRectList[2],9,9,rectlist);	
				GetRectFromList(pRectList[3],14,14,rectlist);	
				for(int i=4; i<nNum; i++)
				{
					pRectList[i] = rectlist[i+15];				
				}
			}
			else if (nSplitType==1)
			{
				Rows = Cols = 4;
				CRect rectlist[MAX_PREVIEW_WND_NUM];
				GetSplitRectByNum(rectlist,rectOrg,Rows,Cols);	

				GetRectFromList(pRectList[0],0,5,rectlist);	
				GetRectFromList(pRectList[1],2,7,rectlist);	
				for(int i=2; i<nNum; i++)
				{
					pRectList[i] = rectlist[i+6];				
				}
			}
		}

		break;
	case 13:  
		{
			if (nSplitType==0)
			{
				Rows = Cols = 5;
				CRect rectlist[MAX_PREVIEW_WND_NUM];
				GetSplitRectByNum(rectlist,rectOrg,Rows,Cols);	

				GetRectFromList(pRectList[0],0,6,rectlist);	
				GetRectFromList(pRectList[1],2,8,rectlist);	
				GetRectFromList(pRectList[2],4,4,rectlist);	
				GetRectFromList(pRectList[3],9,9,rectlist);	
				GetRectFromList(pRectList[4],10,16,rectlist);	
				GetRectFromList(pRectList[5],12,18,rectlist);	
				GetRectFromList(pRectList[6],14,14,rectlist);	
				GetRectFromList(pRectList[7],19,19,rectlist);	

				for(int i=8; i<nNum; i++)
				{
					pRectList[i] = rectlist[i+12];				
				}
			}
			else if (nSplitType==1)
			{
				Rows = Cols = 4;
				CRect rectlist[MAX_PREVIEW_WND_NUM];
				GetSplitRectByNum(rectlist,rectOrg,Rows,Cols);	

				for(int i=0; i<5; i++)
				{
					pRectList[i] = rectlist[i];				
				}

				GetRectFromList(pRectList[5],5,10,rectlist);	
				GetRectFromList(pRectList[6],7,7,rectlist);	
				GetRectFromList(pRectList[7],8,8,rectlist);	
				for(int i=8; i<nNum; i++)
				{
					pRectList[i] = rectlist[i+3];			
				}

			}
		}
		break;
	case 14:
		{
			Rows = Cols = 5;
			CRect rectlist[MAX_PREVIEW_WND_NUM];
			GetSplitRectByNum(rectlist,rectOrg,Rows,Cols);	

			GetRectFromList(pRectList[0],0,12,rectlist);	
			GetRectFromList(pRectList[1],3,9,rectlist);	
			for(int i=2; i<nNum; i++)
			{
				pRectList[i]= rectlist[i+11];			
			}
		}
		break;
	case 16:
		{
			Rows = Cols = 4;
			GetSplitRectByNum(pRectList,rectOrg,Rows,Cols);			
		}
		break;
	case 25:
		{
			int Rows;
			int Cols;
			Rows = Cols = 5;
			GetSplitRectByNum(pRectList,rectOrg,Rows,Cols);			
		}
		break;
	case 36:
		{
			int Rows;
			int Cols;
			Rows = Cols = 6;
			GetSplitRectByNum(pRectList,rectOrg,Rows,Cols);			
		}
		break;
	case 49:
		{
			int Rows;
			int Cols;
			Rows = Cols = 7;
			GetSplitRectByNum(pRectList,rectOrg,Rows,Cols);			
		}
		break;
	case 64:
		{
			int Rows;
			int Cols;
			Rows = Cols = 8;
			GetSplitRectByNum(pRectList,rectOrg,Rows,Cols);			
		}
		break;		
	default:
		break;
	}

	for(int i=0; i<nNum;i++)
	{
		pRectList[i].DeflateRect(lpDeRect);
	}
}


void PaintBkImage(CDC *pDC, const CRect &rect, BOOL bStretch,COLORREF clrBack,Image* pImage)
{
	if ((pImage == NULL)||(pDC == NULL))
	{
		return;
	}
	Graphics graph(pDC->m_hDC);

	int nPngWidth, nPngHeight ;
	nPngWidth  = pImage->GetWidth();
	nPngHeight = pImage->GetHeight();

	int nleft = rect.left;
	int ntop = rect.top;
	int nright = nleft;
	int nbottom = ntop;
	if (bStretch)
	{
		nright = rect.Width();
		nbottom = rect.Height();
		Point points[] = {Point(nleft, ntop), Point(nright, ntop), Point(nleft, nbottom)};
		graph.DrawImage(pImage, points, 3);
	}
	else
	{
		for(int i=0;i<rect.Width();i++)
		{
			nright += nPngWidth;
			nbottom = rect.Height();
			Point points[] = {Point(nleft, ntop), Point(nright, ntop), Point(nleft, nbottom)};
			graph.DrawImage(pImage, points, 3);
			nleft = nright;
			i += nPngWidth-1;
		}

	}
}


void GetRectFromList(CRect &rectWnd,int nTop,int nBottom,CRect* pRectList)
{
	rectWnd.left = pRectList[nTop].left;
	rectWnd.top = pRectList[nTop].top;
	rectWnd.right = pRectList[nBottom].right;
	rectWnd.bottom = pRectList[nBottom].bottom;
}

COLORREF StrToColor(CString strColor)
{
	COLORREF color = 0x00000000;
	CString str,strTemp;
	int length = strColor.GetLength()-1;
	if (length > 6)
	{
		return color;
	}
 	strColor = strColor.Right(length);
	for(int i=length/2-1;i>=0;i--)
	{
		strTemp += strColor.Mid(i*2,2);
	}	
 	sscanf(strTemp, "%x", &color);
	TRACE("color %x \n",color);
	return color;
}

CString ColorToStr( COLORREF color)
{
	CString str;
	str.Format("#%x%02x%02x",GetRValue(color), GetGValue(color), GetBValue(color));
	TRACE("color %s \n",str);
	return str;
}