#ifndef __RS_GLOBAL_H__
#define __RS_GLOBAL_H__

#include "stdafx.h"

inline void TESTHR( HRESULT _hr ) 
{ if FAILED(_hr) throw(_hr); }

inline int MaxValue(int a, int b)
{	return (a >= b)?a:b; }
inline int MinValue(int a, int b)
{   return (a > b)?b:a;  }

#define SAFE_DELETE(p)  { if(p != NULL) { delete (p);     (p) = NULL; } }   //Delete object by New create 
#define SAFE_DELETEA(p) { if(p != NULL) { delete[] (p);   (p) = NULL; } }   //Delete Arrary
#define SAFE_RELEASE(p) { if(p != NULL) { (p)->Release(); (p) = NULL; } }
#define SAFE_FREE(p)	{ if(p != NULL) { free(p); (p) = NULL; } }

#ifdef UNICODE
#define CStringToWCHARPtr(strPngFilePath,wstrFileName) swprintf(wstrFileName, _T("%s"), static_cast<LPCTSTR>(strPngFilePath))
#else
#define CStringToWCHARPtr(strPngFilePath,wstrFileName) MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED | MB_USEGLYPHCHARS, strPngFilePath, -1, wstrFileName, MAX_PATH);
#endif

#define MAX_PREVIEW_WND_NUM   64
#define MAX_PLAYBACK_WND_NUM   4
#define MAX_MAPVIDEO_WND_NUM 16

#define TEXT_MAXLEN	       256
#define	MSG_USER_NAME_LEN	24
#define	MSG_PASSWD_LEN		24
#define	MSG_ADDR_LEN				16
#define	MSG_ALARM_INFO_LEN			48

#define  DEFAULT_SIZE  256 
#define  SWITCH_TIME   30   

#define DIALOG_BKCOLOR2				 RGB(209,214,233) //(RGB(236,233,216))   
#define VIDEO_TITLE_BKCOLOR_NORMAL   RGB(153,153,153)  // normal
#define VIDOO_TITLE_FGCOLOR_NORMAL   RGB(255,255,255)
#define ALL_REC_FILERGN_COLOR        RGB(70,163,255)
#define NORMAL_REC_FILERGN_COLOR     RGB(70,163,255)
#define ALARM_REC_FILERGN_COLOR      RGB(255,0,0)
#define WINDOW_SEL_COLOR		     RGB(4,153,211)
#define WINDOW_NOSEL_COLOR           RGB(0,0,0)
#define LEFTBOTTOM_BK_COLOR			 RGB(79,79,79)
#define DLG_BK_COLOR				 RGB(82,82,82)
#define PLAYBACK_TOOLBAR_HEIGHT      140
#define PREVIEW_TOOLBAR_HEIGHT		 38

#define ID_TIMER_DISPLAY_DELAY		100
#define ID_TIMER_POP_WINDOW			101
#define ID_TIMER_CLOSE_WINDOW		102
#define ID_TIMER_GET_PLAYTIME 		103
#define ID_TIMER_QUERY_DEV	 		104
#define ID_TIMER_ALARMFLASH	 		105
#define ID_TIMER_ALARM_TEST	 		106
#define ID_TIMER_SET_VOLUME         107
#define SMALL_ICON_NOTIFY		(WM_USER+210)
#define WM_DRAG_BUTTONUP		(WM_USER+624)
#define WM_CONNECTION_MESSAGE	(WM_USER+625)
#define WM_MAPPIN_POSCHANGE		(WM_USER+626)
#define WM_QUERYPARAM		    (WM_USER+627)
#define WM_SETPARAM		        (WM_USER+628)
#define WM_WNDSPLITER		    (WM_USER+629)
#define WM_AUTOPREVIEW		    (WM_USER+630)
#define WM_STARTPREVIEW		    (WM_USER+631)
#define WM_STOPPREVIEW		    (WM_USER+632)
#define WM_MAPICON_SEL		    (WM_USER+633)
#define WM_INITMAP			    (WM_USER+634)
#define WM_ALARM			    (WM_USER+635)
#define WM_USERCHANGE		    (WM_USER+636)
#define WM_RECORD_PLAY_MSG		(WM_USER+637)
#define WM_COPY_DATA            (WM_USER+638)
#define WM_INSERT_LIST          (WM_USER+639)

#define ICO_AREA_NORMAL   0
#define ICO_AREA_SELECT   0
#define ICO_DEV_LOGIN     1
#define ICO_DEV_LOGOUT    2
#define ICO_DEV_AIL       3
#define ICO_CH_ENABLE     4
#define ICO_CH_DISABLE    12
#define ICO_CH_PREVIEW    5
#define ICO_CH_RECORD     6
#define ICO_CH_RECVPRE    7

#define COPYDATA_CLEAR    2
#define COPYDATA_MAX      1
#define COPYDATA_MIN      0

enum { User_Common,User_Admin,User_Super}; 
enum { Disable_Auto_LOGIN,Enable_Auto_LOGIN};
enum { Protocol_Tcp,Protocol_Udp,Protocol_Mcast};  
enum { Login_Common,Login_Change,Login_Lock}; 
enum { MessageWndType_Com,MessageWndType_Cap,MessageWndType_Rec}; 
enum { WndType_PreView,WndType_PlayBack,WndType_Map};
enum { PlayType_Play,PlayType_Stop,PlayType_Pause,PlayType_SingleFrame};
enum { FileDowm_Not,FileDowm_Waitting,FileDowm_Downing,FileDowm_Complete};
enum { Alarm_LocalCtr}; 
enum { PreviewType_Single,PreviewType_Poll,PreviewType_Group};
enum { DevTreeType_Area,DevTreeType_Dev,DevTreeType_Ch};

typedef enum _PICTURE_SIZE
{
    SIZE_CIF,
    SIZE_HD1,
    SIZE_D1,
    SIZE_UXGA,
    SIZE_SVGA,
    SIZE_HD720p,
    SIZE_VGA
}PICTURE_SIZE;

#define  XML_FILENAME    "Systemcfg.xml"
#define  XML_PICTURE     "Picture"
#define  XML_RECORD      "Record"
#define  XML_DOWNPIC     "DownPic"
#define  XML_DOWNRECORD  "DownRecord"
#define  XML_REMOTECONFIG "RemoteConfig"
#define  XML_ALARMFILE    "AlarmFile"
#define  XML_ALARMFILE    "AlarmFile"
#define  XML_RES_SIZE      "ResSize"
#define  XML_SWITCH_TIME   "SwitchTime"
#define  XML_COVER_FLAG    "CoverFlag"
#define  XML_DISK		  "Disk"
#define  XML_DISK_NAME    "DiskName"
#define  XML_RECFILE_TYPE   "FileType"
#define  XML_SHOW_CAPTION   "ShowCaption"
#define  XML_PREVIEWWNDSPLITER   "PreviewWndSpliter"
#define  XML_PREWNDSPTYPE   "PreWndSpType"
#define  XML_PREVIEWWNDSAVE   "PreviewWndSave"
#define  CAPTURE_FLODER  "Capture"
#define  DOWN_FLODER     "DownLoad"
#define  DOWN_PIC		 "Picture"
#define  DOWN_REC        "RecordFile"
#define  REMOTE_CONFIG   "RemoteConfig"
#define  ALARM_FILE		 "Sound\\Alarm.WAV"
#define  MAP_FLODER		 "MAP\\"
#define  SKINPATH	      "Skin\\"
#define  ABOUT_CONFIGFILE    "Verinfo.ini"
#define  ADMINPWD		     "RaySharp"


typedef struct _CHANNEL_INFO__
{
	BYTE    Type;
	HTREEITEM hItem;
	char    ChannelID[128];	//ݿͨID
	char    DevID[128];		//ݿ豸ID
	int     iChannelNo;
	char    ChName[128];
	int		iStreamType;	//0  1 Ƶ
	int     iCodeStreamType;// 0 1
	int		iProtocolType;
	BOOL    bPreview;
	BOOL    bRecord;
	RSNetPreview iPreviewID;
	ULONG   iPlayID;
	int     iWndIndex;
	BOOL    bAutoScan;//Զɨ
	char    MapPinID[128];	
	BOOL    bMapPin;
	BOOL    bMapPlay;
	int     iMapVieoWndIndex;
	BOOL    bRecPlay;
	int     iRecWndIndex;
	BOOL    bRecDown;
	BOOL    bDefence;//
	BOOL	bFlicker;//ͼ˸
	BOOL    bAlarmRec;
	BOOL    bAlarmSound;
	BOOL    bAlarmCapture;
	BOOL    bAlarmPreview;
	int		alarmTime; //ʱ
	ULONG   iAlarmPlayID;
	BOOL    bAlarmPinIco;
	RSNetPreview iAlarmPreviewID;
}CHANNEL_INFO;

typedef struct _SERVER_INFO__
{
	BYTE		Type;
	BOOL		bUseFlag;
	BOOL		bLinkState;//豸״̬
	BOOL		bDualTalk;
	BOOL		bAutoLogin;
	BOOL 		bAlarmRptDesired;//ĸ澯
	UINT		iPort;
	ULONG		lDualtalkID;
	CString		szIp;
	CString		szName;
	CString		szPasswd;
	CString		szUser;
	CString		DevID;//豸Ψһʶ
	CString     AreaID;//Ψһʶ
	HTREEITEM   hItem; 
	RSNetConnection pNetConnection;
	RSNetDualtalk pNetDualtalk;
	LoginRsp DevLoginRsp;
	UINT     chIndex;
    DevChnInfo* pDevChnInfo;
}SERVER_INFO;

typedef struct _AREA_INFO__
{
	BYTE		Type;
	CString		strAreaID;
	CString     strAreaName;
	HTREEITEM   hItem; 
}AREA_INFO;

	
typedef struct _MAP_INFO__
{
	char    MapID[128];//ݿID
	HTREEITEM hItem; 
}MAP_INFO;


typedef struct  _drive_t
{
	char  drivename[16];
	bool  IsUse;
	char  unuse[3];
}drive_t;

typedef	struct	_alarm_info_t
{
	unsigned int alarm_type;
	SERVER_INFO* pServerInfo;
	void* data;
	DWORD startTime;
	UINT chNum;
}alarm_info_t;

///////CPUЧ
typedef struct _THREAD_INFO
{
	LARGE_INTEGER CreateTime;
	DWORD dwUnknown1;
	DWORD dwStartAddress;
	DWORD StartEIP;
	DWORD dwOwnerPID;
	DWORD dwThreadId;
	DWORD dwCurrentPriority;
	DWORD dwBasePriority;
	DWORD dwContextSwitches;
	DWORD Unknown;
	DWORD WaitReason;
}THREADINFO, *PTHREADINFO;
typedef struct _UNICODE_STRING
{
	USHORT Length;
	USHORT MaxLength;
	PWSTR Buffer;
} UNICODE_STRING;
typedef struct _PROCESS_INFO
{
	DWORD dwOffset;
	DWORD dwThreadsCount;
	DWORD dwUnused1[6];
	LARGE_INTEGER CreateTime;
	LARGE_INTEGER UserTime;
	LARGE_INTEGER KernelTime;
	UNICODE_STRING ProcessName;
	DWORD dwBasePriority;
	DWORD dwProcessID;
	DWORD dwParentProcessId;
	DWORD dwHandleCount;
	DWORD dwUnused3[2];
	DWORD dwVirtualBytesPeak;
	DWORD dwVirtualBytes;
	ULONG dwPageFaults;
	DWORD dwWorkingSetPeak;
	DWORD dwWorkingSet;
	DWORD dwQuotaPeakPagedPoolUsage;
	DWORD dwQuotaPagedPoolUsage;
	DWORD dwQuotaPeakNonPagedPoolUsage;
	DWORD dwQuotaNonPagedPoolUsage;
	DWORD dwPageFileUsage;
	DWORD dwPageFileUsagePeak;
	DWORD dCommitCharge;
	THREADINFO ThreadSysInfo[1];
} PROCESSINFO, *PPROCESSINFO;

typedef struct  _weekDay_t
{
	BYTE Month;    
	/*ʼܣ0-һܣ1-ڶܣ2-ܣ3-,4-*/
	BYTE Week;
	/*ʼڼ0-Sun,1-Mon, ...6-Sat*/
	BYTE WeekDay;
}weekDay;

BOOL JudgeNumSetString(char* pszString);
BOOL CheckPassword(CString StrTemp); 
BOOL GetDiskDrive(CString strDrive[], int &count);
void CreateFoler(CString strPath);
CString  GetAppPath();
int  CompareTime(SYSTEMTIME posTime,SYSTEMTIME cmpTime);
int GetProcessCpu(int id);//ǽID
CRect RectSizeWithConstantRatio( CRect* rcScreen, CSize sizePicture,BOOL bCenter);
void GetSplitRectByNum(CRect* pRectList,CRect rectOrg,int nRows,int nCols);
void SplitRectByNum(CRect rectOrg, int nNum,CRect* pRectList,LPCRECT lpDeRect,int nSplitType=0);
void GetRectFromList(CRect &rectWnd,int nTop,int nBottom,CRect* pRectList);
int  CompareWeekDay(weekDay beginWeek,weekDay endWeek);
COLORREF StrToColor(CString strColor);
CString ColorToStr( COLORREF color);
#endif  // #ifndef __RS_GLOBAL_H__