#ifndef __RSNet_h__
#define __RSNet_h__

#include "RSTypedef.h"
#include "RSNetParameter.h"
#include "RSNetProtocol.h"

#ifdef _WIN32
#  ifdef RSNET_EXPORTS
#    define RSNET_API __declspec(dllexport)
#  else
#    define RSNET_API __declspec(dllimport)
#  endif
#  define RSNET_CALL __stdcall
#else
#  define RSNET_API
#  define RSNET_CALL
#endif

//////////////////////////////////////////////////////////////////////////
//豸

//RSNetSearchDevParam.Callback
//devΪNULLFALSEȡٵøûص
//ע⣺ֻеȡ󣬲Ļص漰Դܻᷢ
typedef BOOL (RSNET_CALL* RSNetSearchDevCallback)(const SearchDevRsp* dev, void* userParam);

typedef struct 
{
	RSNetSearchDevCallback Callback;
	void* UserParam;
    BYTE  LoginClientType;//1: 2:Zip  3:CDoubles    4:Raydin 6:optimus
    BYTE  reserve[3];
}RSNetSearchDevParam;

//////////////////////////////////////////////////////////////////////////
//http

//RSNetHttpReq.Callback
//bufΪNULLFALSEȡٵøûص
//ע⣺ֻеȡ󣬲Ļص漰Դܻᷢ
typedef BOOL (RSNET_CALL* RSNetHttpReqCallbackGeneral)(const void* buf, int len, void* userParam);

typedef struct 
{
	char*    buf;//httpʽ
	int      len;//ݳ
	PCSTR    IP; //IPַ
	UINT     Port; //IE ˿
	UINT     timeout; //ʱʱ(s)
	RSNetHttpReqCallbackGeneral Callback;
	void* UserParam;
	char szHeadFlag[32];   //ӦϢβʶ 
}RSNetHttpReqGeneral;

typedef struct
{
    char*    buf;//httpʽ
    int      len;//ݳ
    char*    IP; //IPַ
    UINT     Port; //IE ˿
    int      nRecvTimeout;
    int      nSendTimeOut;
    int      bReConnect;
    int      nReConnectCount;
    int      nIntervalTimeOut;
    char     szHeadFlag[32];   //ӦϢβʶ
    void*    UserParam;
    RSNetHttpReqCallbackGeneral Callback;
}RSNetHttpReqEx;

typedef void* RSNetIDConnection;
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
//P2P
typedef BOOL (RSNET_CALL* RSNetP2PTunnelReqCallback)(const void* buf, int len, void* userParam);

typedef struct
{
    char*    pID;
    int      nMediaPort;
    int      bReConnect;
    int      nReConnectCount;
    int      nIntervalTimeOut;
    void*    UserParam;
    RSNetP2PTunnelReqCallback Callback;
}RSNetP2PTunnelReq;

typedef void* RSNetP2PTunnelConnection;
//////////////////////////////////////////////////////////////////////////

//Ϣص
//waram
//RSNetConnection msg
#define RSNetMsgConnectStart				0
#define RSNetMsgConnectSuccess				1
#define RSNetMsgConnectFail					2
#define RSNetMsgConnectClosed				3
#define RSNetMsgConnectStop                 4
#define RSNetMsgLoginRequest				100
#define RSNetMsgLoginSuccess				101
#define RSNetMsgLoginUserLogined			102
#define RSNetMsgLoginNoUserName				103
#define RSNetMsgLoginPasswordError			104
#define RSNetMsgLoginFail					105
#define RSNetMsgLoginNoRight                106
#define RSNetMsgIpFilter					107
#define RSNetMsgOverMaxUser                 108
#define RSNetMsgNotSupportLoginType         109
#define RSNetMsgLoginUserDisable			110
#define RSNetMsgLoginForceChangePWD			111
#define RSNetMsgLoginForceCloseBrowser		112
#define RSNetMsgLoginForbidIP               113
#define RSNetTypeP2P                        121
#define RSNetTypeP2PRelay                   122
#define RSNetMsgSendP2PInfoSuccess          123
#define RSNetMsgSendP2PInfoFailed           124
#define RSNetMsgSendInfoSuccess             125
#define RSNetMsgSendInfoFailed              126
//RSNetPreview msg
#define RSNetMsgPreviewWaitLogin			200
#define RSNetMsgPreviewOpenStream			201
#define RSNetMsgPreviewOpenStreamSuccess	202
#define RSNetMsgPreviewOpenStreamFail		203
#define RSNetMsgPreviewStreamClosed			204
#define RSNetMsgPreviewDevOffLine           205
#define RSNetMsgPreviewDevOnLine            206  
#define RSNetMsgPreviewCloseVideo           207
#define RSNetMsgPreviewMaxPrevNumErr        208
//RSNetDownloadRecord RSNetDownloadRecordStatusCallback.code
#define RSNetMsgDownloadRecordClosed		290 //ؽ
#define RSNetMsgDownloadRecordOK			291 //һļ
#define RSNetMsgDownloadRecordNoFile		292 //һļ
#define RSNetMsgDownloadRecordFail			293 //ļʧ
#define RSNetMsgDownloadRecordStoreFail		294 //ļ洢ʧ
#define RSNetMsgDownloadRecordPercent		295 //param = percent
//RSNetRecordPlay msg
#define RSNetMsgRecordPlayClosed			300
#define RSNetMsgRecordPlayNoData			301
#define RSNetMsgRecordPlayWaitLogin			302
#define RSNetMsgRecordPlayOpenStream		303
#define RSNetMsgRecordPlayOpenStreamSuccess	304
#define RSNetMsgRecordPlayOpenStreamFail	305
#define RSNetMsgRecordPlayDevicePlayback    306
#define RSNetMsgRecordPlayHDDFormat         307
#define RSNetMsgNoBandWidth                 308
#define RSNetMsgNoPreviewAuth               309
#define RSNetMsgRecordPlayIFrameEnd         309
#define RSNetMsgNoPlaybackAuth              310
#define RSNetMsgIsModifyHdd					311
#define RSNetMsgRecordPlayMutexPlayback     322
#define RSMetMsgPreviewActivateFaile        323

//RSNetDualtalk msg 
#define RSNetMsgDualtalkClosed				350
//RSNetRemoteUpgrade RSNetRemoteUpgradeCallback.code
#define RSNetMsgRemoteUpgradeClosed			390 //Ͽ
#define RSNetMsgRemoteUpgradeOK				391 //ļ
#define RSNetMsgRemoteUpgradeReadFileFail	392 //ȡļʧ
#define RSNetMsgRemoteUpgradeInvalidFile	393 //Ϸļ
#define RSNetMsgRemoteUpgradePercent		394 //param = percent
#define RSNetMsgRemoteUpgradeVerError		395 //ļ豸ƥǰ汾̫
#define RSNetMsgRemoteUpgrading				396 //豸
#define RSNetMsgRemoteUpgradeVerSame        397 //ļ汾豸汾ͬ,Ҫ
#define RSNetMsgRemoteUpgradeLanguageError  398
#define RSNetMsgRemoteInUserInterface       399 //ûڲ

#define RSNetMsgFtpIsUpgrade                400 //ǷFTP
#define RSNetMsgFtpUpgrading                401 //״̬
#define RSNetMsgRemoteUpgradeIPCPercent     402 //IPC״̬
#define RSNetMsgSensorRpt					403 //AlarmKitҳSensor澯

//lparam = UserParam
#define RSNetTestBusy                       801
//////////////////////////////////////////////////////////////////////////
// RSNetGetLastError
#define RSNetSuccess					0
#define RSNetEDualtalkBusy				0xE1010001
#define RSNetEParam						0xE1010051
#define RSNetENoRight					0xE1010052

//////////////////////////////////////////////////////////////////////////
//豸

//RSNetConnectionParam.MotionAlarmRptCallback
typedef void (RSNET_CALL* RSNetAlarmRptCallback)(WORD type, void* data, UINT size, void* userParam);
//connection status callback function
typedef void (RSNET_CALL* RSNetConnectionCallback)(WPARAM wparam, LPARAM lparam);
typedef struct
{
	PCSTR IP;
	UINT Port;
	PCSTR UserName;
	PCSTR Password;
	HWND Wnd;
	UINT Message;
	void* UserParam;
	BOOL AutoReconnect;
	RSNetAlarmRptCallback AlarmRptCallback;
	BOOL AlarmRptDesired;
	RSNetConnectionCallback ConnCallback;
}RSNetConnectionParam;

typedef enum{
    LOGIN_TYPE_IP = 0,
    LOGIN_TYPE_ID,//anlian id and urmet id
    LOGIN_TYPE_TUTK_ID,
    LOGIN_TYPE_LANGTAO_ID,
    LOGIN_TYPE_LOREX_ID,
    LOGIN_TYPE_VVSEE_ID,
    LOGIN_TYPE_SHANGYUN_ID,
    LOGIN_TYPE_RSVV_ID,
    LOGIN_TYPE_HSD,
    LOGIN_TYPE_SHANGYUN_V2_ID,
    LOGIN_TYPE_SAMSUNG_DDNS_ID,
    LOGIN_TYPE_URMET_ID_V2 //urmet id start with ur
}LOGIN_TYPE;

enum {
    NET_NORMAL = 0,
    NET_P2P
};

enum {
    P2P_TYPE_NONE = 0,
    P2P_TYPE_LOREX   = 1,
    P2P_TYPE_LANGTAO,
    P2P_TYPE_TUTK,
    P2P_TYPE_VVSEE,
    P2P_TYPE_SHANGYUN
};

typedef struct
{
    PCSTR IP;
    UINT Port;
    PCSTR UserName;
    PCSTR Password;
    HWND Wnd;
    UINT Message;
    void* UserParam;
    BOOL AutoReconnect;
    RSNetAlarmRptCallback AlarmRptCallback;
    BOOL AlarmRptDesired;
    RSNetConnectionCallback ConnCallback;
    int   nLoginType;//value from LOGIN_TYPE
    PCSTR IDServerName;
	BYTE  language;//gy 12.18 IPC  شûѡ
    BYTE  reserve;
	BYTE  LoginClientType;//1: 2:Zip  3:CDoubles 4:Raydin  5:Hello CCTV 6:optimus
    BYTE  reserve1;
}RSNetConnectionParamEx;

//Email test  
typedef void (RSNET_CALL* RSRemoteTestCallback)(WORD type, void* data, UINT size, void* userParam);
typedef struct
{
	WORD  type;
	void* data;
	UINT  dataSize;
	void* UserParam;
	RSRemoteTestCallback remoteTestCallback;
	UINT TimeOut;      //ʱʱ
}RSNetRemoteTestParam;

typedef void* RSNetConnection;
typedef UINT  RSRemoteMsgHandle;
typedef UINT  RSRecordSearch;
typedef UINT  RSPictureSearch;
typedef void* RSNetThumbnailsConn;
typedef void* RSNetTimingConn;
//////////////////////////////////////////////////////////////////////////
//Ԥ

//RSNetPreviewParam.Protocol
#define RSNetPreviewTcp		0
#define RSNetPreviewUdp		1

//RSNetPreviewParam.DataCallback
typedef void (RSNET_CALL* RSNetPreviewDataCallback)(void* data, UINT size, void* userParam);
typedef void (RSNET_CALL* RSNetPreviewStatusCallback)(WPARAM wparam, LPARAM lparam);
typedef struct 
{
	PreviewParam Param;
	UINT Protocol; //TCP,UDP
	BOOL AutoReconnect;
	RSNetPreviewDataCallback DataCallback;
	void* UserParam;
    HWND Wnd;
    UINT Message;
    RSNetPreviewStatusCallback StatusCallback;
}RSNetPreviewParam;

typedef void* RSNetPreview;


//////////////////////////////////////////////////////////////////////////
//¼ѯ

//RSNetQueryRecordParam.DetailCallback
typedef void (RSNET_CALL* RSNetQueryRecordDetailCallback)(const RecordDetailRsp* rsp, void* userParam);
typedef void (RSNET_CALL* RSNetNewQueryRecordDetailCallback)(const NewRecordDetailRsp* rsp, void* userParam);

//RSNetQueryRecordParam.DayOutlineCallback
typedef void (RSNET_CALL* RSNetQueryRecordDayOutlineCallback)(const RecordDayOutlineRsp* rsp, void* userParam);

typedef struct
{
	UINT Type; //MsgRecordDetail...
	QueryRecordReq Req;
	RSNetQueryRecordDetailCallback DetailCallback;
	RSNetQueryRecordDayOutlineCallback DayOutlineCallback;
	void* userParam;
}RSNetQueryRecordParam;

typedef struct
{
    UINT Type; //MsgRecordDetail...
    QueryRecordReq Req;
    RSNetQueryRecordDetailCallback DetailCallback;
    RSNetQueryRecordDayOutlineCallback DayOutlineCallback;
    void* userParam;
    BYTE StreamType; //0 main; 1 sub; 2 mobile;
    BYTE reserve[15];
}RSNetQueryRecordParamEx;

typedef struct
{
    UINT Type; //MsgRecordDetail...
    QueryRecordReq Req;
    RSNetNewQueryRecordDetailCallback DetailCallback;
    RSNetQueryRecordDayOutlineCallback DayOutlineCallback;
    void* userParam;
    BYTE StreamType; //0 main; 1 sub; 2 mobile;
    BYTE reserve[15];
}RSNetNewQueryRecordParamEx;

//ͼƬѯɾ
typedef void (RSNET_CALL* RSNetDelPictureCallback)(int msg, void* userParam);
typedef struct
{
    UINT Type; //MsgQueryJpgDetail or MsgDelJpg
    QueryRecordReq Req;
    RSNetQueryRecordDetailCallback QueryPictureCallback;
    RSNetDelPictureCallback        DelPictureCallback;
    void* userParam;
}RSNetQueryOrDelPictureParam;

//////////////////////////////////////////////////////////////////////////
//¼

//RSNetDownloadRecordParam.StatusCallback
typedef void (RSNET_CALL* RSNetDownloadRecordStatusCallback)(UINT code, UINT param, void* userParam);

#ifndef RSFileType
#  define RSFileType	   1 //.264  .rf
#endif
#ifndef RSAVIFileType
#  define RSAVIFileType	   2 //.avi
#endif
#ifndef RSTEKVFileType
#  define RSTEKVFileType   3 //only for tekversion
#endif
#ifndef RSMP4FileType
#  define RSMP4FileType    4 //.mp4
#endif

//RSNetDownloadRecordParam.LocalParam
typedef struct
{
	char FileName[MAX_PATH];
	UINT FileType;
}RSNetDownloadRecordLocalParam;

typedef struct
{
	UINT Channel;
	const RecordDetailRsp* DevRecordFile;
	const RSNetDownloadRecordLocalParam* LocalParam;
	RSNetDownloadRecordStatusCallback StatusCallback;
	void* UserParam;
}RSNetDownloadRecordParam;

typedef void (RSNET_CALL* RSNetDownloadRecordStatusCallbackEx)(UINT code, UINT param, UINT nIndex, void* userParam);

typedef struct 
{
    UINT Channel;
    const RecordDetailRsp* DevRecordFile;
    const RSNetDownloadRecordLocalParam* LocalParam;
    UINT nFileCount;
    BYTE nDownLoadType;//0:Download by file, 1:Download by time
    BYTE StreamType; //0 main; 1: sub; 2 mobile;
    BYTE reserve[2];
    RSNetDownloadRecordStatusCallbackEx StatusCallback;
    void* UserParam;
}RSNetDownloadRecordParamEx;

typedef void* RSNetDownloadRecord;
typedef void* RSNetDownloadPicture;


//////////////////////////////////////////////////////////////////////////
//¼ط

//RSNetRecordPlayParam.DataCallback
typedef BOOL (RSNET_CALL* RSNetRecordPlayDataCallback)(void* data, UINT size, void* userParam);
typedef void (RSNET_CALL* RSNetRecordStatusCallback)(UINT code, void* userParam);
typedef struct
{
	UINT Channel;
	UINT Type; //NormalRecord...
	DateTime Begin;
	DateTime End;

	RSNetRecordPlayDataCallback DataCallback;
    RSNetRecordStatusCallback   StatusCallback;
	void* UserParam;
	HWND Wnd;
	UINT Message;
}RSNetRecordPlayParam;

typedef struct
{
    UINT Channel;
    UINT Type; //NormalRecord...
    DateTime Begin;
    DateTime End;

    RSNetRecordPlayDataCallback DataCallback;
    RSNetRecordStatusCallback   StatusCallback;
    void* UserParam;
    HWND Wnd;
    UINT Message;
    BYTE StreamType; //0 main; 1 sub; 2 mobile;
    BYTE reserve[15];
}RSNetRecordPlayParamEx;

typedef void* RSNetRecordPlay;
typedef void* RSNetCaptureIFramePlay;


//////////////////////////////////////////////////////////////////////////
//Խ

//RSNetDualtalkParam.DataCallback
typedef void (RSNET_CALL* RSNetDualtalkDataCallback)(void* data, UINT size, void* userParam);

typedef struct
{
	RSNetDualtalkDataCallback DataCallback;
	void* UserParam;
	HWND Wnd;
	UINT Message;
}RSNetDualtalkParam;

typedef void* RSNetDualtalk;


//////////////////////////////////////////////////////////////////////////
//

//RSNetQueryParamParam.ParamCallback
typedef void (RSNET_CALL* RSNetParamCallback)(void* param, void* userParam);

//RSNetQueryParamParam.ListParamCallback
typedef void (RSNET_CALL* RSNetListParamCallback)(void* listParam, void* userParam); 

typedef struct
{
	UINT ParamType; //
	void* Req;
	UINT ParamSize; //ӦĽṹĴС
	RSNetParamCallback ParamCallback;
	UINT ListParamSize; //ӦĽṹĴС
	RSNetListParamCallback ListParamCallback;
	void* UserParam;
	UINT TimeOut;      //ʱʱ
}RSNetQueryParamParam;

typedef struct
{
	UINT ParamMainType; //Ϣ
	UINT ParamSubType; //Ϣ
	void* Req;
	void* Param;
	UINT ReqLen;
	UINT ParamSize; //ӦĽṹĴС
	RSNetParamCallback ParamCallback;
	UINT ListParamSize; //ӦĽṹĴС
	RSNetListParamCallback ListParamCallback;
	void* UserParam;
}RSNetQueryTemporaryParamParam;

typedef struct
{
	UINT ParamType; //
	void* Req;
	void* Param;
	UINT ParamSize; //ӦĽṹĴС
	void* ListParam;
	UINT ListParamSize; //ӦĽṹĴС
	UINT ListParamNum;
	UINT TimeOut;      //ʱʱ
}RSNetQueryParamParamEx;

typedef struct
{
	UINT ParamType;
	void* Param;
	void* ListParams;
	UINT ListParamNum;
	UINT TimeOut;      //ʱʱ
}RSNetSetParamParam;

typedef struct
{
	UINT ParamMainType; //Ϣ
	UINT ParamSubType; //Ϣ
	void* Param;
	UINT ParamSize; //ӦĽṹĴС
	void* ListParams;
	UINT ListParamNum;
	BOOL  bNeedSize; //ṹǰҪҪС
}RSNetSetParamParamEx;

//////////////////////////////////////////////////////////////////////////
//Զ

//RSNetRemoteUpgradeParam.Callback
typedef void (RSNET_CALL* RSNetRemoteUpgradeCallback)(UINT code, void* param, void* userParam);

typedef struct
{
	PCSTR FileName;
	RSNetRemoteUpgradeCallback Callback;
	void* UserParam;
	int filetype;//if it's new upgrade, then set filetype = 3; 
                 //if it's urmet ipc upgrade, then set filetype = 4
                 //if it's raysharp ipc upgrade, then set filetype = 5
    UINT nChannelMask;// for ipc
}RSNetRemoteUpgradeParam;

typedef void* RSNetRemoteUpgrade;
//////////////////////////////////////////////////////////////////////////
//ץͼ
typedef struct
{
	UINT Channel;
	void* UserParam;
	char FileName[MAX_PATH];
	NET_DVR_JPEGPARA jpgParam;
}RSNetDevCaptureParam;
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
//
typedef struct
{
	UINT ParamMainType; //Ϣ
	UINT ParamSubType; //Ϣ
	void* Param;
	UINT ParamSize; //ӦĽṹĴС
}RSNetCmdParam;
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
//
typedef struct
{
    PCSTR                   IP;
    UINT                    Port;
    int                     nLoginType;//value from LOGIN_TYPE
    PCSTR                   IDServerName;

    void*                   UserParam;
    RSNetConnectionCallback ConnCallback;

    void*                   SendParam;
    int                     SendParamSize;
    BYTE                    reserve[4];
}RSNetSendParam;
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
//ѯ־
typedef void (RSNET_CALL* RSNetQueryLogCallback)(void* data, UINT size, void* userParam);
typedef struct
{
    LogSearchInput_t *param;
    void* UserParam;
    RSNetQueryLogCallback DataCallback;
}RSNetQueryLogParam;

typedef struct
{
    UINT  ParamMainType; //Ϣ
    UINT  ParamSubType;  //Ϣ
    void* Req;
    UINT  ReqLen;
    void* Param;
    UINT  ParamSize;    //ӦĽṹĴС
    UINT  TimeOut;      //ʱʱ
    BYTE  reserve[4];
}RSNetReqParam;

typedef void (RSNET_CALL* RSNetExportBackupCallback)(void* data, UINT size, void* userParam);
typedef struct
{
    void* UserParam;
    RSNetExportBackupCallback DataCallback;
}RSNetExportBackupParam;


/********************************************/
typedef enum THUMBNAILS_DECODE_TYPE_E{
    UNKNOWN_ERROR = 0,
    UNKNOWN_TYPE,
    SAVE_FILE_ERROR,
    NOT_FOUND,
    DECODE_FAILED,
    JPEG_PICTURE,
    PNG_PICTURE,
    I_FRAME
}THUMBNAILS_DECODE_TYPE;
typedef struct {
    ThumbnailRsp*          rsp;
    void*                  frame_head;
    THUMBNAILS_DECODE_TYPE type;
    const char*            file_name;//full name of picture
    char                   reserve[16];
}ThumbnailsDecode;
//attention if info == NULL means over
typedef void (RSNET_CALL* RSNetPlaybackThumbnailsCallback)(ThumbnailsDecode* info, void* user_param);

typedef struct
{
    NewRecordDetailRsp*     list_param;//start of RecordDetailRsp
    int                     list_param_size;//the number of RecordDetailRsp

    RSNetPlaybackThumbnailsCallback callback;
    void*                           user_param;

    const char*             file_directory;
    THUMBNAILS_DECODE_TYPE  picture_type;//JPEG_PICTURE or PNG_PICTURE

    unsigned char           reserve[12];
}RSNetPlaybackThumbnailsParam;
/********************************************/

/********************************************/
typedef struct {
    SnapPicForP2PResp*     rsp;
    THUMBNAILS_DECODE_TYPE type;
    const char*            file_name;//full name of picture
    char                   reserve[16];
}SnapPicRespInfo;
typedef void (RSNET_CALL* RSNetChannelThumbnailsCallback)(SnapPicRespInfo* info, void* user_param);
typedef struct
{
    SnapPicForP2PReq*       list_param;//start of SnapPicForP2PReq
    int                     list_param_size;//the number of SnapPicForP2PReq

    RSNetChannelThumbnailsCallback callback;
    void*                          user_param;

    const char*             file_directory;
    THUMBNAILS_DECODE_TYPE  picture_type;//JPEG_PICTURE or PNG_PICTURE

    unsigned char           reserve[12];
}RSNetChannelThumbnailsParam;
/********************************************/

/********************************************/
typedef void (RSNET_CALL* RSNetTimingCallback)(RSNet_WizardInfo_t* info, void* user_param);
typedef struct {
    RSNetTimingCallback callback;
    void*               user_param;
    RSNet_WizardInfo_t* info;
    unsigned char       reserve[16];
}RSNetTimingParam;
/********************************************/

#ifdef __cplusplus
extern "C" {
#endif

RSNET_API BOOL RSNET_CALL RSNetInit();
RSNET_API void RSNET_CALL RSNetRelease();

RSNET_API UINT RSNET_CALL RSNetGetLastError();

RSNET_API void RSNET_CALL RSNetSetEncription(BOOL bEncription);

//豸
RSNET_API void RSNET_CALL RSNetSearchDev(const RSNetSearchDevParam* param);

//豸IPϢ
RSNET_API BOOL RSNET_CALL RSNetSetDevInfo(const NetMDevInfoReq* param);
RSNET_API BOOL RSNET_CALL RSNetSetNewDevInfo(const NewNetMDevInfoReq* param);

//Http
RSNET_API void RSNET_CALL RSNetHttpReqDev(RSNetHttpReqGeneral* param);
RSNET_API RSNetIDConnection RSNET_CALL RSNetHttpReqDevStart(RSNetHttpReqEx* param);
RSNET_API void RSNET_CALL RSNetHttpReqDevStop(RSNetIDConnection* conn);

//豸
RSNET_API RSNetConnection RSNET_CALL RSNetConnectionStart(const RSNetConnectionParam* param);
RSNET_API RSNetConnection RSNET_CALL RSNetConnectionStartEx(const RSNetConnectionParamEx* param);
RSNET_API void RSNET_CALL RSNetConnectionStop(RSNetConnection* conn);
RSNET_API BOOL RSNET_CALL RSNetSetIPAndPort(RSNetConnection* conn,PCSTR strIP,UINT Port);

RSNET_API BOOL RSNET_CALL RSNetGetDevInfo(RSNetConnection conn, LoginRsp* info, UINT infoSize/*=sizeof(LoginRsp)*/);
RSNET_API BOOL RSNET_CALL RSNetGetDevInfoEx(RSNetConnection conn, void* info, UINT infoSize/*=sizeof(LoginRsp)*/);
//Ԥ
RSNET_API RSNetPreview RSNET_CALL RSNetStartPreview(RSNetConnection conn, const RSNetPreviewParam* param);
RSNET_API void RSNET_CALL RSNetStopPreview(RSNetConnection conn, RSNetPreview* preview);
RSNET_API ULONGLONG RSNET_CALL RSNetGetPreviewBitRate(RSNetConnection conn, RSNetPreview preview);
RSNET_API BOOL  RSNET_CALL RSNetForceIFrame(RSNetConnection conn,BYTE channel,BYTE codeStreamType );//Force I frame

//̨ type=MsgPTZUp...
RSNET_API BOOL RSNET_CALL RSNetPTZControl(RSNetConnection conn, UINT type, PTZControlReq* req);

//Email,ddns,Remote reboot Test
RSNET_API BOOL RSNET_CALL RSNetRemoteTest(RSNetConnection conn, const RSNetRemoteTestParam* param);
RSNET_API RSRemoteMsgHandle RSNET_CALL RSNetRemoteTestEx(RSNetConnection conn, const RSNetRemoteTestParam* param);
RSNET_API void RSNET_CALL RSNetRemoteTestStopEx(RSNetConnection conn, const RSNetRemoteTestParam* param, RSRemoteMsgHandle  handle);

//¼ѯ
RSNET_API BOOL RSNET_CALL RSNetQueryRecord(RSNetConnection conn, const RSNetQueryRecordParam* param);
RSNET_API RSRecordSearch RSNET_CALL RSNetAsyncQueryRecord(RSNetConnection conn, const RSNetQueryRecordParam* param);
RSNET_API BOOL RSNET_CALL RSNetQueryRecordEx(RSNetConnection conn, const RSNetQueryRecordParamEx* param);
RSNET_API RSRecordSearch RSNET_CALL RSNetAsyncQueryRecordEx(RSNetConnection conn, const RSNetQueryRecordParamEx* param);
RSNET_API void RSNET_CALL RSNetAsyncQueryRecordStop(RSNetConnection conn, RSRecordSearch  handle);

//豸ץͼ
RSNET_API BOOL RSNET_CALL RSNetCapture(RSNetConnection conn, const RSNetDevCaptureParam* param);
//¼
RSNET_API RSNetDownloadRecord RSNET_CALL RSNetStartDownloadRecord(RSNetConnection conn, const RSNetDownloadRecordParam* param);
RSNET_API RSNetDownloadRecord RSNET_CALL RSNetStartDownloadRecordEx(RSNetConnection conn, const RSNetDownloadRecordParamEx* param);
RSNET_API void RSNET_CALL RSNetStopDownloadRecord(RSNetDownloadRecord* downloadRecord);
//¼ط
RSNET_API RSNetRecordPlay RSNET_CALL RSNetStartRecordPlay(RSNetConnection conn, const RSNetRecordPlayParam* param);
RSNET_API RSNetRecordPlay RSNET_CALL RSNetStartRecordPlayEx(RSNetConnection conn, const RSNetRecordPlayParamEx* param);
RSNET_API void RSNET_CALL RSNetStopRecordPlay(RSNetRecordPlay* recordPlay);
RSNET_API void RSNET_CALL RSNetReqRecordData(RSNetRecordPlay recordPlay);
RSNET_API void RSNET_CALL RSNetReposRecordData(RSNetRecordPlay recordPlay, const ReposRecordDataReq* req);
RSNET_API void RSNET_CALL RSNetReplayRecordData(RSNetRecordPlay recordPlay);
RSNET_API void RSNET_CALL RSNetReqRecordPlayCtrol(RSNetRecordPlay recordPlay, WORD msgSubtype);

//Խ
//RSNetStartDualtalkNULL, ԵRSNetGetLastErrorȡʧԭ
RSNET_API RSNetDualtalk RSNET_CALL RSNetStartDualtalk(RSNetConnection conn, const RSNetDualtalkParam* param);
RSNET_API void RSNET_CALL RSNetStopDualtalk(RSNetDualtalk* dualtalk);
RSNET_API void RSNET_CALL RSNetSendDualtalkData(RSNetDualtalk dualtalk, void* data, UINT size);

//
RSNET_API BOOL RSNET_CALL RSNetQueryParam(RSNetConnection conn, const RSNetQueryParamParam* param);
RSNET_API BOOL RSNET_CALL RSNetQueryParamEx(RSNetConnection conn, const RSNetQueryParamParamEx* param);
RSNET_API BOOL RSNET_CALL RSNetQueryDefaultParam(RSNetConnection conn, const RSNetQueryParamParam* param, UINT nMainMsgType/* = MsgDefaultParam*/);
RSNET_API BOOL RSNET_CALL RSNetQueryDefaultParamEx(RSNetConnection conn, const RSNetQueryParamParamEx* param, UINT nMainMsgType/* = MsgDefaultParam*/);
RSNET_API BOOL RSNET_CALL RSNetQueryTemporaryParam(RSNetConnection conn, const RSNetQueryTemporaryParamParam* param);
RSNET_API BOOL RSNET_CALL RSNetSetParam(RSNetConnection conn, const RSNetSetParamParam* param);
RSNET_API BOOL RSNET_CALL RSNetSetParamEx(RSNetConnection conn, const RSNetSetParamParamEx* param);

//Զ
RSNET_API RSNetRemoteUpgrade RSNET_CALL RSNetStartRemoteUpgrade(RSNetConnection conn, const RSNetRemoteUpgradeParam* param);
RSNET_API void RSNET_CALL RSNetStopRemoteUpgrade(RSNetRemoteUpgrade* remoteUpgrade);


//澯
RSNET_API void RSNET_CALL RSNetAlarmSubscribe(RSNetConnection conn, BOOL desired);

//
RSNET_API void RSNET_CALL RSNetSimpleCmd(RSNetConnection conn,RSNetCmdParam *param);

//ѯ־ 
RSNET_API BOOL RSNET_CALL RSNetQueryLog(RSNetConnection conn,RSNetQueryLogParam *param);

//Reqѯ
RSNET_API BOOL RSNET_CALL RSNetReqControl(RSNetConnection conn, RSNetReqParam* param);

//ļ 
RSNET_API BOOL RSNET_CALL RSNetExportBackup(RSNetConnection conn,RSNetExportBackupParam *param);

//ļ
RSNET_API BOOL RSNET_CALL RSNetRemoteParamImport(RSNetConnection conn, const RemoteBackupResp_t* param);

//µĵ뵼ļ->˽ṹϢ
//
RSNET_API BOOL RSNET_CALL RSNetRemoteParamImportNew(RSNetConnection conn, const RemoteNewParamBackupResp_t* param);
//
RSNET_API BOOL RSNET_CALL RSNetExportBackupNew(RSNetConnection conn, const RSNetExportBackupParam* param);

//ؽӿ
RSNET_API RSNetConnection RSNET_CALL RSNetStartSendPushParam(RSNetSendParam *param);
RSNET_API void RSNET_CALL RSNetStopSendPushParam(RSNetConnection *conn);

//I֡طץͼ KG
RSNET_API RSNetCaptureIFramePlay RSNET_CALL RSNetStartCaptureIFrame(RSNetConnection conn, const RSNetRecordPlayParam* param);
RSNET_API void RSNET_CALL RSNetStopCaptureIFrame(RSNetCaptureIFramePlay* captureIFrame);
RSNET_API void RSNET_CALL RSNetReposIFrameData(RSNetCaptureIFramePlay captureIFrame, const ReposRecordDataReq* req);
RSNET_API void RSNET_CALL RSNetReplayIFrameData(RSNetCaptureIFramePlay captureIFrame);

//طŲѯɾͼƬ KG
RSNET_API RSPictureSearch RSNET_CALL RSNetQueryOrDelPicture(RSNetConnection conn, const RSNetQueryOrDelPictureParam* param);
RSNET_API void RSNET_CALL RSNetQueryOrDelPictureStop(RSNetConnection conn, RSPictureSearch  handle);

//طͼƬ KG
RSNET_API RSNetDownloadPicture RSNET_CALL RSNetStartDownloadPictureEx(RSNetConnection conn, const RSNetDownloadRecordParamEx* param);
RSNET_API void RSNET_CALL RSNetStopDownloadPicture(RSNetDownloadPicture* downloadPicture);

//only for mac lorex p2p
RSNET_API void RSNET_CALL RSNetInitLX2PPath(const char* path);

RSNET_API RSNetConnection RSNET_CALL RSNetStartSavePasword(RSNetSendParam *param);
RSNET_API void RSNET_CALL RSNetStopSavePasword(RSNetConnection *conn);

//query playback record
RSNET_API BOOL RSNET_CALL RSNetNewQueryRecordEx(RSNetConnection conn, const RSNetNewQueryRecordParamEx* param);

//playback thumbnails
RSNET_API RSNetThumbnailsConn RSNET_CALL RSNetStartGetPlaybackThumbnails(RSNetConnection conn, const RSNetPlaybackThumbnailsParam* param);
RSNET_API void RSNET_CALL RSNetStopGetPlaybackThumbnails(RSNetThumbnailsConn* thumbnailsConn);

//channel picture
RSNET_API RSNetThumbnailsConn RSNET_CALL RSNetStartGetChannelThumbnails(RSNetConnection conn, const RSNetChannelThumbnailsParam* param);
RSNET_API void RSNET_CALL RSNetStopGetChannelThumbnails(RSNetThumbnailsConn* thumbnailsConn);

//timing
RSNET_API RSNetTimingConn RSNET_CALL RSNetStartTiming(RSNetConnection conn, const RSNetTimingParam* param);
RSNET_API void RSNET_CALL RSNetStopTiming(RSNetTimingConn* timingConn);

#ifdef __cplusplus
}
#endif


#endif
