/********************************************************************
	ļ	ͻ豸ͨѶЭ
	created by  2011.1.8
*********************************************************************/
#ifndef __RSNetProtocol_h__
#define __RSNetProtocol_h__

#pragma pack(4)

#define RS_DVR_NORMAL       0x0000000000000000ULL  

#define RS_DVR_D9104        0x5253000000010100ULL
#define RS_DVR_D9104B       0x5253000000010101ULL
#define RS_DVR_D9108        0x5253000000010200ULL
#define RS_DVR_D9108B       0x5253000000010201ULL
#define RS_DVR_D9016        0x5253000000010300ULL
#define RS_DVR_D9116        0x5253000000060300ULL
#define RS_DVR_D9116S       0x5253000300070300ULL

#define RS_DVR_D9216H       0x5253000000020300ULL

#define RS_DVR_ID9316H      0x5253000001020300ULL
#define RS_DVR_D9316H       0x5253000000020301ULL

#define RS_DVR_D9604L       0x5253000100010100ULL
#define RS_DVR_D9608L       0x5253000100020200ULL
#define RS_DVR_D9616L       0x5253000100020300ULL 
#define RS_DVR_D9608H       0x5253000100020201ULL
#define RS_DVR_D9616H       0x5253000100020301ULL
#define RS_DVR_D9608B       0x5253000100020202ULL
#define RS_DVR_D9616B       0x5253000100020302ULL

#define RS_DVR_D9704SDI		0x5253000200050100ULL
#define RS_DVR_D9704L	    0x5253000100060100ULL
#define RS_DVR_D9704        0x5253000300060100ULL
#define RS_DVR_D9704BP      0x5253000300060101ULL
#define RS_DVR_D9708L	    0x5253000100060200ULL
#define RS_DVR_D9708        0x5253000300060200ULL
#define RS_DVR_D9708BP      0x5253000300060201ULL
#define RS_DVR_D9708S       0x5253000300070200ULL
#define RS_DVR_D9716L       0x5253000300050300ULL

#define RS_HOME_H1002H      0x5253020100010100ULL
#define RS_HOME_H1002M      0x5253020100010101ULL

#define RS_NVR_N1004        0x5253030200010100ULL
#define RS_NVR_N1104        0x5253030200060100ULL
#define RS_NVR_N1108        0x5253030200060200ULL

#define RS_IPC_TI           0x5253040200030000ULL
#define RS_IPC_GM           0x5253040200040000ULL
#define RS_IPC_3518C      	0x5253040200050000ULL

#define RS_MDVR_D5704       0x5253010100010100ULL

#define RS_DECODER_A9001    0x5253050100010100ULL
#define MaxIpLen	16
#define MaxNameLen	36
#define MaxEncodeNameLen	256
#define MAX_NET_PARAMS_LEN  32


//////////////////////////////////////////////////////////////////////////
//MsgHead.Version
#define MsgHeadV1	0 
#define MsgHeadV2   2
#define MsgHeadV3   3

//MsgHead.AckFlag
#define AckSuccess					0
#define AckFail						1
#define AckNoMsgType 				2
#define AckLoginUserLogined			10
#define AckLoginNoUserName			11
#define AckLoginPasswordError		12
#define AckLoginIPFilerError		13
#define AckLoginUserDisable		    14
#define AckLoginForceChangePWD      15
#define AckLoginForceCloseBrowser   16
#define AckLoginVersionError		17
#define AckLoginForbidIP 			18
#define AckLoginMacFiler     		19

#define AckDualtalkBusy				20
#define AckAuthorityFail			50
#define AckParamError				51
#define AckUpgrading				60
#define AckUpgradeVersionError		61
#define AckPreviewNoStream          62
#define AckUpgradeVersionSame       63
#define AckUpgradeLanguageError     64 
#define AckOverMaxPrevNumErr		65 
#define AckOverMaxUser              66 
#define AckInUserInterface          67
#define AckNoBandWidth            68

//MsgHead.MsgType
#define MsgSearchDev			11
#define MsgDevNetCfg            12
#define MsgIPCSetDevName        13
#define MsgLogin				31
#define MsgHeartbeat			32
#define MsgTcpPreview			71
#define MsgGetUdpAddr			81
#define MsgStartUdpPreview		82
#define MsgStopUdpPreview		83
#define MsgReqIFrame		    87
#define MsgPTZControl			101
#define MsgQueryRecord			111
#define MsgNewQueryRecord		112
#define MsgRecordPlay			121
#define MsgRecordPlayFeedback	122
#define MsgReposRecordData		123
#define MsgRecordPlayControl    124
#define MsgDownloadRecordFile	131
#define MsgDualtalk				141
#define MsgQueryParam			211
#define MsgSetParam				216
#define MsgDefaultParam         217     //Ĭϲ
#define MsgStatusRequest		890		//״̬ϱ
#define MsgAlarmReport			891
#define MsgAlarmSubscribe		896
#define MsgRemoteUpgrade		5139
#define MsgRemoteUpgsIpc        5140    //ͨԶIPC

#define MsgEmailTest            301
#define MsgDDNSTest             302
#define MsgRemoteReboot         303
#define MsgSyncTimeCtl          304
#define MsgColorCtrl            305
#define MsgRemoteCapture        306
#define MsgGainSnaptReport      307
#define MsgQueryLog             308
#define MsgHddFormat            309
#define MsgSearchRemoteDev		310   //NVRãԶ豸
#define MsgSetRemoteDevNet		311   //NVRãԶ˻
#define MsgAddAllDevice         312   // һӹϢ
#define MsgFtpUpgrade           320   //Ftp Զ
#define MsgActivateCloud        321   // Ӳ֤
#define MsgDevicePlayback       322   // طŻ
#define MsgFtpWriteFileTest     323   // ftpдļϢ
#define MsgQueryLog_IPC         324   //ipcר
#define MsgIsFormatHdd          325   //ʽӲط()
#define MsgNoStreamType         326   //no
#define MsgCloudCheck           327   //kguard cloud check
#define MsgSearchLog            328   
#define MsgRebootIPC            329   //ԶIPC
#define MsgIPCLoadDefault       330   //ԶIPCָĬ
#define MsgUpgradeFireware      331   //Զƹ̼(kguard DVR)
#define MsgRemoteOneKeyAddIPC   333 //nvr one key add ipc
#define MsgSGManualUpload       334   //ƽֶ̨ͼƬϴ
#define MsgRsPushParamHandle    335   //rspush handle appinfo
#define MsgZeroChnStatus        336   //ȡ0ͨ״̬(ZIPͻ)
#define MsgRemoteCheck          337   //Զ()ƴ洢
#define MsgIsModifyHdd          360   //޸ط()



#define MsgAddSersorDev        338  //Զsensor豸
#define MsgDeleteSersorDev        339  //Զɾsensor豸
#define MsgSetMobileRemoteControlStatus       340  
#define MsgGetMobileRemoteControlStatus 341


#define MsgSetSensorRuleUpdate        342
#define MsgGetSensorRuleSwitch        343
#define MsgSetSensorDevName        344
#define MsgGetSensorDevName        345
#define MsgRFConnectUpdate        346
#define MsgGetRFConnnectState     347
#define MsgRemoteParamBackup      348

#define MsgDevTelnetOpen          349
#define MsgDevTelnetOff           350

#define MsgDevSerialOpen          351
#define MsgDevSerialOff           352
#define MsgRemoteParamImport      353
#define MsgFtpUpgradeSearchFile   354 //search ftp fle for upgrade 2016.03.24


//޸Ĺؼ
#define MsgQueryKeyConf			400
#define MsgSetKeyConf			401

#define MsgReqVideoActivation   402
#define MsgGetDDNSID            403
#define MsgGetIFrame            404
#define MsgReposIFrameData      405
#define MsgDownLoadJpg          406
#define MsgNoPlaybackAuth       407
#define MsgNoPreviewAuth        408
#define MsgPreviewActivateFaile 409

//
#define PPPOE_SET_MSG           411
#define MsgStopEmailTest        412
#define MsgNewEmailTest         413

//µĵ뵼2016.12.22add
#define MsgRemoteNewParamImport      414
#define MsgRemoteParamNewBackup     415
#define MsgSaveToDev				416
#define MsgSetIOAlarmStatus		417
#define	MsgNEWEmailTest         419
//MsgHead.MsgSubType
#define MsgNoSubType	0

//MsgPTZControl sub type
#define MsgPTZUp			1
#define MsgPTZDown			2
#define MsgPTZLeft			3
#define MsgPTZRight			4
#define MsgPTZUpLeft		5
#define MsgPTZUpRight		6
#define MsgPTZDownLeft		7
#define MsgPTZDownRight		8
#define MsgPTZZoomIn		11 //
#define MsgPTZZoomOut		12 //С
#define MsgPTZFocusNear		13 //ǰ
#define MsgPTZFocusFar		14 //
#define MsgPTZIRISOpen		15 //Ȧ
#define MsgPTZIRISClose		16 //ȦС
#define MsgPTZAutoScan		21
#define MsgPTZCruise		51
#define MsgPTZGetPresetNum  52
#define MsgPTZSetPPCruise			53  //ù켣Ѳ
#define MsgPTZCallPPCruise			54  //ù켣Ѳ
#define MsgPTZStartPattermCruise		55  //ɨ迪ʼ
#define MsgPTZEndPattermCruise		56          //ɨ
#define MsgPTZCallPattermCruise		57          //ûɨ


#define MsgPTZGuard         90
#define MsgPTZSetPreset		91
#define MsgPTZClearPreset	92
#define MsgPTZCallPreset	93
#define MsgPTZSensorPresetInfoGet 94
#define MsgPTZSensorPresetInfoSet 95
#define MsgPTZLockFocus 96
#define MsgPTZLineScanA 98  //ɨ迪ʼ
#define MsgPTZLineScanB 99   //ɨ
#define MsgPTZDefault   100
#define MsgPTZ_ZOOM_POSITION   101
#define MsgPTZ_FOCUS_POSITION   102
#define MsgPTZ_ZOOM_MOVE   103
#define MsgPTZ_FOCUS_MOVE   104
#define MsgPTZ_AUTO_FOCUS   105
#define MsgPTZ_AREA_FOCUS   106
#define MsgPTZ_REFRESH_INFOR   107
#define MsgPTZ_CALIBRATION_SETTING   108

//MsgQueryRecord sub type
#define MsgRecordDetail		 101
#define MsgRecordDayOutline	 102
#define MsgRecordDayHalfHour 103
#define MsgQueryJpgDetail	 104  
#define MsgDelJpg            105

//MsgRecordPlayFeedback sub type
#define MsgRecordDataInsufficient		121
#define MsgRecordDataEnough				122

//MsgAlarmReport sub type
#define MsgPirAlarm 					187
#define MsgSnaptMotion                  188
#define MsgVLossAlarm                   189
#define MsgDevStatReport                190
#define MsgMotionAlarm			        191
#define MsgIOAlarm				        192
#define MsgAIAlarm				        193
#define MsgIntelligentAlarm		        194
#define MsgAvdAlarm				        195

#define MsgAlarmDesired			        196
#define MsgAlarmRefused			        198
#define MsgAIData                       199
#define MsgRecordAlarm          		201
#define MsgHddAlarm             		202
#define MsgFtpUpgradeAlarm              203   // Ftp 澯
#define MsgOscAlarm		                204
#define MsgIntelPeaAlarm                205
#define MsgOscRuleAlarm                 206
#define MsgVideoHideAlarm               207
#define MsgBitrateInfo                  208
#define MsgAllChnsAlarm                 209 //ͨ

//MsgAlarmSubscribe sub type
#define MsgTelModuleAlarm               210
#define MsgRemoteCHStatusReport         211
#define MsgRecordStatusReport			212
#define MsgHddStatusReport				213
#define MsgGpsInfoReport                214
#define MsgIntelIpcPeaAlarm             215 //  2015.11.30
#define MsgIpcOSCAlarm                  216
#define MsgIntelIpcPeaAreaAlarm         218 // ܽ 2015.11.30
#define MsgSensorStatusReport           247  //sensor״̬

#define MsgAlarmIntHD                   248  //  2016.03.09
#define MsgAlarmIntFD                   249  //  2016.03.09
#define MsgAlarmIntPCC                  250  // ͳ 2016.03.09
#define MsgAlarmIntManage		        251  // ܹ 2016.03.09
#define MsgAlarmFishEyeIpcStat          252  
#define MsgAlarmPTZIpcStat				253 //autoFocus ipc 2017.04.25

/******************************
* .SubType   -----start
*******************************/ 
#define MsgParamOsd				        501
#define MsgParamSystemBase		        502
#define MsgParamHdd				        503
#define MsgParamSerial			        504
#define MsgParamUser 			        505
#define MsgParamDst 			        506
#define MsgParamMainStream 	            507
#define MsgParamColor 			        508
#define MsgParamVideoCover 		        509
#define MsgParamPtz 			        510
#define MsgParamNetworkBase 	        511
#define MsgParamDDNS 			        512
#define MsgParamPPPOE 			        513
#define MsgParamEmail 			        514
#define MsgParamNtp 			        515
#define MsgParamMotion 			        516
#define MsgParamAbnormal 		        517
#define MsgParamIOAlarm 		        518
#define MsgParamRecord 			        519
#define MsgParamSchedule 		        520
#define MsgParamDefault 		        521
#define MsgParamIntelligent             522
#define MsgParamIntavd                  523 

#define MsgParamGeneral                 524
#define MsgParamMaintain                525
#define MsgParamSubStream               526
#define MsgParamMobile                  527
#define MsgParamEmailSchedule           528
#define MsgParamPlatform                529
#define MsgParamIpc                     530
#define MsgParamIpcIOAlarm              531
#define MsgParamIpcWifi                 532
#define MsgParam3G                      533
#define MsgParamRouterLan               534
#define MsgParamRouterWan               535
#define MsgParamTuobao                  537
#define MsgParamVehicleMng              538
#define MsgParamOutput			        539
#define MsgParamTelAlarmArea            540
#define MsgParamTelAlarmWireSensor      541
#define MsgParamTelAlarmWirelessSensor  542
#define MsgParamPhoneNumberSetting      543
#define MsgParamCameraSet               544
#define MsgParamMobileStream            545
#define MsgParamHuaweiPlatform          546
#define MsgParamIPFilter                547
#define MsgParamRtsp                    548
#define MsgParamFtp                     549
#define MsgParamElecLock             	550
#define MsgParamCloudStorage            551
#define MsgParamCloudEmail              552

//#define MsgParamP2pMobile               553
#define MsgParamP2pQrCodeID             553
#define MsgParamDevAllStatusSet         554   // URMET ͻԶ̿ͨϢ
#define MsgParamLorexP2pParam           555   // Lorexͻ
#define MsgParamFtpAutoUpgrade          556   // 
#define MsgParamManualRecord            557   // ֶ¼

#define MsgParamSystemIDCtrl             558  // 豸id
#define MsgParamIPCFrameInfo             559  // nvrȡipc֡Ϣ
#define MsgParamNewCloudStorage          560
#define MsgParamUpLoadPhoto              561
#define MsgParamUpLoadVideo              562
#define MsgParamCloudStorageInfo         563
#define MsgParamCloudStorageEmail        564
#define MsgParamCloudStorageFTP          565
#define MsgParamPerimeterLine            566
#define MsgParamVideoDiagnostics         567
#define MsgParamGoodsLostLegacy          568
#define MsgParamKGWireless               569/* KG  Wireless */

/*******************************************************************
,subType,ڱŲãԴ703ʼţݹܰڷţ
Ǳ.µĶע޸ġע ----2016.03.10
********************************************************************/

#define MsgParamPerimeter                703 // ܽ 2015.11.12
#define MsgParamAreaStream               704 // ipc 
#define MsgParamIntHD				 	 705 // 2016.03.09
#define MsgParamIntFD				     706 // 2016.03.09
#define MsgParamIntPCC				     707 //ͳ 2016.03.09
#define MsgParamIntManage                708 //ܹ 2016.03.09

/*õ˽вӦṹEplateform_t*/
#define MsgParamElectricityGrid			 709 //2016.05.25
#define MsgSearchSmartCount              710 //ͳܹߵĸ 2016.05.31
#define MsgParamFishEye                  711  //ipc fisheye
#define MsgParamIPCCamearMode            712

/*ýҳ,Ӧṹ RSNet_SoleSwitch_t*/
#define MsgParamSwitch					 713
#define MsgParamIPCCameaFocusInfo		 714
/*.SubType   -----end*/ 

/*ԤãӦṹ RSNet_SolePreviewCtrl_t,PARAM_PAGE_PREVIEWCTRL*/
#define MsgParamPreviewCtrl  715
#define MsgParamAlarmOutScheduleset  716

/*͸ͨЭ*/

/*Swann*/
#define MsgParamSwannWifi  717 //swann wifiҳ
#define MsgParamSwannIpcRepeat  718 //swann IpcRepeat
#define MsgParamSwannRouterRepeat  719 //swann RouterRepeat

/*APPԶ̿*/
#define MsgParamWizard  720
#define MsgParamTiming  721//Уʱָ

#define MsgParamPir 723

/***************************/
#define MsgSerialTransport          355


/***********************************
 * new nvr param  adapter message
 **********************************/
#define MsgParamModifyMainStream         570
#define MsgParamModifySubStream          571
#define MsgParamModifyMobileStream       572
#define MsgParamModifyLiving             573
#define MsgParamModifyOutput             574
#define MsgParamModifyKBSet              575
#define MsgParamModifyFtpUpgrade         576 
#define MsgParamModifyState              577
#define MsgParamModifyEmailSchedule      578
#define MsgParamLogDeletes				 579
#define MsgParamLogTerm					 580
#define MsgParamVoice					 581
#define MsgParamIDSet                    582
#define MsgParamStreamSet                583 //honeywell only. (20140516)
#define MsgParamSoleUploadVideo          584 //Ƶϴ 7day*48halfhour
#define MsgParamIntelliRec               585 //¼ƻ(Qt v2)
#define MsgParamIPCImageSet              587 //IPCͼ
#define MsgParamRenewFactory             588 //shenzhen renew factory
#define MsgParamCustomProtocol           589 //ԶЭ(nvr)
#define MsgParamSGPlatform               590 //ƽ̨
#define MsgParamIPCROI                   591 
#define MsgParamOD                       592 
#define MsgParamIPCWireless              593 //LorexIPCרò
#define MsgParamKguardP2p                594 //Kguard ShangYun P2P (DVR)
#define MsgParamSensorAlarm              595 //Kguard Sensor Alarm (DVR)
#define MsgParamPushInfo                 596 //push info 
#define MsgParamAnalogCam                597 //DVRģͨϢ
#define MsgParamCaptureSet               598 //DVRץͼ
#define MsgParamCapSchedule              599 //DVRץͼƻ
#define MsgParamIPV6Info                 600 //ipv6 info 
#define MsgParamZeroChn                  601 //ͨ
#define MsgParamSensorAlarmSingle        602 //Kguard single Sensor Alarm (DVR)
#define MsgParamSensorCtrl			     603 //sensor control Alarm(dvr ĿǰKguardʹ)


#define MsgParamKeyParamSet              700 //Զдؼ
#define MsgParamChnInfo                  701 //DVRͨϢ
#define MsgParamRecInfo                  702 //DVR¼Ϣ

/*GB28181 ҳ*/
#define MsgParamGB28181 722

#define MsgSysParamEx                  803 
#define MsgParamUrmetHttp   		   804
#define MsgParamNewCloudestorage       805
#define MsgParamIPCIOAlarm 		       806
#define MsgParamOutPut 		       807
#define MsgNewIOAlarm              808
#define MsgParamNetFilter		   809
#define MsgParamALTEReport		   810
#define MsgParamThumbnail		   811
#define MsgParamSnapPicForP2P	   812



/**********************************************************
ע:703-708ѱ""ռã#define MsgParamPerimeter
µĶע޸ġע ----2016.03.21
**********************************************************/

//
#define MsgParamOccSet_IPC               1000 
#define MsgParamModifySnmpSet			 1001 
#define MsgParamModifyGb28181			 1002 
#define MsgParamModifyIeeeSet			 1003 
#define MsgParamModifyCameraSet_IPC      1004  
#define MsgParamModifyNetBeakSet         1010  
#define MsgParamSoundRecord              1012
#define MsgParamLightSchedule            1013  /* KG ƺschedule*/
#define MsgParamSnapshot                 1014   //KGչ
#define MsgParamFishEyeCircle            1015

// sub type
#define MsgRemoteUpgradeData	761
#define MsgRemoteUpgradeEnd		762
#define MsgRemoteUpgradePartEnd 763
#define MsgRemoteUpgradeWriteFlashInProgress 764
#define MsgRemoteUpgradeWriteFlashEnd 765


#define MsgRSPlatform           800

//sync time sub type
#define MsgSyncSetTime          331
#define MsgSyncGetTime          332

//MsgStatusAlarmRequest	Sub Type 
#define MsgDevAllStatusReq			610
#define MsgRemoteCHStatusReq		611  //ѯԶͨ״̬,ҪָNVRӵIPC״̬

//Msg PEA , GoodsLost Sub Type
#define MsgPeaAlarmReq              612
#define MsgGoodsLostAlarmReq        613
//ֻȡ豸״̬,lorexͬʱȡ״̬ͼ
#define MsgDevStatusOnlyReq         614
#define MsgGetRemoteParam           615 //ȡlorex http
#define MsgLastRecordReq            616 //豸һμ¼Ϣ.(ALTEͻ)


#define EMsgLogin				    617
#define EMsgSearchDev			    618

#define CdoublesMsgLogin			619
#define CdoublesMsgSearchDev		620
#define CryptoMsgLogin 			    621

#define RaydinMsgLogin				622
#define RaydinMsgSearchDev			623

#define OPTIMUSMsgLogin             624
#define OPTIMUSMsgSearchDev         625

typedef struct
{
	BYTE Version : 2; 	//Ϣͷ汾
	BYTE ExtSize : 6; 	//ϢͷչСʵչС = ExtSize * 4
	BYTE Reserved;
	WORD AckFlag; 		//ϢӦ
	WORD MsgType; 		//Ϣ
	WORD MsgSubType; 	//Ϣ
	UINT MsgSize;  		//ϢͷݴС
	UINT Seq;  		    //ϢкţʶһϢΨһԣ󷽴Ӧԭֵ
}MsgHead;			 	//Ϣͷsizeof(MsgHead) = 16
//ͨ·ʹӦ
typedef struct 
{
	int res; //0 failed  1 success 
	int reserve;
}RSSerialRes_t;

//232ݷϢ
typedef struct 
{
	int datatype; //0 play control ,1 user commind ,2 չ
	int datasize; 
	char buf[1];
}RSSerialReqData_t;


//////////////////////////////////////////////////////////////////////////
//豸
// MsgType=MsgSearchDev
//Ӧ MsgSize=sizeof(SearchDevRsp)

#define SearchDevPort	9333

//SearchDevRsp.NetworkMode
#define NetworkModeDHCP		0
#define NetworkModePPPOE	1
#define NetworkModeManual	2

typedef struct
{
	char IP[MaxIpLen]; //IP
	char HostName[MaxNameLen]; //
	char NetMask[MaxIpLen]; //
	char GateWay[MaxIpLen]; //
	char DNS1[MaxIpLen]; //dns1
	char DNS2[MaxIpLen]; //dns2

	UINT Port; //ͻ豸˿
	UINT IEPort; //IE˿

	UINT NetworkMode; //ʽ

	char DevType[MaxNameLen - 8]; //豸
	unsigned long long DevTypeULL;
	char DevVer[MaxNameLen]; //豸汾
	UINT DeviceID;  //
   	char DeviceName[MaxNameLen]; //豸ƣ޸        
	char MacAddr[MaxNameLen]; //豸MACַ

	UINT ChannelNum; //ͨ
	
	unsigned char Version;//汾
	char cNetInterface;// 0 eth0 1 eth1
	char P2pID[38];
    char manufacture[32];
    char reserved[96];
}SearchDevRsp;


//////////////////////////////////////////////////////////////////////////
//¼
// MsgType=MsgLogin, MsgSize=sizeof(LoginReq)
//Ӧ ɹAckFlag=AckSuccess,MsgSize=sizeof(LoginRsp) ʧAckFlag=AckLoginUserLogined,AckLoginNoUserName,AckLoginPasswordError,AckFail

//VideoFormat
#define RS_PAL  0
#define RS_NTSC 1

typedef struct
{
	char UserName[MaxNameLen];
	char Password[MaxNameLen];
	UINT UserKey; //״ε¼Ϊ0ϴγɹ¼صUserKeyԷռûûѵ¼Ĵ󷵻
	UINT AlarmReportDesired : 1;
	UINT ZipLogin: 1;//zip login falg
	UINT Reserved : 22;
	UINT Language : 8; /* 1,2.Ӣ */
}LoginReq;

typedef struct
{
    char UserName[256];
    char Password[256];
    UINT UserKey; //״ε¼Ϊ0ϴγɹ¼صUserKeyԷռûûѵ¼Ĵ󷵻
    UINT AlarmReportDesired : 1;
    UINT ZipLogin: 1;//zip login falg
    UINT Reserved : 22;
    UINT Language : 8; /* 1,2.Ӣ */
}LoginCryptoReq;

typedef struct
{
    int  structsize;
    char reserve[4];
    char uuid[24];
    char reserve1[128];
}LoginReponse;

//ûȨ޸λʾ
typedef struct
{
	UINT UserSetRight;/*0 ,̹1,Զ̵2,ϵͳά3,־鿴4,(Ѳ5)ѯ6, ֶ¼7,ֶ׽ͼ8,ƵȨ9*/
//	UINT ManualRecordChannel;  //ֶ¼ͨ 
	UINT PreviewChannel;     //Ԥͨ
	UINT PlayBackChannel;       //طͨ
	UINT BackupChannel;        //ͨ
	UINT PtzControlChannel;     //̨ͨ
	BYTE UserPreview;        //ԤȨ
//	BYTE UserManualRecord;   //ֶ¼Ȩ
	BYTE UserPlayBack;        //¼طȨ
	BYTE UserBackup;          //Ȩ
	BYTE UserPtzControl;       //̨Ȩ
	
	BYTE MainStream:1;       //Ȩޣλȡֵ        
	BYTE SbuStream:1;		//Ȩޣλȡֵ        
	BYTE MobileStream:1;	//Ȩޣλȡֵ     
	BYTE UserAlarmSensorControl:1;       //alarm sensor control
	BYTE Reser:4;
         
	BYTE Reserved[15];
}UserRightWrap;
//C_ASSERT(sizeof(UserRightWrap) == 40);

typedef enum
{
	PLATF_SWITCH_RS_PLATFORM = 0,
	PLATF_SWITCH_HUAWEI_PLATFORM,
}PlatformSwitch_E;

typedef enum
{
  BIT0_E = 0,//Bit0 indicates whether or not  display image control page, 0 means showed that 1 is hidden
  BIT1_E,    //Bit1 indicates whether or not display IRIS function , 1 display , 0 not display 
  BIT2_E,    //Bit2 indicates samsung dedicated h. 265 ipc image page parameter, 0 indicates not samsung customer, 1 indicates samsung customer
  BIT3_E,    //Indicates whether or not the display intelligence analysis page.0 means hide, 1 display
  BIT4_E,    //area encode page for ipc
  BIT5_E,    //Whether show intelligent management function
  BIT6_E,	 //Whether show Analog channelpage(DVR PRODUCT)
  BIT7_E,	 //Wheher PTZ  Page show COAX1 COAX2, or just show COAX
  BIT8_E,    //display or hide the import-export page
  BIT9_E,    //display or hide power grid page;
  BIT10_E,   //snap picture 
  BIT11_E,   //substream playback
  BIT12_E,   //fisheye ipc
  BIT13_E,   //hydvr whether display sharpness pic
  BIT14_E,   //whether or not use dynamic occlusion  
  BIT15_E,   //display or hide sensercontrol page
  BIT16_E,   // 1:show new rtsp page, 0:show old rtsp page
  BIT17_E,   // 1:show new NTP page, 0:show old ntp page
  BIT18_E,   //1:IE recoed flag enable, 0: IE recoed flag disable  
  BIT19_E,	 //Whether use AMR function , 1 use ,0 not used  
  BIT20_E,   //0:old , 1:all alarm status and device capbiliti use DevAllStatusRpt struct(2016,11.17 add)
  BIT21_E,	 //whether or not allow Disable admin password. 0:allow 1:not allow
  BIT22_E,   //1: show format hdd , 0:not show
  BIT23_E,   //1: add NTP  user defined, 0 not add
  BIT24_E,   //display or hide p2p swith ,0:hide, 1:display
  BIT25_E,   //1:support I/O Alarm,0 not support
  BIT26_E,   //1:support Audio In/Out0 not
  BIT27_E,   //When the device needs to be forced to set the password, tell the client in the first login or restore default to make a prompt, 1:prompt
  BIT28_E,   //DEFENDER mars,control Motion erae
  BIT29_E,   //download speed 0,not support, 1:support
  BIT30_E,   //0:v100, 1:v300
  BIT31_E,   //1:double eye ipc
}PageControl_E;

typedef enum
{
	PBIT0_E = 0,//1:use NewIOAlarmParamAdapter, 0 : use old  
	PBIT1_E,    // 1: no support Mobile stream  0: support Mobile stream
	PBIT2_E,    // 1: no support corridor mode and Angle Rotation    0: support corridor mode and Angle Rotation
	PBIT3_E,    //1: no support Transparency    0: support Transparency
	PBIT4_E,    //1:support thumbnail , 0: no support ;
	PBIT5_E,    //1:support PIR and MOTION , 0: no support
	PBIT6_E,    // 1: no support Mobile stream  0: support Mobile stream
	PBIT7_E,    // 1: no support corridor mode and Angle Rotation    0: support corridor mode and Angle Rotation
	PBIT8_E,    // 1: support GB28181    0: no support
	PBIT9_E,  //1:use new email struct
	PBIT10_E,   //1:support  PIR     0: no support
	PBIT11_E,	//1support alarmLink page  0:no support alarmLink page;
	PBIT12_E,   //1:support  PIR     0: no support
}PageControl2_E;
typedef struct
{
	BYTE isFishEye;
	BYTE isSupportHard_dec;
	BYTE curShowMode;
	BYTE curStreamNum;
	BYTE fishEyeflag;// 0 not support fish eye ipc, 1 suport fish eye ipc
	BYTE unused[3];
} FishEyeIpc_Cap_t;

//ԶԽZoomFocusСλ
typedef struct
{
	UINT mixZoomPosition;
	UINT maxZoomPosition;
	UINT mixFocusPosition;
	UINT maxFocusPosition;
	BYTE PTZVersion;//ʹPTZ İ汾0:ɽ棬1:½
	BYTE unused[7];
} AutoFocus_Default_t;
typedef struct 
{
	UINT StructSize; //ýṹС
	UINT ChannelMask;//ͨ
    UINT curZoomValue;//zoomǰλ
    UINT zoomStep;//01  15  220
    UINT curFocusValue;//focusǰλ
    UINT focusStep;//01  15  220
    BYTE autoFocusState;//0:Խ1жԽ
    char ShiftRange;//0:Χ1Ƭ
    BYTE unused[30];//
}AUTOFOCUS_CONTROL_S;

typedef struct
{
	unsigned long long DevType; //豸
	char DevVer[MaxNameLen]; //豸汾
	char DeviceName[MaxNameLen]; //豸ƣ޸        
	char MacAddr[MaxNameLen]; //豸MACַ
	UINT DeviceID;  //
 
 	UserRightWrap UserRight; //ûȨ

	UINT UserKey; //ûԿ
 	WORD TotalFPS_D1; //豸D1ģʽÿ֡TotalFPS=100, 4CIF 25f/s2HD1 25f/s1D1 25f/s
 	BYTE ChannelNum; //ͨ
 	BYTE VideoFormat; //ͷʽ

 	BYTE AlarmInNum;  //
 	BYTE AlarmOutNum; //(̵)
	BYTE AIAnalyzeCap; //Ƿ֧ܷ
	BYTE AIAnalyzeChannels; //ܷ·

	BYTE SerialNum;	//豸ʹôڵĿûо0(ǲôͨѶ)
	BYTE ISAdmin;   //ǷǹԱ
	BYTE AudioNum;         //Ƶͨ
	BYTE ResolutioFrameFix;//֡ʷֱǷ̶:0-ɵ,1-̶2-չΪߵ

	BYTE PreviewOff;       //ԤǷԹرգҪD90160-ԣ1-
	BYTE VideoCoverNum;    //ֵ֧ͨƵڵҪD9016
	BYTE SupportSpot;      //Ƿ֧spotӿڵع
	BYTE SubStreamMin;     //СȡֵΧӦֵƷʵֵ

	BYTE SubStreamMax;     //:0     1     2     3     4    5     6     7    8       9       10      11     12
	BYTE PlatformSupport; //0(֧ƽ̨) 1(֧ƽ̨)
	
    WORD ChnInfoSize;		//ʾ¼ṹͨϢDevChnInfoṹĴС
							//汾ʹͨϢṹ塣ΪϢMsgRemoteCHStatusReqȡͨϢ

	BYTE SubStreamRestrict; // 0() 1 ()
	BYTE DualtalkShowTag;  //0(ʾ:ֶ֧ܲԽ) 1(ʾֶ֧Խ)
	BYTE RouterShowTag;    //Ƿʾ·ɲҳ
	BYTE LanShowTag;		//Ƿʾ·Lanҳ

	UINT PlatFormShowTag;   //Ƿʾƽ̨òҳ棬Value Show Plat*(UINT*)"PLEn" Hide Plat0x00000000 
	char ProductName[24];
	UINT PlatFormSwitch;   //PlatformSupport = 1PlatFormShowTag = "PLEn" жϴƽ̨֧, λʾʹ PlatformSwitch_E , ȫΪ0ΪĬϵRS_PLATFORM
	
	BYTE VideoActivateSwitch; // Ƿ֧ ûѡͨƵС
	BYTE MotionMode;          //0ɵģʽ1  44*36 ʽģʽ
    BYTE ResolutionMode;      //0 D1ģʽ,1D1960Pģʽ, 2CIFģʽ, 3CIFǲ֡
                              //4 720P 5720P960
	BYTE HidePhonePage;        //0أ1
	
	BYTE UpgradeType;         //0 豸 1 豸
	BYTE ElecLockFlag;         //0 δ״̬ 1 ״̬
 	WORD TotalFPS_960;			//豸960ģʽÿ֡TotalFPS=100, 4CIF 25f/s2HD1 25f/s1D1 25f/s

	// one byte
	BYTE WifiStatus:1;           //0 ûм⵽wifiģ, 1 ģ
	BYTE RtspPageEnable:1;           //ǷRTSPҳ濪 0ر, 1 
	BYTE FtpPageFlag:1;          //Ftpܱʶ1 д˹ܣ0Ϊû
	BYTE c32PasswordFlag:1;     // ʹóʶ1Ϊʹ32ֽڵ룬0Ϊʹ
	BYTE UrmetDevStatusFlag:1;   // ;UEMETͻ 豸״̬Ϣҳʾʶ	
	BYTE FileSystemFlag:1;       // ;0 ˼ϵͳ 1 ϵͳ
	BYTE KguardP2pUidFlag:1;      // 0 ʾUid, 1ʾUid
	BYTE EmailFlagSwitch:1;     // EmailScheduleFlag ʶλĿƿǷЧ1Ч0:Ч.
	
	BYTE EmailScheduleFlag:1;     // Ƿ¼ƻҳ棬0 1
	BYTE PtzHiddenFlag:1;	     // ǷPTZܣ 0 (), 1 (ر)
                                 // Ϊͬʱǰ豸汾3gܣû3g	
	BYTE c3GFlagSwitch:1;         // 3GFlag ʶλĿƿǷЧ1Ч0:Ч.
	BYTE c3GFlag:1;               // 0 3G, 1 3G 
	BYTE RecordTypeFlag:1;	 //ط¼ͱ־ 
	BYTE SystemIDCtrl:1;     // systemID 	
	BYTE FtpPcSendFlag:1;     // FtpץͼƬܱ־λ 0 ر  1 	
	BYTE CloudStorageFlag:1;  // ƴ洢0 ر 1  	
	
	BYTE AutoMaintenance:1;   //Զάҳأ0  1 
	BYTE CloudSGSerSwitch:4;  //  ƴ洢
	BYTE ShieldColorSetFlag:1; 
	BYTE IntelligentAnalysis:1;  // ܷҳ棬0 close 1 open
	BYTE RemoteUpgradeMode:1;   // 0: old Mode, 1: new Mode

	BYTE CloudeSGType:4;      // 0 dropbox and google 1: only dropbox 2: only google
	BYTE CloudeStorageMode:1; // 0:old param struct , 1: new param struct
	BYTE VBRFlag:1;
	BYTE RemoteFtpUpgradeSupport:1;  // 0:not support , 1: support to upgrade
	BYTE MainStreamMutex:1; 

	BYTE NewAapterQTParamFlag:1;  // Qt־λ
	BYTE PtzSupported:1;		  // only for nvr set IPC ptz param 
	BYTE PasswordSwitch:2;        //First bits for this function, Second for password switch
	BYTE NvrFlag:2;               //n1104:0,others:1
    BYTE MaintainUserEnabled:1;   //just in compatible with former version
    BYTE MdStreamFlag:1;         //Ȩ޿

	BYTE MaxPOENum;
    BYTE UiType;             //ui 1.0, 2.0, 3.0, 3.1
    BYTE ChipNum;            //豸оƬ
    UINT ProtocolType;       //ÿһλһЭ飬0֧֣1֧

    BYTE QueryRHMIFlag:1;    //ѯ¼Ӳ̡ƶ⡢IO״̬ʱlorex(flir)
    BYTE compatUpgrade:1;    //lorexͻ˼ͻȡ豸״̬
    BYTE supportMutiEmail:3; //Ƿֶ֧ʼ.0:1ʼ;1:3ʼ(lorex)
    BYTE showVersionFlag:1;  //Ƿʾ汾Ϣʾ(lorex).0:ʾ;1:ʾ
    BYTE honeyNewChName:1;   //honeywell OSDͨ,֧8(utf-8)
    BYTE pppoeFlag:1;        //0 PPPoE, 1 PPPoE
    BYTE maxChFps;           //ͨ֡.1:720P 15FPS; 2:1080P 15FPS;ĬΪ0
    WORD maxTotalFPS;        //ͨ֡ܺ
    BYTE hybirdDVRFlag:4;    //dvr־
    BYTE FrameAutoFlag:1;    //֡Զڿ(ĿǰΪQt DVR)
    BYTE customProtolFlag:1; //ԶǷʾԶЭҳ(NVR)
    BYTE sgPlatformFlag:1;   //ԶǷʾƽ̨ҳ(NVR)
    BYTE PushEnabled:1;      //Ƿ͹.0: close, 1: open.
    BYTE AnalogChNum;        //DVR ģͨĸ
    BYTE BitrateMode;        //ѡ, DVRضϵвƷͺ
    BYTE ShowSensorAlarm:1;  //ԶǷʾҳ,0: ʾ;1: ʾ(DVR)
    BYTE ZeroChFlag:1;       //0ͨܿ(ZIPͻ)
    BYTE GetAlarmChns:1;     //±ϸ淽ʽ,1:һλȡĳ¼ӦͨϢ,(Ĭ0)
    BYTE CoaxialFlag:1;      //Ƿ֧ͬṦ. 1:support, 0:not support    
    BYTE eSATAEnabled:4;     //豸ǷESATA.(NVR)

    char p2pId[32];         //P2P Id(OWLֻ)
    WORD totalFrameRes;     //֡Դ (ĿǰΪQt DVR)
    BYTE DevPlayBackCap;    //0:ɵĻطģʽ1:ֻȡI֡ģʽ2:I֡ģʽ
    BYTE PushType;          //0:tutktype(tutkԳOWLɷ64.91.227.90), 1:rstype,  2: tpns2.0 ·ר(host.nightowldvr04.com)
    BYTE DLMode;
    BYTE ZipFlag;           //0:nozip , 1:zip
    BYTE RemoteSearchLogFlag;           //Ƿ֧Զ־1:enable, 0:disable
	BYTE KguardDomeFlag:1; //kgҪͶǣ0no 1yes
	BYTE HKDemoFlag:1; //ʶ0no 1yes
	BYTE AIFlag:1;     //new AI :1 , old AI :0
	BYTE RSDomeFlag:1;//ңͷǣ0no 1yes	
	
	BYTE NewEmailTest:1;
	BYTE c32UserNameFlag:1;// ʹóûʶ1Ϊʹ32ֽڵû0Ϊʹ
	BYTE reserv:2;
	UINT PreviewChannel_EX[8];     //Ԥͨ
	UINT PlayBackChannel_EX[8];       //طͨ
	UINT BackupChannel_EX[8];        //ͨ
	UINT PtzControlChannel_Ex[8];     //̨ͨ
	U32  PageControl; // 0)display image 1)IRIS 2)samsung customer 3)intelligent analysis 4)area encode 5) intelligent manage
	FishEyeIpc_Cap_t FishEyeIpcCap;
	WORD CustomerVal;//CustomVal_E
	BYTE PreviewNum; //ԶԤͨ
	BYTE DefualtStream;//ipcĬIE¼ʾ0: 1: 2: ֻ
    U32 PageControl2;//PageControl2_E
    AutoFocus_Default_t  AutoFocusDefault;
	BYTE WizardFlag:1;
	BYTE reserv3:7;
	BYTE reserv4[8*100-29];
}LoginRsp;
//C_ASSERT(sizeof(LoginRsp) == 1232);




//////////////////////////////////////////////////////////////////////////
//
// MsgType=MsgHeartbeat
//Ӧ 


//////////////////////////////////////////////////////////////////////////
//

//PackHead.Version
#define PackHeadV1		0
#define PackHeadV2      1

#define MaxPackSize		    1400
#define MaxPackSize_2       (8*1024)

//PackHead.Type
#define FramePack				0 //ֵ֡İ
#define ReposPack				1 //طʱضλ͵ضλ
#define NoDataPack				2 //طʱʾǰطʱѾû¼
#define FileEndPack				3 //¼ʱʾһļ
#define IFrameEndPack  			4 //I ֡ݽ
#define IsThumbnailsPack        5 //ͼ

typedef struct
{
	BYTE Version : 2; //ͷ汾
	BYTE ExtSize : 6; //ͷչСʵչС = ExtSize * 4
	BYTE Type;
	WORD PackNum;
	UINT FrameNo;
	WORD PackNo; //0,1,2,3...
	WORD PackSize;
}PackHead; //ͷ, sizeof(PackHead) = 12


//////////////////////////////////////////////////////////////////////////
//Ԥ

//Type
#define PreviewMain	0
#define PreviewSub	1
#define PreviewMobile 2

//Content
#define PreviewComposite	0
#define PreviewVideoOnly	1

typedef struct
{
	UINT Channel; //ͨ 0,1,2,3...
	BYTE Type; //
	BYTE Content; //Ƶ
    BYTE timepos; //ȡ¼ʱ㣺0 ǰʱ 1 ¼ʱ
    BYTE bufsize; //֡ݴС,ʵʴС = bufsize*1024*10; 
}PreviewParam;


//////////////////////////////////////////////////////////////////////////
//TCPԤ
// MsgType=MsgTcpPreview, MsgSize=sizeof(TcpPreviewReq)
//Ӧ ɹAckFlag=AckSuccess ʧAckFlag=AckFail

typedef struct
{
	PreviewParam Param;
	UINT UserKey;
}TcpPreviewReq;


//////////////////////////////////////////////////////////////////////////
//UDP̽
// MsgType=MsgGetUdpAddr
//Ӧ MsgSize=size(GetUdpAddrRsp)

typedef struct
{
	struct sockaddr_in ClientAddr;
	UINT socketfd;
	BYTE Addr[44];
}GetUdpAddrRsp;


//////////////////////////////////////////////////////////////////////////
//UDPʼԤ
// MsgType=MsgStartUdpPreview, MsgSize=sizeof(UdpStartPreviewReq)
//Ӧ ɹAckFlag=AckSuccess, MsgSize=sizeof(UdpStartPreviewRsp) ʧAckFlag=AckFail

typedef struct
{
	GetUdpAddrRsp Rsp;
	PreviewParam Param;
}UdpStartPreviewReq;

typedef struct
{
	UINT UdpPreviewKey;
}UdpStartPreviewRsp;


//////////////////////////////////////////////////////////////////////////
//UDPֹͣԤ
// MsgType=MsgStopUdpPreview, MsgSize=sizeof(UdpStopPreviewReq)
//Ӧ 

typedef struct
{
	UINT UdpPreviewKey;
}UdpStopPreviewReq;


//////////////////////////////////////////////////////////////////////////
//ǿI֡
// MsgType=MsgForceIFrame, MsgSize=sizeof(PreviewParam)
//ҪӦ
typedef struct 
{       
	UINT Channel; //ͨ 0,1,2,3...
	BYTE Type;    //,ͬԤ
	BYTE Reserved[7];
} IFrameReq;

//////////////////////////////////////////////////////////////////////////
//̨
// MsgType=MsgPTZControl, MsgSubtype=MsgPTZUp..., MsgSize=sizeof(PTZControlReq)
//Ӧ ɹAckFlag=AckSuccess, ʧAckFlag=AckFail

#define PTZMinSpeed			0
#define PTZMaxSpeed			100
#define PTZMinCruiseNo		0
#define PTZMaxCruiseNo		63
#define PTZMinPresetIndex	1
#define PTZMaxPresetIndex	255

//Flag
#define PTZControlStart	0
#define PTZControlStop	1

typedef struct
{
	UINT Flag;
	UINT Speed;
}PTZControlNormal;

typedef struct
{
	UINT Flag;
	UINT No;
	UINT Time; /* ԤõѲʱ
				  0  ʾ5S ; 1 ʾ10S; 2 ʾ15S */
	UINT LineSpeed;
}PTZControlCruise;

typedef struct
{
	UINT Index;
}PTZControlPreset;
typedef struct
{
	UINT  CruiseIndex; // ???,??4??? 1-4
	BYTE PpCount; //?????
	BYTE PauseSecs; // ???????
	BYTE Speed; //????
	BYTE Reserved[1];
	BYTE Pps[32]; //?????,????32?
}PTZControlSetPPCruise;

typedef struct
{
	UINT CruiseIndex;//???,1-4
	BYTE Reserved[4];
	
}PTZControlCallCruise;

typedef struct
{
    int PresetNum;
    int reserv[7];
}PTZPresetNum_t;

typedef struct
{
	UINT Channel;
	union
	{
		PTZControlNormal Normal; //MsgPTZUp...MsgPTZAutoScan
		PTZControlCruise Cruise; //MsgPTZCruise
		PTZControlPreset Preset; //MsgPTZSetPreset...MsgPTZCallPreset
        PTZPresetNum_t PresetNum; //MsgPTZGetPresetNum
		PTZControlSetPPCruise ppsCruise;//MsgPTZSetPPCruise
		PTZControlCallCruise idxCruise;//MsgPTZCallPattermCruise,MsgPTZCallPPCruise,MsgPTZStartPattermCruise,MsgPTZEndPattermCruise

	};
}PTZControlReq;

/*ipc, kg*/
typedef struct
{
	BYTE Sensor_id[32]; /* ѯָsensor ID Ԥλ */
	UINT PresetIndex;  /* ָsensor ID ԤλΧ(0 -16)*/ 
}PTZSensorPresetInfo;
//////////////////////////////////////////////////////////////////////////
//ɫʿ
typedef struct
{
	UINT Channel;
	BYTE Chroma;       /* ɫ, <0 - 63> */
	BYTE Brightness;   /* , <0 - 63> */
	BYTE Contrast;     /* Աȶ, <0 - 63> */
	BYTE Saturation;   /* Ͷ, <0 - 63> */
	BYTE reservel[20];
}ColorCtrlReq;

//////////////////////////////////////////////////////////////////////////
//ʱṹ

//typedef struct
//{
//	WORD Year; //2011
//	BYTE Month; //1 ~ 12
//	BYTE Day; //1 ~ 31
//	BYTE Hour; //0 ~ 23
//	BYTE Minute; //0 ~ 59
//	BYTE Second; //0 ~ 59
//	BYTE Reserved;
//}DateTime;


//////////////////////////////////////////////////////////////////////////
//¼ѯ λѯһ32λ

//RecordType
//#define NormalRecord	0x1
//#define AlarmRecord		0x2
//#define AllRecord		0xFFFFFFFF //Only for req, equal to NormalRecord|AlarmRecord...

#define NoRecord       0x0
#define NormalRecord  0x1
#define AlarmRecord   0x2
#define MotionRecord  0x4
#define IORecord      0x8
#define PEARecord      0x10   // ܣܲʹ
#define PEALineRecord 0x10  // 2015.11.30
#define AVDRecord     0x20
#define OSCRecord     0x40
#define AllIntelliRec 0x80
#define SensorRecord   0x100
#define PEAAreaRecord  0x200  // 2015.11.30/2016.03.09
#define OCCRecord      0x400  //private zone
#define NetbreakRecord 0x800  //netbreak
#define HDRecord       0x1000 // 2016.03.09
#define FDRecord       0x2000 // 2016.03.09
#define PCCRecord      0x4000 // 2016.03.09
#define MothionAndIo   0x8000 // 2017.02.09
#define PIRRecord      0x10000 //2017.05.09
#define INE_ALL_RECORD	(PEARecord|PEALineRecord|AVDRecord|OSCRecord|PEAAreaRecord|HDRecord|FDRecord|PCCRecord)
#define AllRecord     0xFFFFFFFF

typedef struct
{
	UINT Channel;
	DateTime Begin;
	DateTime End;
	UINT Type; //RecordType
	UINT Channel_EX[8];
	U8 StreamType;//PLAY_BACK_STREAMTYPE_E
	U8 reserved[7];
}QueryRecordReq;

//ַʽѯ,Ӧʱ,ʱ¼,ҲӦسɹAckFlag=AckSuccess, MsgSize=0

// MsgType=MsgQueryRecord, MsgSubtype=MsgRecordDetail, MsgSize=sizeof(QueryRecordReq)
//Ӧ ɹAckFlag=AckSuccess, MsgSize=n*sizeof(RecordDetailRsp) ʧAckFlag=AckFail

typedef struct
{
	UINT StructSize; //sizeof(RecordDetailRsp)
	DateTime Begin;
	DateTime End;
	UINT Type; //RecordType
	UINT Size; //ļС
}RecordDetailRsp;

// MsgType=MsgQueryRecord, MsgSubtype=MsgRecordDayOutline, MsgSize=sizeof(QueryRecordReq)
//Ӧ ɹAckFlag=AckSuccess, MsgSize=n*sizeof(RecordDayOutlineRsp) ʧAckFlag=AckFail

typedef struct
{
	UINT StructSize; //sizeof(RecordDayOutlineRsp)
	WORD Year; //2011
	BYTE Month; //1 ~ 12
	BYTE Day; //1 ~ 31
	BYTE Hour; //0 ~ 23
	BYTE Minute; //0 ~ 59
	BYTE Second; //0 ~ 59
	BYTE Type;
}RecordDayOutlineRsp;

typedef struct
{
	UINT StructSize; //sizeof(RecordDayHalfHourRsp)
	WORD Year;       //2011
	BYTE Month;      //1 ~ 12
	BYTE Day;        //1 ~ 31
	BYTE HarfHour;   //0 ~ 47
	BYTE Minute;     //0 ~ 59
	BYTE Second;     //0 ~ 59
	BYTE Type;
}RecordDayHalfHourRsp;


//////////////////////////////////////////////////////////////////////////
//¼
// MsgType=MsgDownloadRecordFile, MsgSize=sizeof(DownloadRecordFileReq)+n*sizeof(RecordDetailRsp)
//Ӧ ɹAckFlag=AckSuccess ʧAckFlag=AckFail
//: file1,FileEndPack; file2,FileEndPack; ... filen,FileEndPack
typedef struct
{
	UINT StructSize; //sizeof(DownloadRecordFileReq)
	UINT UserKey;
	UINT Channel;
	BYTE StreamType;//PLAY_BACK_STREAMTYPE_E
	BYTE reserv[11];
}DownloadRecordFileReq;


//////////////////////////////////////////////////////////////////////////
//¼ط

//ʼط
// MsgType=MsgRecordPlay, MsgSize=sizeof(RecordPlayReq)
//Ӧ ɹAckFlag=AckSuccess, ʧAckFlag=AckFail, Ӧ󲻷,ͳһյMsgRecordDataInsufficient

typedef struct
{
	UINT UserKey;
	UINT Channel;
	UINT Type; //RecordType
	DateTime Begin;
	DateTime End;
	BYTE StreamType;//PLAY_BACK_STREAMTYPE_E
	BYTE ExactFrame[39]; 
}RecordPlayReq;

//طŷ
// MsgType=MsgRecordPlayFeedback, MsgSubType=MsgRecordDataInsufficient,MsgRecordDataEnough
//ҪӦ

//ضλ¼
// MsgType=MsgReposRecordData, MsgSize=sizeof(ReposRecordDataReq)
//ҪӦ,յϢ,ֹ֮ͣǰ(Ƿһİ֮),ŷReposPack,Ƿµ
typedef struct
{
	DateTime Begin;
	DateTime End;
}ReposRecordDataReq;

// ڽʱ,ᷢʹϢ
// MsgType=MsgHeartbeat
//ҪӦ


//////////////////////////////////////////////////////////////////////////
//Խ
// MsgType=MsgDualtalk, MsgSize=sizeof(DualtalkReq)
//Ӧ ɹAckFlag=AckSuccess ʧAckFlag=AckFail
typedef struct
{
	UINT UserKey;
}DualtalkReq;


//////////////////////////////////////////////////////////////////////////
//־ѯ

//LogType
#define LOG_TYPE_IO         0x0
#define LOG_TYPE_MD         0x1
#define LOG_TYPE_HDD        0x2
#define LOG_TYPE_VLOSS      0x3
#define LOG_TYPE_OPERA      0x4  // ѯʹ
#define LOG_TYPE_ALARM      0x5  // ѯʹ, iomdƵʧӲ     
#define LOG_TYPE_ALL        0x6  // ѯʹ, ȫ

//Operation type
#define LOG_OPT_FIRST  0x0
#define LOG_OPT_NEXT   0x1
#define LOG_OPT_PREV   0x2 
#define LOG_OPT_LAST   0x3
typedef struct
{   
    DateTime Begin;
    DateTime End;
    UINT Type; 
    UINT Operation;  // û:һʾ;һҳ;һҳ;һҳ
    UINT ExpectNum;  // ϣصĸ
}QueryLogReq;

/*DVRʹ*/
typedef struct
{
    UINT StructSize; //sizeof(QueryLogRsp)
    UINT Channel;
    UINT Type;
    DateTime Point;
    BYTE Reserved[4];
}QueryLogRsp;

/*IPCʹ*/
typedef struct
{
	UINT StructSize;
	char event[64];		///< event description
	BYTE Reserved[4];
}QueryLogRsp_IPC;

//////////////////////////////////////////////////////////////////////////
//

//Element : ElementSize + ExtensibleStruct + zero or more List
//List : ListSize + one or more Element
//ExtensibleStruct : StructSize + other member define
//ע: ElementٱһǿյExtensibleStructֻһStructSize=4Ľṹʾյ)ǿյListElementʾյģ壩Ӧɾȥ
//		ListٱһһElement

//Ӧ ɹAckFlag=AckSuccess ʧAckFlag=AckFail AckFlag=AckParamError, Ȩ޲AckFlag=AckAuthorityFail



typedef struct
{
	UINT StructSize;
	UINT ChannelMask[8];
}ChannelParamReq;

//////////////////////////////////////////////////////////////////////////
//澯ϱ
//ֱϱͻӦ
//
//MsgType=MsgAlarmReport
//ƶ: MsgSubType = MsgMotionAlarm, MsgSize = sizeof(MotionAlarmRpt)
//IO: 	MsgSubType = MsgIOAlarm, MsgSize = sizeof(MotionIORpt)
//ܷ: MsgSubType = MsgAIAlarm, MsgSize = sizeof(MotionAIRpt)

//Status
#define AlarmOn  1 
#define AlarmOff 0 

typedef struct
{
	UINT Channel;
	UINT Status;
	DateTime AlarmTime;
    char RecState;               /* ¼״̬ */
    char CurRecType;             /* ǰ¼ */
    char Schedule;             /* ƻ*/
	char RecEnable;           /* Ƿ¼ */
    UINT ProtocolType;  /* IPCЭ */
	UINT Abilities;     /* IPC豸 */
	UINT Channel_EX[8];
	UINT Status_EX[8];
	UINT IPCDevTypeFlag; /*IPC豸*/
	U8 MsgValidFlagIPCWeb; // whether the msg is valid for IPC IE , 0:valid , 1:invalid (2016.10.28 add)
	U8  InputNum;                 /*ipc io·*/
	U8  OutputNum;                /*ipc io·*/
	BYTE reserver;
	UINT AlarmType;
	/*0:NORMAL;    1:MDALARM;   2:IOALARM;   3:SMART_PEALINE;   4:SMART_AVD;     5:SMART_OSC;
	6:SMART_PEAAREA;  7:SMART_HD;  8:SMART_FD;    9:SMART_CC;*/
	
}RsNetAlarmRpt;

typedef struct{
    short x1;
    short y1;
    short x2;
    short y2;
}Net_Rule_Line_S;

typedef struct
{
	UINT Channel;
	UINT Status;
	DateTime AlarmTime;
}IntelligentAlarmRpt;


/* ܽ */
typedef struct {

    BYTE ChnSwitch;          /*0-رգ1-*/
    BYTE RuleSwitch;         /*ÿͨһֽڱʾ80-رգ1-ʹ*/
    BYTE RuleType;           /*ÿͨһֽڱʾ8-ͣ0-ߣ1-ܽ*/
    BYTE LineTwoWay;         /*ÿͨһֽڱʾ8-˫0-1-˫*/
    BYTE reserver[4];
    Net_Rule_Line_S RuleLine[32];	/*ÿͨ64,32ߣǰֻʹõ1ߣ
                                 ܽ8ɱպͼ */
}SolePEALineMsg;

typedef struct
{
    SolePEALineMsg RuleLine[32];

}SolePEAAlarmRpt;


/* Ʒʧ*/
typedef struct{
    BYTE ChnSwitch;         	 /*0-رգ1-*/
    BYTE RuleSwitch;        	 /*ÿͨһֽڱʾ80-رգ1-ʹ*/
    BYTE reserve[6];
    BYTE RuleRectEnable[8];  	 /*ÿͨ8ÿ4.ÿһλһʹܣĿǰֻǰλ*/
    Net_Rule_Line_S RuleRect[32];/*ÿ4,ÿͨ8432*/
}SoleGoodsLostMsg;

typedef struct
{
    SoleGoodsLostMsg RuleLostLegacy[32];

}SoleGoodsLostAlarmRpt;

typedef struct
{
	UINT Channel;
	UINT Status;
	DateTime AlarmTime;
}AvdAlarmRpt;

typedef struct
{
	UINT Channel;
	UINT Status;
	DateTime AlarmTime;
}VLossAlarmRpt;


//MsgDevStatReport
//MsgNormalStatusReq
typedef struct
{
	UINT Channel;
	UINT Status;
	DateTime AlarmTime;
	
	UINT ProtocolType;
	UINT Abilities;
	UINT AlarmType;
	/*0:NORMAL;    1:MDALARM;   2:IOALARM;   3:SMART_PEALINE;   4:SMART_AVD;     5:SMART_OSC;
	6:SMART_PEAAREA;  7:SMART_HD;  8:SMART_FD;    9:SMART_CC;*/
	U8 IPCDevTypeFlag; /*IPC豸*/	
	U8 MsgValidFlagIPCWeb;//whether the msg is valid for IPC IE , 0:valid , 1:invalid (2016.10.28 add);
	S8 s8Reserve[2];
}DevStatRpt;

typedef struct
{
	UINT Channel;
	UINT Status;
	DateTime AlarmTime;
    char RecState;               /* ¼״̬ */
}VideoHideAlarmRpt;

typedef struct
{
	UINT Channel;
	UINT Status;
	UINT AreaNum;
	UINT SensorNum; 
	DateTime AlarmTime;
}TelModuleAlarmRpt;


//AIType
#define AIPerimeterAlarm 0 //ܽ籨
#define AITripwireAlarm 1 //߱

typedef struct
{
	UINT Channel;
	UINT Status;
	UINT AIType;
	DateTime AlarmTime;
}AIAlarmRpt;

/*ͨʵʱܷ*/
#define MAX_AI_POS_COUNT  16
typedef struct  
{
	/*ͨ*/
	BYTE Channel;
	/**/
	BYTE RuleNo;
	/*ʹܿ*/
	BYTE RuleEnable;
	/*ͣ0-ߣ1-ܽ*/
	BYTE RuleType;
	/**/
	BYTE Direction;
	/*λ*/
	BYTE reservel[3];
	/*߻ֵ߽ܽʹǰĸԪż±Ϊx꣬±Ϊy*/
	unsigned short aiPoints[MAX_AI_POS_COUNT]; 
} AIDataRpt;

//MsgRecordStatusReport
//¼澯Ͷ
#define RECORDSTATUSTYPE_NORMAL      0 
#define RECORDSTATUSTYPE_MANUAL      1 
#define RECORDSTATUSTYPE_MOTION      2 
#define RECORDSTATUSTYPE_IO          3 
#define RECORDSTATUSTYPE_MOTION_IO   4  //ƶIO澯
#define RECORDSTATUSTYPE_MOTION_END  5  //ƶֹͣ  
#define RECORDSTATUSTYPE_IO_END      6  //IOֹͣ 
#define RECORDSTATUSTYPE_PEA         7 
#define RECORDSTATUSTYPE_OSC         8 
#define RECORDSTATUSTYPE_PEA_END     9 
#define RECORDSTATUSTYPE_OSC_END     10 
#define RECORDSTATUSTYPE_PEAAREA     11 // PEA-Area 2015.11.26
#define RECORDSTATUSTYPE_PEAAREA_END 12 // PEA-Area 2015.11.26

#define RECORDSTATUSTYPE_SMART       13 // ܸ澯ʶͳһһ 2016.05.12
#define RECORDSTATUSTYPE_SMART_END   14 // ܸ澯ʶͳһһ 2016.05.12

#define RECORDSTATUSTYPE_PIR         15  // PIR 2017.08.07
#define RECORDSTATUSTYPE_PIR_END     16  // PIR 2017.08.07

typedef struct
{
	UINT Type;  //
	DateTime AlarmTime;//ʱ
	
	UINT ChannelNum;     //Ӧ澯ͨ Ϊ0xffffffffΪͨ
	BYTE RecordStatus;   //¼״̬  1 ʼ¼ 0 ֹͣ¼
	BYTE reservel[3];
    UINT AllChanRecState;    //ͨ¼״̬	
	UINT AlarmType;
	/*0:NORMAL;    1:MDALARM;   2:IOALARM;   3:SMART_PEALINE;   4:SMART_AVD;     5:SMART_OSC;
	6:SMART_PEAAREA;  7:SMART_HD;  8:SMART_FD;    9:SMART_CC;*/
	BYTE  reservel2[4];    
}RecordStatusRpt;

typedef struct
{
	int  SensorNodeId;
	char SensorCmd;
	char OperationType;/*1--modfiy, 2--update,3--add,4--delete*/
	BYTE reserver[2];
	char SensorName[24];
	DateTime AlarmTime;	//ʱ
}SensorStatusRpt;

typedef enum{
	RSNET_HDDSTATUS_NULL		= 0,
	RSNET_HDDSTATUS_OK			= 1,
	RSNET_HDDSTATUS_UNFORMAT	= 2,
	RSNET_HDDSTATUS_FERROR		= 3,
	RSNET_HDDSTATUS_FULL		= 4,
	RSNET_HDDSTATUS_BAD
}RS_HDDSTATUS_E;

//MsgHddStatusReport
typedef struct
{
	
	BYTE HddStatus;	//Ӳ״̬ȡRS_HDDSTATUS_Eֵ
	BYTE reserve[3];
	char HddSN[32];		//̳к
	DateTime AlarmTime;	//ʱ
}HddStatusRpt;


//////////////////////////////////////////////////////////////////////////
//Ϊ˱ЭļĶԣGpsϢϸʱ
//ҲPuInfoHead_tGpsINfo_tRSFrame.hļп 
//RSInfo
#define RSPuInfoTag *(unsigned int*)"RSI"
#define RSPuInfoTypeGPS 'G'
#define RSPuInfoTypeRepos 'R'
#define RSPuInfoTypeEnd 'E'

typedef struct __PuInfoHeadRpt_t
{
	unsigned int Tag : 24;
	unsigned int Type : 8;
	unsigned int InfoSize;
	unsigned long long Time; //(microseconds) Time/1000,000 = the number of seconds after January 1, 1970 UTC
}PuInfoHeadRpt_t;

//pu_info_head_t.type = RSPuInfoTypeGPS, pu_info_head_t.info_size = sizeof(gps_info_t)
typedef struct __GpsInfoRpt_t
{
	double Longitude;
	double Latitude;
	float Speed;
	float SensorSpeed;          //ٶȣΪѡģ飬ֵܸЧ
	float Azimuth;    			// Ϊ0˳ʱ뷽 0~360
	int Signal3G;               //3Gź
	unsigned int TotalMileage;  //  г
	int Temperature;
	char LatitudeDir;       	// ϱ 'N' or 'S'
	char LongitudeDir;      	//  'E' or 'W'
	char Rectified;             // ǷѾ
	char Status;   				//״̬, 'A' ΪЧλ, 'V'ΪЧվ棬ǰҰϷǸ3š
	unsigned char IgnitionFlag; //־λ1:0Ϩ
	char Reserved[3];
	double LongitudeOffset;
	double LatitudeOffset;
}GpsInfoRpt_t;

//GPSϢϸṹ
//MsgGpsInfoReport
typedef struct 
{
	PuInfoHeadRpt_t stHeadRpt;
	GpsInfoRpt_t stBodyRpt;
	
	DateTime AlarmTime;
}GpsInfoPacketRpt;


//////////////////////////////////////////////////////////////////////////
//״̬

// MsgType=MsgStatusRequest, MsgSubtype	= MsgDevAllStatusReq; MsgSize=0
//Ӧ ɹAckFlag=AckSuccess, MsgSize=sizeof(DevAllStatusRpt) ʧAckFlag=AckFail

typedef enum {
	RECORD_STATUS_STOP_E = 0,
	RECORD_STATUS_NORMAL_E,
	RECORD_STATUS_MANUAL_E,   
	RECORD_STATUS_MOTION_E,
	RECORD_STATUS_IOALARM_E,
	RECORD_STATUS_MOTION_IO_E,
	RECORD_STATUS_INTELLIGENTALL_E,
    RECORD_STATUS_MAX_E
}RS_RECORD_STATUS_E;

typedef enum
{
	IPCBIT0_E = 0,//wether display PID intelligent function, 1 : show that ;
	IPCBIT1_E,    //wether display LCD intelligent function, 1 : show that ;
	IPCBIT2_E,    //wether display SOD intelligent function, 1 : show that ;
	IPCBIT3_E,    //wether display PD intelligent function, 1 : show that ;
	IPCBIT4_E,    //wether display FD intelligent function, 1 : show that ;
	IPCBIT5_E,    //wether display CC intelligent function, 1 : show that ;

}PageIntelligent_E;
typedef struct
{
	DateTime AlarmTime;
	
	UINT RecordEnable;	//¼ʹܣλʾ, λΪͨ0
	UINT RecordStatus;	//¼״̬λʾ, λΪͨ0

	UINT MotionEnable;	//ƶʹܣλʾ, λΪͨ0
	UINT MotionStatus;	//ƶ״̬λʾ, λΪͨ0
	
	UINT IOEnable;		//IO澯ʹܣλʾ, λΪͨ0
	UINT IOStatus;		//IO澯״̬λʾ, λΪͨ0
	
	UINT VLossStatus;	//Ƶʧ״̬λʾ, λΪͨ0
	
	BYTE HddStatus[8];	//¼״̬ȡRS_HDDSTATUS_Eֵ
	BYTE HddSN[8][32];	//̳к
	
	//32ͨĲͬ¼״̬ıʶ, ȡ RS_RECORD_STATUS_E ֵ
	BYTE RecordAllStatus[32]; 
    BYTE FtpNewVersFlag;    //Ƿµļʶ:1 ;0 û, 2: 
                            //5: emergency(lorex ר),IEʾ
	BYTE reserve2[3];
    UINT AudioStatus;   //Ƶ״̬,λʾ,λΪͨ0.(ALTEͻ)
    U32  PageIntelligent; 	 //ipc intelligent analysis capability sets (see PageIntelligent_E) add 2016.10.27
	UINT IntelligentChnStatus;	//ui5.0, ʾܵ¼״̬
	UINT IntelligentChnStatusExt[6];//ui5.0ﱣ192·ܹ224·Ӧù
	UINT IntelligentStatus;/*only for ipc used , bit value*/
	/*0:NORMAL;1:MDALARM;2:IOALARM;3:SMART_PEALINE;4:SMART_AVD;5:SMART_OSC;
	  6:SMART_PEAAREA;7:SMART_HD;8:SMART_FD;9:SMART_CC;*/
	UINT CameraCoverSwitch;
	UINT CameraCoverState;
	UINT MotionStatusExt[8];  //ƶ״̬
	UINT IOStatusExt[8];      //IO澯״̬
	BYTE RecordAllStatusExt[8][32];
	UINT PIRStatusExt[8];//PIR״̬λʾ, λΪͨ0 (2016.11.01 add for hydvr)
	UINT SmokeStatusExt[8];//Smoke״̬λʾ, λΪͨ0  (2016.11.01 add for hydvr)
	UINT PageIntelligentChn[32];//ÿܷͨλʾ(see PageIntelligent_E,2016.11.23 add for nvr)
}DevAllStatusRpt;

typedef struct
{
	BYTE code_mode;
	BYTE curShowMode;
	BYTE curStreamNum;
	BYTE unused[13];
}FishEyeIpcStatusRpt;

/* 豸һ¼¼ (ALTEͻר) */
typedef struct
{    
    DateTime LastTime; //¼ʱ
    BYTE ChannelNo;    //¼ͨ
    BYTE RecType;      //¼
    BYTE reserved[22];
}DevLastRecordRpt;

/* lorex httpҪݵԶ˵Ĳ 2014-10-13*/
typedef struct
{
    BYTE OldVersion[8];     //ɰ汾
    BYTE NewVersion[8];     //°汾
    BYTE model[16];         //豸ͺ
    BYTE message[256];      //ʾ
    BYTE reserved[32];
}HttpUpgsRemoteParam_S;

// MsgType=MsgStatusRequest, MsgSubtype	= MsgRemoteCHStatusReq; MsgSize=0
//Ӧ ɹAckFlag=AckSuccess, MsgSize=MAX_CHN_NUM * sizeof(RemoteChnStatusRpt) ʧAckFlag=AckFail

//MsgRemoteCHStatusReport
//MsgRemoteCHStatusReq
typedef struct
{
	unsigned long long DevType;  /* 豸 */
	char CurChnName[20];         /* 豸 */

	char CurChnState;            /* ǰͨ豸״̬ */
    char RecState;               /* ¼״̬ */
    char CurRecType;             /* ǰ¼ */
    char MDState;                /* Motion״̬ */

    char IOState;                /* IO״̬ */
    char VLossState;             /* Ƶʧ״̬ */
	char HddState;               /* Ӳ״̬ */
    char MDSchedule;             /* ƶƻ*/

    char AlarmSchedule;          /* ƻ*/
	
    unsigned char ChannelNum;		/*ǰ豸ӵеͨ*/
    BYTE  IPCDevTypeFlag;        /*IPCͱ־,ڼ3516D,ӦIPC_Dev_Type_e*/
    char  NewDevAbilityModeFlag;      /*˱־˽IPC޸Ϊȡ0λ*/
	
    UINT ProtocolType;/*ǰЭͣӦPROTO_TYPE_E*/
	UINT Abilities;   /*ÿһλһ0֧֣1֧֣ӦNet_ABILITY_TYPE_E*/
	BYTE  InputNum;                 /*ipc io·*/
	BYTE  OutputNum;                /*ipc io·*/
	BYTE reserved[6];	
}DevChnInfo;
//C_ASSERT(sizeof(DevChnInfo) == 56);

/* IPC豸,ڼRS 3516D IPC */
typedef enum
{
    IPC_Reserve_e = 0,    
    IPC_RS_H264_e = 1,
    IPC_RS_H265_e,
    IPC_Onvif_H264_e,
    IPC_Onvif_H265_e,
	IPC_ENCODE_H265_e,/*In view of the third party manufacturer, whether to support h264 / h265 coding*/
	IPC_RS_H264_plus_e,//ְ֧H264H264+
	IPC_RS_H265_plus_e,//ְ֧H265H265+
	IPC_RS_H264_H265_plus_e,//ְ֧H264H265H264+H265+
}IPC_Dev_Type_e;

//MsgRemoteCHStatusReport
//MsgRemoteCHStatusReq
typedef struct
{
	int StructSize;
	int channel;
	DevChnInfo ChnInfo;
}RemoteChnStatusRpt;

// MsgFtpUpgradeAlarm 澯ظ
#define FTPUPGRADE_SUCCESS    0
#define FTPUPGRADE_UPGRADEING 1
#define FTPUPGRADE_PRE_REBOOT 2 
#define FTPUPGRADE_ERROR      3 

typedef struct {
	BYTE UpgradeProcess;  // ɽ 100 Ϊ	
	BYTE UpgradeStatus;    // ǰ״̬
	BYTE reserved[2];	
}FtpUpgradeRpt;



//////////////////////////////////////////////////////////////////////////
//澯
// MsgType=MsgAlarmSubscribe, MsgSubType=MsgAlarmDesired, MsgAlarmRefused
//Ӧ ɹAckFlag=AckSuccess ʧAckFlag=AckFail


//////////////////////////////////////////////////////////////////////////
//Զ

// MsgType=MsgRemoteUpgrade, MsgSize=sizeof(RS_UpgradeReq)
//Ӧ ɹAckFlag=AckSuccess, MsgSize=RS_UpgradeRsp ʧAckFlag=AckUpgrading,AckUpgradeVersionError,AckFail

#define MaxUpgradeFileHead 1024*5

typedef struct
{
	UINT UserKey;
	BYTE FileHead[MaxUpgradeFileHead];
}RS_UpgradeReq;

typedef struct 
{
	unsigned int UpgradeBitmap; //must be int here,can't be long
	unsigned int UpgradeFileSize;
}RSNewMode_UpgradeRsp;

/* Զ IPC */
typedef struct
{
    UINT UserKey;      //û id
    UINT FileSize;     //ļС
    UINT ChannelMask;  //ͨ.λȡ,1:Ҫ;0:Ҫ
    BYTE reserved[4];
    BYTE FileName[256];//ļ
    UINT ChannelMask_EX[8];  //ͨ.λȡ,1:Ҫ;0:Ҫ
}RS_UpgsIpcReq;


#define MaxUpgradeModules  32

typedef struct
{
	upgradefileheaderentry_t NeedUpgrade[MaxUpgradeModules];
}RS_UpgradeRsp;

//ݴ 
//MsgType=MsgRemoteUpgrade, MsgSubType=MsgRemoteUpgradeData,MsgSize=MaxUpgradeFileHead
#define MaxUpgradeDataSize	4096 //һģܻСMaxUpgradeDataSize

//һģ鴫
// MsgType=MsgRemoteUpgrade, MsgSubType=MsgRemoteUpgradePartEnd
//ҪӦ

//
// MsgType=MsgRemoteUpgrade,MsgSubType=MsgRemoteUpgradeEnd, MsgSize=sizeof(RemoteUpgradeEndCheck)
//Ӧ ɹAckFlag=AckSuccess, ʧAckFlag=AckFail ,MsgSize=sizeof(RemoteUpgradeEndWriteFlash)

typedef struct
{
	ULONG Crc;
}RemoteUpgradeEndCheck;

typedef struct
{
    BYTE WriteFlashFlag; //Ƿдflashʾ  1:   0: 
    BYTE reserved[3];
}RemoteUpgradeEndWriteFlash;

//Ӧ MsgType=MsgRemoteUpgrade,MsgSubType=MsgRemoteUpgradeWriteFlashInProgress, MsgSize=sizeof(WriteFlashProgress)  (0 < progress <= 100)
//Ӧ MsgType=MsgRemoteUpgrade,MsgSubType=MsgRemoteUpgradeWriteFlashEnd ʾ
typedef struct 
{
    unsigned char Progress;//ʾ
    char reserved[3];
}WriteFlashProgress;

//Email
typedef struct
{
	WORD Ssl;
	WORD Port;
	BYTE Server[MaxNameLen];
	BYTE Sender[MaxNameLen];  
	BYTE Receiver[MaxNameLen];
	BYTE Password[MaxNameLen];
    BYTE TestType;            //0: ͨ, 1: Kguard ʼ
	BYTE StopTest;
	BYTE Reserved[14];
	BYTE RecvEmail[3][MaxNameLen];
	BYTE username[MaxNameLen];
} EmailTestReq;

//DDNS
typedef struct
{
	BYTE Serveraddr;
	BYTE Hostname[MaxNameLen];
	BYTE Username[MaxNameLen];
	BYTE Password[MaxNameLen];
    BYTE s8TestType;
	BYTE s8CommaxUseLoginFlag;
	BYTE s8UseDDNS;
    BYTE Reserved[12];

} DDNSTestReq;

/* Զ */
typedef struct
{
    BYTE ReqType;   /*,1:ƴ洢.2:̼(չ)*/
    BYTE ReqSubType;/*,1:ƴ洢.2:ƴ洢*/
    WORD ReqMsgSize;/*ЯݴС*/
    BYTE reserved[28];
}RemoteCheckReq;

/* ԶӦ */
typedef struct
{
    BYTE MainType;
    BYTE SubType;
    int  RetValue;
    BYTE reserved[502];
}RemoteCheckRsp;

typedef struct
{
	int  RetVal;
	BYTE RetMsg[500];
} TestRsp;

//Ӳ̸ʽ
#define HDDFORMAT_SUCCESS            0
#define HDDFORMAT_FORMATTING         1 
#define HDDFORMAT_FAIL               2 
#define CANNOT_HDDFORMAT_RECDOWNLOAD 3
typedef struct
{
	UINT HddBitmap;
	UINT ChannelBitmap;	//ֻʽͨ
		
	BYTE Reserved[12];
} HddFormatReq;

typedef struct 
{
	BYTE HddNO;     // ʽ̺ 
	BYTE HddFormatProcess; //  ʽ  10ȡһθʽȣ״̬
	BYTE HddFormatStatue;  // ʽ״̬ 0-ʽɹ 1ڸʽ 2 ʽʧ

	 BYTE Reserved[13];
}HddFormatRsp;
//////////////////////////////////////////////////////////////////////////
//ʱͬ
#define MaxTimeZoneSize  10
typedef struct 
{   
    DateTime Time;
    char     TimeZone[MaxTimeZoneSize];
    char     Reserved[42];
}TimeSyncReq;

//////////////////////////////////////////////////////////////////////////
//Զץͼ
typedef struct 
{
	/*ע⣺ͼѹֱΪVGAʱ֧0=CIF, 1=QCIF, 2=D1ץͼ
	ֱΪ3=UXGA(1600x1200), 4=SVGA(800x600), 5=HD720p(1280x720),6=VGA,7=XVGA, 8=HD900p
	ֵ֧ǰֱʵץͼ*/
	UINT    StructSize;
	WORD	wPicSize;				/* 0=CIF, 1=QCIF, 2=D1 3=UXGA(1600x1200), 4=SVGA(800x600), 5=HD720p(1280x720),6=VGA*/
	WORD	wPicQuality;			/* ͼƬϵ 0- 1-Ϻ 2-һ */
} NET_DVR_JPEGPARA, *LPNET_DVR_JPEGPARA;

typedef struct 
{
	UINT StructSize; //sizeof(RemoteCaptureReq)
	UINT UserKey;  //User key
	UINT Channel;  //Channel No.
	NET_DVR_JPEGPARA jpgPara;//Picture quality parameters
} RemoteCaptureReq;

typedef struct
{
	UINT picSize;
	BYTE Reserved[16];
} RemoteCaptureRsp;

///////////////////////////////////////////////////////////////////////////
//Snapt Report
//Request
typedef struct 
{
	UINT UserKey;
	WORD reserved1;
	WORD reserved2;
} SnaptReportReq;

typedef struct 
{
	DateTime snaptTime; 
	UINT     picSize;
}SnaptCommInfo;
//Motion Report
typedef struct
{
	SnaptCommInfo cmInfo;
	WORD          ch; //0,1,2
	WORD          reserved;
} SnaptMotionReport;

//////////////////////////////////////////////////////////////////////////
//Զ豸̬
//NVR

// MsgType=MsgDevNetCfg, MsgSubType=MsgNoSubType, MsgSize=sizeof(NetMDevInfoReq)
//Ӧ ɹAckFlag=AckSuccess, MsgSize=sizeof(NetMDevInfoRsp) ʧAckFlag=AckFail, MsgSize=sizeof(NetMDevInfoRsp);
#define MAX_UNAME_LEN 10
#define MAX_PWD_LEN   14

typedef struct _NetMDevInfoReq_ //
{
   BYTE msgid[16];  //message id
   BYTE user[MAX_UNAME_LEN]; //user name (for device's authority)
   BYTE pwd[MAX_PWD_LEN];    //password  (for device's authority)
   BYTE cip[4];     //current device ip
   
   BYTE ip[4];     //the device ip what the client wants to change into
   BYTE mask[4];   //the device net mask
   BYTE gw[4];      //the device default gateway
   BYTE dns1[4];    //DNS1
   BYTE dns2[4];    //DNS2
   WORD mport;      //media port   
   WORD wport;      //web port
   BYTE wMode;      //net mode 2:static
   BYTE wNewFlag;   //1:new, 0:old
   BYTE SonixSetMac;//1:setmac
   BYTE reserved;
}NetMDevInfoReq;

// New NetMDevInfoReq, Ϊ˼ ɰ汾
typedef struct _NewNetMDevInfoReq_ //
{
    union
	{
		NetMDevInfoReq DevInfoReq;//ɰ汾ṹ  
		BYTE IpcName[64];
	};
	U64  devTypeULL;            
	BYTE macAddr[36];   //豸MACַ      
}NewNetMDevInfoReq;

struct NetMDevInfoRsp //豸ظ
{
	BYTE msgid[16];  //󷽸msgid,豸ԭֵ
};


//////////////////////////////////////////////////////////////////////////
//ѯԶ豸״̬
//NVR

// MsgType=MsgSearchRemoteDev, MsgSubType=MsgNoSubType, MsgSize=sizeof(SearchRemDevReq)
//Ӧ ɹAckFlag=AckSuccess, MsgSize=n*sizeof(SearchRemDevRe) ʧAckFlag=AckFail, MsgSize=0;

typedef struct
{
	UINT UserKey;
}SearchRemDevReq;

typedef struct
{
    UINT StructSize;		//sizeof(SearchRemDevRe)
    BYTE IPAddr[4];			/*IPַ*/
    BYTE Netmask[4];
    BYTE GateWay[4];
    BYTE Dns1[4];
    BYTE Dns2[4];

    UINT Port;				/*ý˿*/
    UINT WebPort;

    BYTE DevType[8];
    char UserName[36];		/*½û*/
    char UserPW[36];		/*½û*/
    char DeviceName[36];	/*豸ƣ޸*/

    BYTE Protocol;		  //0:RS, 1:HiK, 2:DaH, 3:HH, 4:Onvif
    BYTE ChnMax;			/*ǰipӦǰ豸ͨ*/
    BYTE Version ;
    BYTE switchmode; /*0 Զģʽ 1 Զģʽ*/

    BYTE MacAddr[36];
    U8 switchflag; /*1  0 ʾû*/
    U8 portnum;    /* [0  -MAX_POE_NUM) */
    U8 FrontEndChnnal;
    U8 reserved;
	unsigned long long DevTypeULL;

	//onvifЭ飬ieԶϢ
	char hardware[36];
	char software[36];
	char devicetype[24];
	char manufacturer[36];
    U8 reserved2[4];
}SearchRemDevRep;


//////////////////////////////////////////////////////////////////////////
//Զ豸
//NVR

// MsgType=MsgSetRemoteDevNet, MsgSubType=MsgNoSubType, MsgSize=n*sizeof(SetRemDevNetReq)
//Ӧ ɹAckFlag=AckSuccess, MsgSize=n*sizeof(SetRemDevNetRep) ʧAckFlag=AckFail, MsgSize=0;
typedef struct
{
	UINT StructSize;		//sizeof(SetRemDevNetRe)

	UINT UserKey;
	
	BYTE TargetIPAddr[4];			/*ĿIPַ*/
	UINT TargetPort;				/*Ŀý˿*/    
	
    /*IPַ*/
    BYTE IPAddr[4];
    /**/
    BYTE NetMask[4];
    /**/
    BYTE GateWay[4];
    /*ͻ˶˿ں*/
    UINT Port;
    /*Web˿ں*/
    UINT WebPort;
    /*DNS1*/
    BYTE Dns1[4];
    /*DNS2*/
    BYTE Dns2[4];
	
	char UserName[36];		/*޸Ĳ½û*/    
	char UserPW[36];		/*޸Ĳ½û*/    
	
	BYTE MacAddr[36];
	unsigned long long DevTypeULL;
	BYTE Version ;
	BYTE reserved[3];
}SetRemDevNetReq;

typedef struct
{
	UINT StructSize;		//sizeof(SetRemDevNetRep)
	UINT ErrCode;			//0ɹΪsdkش
}SetRemDevNetRep;


//////////////////////////////////////////////////////////////////////////
//Ƶ
// MsgType=MsgReqVideoActivation;MsgSize=sizeof(VideoActivationReq);Ϣ
//Ӧ ɹAckFlag=AckSuccess,MsgSize= 0  ʧ AckFlag=AckFail;
typedef struct
{
	UINT StructSize;
	UINT ChannelBitmap[8]; 
}VideoActivationReq;

// ErrCode 
#define E_SUCCESS    0        /** < succeed > **/
#define E_FAILED     -1       /** < failed  > **/
#define E_CONTENT    -101     /** < content failed > **/
#define E_CONNECT    -102     /** < connect failed > **/
#define E_SEND       -103     /** < send faile > **/
#define E_RECV       -104     /** < recv faile > **/
typedef struct 
{
	char InfoFlag;  //жӲ֤ת· :0 ͻ· ,1 EmaliTest·ߣ
	char ErrCode;   //  
	char reserve[2];
	char RetMsgInfo[500];
}ActivateCloudRsp;

//FtpWriteFile
typedef struct
{
	BYTE FtpAddr[MaxNameLen];
	UINT FtpPort;
	BYTE Username[MaxNameLen];
	BYTE Password[MaxNameLen];
	BYTE CloudSGFtpTestFlag;
	BYTE Reserved[15];
} FtpWriteFileTestReq;

typedef struct
{
	char ddnsid[MaxNameLen];
	int ErrCode;
}GetDDNSIDRsp;

typedef struct
{
    UINT StructSize; //sizeof(RebootIpcReq)
    UINT ChannelMask;//ͨ
	UINT UserKey;    //User key
    BYTE reserved[4];
    UINT ChannelMask_EX[8];//ͨ
}RebootIpcReq;
typedef struct
{    
    BYTE caption[128];  //˵
    BYTE RepaireType;   //
    BYTE ErrorType;     //
    BYTE reserved[6];
}SG_Repaire_t;

/* ƽֶ̨ϴ -> ά */
typedef struct
{    
    BYTE caption[128];  //˵
    BYTE EquipMaintain; //豸ά
    BYTE MaintainRes;   //ά޽
    BYTE reserved[6];
}SG_Maintenance_t;

/* ƽֶ̨ϴ -> ͼƬ */
typedef struct
{    
    UINT ChannelMask;   //ϴͼƬͨ
    BYTE type;          //
    BYTE reserved[3];
}SG_PicUpload_t;

/* ƽ̨Զ̲ -> ֶͼƬϴ */
typedef struct
{
    UINT StructSize;  //ýṹС
    BYTE mode;        //άģʽ.0:; 1:ά; 2:ͼƬ
    BYTE reserved[3];
    union
    {
        SG_Repaire_t Repaire;
        SG_Maintenance_t Maintain;
        SG_PicUpload_t PicUpload;
    };
}SGManualUploadReq;

/* ͨ± */
typedef struct
{
    UINT StructSize; //ýṹС
    BYTE ReqType;    //, 0-ȡͨ״̬,1-ͨر
    BYTE PreviewMode;//Ԥģʽ.1--,0--໭
    BYTE EncodeCh;   //±ͨ,໭Ϊ200
    BYTE reserved[25];
}ZeroChnStatReq;

/* Զ̻ȡͨԤ״̬ */
typedef struct
{
    UINT StructSize; //ýṹС
    BYTE SplitMode;  //ģʽ,ʱ˫±.1--,4--Ļ,...
    BYTE PreviewMode;//Ԥģʽ.1--,0--໭
    BYTE reserved[2];
    BYTE ChnList[32];//ͨб
}ZeroChnStatRsp;

/*/ɾ豸*/
typedef struct
{
	UINT devId; //sensor豸
	BYTE sensorType;  //sensor豸
	S8   Sensorname[24]; //sensor豸
	S8 sensorCmd;
	BOOL ruleSwitch;
}SensorDevReq;

typedef struct 
{
	S32 remoteCmd;
}MobileRemoteControlStatusReq;


typedef struct 
{
	S8 connectStatus;
}RFConnectReq;
typedef struct
{
	UINT Channel;
	
	UINT delayTime;

	BYTE status;
	BYTE reservel[7];
}SetIOAlarmReq;

typedef struct 
{
	int   UserKey;
	char  Reserve[4];
}RemoteBackupReq_t;

typedef struct 
{
	char msgHead[16];
    char respInfo[40*1024-16];
	char filename[32];
	int  paramLen;
}RemoteBackupResp_t;

//µĵ뵼ļСԭΪ˼ݱ
typedef struct 
{
	int structSize;
	int  paramLen;
	char filename[32];
	char respInfo[80*1024];
}RemoteNewParamBackupResp_t;

typedef struct 
{
	DateTime starTime;//ʼʱ
	DateTime endTime; //ʱ
	BYTE alarmType;//ܽڰߵȸ澯
	BYTE reportType;//
	BYTE censusType;//ͳ
	BYTE reserve;
	UINT channel;
}SearchSmartCountReq;

typedef struct
{
	BYTE alarmType;//ܽڰߵȸ澯
	BYTE version;  //0-ɵĲѯ1-µĲѯ
	BYTE reserve[2];
	UINT channel;
	int  report[32];
	int  reportExt[32]; 
	BYTE filename[32];//heat mapping name
}SearchSmartCountResp;

typedef struct 
{
    UINT StructSize; 	//ýṹС
    BYTE Password[256];
    BYTE reservel[256];
}RSNet_SoleSavetoDev_t;

typedef struct
{
    int  structsize;
    int  times;
}LoginRep_Time;

typedef struct
{
	UINT StructSize; //sizeof(RecordDetailRsp)
	DateTime Begin;
	DateTime End;
	UINT Type; //RecordType
	UINT Size; //ļС
    int  recordId;
    int  diskEventId;  
    BYTE ReqType;//0: jpeg 1: png 2:  I frame
    BYTE reservel[11];
}NewRecordDetailRsp;

typedef struct
{
    UINT StructSize;
    UINT FrameSize;
    BYTE Type;//0: jpeg 1: png 2:  I frame
    BYTE reserve[55];
    NewRecordDetailRsp rsp;
}ThumbnailRsp;

typedef struct
{
    UINT structSize;
    BYTE reserve[12];
    UINT ch[8];
    DateTime eventTime;
}SnapPicForP2PReq;

typedef struct
{
    UINT structSize;
    UINT width;
    UINT height;
    UINT picSize;
    BYTE ch;
    BYTE Type;//0: jpeg 1: png 2:  I frame
    BYTE reserve[14];
    DateTime eventTime;
}SnapPicForP2PResp;

#pragma pack()

#endif
