#ifndef __RSPLAY_H__
#define __RSPLAY_H__

#include "RSTypedef.h"
#include "common_type.h"
#include "correction_type.h"

#ifdef _MSC_VER
#  ifdef RSPLAY_EXPORTS
#    define RSPLAY_API __declspec(dllexport)
#  else
#    define RSPLAY_API __declspec(dllimport)
#  endif
#  define RSPLAY_CALL __stdcall
#else
#  define RSPLAY_API
#  define RSPLAY_CALL
#endif


//ſ
#define PLAY_MODE_NORMAL			0x0001
#define PLAY_MODE_STOP				0x0002
#define PLAY_MODE_PAUSE				0x0003
#define PLAY_MODE_SLOW				0x0004
#define PLAY_MODE_SLOW4				0x0005	
#define PLAY_MODE_SLOW8				0x0006
#define PLAY_MODE_SLOW16			0x0007	
#define PLAY_MODE_FAST_FORWARD2		0x0010
#define PLAY_MODE_FAST_FORWARD4		0x0011
#define PLAY_MODE_FAST_FORWARD8		0x0012
#define PLAY_MODE_FAST_FORWARD16	0x0013
#define PLAY_MODE_FAST_FORWARD32	0x0014
#define PLAY_MODE_SINGLE_FRAME		0x0030
#define PLAY_MODE_NO_RIGHT          0x0031

//audio setting
#define BIT_PER_SAMPLE				16
#define PLAY_AUDIO_SAMPLE_POOR		8000
#define HI3510_TALK_DARABLOCK_SIZE	80
	
typedef struct{ 
	long nWidth; // λΪأƵΪ0
	long nHeight; // ߣλΪأƵΪ0
	long nStamp; // ʱϢλ
	long nType; //
	long nFrameRate;// ʱͼ֡
}FRAME_INFO;

typedef struct{
    void* qImagebuf;
	void* qImageEvent;
}ImageHandle;

enum{
	IMAGE_RGB32 = 16,
	IMAGE_CAPTURE= 32,
	NSysPlay_PLAY = 64,
    SysPlay_PLAY = 128,
    Local_PLAY = 256
};

typedef int (CALLBACK *DECODE_CALLBACK) (char *pData, long lSize, FRAME_INFO *pInfo, void* dwUser); 
typedef ImageHandle* (CALLBACK *IMAGEINFO_CALLBACK)(int nWidth,int nHeight,void* dwObject);
typedef void (CALLBACK* DRAW_FUN_CALLBACK) (HDC hDC, DWORD with, DWORD height, void* pUser, DWORD left, DWORD top);
typedef int (CALLBACK* DUAL_SPEAK_CALLBACK)(int size, const char* data, void* dwUser);
typedef void (CALLBACK *IMAGEEVENT_CALLBACK)(void* qImageEvent,UINT ImageType,char*mfName, void* dwUser);
typedef void (CALLBACK *IMAGEFILE_CALLBACK)(UINT ImageType,int nWidth,int nHeight,long lSize,UCHAR* buf,char*mfName, void* dwUser);
typedef void (CALLBACK* CAPTURE_PICTURE_CALLBACK)(void* data, int size, ULONGLONG time, void* pUser);

typedef struct {
	IMAGEINFO_CALLBACK ImageSizeCallback;
	IMAGEEVENT_CALLBACK ImageEventCallback;
	UINT ImageType;
	void* dwUser;
	void* pObject;
}IMAGE_INFO;

typedef struct {
	IMAGEFILE_CALLBACK ImageEventCallback;
	const char *recordfile_name;
	const char *pic_name;
	UINT fileType;
	UINT ImageType;
	void* dwUser;
    UINT recordMode;
}RSFILE_INFO;

typedef struct {
	const char *recordfile_name;
	const char *pic_name;
}RSFILE_INFOEx;

//
#define VOLUM_MIN	0
#define VOLUM_MAX	100

//
#define PLAY_UNKNOW_TYPE     -1    //no file
#define PLAY_LOCALFILE_TYPE  0     //local file
#define PLAY_NETFILE_TYPE    1     //net file
#define PLAY_NETSTREAM_TYPE  2     //net stream
#define PLAY_DUALTALK_TYPE	 3	   //dual talk
#define PLAY_SYNC_TYPE		 4     //sync play

//
#define DST_SPEAKERS		0	//  
#define SRC_WAVEOUT			1   //
#define SRC_SYNTHESIZER		2	//ϳ
#define SRC_COMPACTDISC     3	//CD
#define SRC_MICROPHONE		4   //˷

#ifdef __APPLE__
#  define MAX_SET_OSD_NUM		36
#else
#  define MAX_SET_OSD_NUM		12	//OSDĿ
#endif

typedef struct __osd_info_t
{
	char font[24];
	int font_width;
	int font_height;
	unsigned char osd_color_red;		//0-255
	unsigned char osd_color_green;		//0-255
	unsigned char osd_color_blue;		//0-255
	RECT osd_rect;

	char osd_string[128];
}osd_info_t;

typedef struct{
	int iRate;
	int iWidth;
	int iFormat;
	int iAmr_mode;
	int iAmr_format;
}AudioTalkConfig_t;

typedef struct {
    DUAL_SPEAK_CALLBACK AudioCaptureCallback;
    void* dwUser;
}AUDIO_CAPTURE_CALLBACK_INFO;

//RSPlaySetCallbackMessage message wparam
#define NET_FILE_DATA_NOT_ENOUGH	1
#define FILE_PLAY_END				11
#define CREATE_DECODE_FAILED        21
#define FILE_CREATE_FAILED          31
#define FILE_WRITE_FAILED           32
//lparm = userParam

//record
#ifndef RSFileType
#  define RSFileType	   1 //.264  .rf
#endif
#ifndef RSAVIFileType
#  define RSAVIFileType	   2 //.avi
#endif
#ifndef RSTEKVFileType
#  define RSTEKVFileType   3 //only for tekversion
#endif
#ifndef RSMP4FileType
#  define RSMP4FileType    4 //.mp4
#endif

enum {
	YUV_444 = 1,
	YUV_422,
	YUV_420,
	YUV_411,
	RGB_565,
	RGB_555,
	RGB_24,
	RGB_32,
	ADPCM,
	IMAGE_INIT = 512
};

enum{
    DEV_TYPE_RSNEW = 0,
    DEV_TYPE_HK,
    DEV_TYPE_RSOLD
};

enum{
    DRAW_TYPE_DDRAW =0,
    DRAW_TYPE_D2D1
};

typedef enum _RSPLAY_FLAG_{
    //1 2 4 8...
    LACK_RESOURCE_FLAG = 1,
}RSPLAY_FLAG;

#ifndef _WIN64
typedef unsigned long RSPlayHandle;
#else
typedef void*         RSPlayHandle;
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void (CALLBACK* PLAY_FUN_CALLBACK)(UINT message, void* userParam);
typedef void (CALLBACK* CROSS_DAY_CALLBACK)(UINT message, void* userParam);
typedef void (CALLBACK* PLAY_DATA_CALLBACK)(const char* data, const UINT width, const UINT height, void* userParam);
typedef void (CALLBACK* CAPTURE_CALLBACK)(BYTE* data, UINT size, int type, void* pUuser);
RSPLAY_API int RSPLAY_CALL RSPlayInitPlayLib(int reserve/* = 0*/, int nDrawType/* = DRAW_TYPE_DDRAW*/, const char* strPath/* = NULL*/);
RSPLAY_API int RSPLAY_CALL RSPlayDeinitPlayLib(void);

RSPLAY_API RSPlayHandle RSPLAY_CALL RSPlayCreatePlayInstance(int play_type); 
RSPLAY_API int RSPLAY_CALL RSPlayDestroyPlayInstance(RSPlayHandle player_id);

RSPLAY_API int RSPLAY_CALL RSPlaySetCallbackMessage(RSPlayHandle player_id, HWND hwnd, UINT message, void* userParam); //NET_FILE_DATA_NOT_ENOUGH...

RSPLAY_API int RSPLAY_CALL RSPlaySetCallbackMessageEx(RSPlayHandle player_id, PLAY_FUN_CALLBACK callback, void* userParam);

//Ļص
RSPLAY_API int RSPLAY_CALL RSPlaySetCrossDayCallbackMessageEx(RSPlayHandle player_id, CROSS_DAY_CALLBACK callback, void* userParam);

RSPLAY_API int RSPLAY_CALL RSPlayAddSyncPlayInstance(RSPlayHandle sync_play, RSPlayHandle player_id);

RSPLAY_API int RSPLAY_CALL RSPlaySetNetPlayBufNum(RSPlayHandle player_id, int num);
//һŴڵָĲʵУһνരȾģʽ
RSPLAY_API int RSPLAY_CALL RSPlaySetPlayWnd(RSPlayHandle player_id, HWND hwnd);
//ָĲʵɾһŴڣһνരȾģʽ
RSPLAY_API int RSPLAY_CALL RSPlayDelPlayWnd(RSPlayHandle player_id, HWND hwnd);

RSPLAY_API int RSPLAY_CALL RSPlaySetPlayPicSize(RSPlayHandle player_id, int width, int height);
RSPLAY_API int RSPLAY_CALL RSPlayGetNetPlayBufNum(RSPlayHandle player_id);
RSPLAY_API HWND RSPLAY_CALL RSPlayGetPlayWnd(RSPlayHandle player_id);
RSPLAY_API int RSPLAY_CALL RSPlayGetPlayPicSize(RSPlayHandle player_id, int *width, int *height);

//0: success   -1:unknown error   -2:file not exist   -3:file access permission denied
RSPLAY_API int RSPLAY_CALL RSPlayOpenPlayFile(RSPlayHandle player_id, const char *file_name);
RSPLAY_API int RSPLAY_CALL RSPlayOpenPlayFileList(RSPlayHandle player_id,const char* fileList, size_t strBufLen, size_t count);
RSPLAY_API int RSPLAY_CALL RSPlayOpenPlayFileListEx(RSPlayHandle player_id,const char* fileList, size_t count);
RSPLAY_API int RSPLAY_CALL RSPlayClosePlayFile(RSPlayHandle player_id);
RSPLAY_API int RSPLAY_CALL RSPlayGetPlayFileTimeRange(RSPlayHandle player_id, ULONGLONG* beginTime, ULONGLONG* endTime);
RSPLAY_API ULONGLONG RSPLAY_CALL RSPlayGetCurPlayedTime(RSPlayHandle player_id);
RSPLAY_API int RSPLAY_CALL RSPlaySetCurPlayedTime(RSPlayHandle player_id, ULONGLONG time);
RSPLAY_API int RSPLAY_CALL RSPlaySetCurPlayedTimeEX(RSPlayHandle player_id, ULONGLONG time);
RSPLAY_API int RSPLAY_CALL RSPlayGetPosImage(RSPlayHandle player_id, ULONGLONG time,IMAGE_INFO *imageInfo);

RSPLAY_API int RSPLAY_CALL RSPlayGetFrameRate(RSPlayHandle player_id, BOOL bFrame_rate);
RSPLAY_API int RSPLAY_CALL RSPlayGetBitRate(RSPlayHandle player_id, BOOL bBit_rate);
RSPLAY_API long RSPLAY_CALL RSPlayGetTotalFrames(RSPlayHandle player_id);
RSPLAY_API long RSPLAY_CALL RSPlayRefreshImage(RSPlayHandle player_id);
RSPLAY_API int RSPLAY_CALL  RSPlayHardwareStretch(RSPlayHandle player_id,BOOL benable,HWND hwnd/* = NULL*/);
RSPLAY_API int RSPLAY_CALL RSPlayGetImageiBpp(RSPlayHandle player_id);

RSPLAY_API int RSPLAY_CALL RSPlayStartPlay(RSPlayHandle player_id);
RSPLAY_API int RSPLAY_CALL RSPlayStopPlay(RSPlayHandle player_id);
RSPLAY_API int RSPLAY_CALL RSPlaySetPlayMode(RSPlayHandle player_id, int play_mode, int reserved/* = 0*/);
RSPLAY_API int RSPLAY_CALL RSPlayGetPlayMode(RSPlayHandle player_id);


RSPLAY_API int RSPLAY_CALL RSPlayStartlocalrecord(RSPlayHandle player_id, const char *recordfile_name, UINT fileType, UINT record_mode/* = 0*/);
RSPLAY_API int RSPLAY_CALL RSPlaySwitchRecordFile(RSPlayHandle player_id, const char *recordfile_name, UINT fileType, UINT record_mode/* = 0*/);
RSPLAY_API int RSPLAY_CALL RSPlayStoplocalrecord(RSPlayHandle player_id, ULONGLONG* begintime, ULONGLONG* endtime);
RSPLAY_API int RSPLAY_CALL RSPlayStartlocalrecordFile(RSPlayHandle player_id, RSFILE_INFO *fileinfo);
RSPLAY_API int RSPLAY_CALL RSPlayCreatePicbylocalFile(RSPlayHandle player_id,RSFILE_INFOEx *fileinfo);

RSPLAY_API int RSPLAY_CALL RSPlayInputNetFrame(RSPlayHandle player_id, void *buf, int size);
RSPLAY_API int RSPLAY_CALL RSPlayGetListFrameNum(RSPlayHandle player_id);

RSPLAY_API int RSPLAY_CALL RSPlayOpenSound(RSPlayHandle player_id);
RSPLAY_API int RSPLAY_CALL  RSPlayCloseSound(RSPlayHandle player_id);
//Control the system volume,cannot use in win7 OS
RSPLAY_API int RSPLAY_CALL RSPlaySetPlayVolume(int volume);
RSPLAY_API int RSPLAY_CALL RSPlayGetPlayVolume();
RSPLAY_API int RSPLAY_CALL RSPlaySetMute(BOOL bMute);
RSPLAY_API BOOL RSPLAY_CALL RSPlayGetMute();
//
//Only control volume on one play instance
RSPLAY_API int RSPLAY_CALL RSPlaySetPlayVolume_s(RSPlayHandle player_id,int volume);
RSPLAY_API int RSPLAY_CALL RSPlayGetPlayVolume_s(RSPlayHandle player_id);
RSPLAY_API int RSPLAY_CALL RSPlaySetMute_s(RSPlayHandle player_id,BOOL bMute);
RSPLAY_API BOOL RSPLAY_CALL RSPlayGetMute_s(RSPlayHandle player_id);
RSPLAY_API int RSPLAY_CALL RSPlaySetPlayVolume_bysoft(RSPlayHandle player_id,int volume);
//

RSPLAY_API int RSPLAY_CALL RSPlaySetMicPlayVolume(int volume);
RSPLAY_API int RSPLAY_CALL RSPlayGetMicPlayVolume();
RSPLAY_API int RSPLAY_CALL RSPlaySetMicMute(BOOL bMute);
RSPLAY_API BOOL RSPLAY_CALL RSPlayGetMicMute();

RSPLAY_API int RSPLAY_CALL RSPlaySetOsdString(RSPlayHandle player_id, int index, osd_info_t *p_osd_info);
RSPLAY_API int RSPLAY_CALL RSPlayRemoveOsdstring(RSPlayHandle player_id, int index);
RSPLAY_API int RSPLAY_CALL RSPlayGetAllOsdstring(RSPlayHandle player_id, osd_info_t *p_osd_info,bool* p_bOsd); //max size:MAX_SET_OSD_NUM

RSPLAY_API int RSPLAY_CALL RSPlayCapturePicture(RSPlayHandle player_id, char *file_name);
//type:0ΪBMPļ1Ϊpngļ2Ϊjpgļ
RSPLAY_API int RSPLAY_CALL RSPlayCapturePictureToBuf(RSPlayHandle player_id, CAPTURE_CALLBACK callback, void *pUser, int type);
RSPLAY_API int RSPLAY_CALL RSPlayCapturePictureBuf(RSPlayHandle player_id, char *buf);
RSPLAY_API int RSPLAY_CALL RSPlayCapturePictureCallUser(RSPlayHandle player_id, void *usr);

RSPLAY_API int RSPLAY_CALL RSPlayGetSDKVesion(char *ver_string);
RSPLAY_API int RSPLAY_CALL RSPlayGetLastError(RSPlayHandle player_id, char *err_string);

RSPLAY_API int RSPLAY_CALL RSPlayStartDualTalk(RSPlayHandle player_id, AudioTalkConfig_t *pAudioTalk/* = NULL*/);
RSPLAY_API int RSPLAY_CALL RSPlayStopDualTalk(RSPlayHandle player_id);
RSPLAY_API int RSPLAY_CALL RSPlayRegisterSetDualCallback(RSPlayHandle player_id, DUAL_SPEAK_CALLBACK callback, void* dwUser);

RSPLAY_API int RSPLAY_CALL RSPlayGetCurrentFrameNo(RSPlayHandle player_id); 
RSPLAY_API int RSPLAY_CALL RSPlayAdjustViewArea(RSPlayHandle player_id, int left, int right, int top, int bottom);
//עָŴڵĻͼصһνരȾģʽ
RSPLAY_API int RSPLAY_CALL RSPlayRegisterDrawFun_s(RSPlayHandle player_id, DRAW_FUN_CALLBACK DrawFun, void* pUser,HWND hwnd);
//עָʵĻͼصڵν뵥Ⱦģʽ
RSPLAY_API int RSPLAY_CALL RSPlayRegisterDrawFun(RSPlayHandle player_id, DRAW_FUN_CALLBACK DrawFun, void* pUser);
//bEnable = 0, ʵʱ
//bEnable = 1, iMax = 0⽫֡ݵʱţ֡ҪƣҲnet_fileģʽ
//bEnable = 1, iMax1505000,iMaxΪõ֡
RSPLAY_API int RSPLAY_CALL  RSPlaySetCushionRange(RSPlayHandle player_id, BOOL bEnable, int iMax);
RSPLAY_API int RSPLAY_CALL RSPlayRegisterDecCallback(RSPlayHandle player_id, DECODE_CALLBACK DecCallback, void* dwUser);
RSPLAY_API int RSPLAY_CALL RSPlayImageCallback(RSPlayHandle player_id,IMAGE_INFO *pInfo,HWND hwnd/* = NULL*/);
#define RE_NORMAL			0
#define RE_MIRROR_LEFTRIGHT	1
#define RE_MIRROR_UPDOWN	2
RSPLAY_API int RSPLAY_CALL RSPlaySetRenderEffect(RSPlayHandle player_id, int type);

//enable 0:ƽ̵ ʵͼʾʵʱĬΪ0
#define RP_ORIGINAL         0
#define RP_PICTURE          1
#define RP_4_3              2
#define RP_16_9             3
RSPLAY_API void RSPLAY_CALL RSPlayRenderActualProportion(RSPlayHandle player_id, int enable); 
//Ƿʹˮӡ
RSPLAY_API void RSPLAY_CALL RSUseWaterMarkDecorder(BOOL bUse);

//ǷʾˮӡFALSEʾƵ֤ʧܣƵܱ۸Ĺ
RSPLAY_API BOOL RSPLAY_CALL RSShowWaterMark(RSPlayHandle player_id);

RSPLAY_API BOOL RSPLAY_CALL RSPlayRePaint(RSPlayHandle player_id);
RSPLAY_API BOOL RSPLAY_CALL RSPlayNSynchroRePaint(RSPlayHandle player_id);
/*add by huijun 20110801*/
typedef int (CALLBACK *CONVERT_STATUS_CALLBACK) (int progress,void* param); 
RSPLAY_API int RSPLAY_CALL RSPlay264ToAviStart(RSPlayHandle player_id,PCSTR _264FileName,PCSTR aviFileName,void* param,CONVERT_STATUS_CALLBACK status_callback);
RSPLAY_API int RSPLAY_CALL RSPlay264ToAviStop(RSPlayHandle player_id);
    
RSPLAY_API int RSPLAY_CALL RSPlayConvertFileStart(RSPlayHandle player_id,PCSTR src_file,PCSTR dst_file,void* param,CONVERT_STATUS_CALLBACK status_callback);
RSPLAY_API int RSPLAY_CALL RSPlayConvertFileStop(RSPlayHandle player_id);

//طץͼص
//type:0ΪBMPļ(only for windows)1Ϊpngļ2Ϊjpgļ
RSPLAY_API int RSPLAY_CALL RSPlaySetCapturePictureCallback(RSPlayHandle player_id, int imageType, CAPTURE_PICTURE_CALLBACK callback, void* pUser);
  
RSPLAY_API void RSPLAY_CALL RSPlayClearFlag(RSPLAY_FLAG mask);

RSPLAY_API void RSPLAY_CALL RSPlaySetRenderStatus(BOOL bStop, BOOL bLock);

//for android to send record audio data to DVR or NVR
RSPLAY_API int RSPLAY_CALL RSPlayGetAudioCaptureInfo(RSPlayHandle player_id, AUDIO_CAPTURE_CALLBACK_INFO* info);

//set hardware decode,only for ios and h264 frame
RSPLAY_API int RSPLAY_CALL RSPlaySetHardWareDecode(BOOL bEnable);

//for fish eye
RSPLAY_API int RSPLAY_CALL RSPlayFishGetChnNums(FISHEYE_COMB_TYPE_E enFishEyeType);
RSPLAY_API int RSPLAY_CALL RSPlayFishSetMode(RSPlayHandle player_id, FISHEYE_COMB_TYPE_E enFishEyeType);
RSPLAY_API int RSPLAY_CALL RSPlayFishControl(RSPlayHandle player_id, FISH_CONTROL_REQ_S* req);

RSPLAY_API int RSPLAY_CALL RSPlayDelSyncPlayInstance(RSPlayHandle sync_play, RSPlayHandle player_id);

#ifdef __cplusplus
}
#endif // end of extern "C"

#endif // end of __RSPLAY_H__
