#ifndef _CORRECTION_TYPE_H_
#define _CORRECTION_TYPE_H_

#include "common_type.h"

#ifndef WINDOWS_PLATFORM
#include <sys/time.h>
#define CV_PI 3.1415926f
#endif
#ifdef ANDROID_PLATFORM
#include <jni.h>
#include <android/log.h>
#define  LOG_TAG    "libgl2jni"
#define  LOGI(...)  __android_log_print(ANDROID_LOG_INFO,LOG_TAG,__VA_ARGS__)
#define  LOGE(...)  __android_log_print(ANDROID_LOG_ERROR,LOG_TAG,__VA_ARGS__)
#endif

#define MAX_FISHEYE_CHN 9	//Ŀ
#define MAX_FISHEYE_DEV 1	//豸Ŀ

/*̶ģʽ*/
typedef enum rsFISHEYE_COMB_TYPE_E
{
	FISH_CEILING_EYE = 0,		// +                  [FishEye]
	FISH_CEILING_VR,	        // +VR״                [VR]
	FISH_CEILING_CYLIND3D,      // +VR                [Cylinder]
	FISH_CEILING_CYLIND360,		// +360ȫ			      [Panorama 360]
	FISH_CEILING_CYLIND180,		// +180ȫ               [Panorama 180]
	FISH_CEILING_2PTZ,			// +2PTZ                [2 PTZ]
	FISH_CEILING_4PTZ,			// +4PTZ         = 4    [4 PTZ]
	FISH_CEILING_CYLIND360_1PTZ,// +360ȫ+1PTZ        [Panorama 360 + 1 PTZ]
	FISH_CEILING_CYLIND360_3PTZ,// +360ȫ+3PTZ = 4    [Panorama 360 + 3 PTZ]
	FISH_CEILING_CYLIND360_6PTZ,// +360ȫ+6PTZ = 7    [Panorama 360 + 6 PTZ]
	FISH_CEILING_CYLIND360_8PTZ,// +360ȫ+8PTZ = 9    [Panorama 360 + 8 PTZ]
	FISH_CEILING_EYE_3PTZ,		// ++3PTZ	   = 4    [FishEye + 3 PTZ]
	FISH_CEILING_EYE_8PTZ,		// ++8PTZ    = 9    [FishEye + 8 PTZ]

	FISH_DESKTOP_EYE,			// +                  [FishEye]
	FISH_DESKTOP_VR,	        // +VR״                [VR]
	FISH_DESKTOP_CYLIND3D,      // +VR                [Cylinder]
	FISH_DESKTOP_CYLIND360,		// +360ȫ               [Panorama 360]
	FISH_DESKTOP_CYLIND180,		// +180ȫ               [Panorama 180]
	FISH_DESKTOP_4PTZ,			// +4PTZ         = 4    [4 PTZ]
	FISH_DESKTOP_CYLIND360_1PTZ,// +360ȫ+1PTZ        [Panorama 360 + 1 PTZ]
	FISH_DESKTOP_CYLIND360_3PTZ,// +360ȫ+3PTZ = 4    [Panorama 360 + 3 PTZ]
	FISH_DESKTOP_CYLIND360_6PTZ,// +360ȫ+6PTZ = 7    [Panorama 360 + 6 PTZ]
	FISH_DESKTOP_CYLIND360_8PTZ,// +360ȫ+8PTZ = 9    [Panorama 360 + 8 PTZ]
	FISH_DESKTOP_EYE_3PTZ,		// ++3PTZ    = 4    [FishEye + 3 PTZ]
	FISH_DESKTOP_EYE_8PTZ,		// ++8PTZ    = 9	  [FishEye + 8 PTZ]

	FISH_WALL_EYE,				// װ+				  [FishEye]
	FISH_WALL_VR,               // װ+VRȫ				  [VR]
	FISH_WALL_NORMAL,			// װ+normalȫ			  [Panorama]
	FISH_WALL_4PTZ,				// װ+4PTZ            = 4 [4 PTZ]
	FISH_WALL_NORMAL_3PTZ,		// װ+normalȫ+3PTZ = 4 [Panorama + 3 PTZ]
	FISH_WALL_NORMAL_8PTZ,		// װ+normalȫ+8PTZ = 9 [Panorama + 8 PTZ]
	FISH_WALL_EYE_3PTZ,			// װ++3PTZ       = 4 [FishEye + 3 PTZ]
	FISH_WALL_EYE_8PTZ,			// װ++8PTZ       = 9 [FishEye + 8 PTZ]

	FISH_TILT_EYE,				// б+                  [FishEye]
	FISH_TILT_VR,               // б+VRȫ				  [VR]
	FISH_TILT_NORMAL,			// б+normalȫ            [Panorama]
	FISH_TILT_4PTZ,				// б+4PTZ            = 4 [4 PTZ]
	FISH_TILT_NORMAL_3PTZ,		// б+normalȫ+3PTZ = 4 [Panorama + 3 PTZ]
	FISH_TILT_NORMAL_8PTZ,		// б+normalȫ+8PTZ = 9 [Panorama + 8 PTZ]
	FISH_TILT_EYE_3PTZ,			// б++3PTZ       = 4 [FishEye + 3 PTZ]
	FISH_TILT_EYE_8PTZ,			// б++8PTZ       = 9 [FishEye + 8 PTZ]

	FISH_COMB_TYPE_BUTT
}FISHEYE_COMB_TYPE_E;

/*۹һģ*/
typedef enum rsFISHEYE_MOUNT_MODE_E					
{
	RSFISHEYE_CEILING_MOUNT = 0,		///
	RSFISHEYE_DESKTOP_MOUNT = 1,		//׹/
	RSFISHEYE_WALL_MOUNT    = 2,		//ڹ/װ
	RSFISHEYE_TILT_MOUNT    = 3,		//ڹ/б
	RSFISHEYE_MOUNT_MODE_BUTT
}RSFISHEYE_MOUNT_MODE_E;

/*Ӧģ*/
typedef enum rsFISHEYE_MODEL_E						
{
	FISHEYE_SPHERE		= 0,		//Уң׹ңڹң
	FISHEYE_LATITUDE	= 1,		//ڹģͣԼͼװģ Latitude
	FISHEYE_CYLINDER360 = 2,		//360Ȼͼң׹ң
	FISHEYE_CYLIND3D    = 3,        //3dң׹ң
	FISHEYE_SPHERE_VR   = 4,		//VRͼң׹ң
	FISHEYE				= 5,        //ԭͼ
	FISHEYE_SPHERE_RE   = 6,        //ģ[-1/2 1/2]ȷĳǶ۷ΧΧ
	FISHEYE_BOUNDARY    = 7,        //ģ[-1 1], ѡдڻ߽
	FISHEYE_CYLINDER180 = 8,		//180Ȼͼң׹ң
#if !defined (WINDOWS_PLATFORM)
	FISHEYE_FLIP = 9,				//flip
	FISHEYE_ORIGNAL = 10,			//ԭͼ
#endif
	FISHEYE_MODEL_BUTT
}FISHEYE_MODEL_E;

typedef enum rsFISHEYE_RANGE_TYPE_E
{
	FISHEYE_RANGE_CURVE,				//߷Χ
	FISHEYE_RANGE_RECT,					//ηΧ
	FISHEYE_RANGE_BUTT
}FISHEYE_RANGE_TYPE_E;

/*ɫĿ*/
typedef enum rsFISH_PROGRAM_E
{
	FISH_PROGRAM_NORMAL,
//	FISH_PROGRAM_SPHEREVR,				
//	FISH_PROGRAM_CYLINDVR,				//VRģĿ
	FISH_PROGRAM_SPHERERANGE,			//淶ΧĿ
	FISH_PROGRAM_CYLINDRANGE,			//淶ΧĿ
	FISH_PROGRAM_LATITUERANGE,			//γȷΧ
	FISH_PROGRAM_BOUNDARY,				//α߽緶ΧĿ
#if !defined (WINDOWS_PLATFORM)
	FISH_PROGRAM_FLIP,					//flip
	FISH_PROGRAM_ORIGNAL,				//ԭͼ
#endif
	FISH_PROGRAM_BUTT
}FISH_PROGRAM_E;

/*ͼʽ*/
typedef enum rsFISH_SNAPSHOT_E
{
	FISH_SNAPSHOT_BMP = 0, //D3DXIFF_BMP
	FISH_SNAPSHOT_JPG = 1, //D3DXIFF_JPG
	FISH_SNAPSHOT_TGA = 2, //D3DXIFF_TGA
	FISH_SNAPSHOT_PNG = 3, //D3DXIFF_PNG
	FISH_SNAPSHOT_DDS = 4, //D3DXIFF_DDS   
	FISH_SNAPSHOT_BUTT
}FISH_SNAPSHOT_E;

/*ptz*/
typedef enum rsFISH_PTZ_E
{
	FISH_PTZ_LEFT = 0,					//
	FISH_PTZ_RIGHT,						//
	FISH_PTZ_UP,						//
	FISH_PTZ_DOWN,						//
	FISH_PTZ_LEFTUP,					//
	FISH_PTZ_RIGHTUP,					//
	FISH_PTZ_LEFTDOWN,					//
	FISH_PTZ_RIGHTDOWN,					//
	FISH_PTZ_ZOOMINC,					//Ŵ
	FISH_PTZ_ZOOMDEC,					//С
	FISH_PTZ_CURISE,					//Ѱ
	FISH_PTZ_BUTT
}FISH_PTZ_E;

/*ڲ*/
typedef struct rsFISH_INTRIC_PARA_S
{
	float r;								//۰뾶
	float cx;								// x
	float cy;								// y
	float ang;								//ʼǶ
#if defined (HI_PLATFORM) || defined (WINDOWS_PLATFORM)
	int width[3];
	int height[3];							//ͼ
#endif
	char resvd[4];
}FISH_INTRIC_PARA_S;	

/*ptz*/
typedef struct rsFISH_MOVE_S
{
	FISH_PTZ_E ePtz;					//ptz
	float dx;							//϶xС  ptzλƶxСҷ
	float dy;							//϶yС  ptzλƶyС·
	float dk;							//ŴС ptzβŴС仯ֵ

	float v;							//ptzǰλƶٶ

	float x;							//Ԥλxλ
	float y;							//Ԥλyλ
	float k;							//ԤλŴС

	char CruiseNum;                     //ڼѲ(1~MAX_FISHEYE_CHN, 0ΪûѲ)
	char EnableNum;                     //ڼPTZ (1~MAX_FISHEYE_CHN, 0Ϊûп)
	bool bSlowDown;						//ǷǴڼ״̬
	char resvd[1];
}FISH_MOVE_S;

/*β*/
typedef struct rsFISH_ROAM_PARA_S
{
	float x;							//x
	float y;							//y
	float k;							//ŴС
#if !defined (WINDOWS_PLATFORM)
	bool bFullScreen;					//ǷΪȫ
	bool bCruise;						//Ƿѯ
#endif
	bool bDefault;                      //ǷĬϲ
	char resvd[3];
}FISH_ROAM_PARA_S;

typedef struct rsFISH_RENDER_RANGE_S
{
	float x;						//Ⱦƽʼλx
	float y;						//Ⱦƽʼλy
	float w;						//Ⱦƽʼλÿ
	float h;						//Ⱦƽʼλø߶
#if defined (WINDOWS_PLATFORM)
	int screen_width;               //ÿĿ
	int screen_height;				//ÿĸ߶
#endif
	char resvd[4];
}FISH_RENDER_RANGE_S;

typedef struct rsROMA_ATTR_S
{
	FISHEYE_MODEL_E eModel;           //ģ	
	FISH_ROAM_PARA_S astRoamPara;     //β
	FISH_RENDER_RANGE_S stRenderRange;//Χ
	OrthoProjInfo_S stOrthoProjInfo;  //ͶӰ
	float fAngle;					  //Ƕȱ仯
	char resvd[4];
}ROMA_ATTR_S;

/*УΧͼϢ*/
typedef struct rsFISHEYE_RANGE_MAP_S
{
	FISH_PROGRAM_E	eFishProgramRange;		//ͼҪʹõĿ
	bool bActivate;							//ΧǷ񱻼

	#ifdef WINDOWS_PLATFORM

	FISHEYE_RANGE_TYPE_E enRangeType;       //Χ
	time_t clickTimeVal;					//ʱ
	unsigned char u8DrawScreenNum;			//ڵڼϻΧ
	char resvd[2];

	#else

	FISHEYE_MODEL_E	eFishEyeModel;			//ȫͼ
	struct timeval clickTimeVal;			//ʱ
	bool bDraw;								//ǷҪУΧͼ
	unsigned char u8SelectScreenNum;		//ѡĵڼĻ
	unsigned char u8ScreenNum;				//ڵڼϽͼ
	char resvd[1];

	#endif

}FISHEYE_RANGE_MAP_S;

/*ӹϢ*/
typedef struct rsFISHEYE_FUNC_S
{
	char String[256];				  //ͼ· 
	FISH_SNAPSHOT_E enSnapShotType;   //ͼͼƬĸʽ
	bool bIsSnapShot;                 //ǷͼĬϲͼ
	bool bIsRender;                   //ǷȾĬȾ

}FISHEYE_FUNC_S;

/*ģͶ̬仯Ч*/
typedef struct rsFISHEYE_DYNAMIC_S
{
	/*ɲ0任1*/
	ROMA_ATTR_S stRoma0;		//ģ0Ĳ(ǰģ)
	ROMA_ATTR_S stRoma1;		//ģ1Ĳ
	float fCoef;				//ģͱ仯ϵ0->10Ϊǰģͣ1ΪҪģ,мֵΪ̬仯
	unsigned char u8DynamicType;//̬仯ͣ0:Ϊģڲл1:Ϊģʽл
	bool bActivate;				//̬ЧǷ񱻼
	char resvd[2];

}FISHEYE_DYNAMIC_S;

/*УʼǶ*/
typedef struct rsFISHEYE_INITANGLE_S
{
	bool bActivate;					//Ƿ񱻼
	float x;						//Ⱦƽʼλx
	float y;						//Ⱦƽʼλy
	float w;						//Ⱦƽʼλÿ
	float h;						//Ⱦƽʼλø߶
	float fInitAngle;				//ʼǶ
	RSFISHEYE_MOUNT_MODE_E enFishMountMode;
}FISHEYE_INITANGLE_S;

typedef struct rsFISHEYE_ATTR_S 
{
	RSFISHEYE_MOUNT_MODE_E enFishMountMode;			//۹һģ
	FISHEYE_COMB_TYPE_E  enFishCombType;		    //ģʽ	
	
	unsigned char u8MultiScreen;				    //Ŀ
	unsigned char u8SelectScreenNum;		        //ѡĵڼĻ
	unsigned char u8FullScreen;						//ڼȫ
	char resvd[1];
	ROMA_ATTR_S astRegionAttr[MAX_FISHEYE_CHN];     //
	FISH_MOVE_S stFishMove;                         //PTZ
	FISHEYE_RANGE_MAP_S stFishRangeMap;			    //УķΧͼ
	FISHEYE_DYNAMIC_S   stFishDynamic;              //̬Ч
	FISHEYE_FUNC_S astFishFunc[MAX_FISHEYE_CHN];    //ӵĹ
	FISHEYE_INITANGLE_S stFishInitAngle;			//ʼǶȿ
}RSFISHEYE_ATTR_S; 

typedef struct rsIMAGE_S
{
	FISHEYE_PIXEL_FORMAT_E ePixFormat;					//
#if !defined (WINDOWS_PLATFORM)
	FISHEYE_FRAME_FORMAT_E eFrameFormat;				//֡ͣͨframe,frame
#endif
	unsigned char* pDataAddr[3];						//ַ
	unsigned int u32PhyAddr[3];							//ַ
	int width[3];										//ͼ
	int height[3];										//ͼ
	int stride[3];										//
	int timeRef;										//ʱο
	void* pPrivate;										//
	char resvd[4];
}IMAGE_S;

typedef struct rsFISH_OUT_INFO_S
{
	int imgNum;									//ͼĿ
	IMAGE_S stFishImgOut[MAX_FISHEYE_CHN];		//ͼϢ
	char resvd[4];
}FISH_OUT_INFO_S;

#ifdef WINDOWS_PLATFORM
typedef struct rsFISH_SHADER_PATH_S
{
	char* Path[100];

}FISH_SHADER_PATH_S;

typedef struct rsFISH_DEVICE_S
{
	FISH_SHADER_PATH_S* Path;
	HWND hWnd;    // window handle
	//HGLRC hglrc;  // rendering context
	//HDC   hdc;    // device context

}FISH_DEV_S;
#endif

/**/
typedef enum rsFISH_MOUSE_E
{
	FISH_MOUSE_MOVE = 0,               //
	FISH_MOUSE_WHEEL,                  //
	FISH_MOUSE_LBUTTONDOWN,            //
	FISH_MOUSE_LBUTTONUP,              //ͷ
	FISH_MOUSE_LBUTTONDBLCLK,          //˫left button double click
	FISH_MOUSE_RBUTTONDBLCLK,          //Ҽ˫right button double click
	FISH_MOUSE_BUTT
}FISH_MOUSE_E;

/*ܰť*/
typedef enum rsFISH_FUNC_E
{
	FISH_FUNC_SNAPSHOT = 0, 		  //ͼ
	FISH_FUNC_PREVIEW,                //ͨԤ
	FISH_FUNC_CHNSELECT,			  //ѯǰѡеķں
	FISH_FUNC_BUTT
}FISH_FUNC_E;

/*豸*/
typedef enum _FishControlFlag_E 
{
    FISH_EYE_PTZ_E   = 0,              //PTZ
    FISH_EYE_MOUSE_E = 1,              //
	FISH_EYE_FUNC_E  = 2,              //ܰť
    FISH_EYE_BUTT
}FishControlFlag_E;

typedef struct 
{
    FISH_PTZ_E eFlag;                   //FISH_PTZ_LEFT --- FISH_PTZ_RIGHTDOWN
    float      speed;                   //ptzǰλƶٶ 1~10
	float      k;                       //ptz-1~+1 	FISH_PTZ_ZOOMINC --- FISH_PTZ_ZOOMDEC
	bool       bEnable;                 //ʹܿ
}FISH_EYE_PTZ_S;

typedef struct 
{
	FISH_MOUSE_E eFlag;                 //FISH_MOUSE_MOVE --- FISH_MOUSE_LBUTTONDBLCLK
    float        x;						//϶xС
    float        y;						//϶yС
	float        value;                 //βŴС仯ֵ
}FISH_EYE_MOUSE_S;

typedef struct
{
	FISH_FUNC_E eFlag;                  //FISH_FUNC_CHNSELECT --- FISH_FUNC_PREVIEW
	bool bEnable;                       //FISH_FUNC_PREVIEW ʹ
	FISH_SNAPSHOT_E enSnapShotType;     //FISH_FUNC_SNAPSHOT
	char String[256];                   //FISH_FUNC_SNAPSHOT
	unsigned char ChnSelect;            //FISH_FUNC_CHNSELECT ѡеĴ
}FISH_EYE_FUNC_S;

typedef struct _FISH_CONTROL_REQ_S_ 
{
    int                 channel;
    FishControlFlag_E   eFlag;
    int                 width;         // UI width
    int                 height;        // UI height
    union 
	{
        FISH_EYE_PTZ_S   stPtz;
        FISH_EYE_MOUSE_S stMouse;
		FISH_EYE_FUNC_S  stFunc;
    };
}FISH_CONTROL_REQ_S;

#endif