// CheckGroupCtrl.cpp : ʵļ
//

#include "stdafx.h"
#include "CheckGroupCtrl.h"


// CCheckGroupCtrl

//IMPLEMENT_DYNAMIC(CCheckGroupCtrl, CStatic)

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define BK_COLOR RGB(240,240,240)
#define BUTTON_NORMAL_COLOR   RGB(233,233,233)
#define BUTTON_PRESSED_COLOR RGB(37,127,226)

#define BRUSH_COLOR_NORMAL RGB(16,140,16)
#define BRUSH_COLOR_MOTION RGB(255,255,0)
#define BRUSH_COLOR_ALARM RGB(255,0,0)

/////////////////////////////////////////////////////////////////////////////
// CCheckGroupCtrl

CCheckGroupCtrl::CCheckGroupCtrl()
{
	m_HeadHeight = 1;
	m_iLeftWidth = 10;		
	m_iRightWidth = 10;		
	m_iTopHeight = 30;		
	m_iBottomHeight = 40;
	m_bDragging = FALSE;
	m_bPressed = 0;
	//m_recType = RS_NormalRecord;
	m_iTrackedButton = -1;
	m_iTrackedBlock = -1;
	m_allChecked = FALSE;
	m_rectHeight = 20;
	m_rectWidth = 30;
	m_startIndex = 0;
	m_bPressedColor = 0;
	memset(m_Blocks,0,sizeof(m_Blocks));
	memset(m_rectBlocks,0,sizeof(m_rectBlocks));
}

CCheckGroupCtrl::~CCheckGroupCtrl()
{
}


BEGIN_MESSAGE_MAP(CCheckGroupCtrl, CStatic)
	//{{AFX_MSG_MAP(CCheckGroupCtrl)
	ON_WM_PAINT()
	ON_WM_ERASEBKGND()
	ON_WM_SIZE()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCheckGroupCtrl message handlers


void CCheckGroupCtrl::OnPaint() 
{
	CPaintDC dc(this); // device context for painting

	// TODO: Add your message handler code here
	CPen *pOldPen = NULL;
	int tempWidth = 0;
	CRect rcClient;
	CRect rect;
	GetClientRect(&rcClient);
	CBrush brushSel;
	CBrush brushNoSel;
	CBrush brushAlarmSel;
	CFont*  font;
	CDC memDC;
	memDC.CreateCompatibleDC(&dc); //DCڴDC
	CBitmap  bmp;
	bmp.CreateCompatibleBitmap(&dc,rcClient.Width(),rcClient.Height()); //λͼ
	CBitmap *pOldBitmap = memDC.SelectObject(&bmp); //λͼѡڴDC,ԭλͼ浽m_pOldBitmap
	//-------------------------------------------
	CBrush brushBk;
	brushBk.CreateSolidBrush(BK_COLOR);
	memDC.FillRect(&rcClient,&brushBk);
	//----------------------end--------------------------------

	//CRect rectLine;
	//rectLine.left = 0;
	//rectLine.right = rcClient.right;
	//rectLine.top = 0;
	//rectLine.bottom = 1;
	//memDC.Draw3dRect (	&rectLine,
	//	::GetSysColor (COLOR_3DHILIGHT),
	//	::GetSysColor (COLOR_3DDKSHADOW));

	//font.CreatePointFont(8,_T(""),NULL);
	font = GetFont();
	memDC.SelectObject(font);
	//CFont* pFont = dc.SelectObject(font);
	memDC.SetTextColor(CHK_TEXT_COLOR);//ıɫ
	memDC.SetBkMode (TRANSPARENT);
	for( int row=0; row<CHK_BLOCKROWS; row++)
	{
		for( int column=0; column < m_maxColum;  column++)
		{
			rect = m_rectBlocks[row][column];
			memDC.Draw3dRect (&rect,
				::GetSysColor (COLOR_3DHILIGHT),
				::GetSysColor (COLOR_3DDKSHADOW));
			int nPressed = m_Blocks[row][column];
		
			memDC.Draw3dRect (	&rect,
				::GetSysColor (COLOR_3DHILIGHT),
				::GetSysColor (COLOR_3DDKSHADOW));
			rect.DeflateRect(1,1,1,1);
			CBrush brushButton;
			if (nPressed)
			{
				switch(m_bPressedColor)
				{
				case 0:
					 {
						brushButton.CreateSolidBrush(BUTTON_PRESSED_COLOR);
						break;
					 }
				case 1:
					 {
						 brushButton.CreateSolidBrush(BRUSH_COLOR_NORMAL);
						 break;
					 }
				case 2:
					 {
						 brushButton.CreateSolidBrush(BRUSH_COLOR_MOTION);
						 break;
					 }
				case 3:
					 {
						 brushButton.CreateSolidBrush(BRUSH_COLOR_ALARM);
						 break;
					 }
				}
				
			}
			else
			{
				brushButton.CreateSolidBrush(BUTTON_NORMAL_COLOR);
			}

			memDC.FillRect(&rect,&brushButton);		
			memDC.SetTextColor(CHK_TEXT_COLOR);//ıɫ
			CString text;
			if(column == 0)
			{
				text = _T("Record:");
			}
			else
			{
				text.Format("%02d",column + m_startIndex);
			}
			
			memDC.DrawText(text,&rect,DT_SINGLELINE|DT_VCENTER | DT_CENTER);
		}
	}
	dc.BitBlt(0,0,rcClient.Width(),rcClient.Height(),&memDC,0,0,SRCCOPY);
	memDC.SelectObject(pOldBitmap); 
	memDC.DeleteDC();

}

BOOL CCheckGroupCtrl::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default	
	return TRUE;		
	//	return CStatic::OnEraseBkgnd(pDC);
}

void CCheckGroupCtrl::OnSize(UINT nType, int cx, int cy) 
{
	CStatic::OnSize(nType, cx, cy);	
	// TODO: Add your message handler code here
	CRect rcClient;
	GetClientRect(&rcClient);

	CRect rect;
	
	for( int row=0; row<CHK_BLOCKROWS; row++)
	{
		for( int column=0; column<m_maxColum;  column++)
		{
			if (column == 0)
			{
				rect.SetRect( CPoint((column)*m_rectWidth, 1), 
					CPoint((column+1)*m_rectWidth + 40, 1 + m_rectHeight));
			}
			else
			{
				rect.SetRect( CPoint(column*m_rectWidth + 40, 1), 
					CPoint((column+1)*m_rectWidth + 40, 1 + m_rectHeight));
			}
			m_rectBlocks[row][column] = rect;
		}
	}
	Invalidate(TRUE);
}


int  CCheckGroupCtrl::HitTest(CPoint& pt)
{
	int row = -1;
	int column = -1;
	for( int row = 0; row < CHK_BLOCKROWS; row++)
	{
		for( int column=0; column<m_maxColum;  column++)
		{
			if (m_rectBlocks[row][column].PtInRect (pt))
			{
				return row*m_maxColum + column;
			}
		}
	}
	return -1;
}

int  CCheckGroupCtrl::HitButton(CPoint& pt)
{
	for( int i = 0; i < 3; i++)
	{
		if (m_rectButtons[i].PtInRect (pt))
		{
			return i;
		}
	}
	return -1;
}

void CCheckGroupCtrl::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	CStatic::OnLButtonDown(nFlags, point);

	SetCapture();
	int iButton = HitButton(point);
	if (iButton != -1)
	{
		m_recType = iButton;
		Invalidate(TRUE);
	}
	m_bDragging = TRUE;
	m_rectArea.left = point.x;
	m_rectArea.top  = point.y;
	m_rectArea.right = point.x;
	m_rectArea.bottom = point.y;
	int nIndex = HitTest(point);
	TRACE(" HitTest return %d\n", nIndex);
	if( nIndex <0)
		return;
	int Selrow, Selcolumn;
	Selrow = nIndex / m_maxColum;
	Selcolumn = nIndex % m_maxColum;
	
	m_bPressed = ( m_Blocks[Selrow][Selcolumn]==0 )? 1 : 0;
	if (nIndex == 0)
	{
		if(m_allChecked)
		{
			m_allChecked = FALSE;
			m_Blocks[Selrow][Selcolumn] = 0;
		}
		else
		{
			m_allChecked = TRUE;
			m_Blocks[Selrow][Selcolumn] = 1;
		}
		SelAllBlocks(m_allChecked);
	}
	else
	{
		m_Blocks[Selrow][Selcolumn] = m_bPressed;
	}

	m_Blocks[0][0] = QueryAllState();

	Invalidate(TRUE);
}

void CCheckGroupCtrl::OnMouseMove(UINT nFlags, CPoint point)
{
	// TODO: ڴϢ/Ĭֵ

	CStatic::OnMouseMove(nFlags, point);
	/*m_iTrackedButton = HitTest(point);
	int Selrow, Selcolumn;
	Selrow = m_iTrackedButton/m_maxColum;
	Selcolumn = m_iTrackedButton%m_maxColum;
	
	CClientDC     dc(this); 
	InvertShape(&dc,m_rectBlocks[Selrow][Selcolumn],TRUE); 
	Invalidate(TRUE);*/

}


void CCheckGroupCtrl::OnLButtonUp(UINT nFlags, CPoint point)
{
	// TODO: ڴϢ/Ĭֵ

	CStatic::OnLButtonUp(nFlags, point);
	ReleaseCapture();
	Invalidate(TRUE);
}

void   CCheckGroupCtrl::InvertShape(CDC   *pDC,   CRect   &s,   bool   bInvert) 
{ 
	CBrush   *pBrushOld; 
	ASSERT(pDC!=NULL); 
	int   nModeOld; 
	if(bInvert)
	{ 
		nModeOld=pDC->SetROP2(R2_NOT); 
	} 
	pBrushOld=(CBrush*)pDC->SelectStockObject(NULL_BRUSH); 
	pDC-> Rectangle(s); 
	if(bInvert) 
	{ 
		pDC->SetROP2(nModeOld); 
	} 
	pDC-> SelectObject(pBrushOld); 
	pBrushOld=NULL; 
}

void   CCheckGroupCtrl::SetBlockValue(int row, int clum, BYTE _value)
{
	m_Blocks[row][clum] = _value;
	InvalidateRect(m_rectBlocks[row][clum], TRUE);
	if(QueryAllState())
	{
		m_Blocks[0][0] = 1;
		InvalidateRect(m_rectBlocks[0][0], TRUE);
	}
	else
	{
		m_Blocks[0][0] = 0;
		InvalidateRect(m_rectBlocks[0][0], TRUE);
	}

}

BOOL   CCheckGroupCtrl::QueryRowsState(int iRow)
{
	BOOL bSelAll = TRUE;
	for( int column=1; column<m_maxColum;  column++)
	{
		if (m_Blocks[iRow][column] == 0)
		{
			bSelAll = FALSE;
			break;
		}				
	}
	return bSelAll;
}


BOOL   CCheckGroupCtrl::QueryColumnsState(int iColumns)
{
	BOOL bSelAll = TRUE;
	for( int row=0; row<CHK_BLOCKROWS; row++)
	{	
		if (m_Blocks[row][iColumns] == 0)
		{
			bSelAll = FALSE;
			break;
		}	
	}
	return bSelAll;
}

BOOL   CCheckGroupCtrl::QueryAllState()
{
	BOOL bSelAll = TRUE;
	for( int row=0; row<CHK_BLOCKROWS; row++)
	{	
		for( int column=1; column<m_maxColum;  column++)
		{
			if (m_Blocks[row][column] == 0)
			{
				bSelAll = FALSE;
				break;
			}				
		}
	}
	return bSelAll;
}

void CCheckGroupCtrl::SelAllBlocks(BOOL bSel)
{
	for( int row=0; row<CHK_BLOCKROWS; row++)
	{
		for( int column=0; column<m_maxColum;  column++)
		{
			m_Blocks[row][column] = bSel;
			InvalidateRect(m_rectBlocks[row][column],TRUE);
		}
	}
}

void CCheckGroupCtrl::InvalidateAllRect()
{
	for( int row=0; row<CHK_BLOCKROWS; row++)
	{
		for( int column=0; column<m_maxColum;  column++)
		{
			InvalidateRect(m_rectBlocks[row][column],TRUE);
		}
	}
}
