
//

#include "stdafx.h"
#include "RSLibDemo.h"
#include "RSLibDemoDlg.h"
#include "DevInfo.h"

IMPLEMENT_DYNAMIC(CDevInfoDlg, CDialog)

CDevInfoDlg::CDevInfoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDevInfoDlg::IDD, pParent)
{

}

CDevInfoDlg::~CDevInfoDlg()
{
}

void CDevInfoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_EDT_DEVNAME, m_strName);
	DDX_Text(pDX, IDC_EDT_IP, m_strIP);
	DDX_Text(pDX, IDC_EDT_PORT, m_strPort);
	DDX_Text(pDX, IDC_EDT_CH, m_strCh);
	DDX_Text(pDX, IDC_EDT_USER, m_strUser);
	DDX_Text(pDX, IDC_EDT_PSW, m_strPsw);
	DDX_Text(pDX, IDC_EDT_AREA, m_strArea);
	DDX_Text(pDX, IDC_EDT_AUTO_LOGIN, m_strAutoLogin);
}


BEGIN_MESSAGE_MAP(CDevInfoDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CDevInfoDlg::OnBnClickedOk)
	
END_MESSAGE_MAP()

BOOL CDevInfoDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	//m_strName = _T("172.18.12.60");
	//m_strIP = _T("172.18.12.60");
	//m_strPort =  _T("9000");
	//m_strCh = _T("1");
	//m_strUser = _T("admin");
    m_strPsw = _T("");
	UpdateData(FALSE);
	return TRUE; 

}

void CDevInfoDlg::OnBnClickedOk()
{
	OnOK();
}

void CDevInfoDlg::OnOK()
{
	//Add device to Device tree
	UpdateData(TRUE);
	AppendDevToList();

	CDialog::OnOK();
}

BOOL CDevInfoDlg::AppendDevToList()
{
	CRSLibDemoDlg* pMainDlg =  (CRSLibDemoDlg*)theApp.pMainFrame;

	//Add list
	CString strDevID;
	/* Use the current timestamp as device ID*/
	strDevID.Format("%d",GetTickCount());
	ServerInfoSync.Lock();
	SERVER_INFO *pInfo = new SERVER_INFO;
	pInfo->Type = DevTreeType_Dev;
	
	pInfo->DevID = strDevID;
	pInfo->AreaID = _T("ROOT");						
	pInfo->szIp = m_strIP;
	pInfo->szName = m_strName;
	pInfo->szUser = m_strUser;
	pInfo->szPasswd = m_strPsw;
	pInfo->iPort = atoi(m_strPort);
	pInfo->bAutoLogin = atoi(m_strAutoLogin);
	pInfo->bUseFlag = 0;
	pInfo->bLinkState = 0;//Device connect state
	pInfo->hItem = NULL; 
	pInfo->pNetConnection = NULL;
	pInfo->bDualTalk = 0;
	pInfo->lDualtalkID = 0;
	pInfo->pNetDualtalk = NULL;
	pInfo->bAlarmRptDesired = TRUE;
    pInfo->pDevChnInfo = NULL;
	memset(&pInfo->DevLoginRsp,0,sizeof(LoginRsp));

	/*TV_INSERTSTRUCT TCItem;
	TCItem.hParent = pMainDlg->m_hRootItem;
	TCItem.hInsertAfter = TVI_LAST;
	TCItem.item.mask = TVIF_TEXT|TVIF_PARAM|TVIF_IMAGE|TVIF_SELECTEDIMAGE;
	TCItem.item.pszText = (LPSTR)(LPCTSTR)m_strName;
	TCItem.item.lParam = (LPARAM)pInfo;
	TCItem.item.iImage = ICO_DEV_LOGOUT;
	TCItem.item.iSelectedImage = ICO_DEV_LOGOUT;
	HTREEITEM hCurItem2 = pMainDlg->m_devTree.InsertItem(&TCItem);*/
    HTREEITEM hCurItem2 = pMainDlg->m_devTree.InsertItem(TVIF_TEXT|TVIF_PARAM|TVIF_IMAGE|TVIF_SELECTEDIMAGE, \
        (LPSTR)(LPCTSTR)m_strName, ICO_DEV_LOGOUT, ICO_DEV_LOGOUT, 0, 0, (LPARAM)pInfo, pMainDlg->m_hRootItem, TVI_LAST);
	pMainDlg->m_devTree.Expand(pMainDlg->m_hRootItem,TVE_EXPAND);
	pInfo->hItem = hCurItem2;
	g_ServerInfoList.AddTail(pInfo);
	ServerInfoSync.Unlock();
	AddChannels(pInfo,atoi(m_strCh));
//end

	return TRUE;
}

BOOL CDevInfoDlg::AddChannels(SERVER_INFO *pDevInfo,int chNum)
{
	CRSLibDemoDlg* pMainDlg =  (CRSLibDemoDlg*)theApp.pMainFrame;
	for(int i = 0; i < chNum; i++)
	{
		CString strChName;
		strChName.Format("CH%d",i+1);
	
		CString strChID;
		strChID.Format("%d",GetTickCount());
		Sleep(1);
		int iChNo = i;

		//Add list
		ChannelInfoSync.Lock();
		CHANNEL_INFO *pInfo = new CHANNEL_INFO;
		memset(pInfo, 0, sizeof(CHANNEL_INFO));
		pInfo->Type = DevTreeType_Ch;
		sprintf_s(pInfo->DevID,"%s",pDevInfo->DevID);
		sprintf_s(pInfo->ChannelID,"%s",strChID);
		sprintf_s(pInfo->ChName,"%s",strChName);
		pInfo->iChannelNo = iChNo;
		pInfo->iStreamType = CH_STREAM_VIDEO;
		pInfo->iProtocolType = DEV_PROTO_TCP;
		pInfo->iPreviewID = NULL;
		pInfo->iWndIndex = -1;
		pInfo->bDefence = 1;
		pInfo->bPreview = FALSE;

		/*TV_INSERTSTRUCT TCItem;
		TCItem.hParent = pDevInfo->hItem;//Add root item
		TCItem.hInsertAfter = TVI_LAST;//Insert Item at the last position
		TCItem.item.mask = TVIF_TEXT|TVIF_PARAM|TVIF_IMAGE|TVIF_SELECTEDIMAGE;
		TCItem.item.pszText = (LPSTR)(LPCTSTR)strChName;
		TCItem.item.lParam = (LPARAM)pInfo;
		TCItem.item.iImage = ICO_CH_DISABLE;//Normal Icon
		TCItem.item.iSelectedImage = ICO_CH_DISABLE;//Checked Icon
		pInfo->hItem = pMainDlg->m_devTree.InsertItem(&TCItem);*/
        pInfo->hItem = pMainDlg->m_devTree.InsertItem(TVIF_TEXT|TVIF_PARAM|TVIF_IMAGE|TVIF_SELECTEDIMAGE, \
            (LPSTR)(LPCTSTR)strChName, ICO_CH_DISABLE, ICO_CH_DISABLE, 0, 0, (LPARAM)pInfo, pDevInfo->hItem, TVI_LAST);

		g_ChannelInfoList.AddTail(pInfo);
		ChannelInfoSync.Unlock();
		//end									
	}
	pMainDlg->UpdateWindow();
	return TRUE;
}


//void CDevInfoDlg::OnBnClickedModify()
//{
//	NetMDevInfoReq Info = {0};
//    CString xml = "172.18.12.33";
//	for (int i=0, j=0; i<3; i++)
//	{
//		j = xml.Find('.', 0); 
//		Info.cip[i] = atoi(xml.Left(j).GetBuffer(0));
//		xml = xml.Right(xml.GetLength() - (j+1));
//	}
//	Info.cip[3] = atoi(xml);
//
//	RSNetSetDevInfo(&Info);
//}
