#ifndef __RSDEVICE_H__
#define __RSDEVICE_H__

enum dev_type
{
    DEV_DVR = 0,//ģDVR
    DEV_MVR = 1,//
    DEV_INTEL = 2,
    DEV_NVR = 3,//NVR
    DEV_IPC = 4,//IPC
    DEV_HDVR = 6,//DVR
};

enum tag_UI_TYPE_E
{
    RS_UI_1_0 = 0,      //UI 1.0
    RS_UI_2_0,      //UI 2.0
    RS_UI_3_0,      //UI 3.0
    RS_UI_3_1       //UI 3.1
};

class CRSDevice
{
public:
    CRSDevice(SERVER_INFO* pServer);
    ~CRSDevice();

    RSNetConnection GetConnection() { return m_pServer->pNetConnection; }
    LoginRsp* GetLoginRsp() { return &m_pServer->DevLoginRsp; }
    int GetDeviceType() { return m_pServer->DevLoginRsp.DevType >> 40 & 0xf; }
    int GetAnalogChNum() { return m_pServer->DevLoginRsp.AnalogChNum; }

private:
    SERVER_INFO* m_pServer;
};

#endif
