

#include "stdafx.h"
#include "RSLibDemo.h"
#include "PViewDlg.h"
#include "RSLibDemoDlg.h"


void RSNET_CALL PViewDrawCallbackSt(HDC hDC, DWORD width, DWORD height, void* pUser);
/////////////////////////////////////////////////////////////////////////////
// CVideoPViewDlg dialog
#define TIMESWITCH    120
#define TIMESBITRATE      121
IMPLEMENT_DYNAMIC(CPViewDlg, CDialog)

CPViewDlg::CPViewDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPViewDlg::IDD, pParent)
	,m_bPlay(0)
	,m_nIndex(-1)
	,m_bChecked(FALSE)
	,m_bMaxVideoWnd(FALSE)
{

}

CPViewDlg::~CPViewDlg()
{
}

void CPViewDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(CPViewDlg, CDialog)
ON_WM_PAINT()
ON_WM_LBUTTONDBLCLK()
END_MESSAGE_MAP()

#include "RSMedia.h"
// CVideoPViewDlg message handlers
void RSNET_CALL PreviewDataCallback(void* data, UINT size, void* userParam)
{
	//ڴ˿ȡ֡ݣΪȡ֡Ƶα
	RS_FRAME_S *pFrame = (RS_FRAME_S *)data;

	//ж֡ǷΪƵ֡
	if(pFrame->frame_head.FrameType == RSAFrame)
	{
		unsigned char *pAudioDate = new unsigned char[pFrame->frame_head.FrameSize - 4];
		//ƫƵ4ֽΪ˼ͷ
		memcpy(pAudioDate, pFrame->frame_data +4, pFrame->frame_head.FrameSize - 4);

		//pAudioDate ΪƵ


		delete[] pAudioDate;
	}

	CHANNEL_INFO* pChannelInfo = (CHANNEL_INFO*)userParam;
	RSPlayInputNetFrame(pChannelInfo->iPlayID, data, size);
}

void CPViewDlg::SetServerInfo(SERVER_INFO *pServer, CHANNEL_INFO *pChannel)
{
	m_pServerInfo = pServer;
	m_pChannelInfo = pChannel;
}

void CPViewDlg::PreviewPlay()
{
	
	CRSLibDemoDlg* pdlgDev = (CRSLibDemoDlg*)theApp.pMainFrame;
	if ((m_pServerInfo == NULL)&&(m_pChannelInfo == NULL))
	{
		return;
	}
	RSNetPreviewParam param;
    ZeroMemory(&param, sizeof(param));
	param.Param.Channel = m_pChannelInfo->iChannelNo;
	param.Param.Type = m_pChannelInfo->iCodeStreamType;
	param.Param.Content = 0;
    param.Param.timepos = 0;
	param.AutoReconnect = TRUE;
	param.Wnd = pdlgDev->GetSafeHwnd();
	param.Message = WM_CONNECTION_MESSAGE;
	param.DataCallback = PreviewDataCallback;
	param.Protocol = m_pChannelInfo->iProtocolType;
	param.UserParam = m_pChannelInfo;
	m_bPlay = TRUE;
	m_pChannelInfo->iWndIndex = m_nIndex;
	m_pChannelInfo->iPlayID = RSPlayCreatePlayInstance(PLAY_NETSTREAM_TYPE);
	RSPlaySetPlayWnd(m_pChannelInfo->iPlayID, GetSafeHwnd());
	RSPlayStartPlay(m_pChannelInfo->iPlayID);

	m_pChannelInfo->bPreview = TRUE;
	m_pChannelInfo->iPreviewID = RSNetStartPreview(m_pServerInfo->pNetConnection, &param);
	CString strLoad;
	strLoad.Format("%s-%s",m_pServerInfo->szName,m_pChannelInfo->ChName);

	RSPlayOpenSound(m_pChannelInfo->iPlayID);

	RSNetCmdParam cmdParam;
	memset(&cmdParam, 0, sizeof(cmdParam));
	cmdParam.ParamMainType = MsgStatusRequest;
	cmdParam.ParamSubType = MsgDevAllStatusReq;
	RSNetSimpleCmd(m_pServerInfo->pNetConnection,&cmdParam);

	UpdateData(TRUE);
	memcpy(m_PreviewID,m_pChannelInfo->ChannelID,128);

	//RSPlayRenderActualProportion(m_pChannelInfo->iPlayID,TRUE);
}

void CPViewDlg::PreviewStop()
{
	if (!m_bPlay)
	{
		return;
	}
	CRSLibDemoDlg* pdlgDev = (CRSLibDemoDlg*)theApp.pMainFrame;
	if ((m_pServerInfo == NULL)&&(m_pChannelInfo == NULL))
	{
		return;
	}	
	RSPlayCloseSound(m_pChannelInfo->iPlayID);
	RSNetStopPreview(m_pServerInfo->pNetConnection, &m_pChannelInfo->iPreviewID);
	RSPlayStopPlay(m_pChannelInfo->iPlayID);
	RSPlayDestroyPlayInstance(m_pChannelInfo->iPlayID);
	pdlgDev->m_devTree.SetItemImage(m_pChannelInfo->hItem,ICO_CH_ENABLE,ICO_CH_ENABLE);
	m_pChannelInfo->iPlayID = NULL;					
	m_pChannelInfo->iWndIndex = -1;
	m_pChannelInfo->bPreview = FALSE;
	m_pChannelInfo->bAutoScan = FALSE;
	m_pServerInfo =  NULL;
	m_pChannelInfo = NULL;
	m_bPlay = FALSE;

	UpdateData(TRUE);
	UpdateWindow();
	Invalidate(TRUE);
}

void CPViewDlg::OnPaint() 
{
	CPaintDC dc(this); 

	if(m_bChecked)
	{
		CDC *pDC = &dc;
		
		CRect rect;
		GetClientRect(&rect);

		//Draw selected window border
		CPen myPen(PS_SOLID, 4, RGB(0,255,0));
		CPen *pOldPen = pDC->SelectObject(&myPen);
		CPen *oldPen = pDC->SelectObject(&myPen);
		pDC->MoveTo(rect.left, rect.top);
		pDC->LineTo(rect.right, rect.top);
		pDC->LineTo(rect.right, rect.bottom);
		pDC->LineTo(rect.left, rect.bottom);
		pDC->LineTo(rect.left, rect.top);
		pDC->SelectObject(oldPen);
		myPen.DeleteObject();
	}
	
}

BOOL CPViewDlg::PreTranslateMessage(MSG* pMsg) 
{
	if (pMsg->message == WM_LBUTTONDOWN)
	{
		((CRSLibDemoDlg*)theApp.pMainFrame)-> SetCurPlayWnd(m_nIndex);
	}
	return CDialog::PreTranslateMessage(pMsg);
}
void CPViewDlg::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	m_bMaxVideoWnd = !m_bMaxVideoWnd;
	CPViewDlg* pViewWnd = (CPViewDlg*)GetParent();
	CRect parentRect;
	pViewWnd->GetClientRect(&parentRect);
	if(m_bMaxVideoWnd)
	{
		MoveWindow(&parentRect,TRUE);
		CRSLibDemoDlg *pMainDlg = (CRSLibDemoDlg*)theApp.pMainFrame;
		for(int i=0; i<4;i++)
		{
			if(pMainDlg->pViewDlg[i].m_hWnd != m_hWnd)
			{
				pMainDlg->pViewDlg[i].ShowWindow(SW_HIDE);
			}
		}

	}
	else
	{
		CRSLibDemoDlg *pMainDlg = (CRSLibDemoDlg*)theApp.pMainFrame;
		int width = (parentRect.right - parentRect.left)/2;
		int height = (parentRect.bottom - parentRect.top)/2;

		pMainDlg->pViewDlg[0].ShowWindow(SW_SHOW);
		pMainDlg->pViewDlg[0].MoveWindow(parentRect.left,parentRect.top,width,height);
		pMainDlg->pViewDlg[1].ShowWindow(SW_SHOW);
		pMainDlg->pViewDlg[1].MoveWindow(parentRect.left+width,parentRect.top,width,height);
		pMainDlg->pViewDlg[2].ShowWindow(SW_SHOW);
		pMainDlg->pViewDlg[2].MoveWindow(parentRect.left,parentRect.top+height,width,height);
		pMainDlg->pViewDlg[3].ShowWindow(SW_SHOW);
		pMainDlg->pViewDlg[3].MoveWindow(parentRect.left+width,parentRect.top+height,width,height);
	}

	pViewWnd->Invalidate(TRUE);
	CDialog::OnLButtonDblClk(nFlags, point);
}

void CPViewDlg::ShowVideoString( int nMsgType, BOOL bShow, COLORREF nColor )
{
	if (!m_bPlay || m_pChannelInfo->iPlayID == 0){
		return;
	}

	int nIndex = MsgHddStatusReportIndex;
	memset(&m_osd_info, 0, sizeof(m_osd_info));
	m_osd_info.font_height = 22;
	strcpy_s(m_osd_info.font, 23, "Arial");

	int lw = 30;
	CRect rect, rt;
	GetClientRect(rect);

	switch (nMsgType)
	{
		//e.g.MsgMotionAlarm
	case MsgMotionAlarm:
		{
			if (bShow){
				//ʾַ
				strcpy_s(m_osd_info.osd_string, 127, "M");  
				//ʾַλ
				rt.left = rect.Width()/2 + lw*2;
				rt.right = rt.left + lw;
				rt.bottom = rect.bottom - 50;
				rt.top = rt.bottom - 22;
			}
			nIndex = MsgMotionAlarmIndex;
		}
		break;
	case MsgRecordStatusReport:
		{
			if (bShow){
				strcpy_s(m_osd_info.osd_string, 127, "R");  
				rt.left = rect.Width()/2 - lw;
				rt.right = rt.left + lw;
				rt.bottom = rect.bottom - 50;
				rt.top = rt.bottom - 22;
			}
			nIndex = MsgRecordStatusReportIndex;
		}
		break;
	}

	if (bShow){
		m_osd_info.osd_color_red = GetRValue(nColor);
		m_osd_info.osd_color_green = GetGValue(nColor);
		m_osd_info.osd_color_blue = GetBValue(nColor);
		m_osd_info.osd_rect = rt;
		//RSPlayӿڽʾ
		RSPlaySetOsdString(m_pChannelInfo->iPlayID, nIndex, &m_osd_info);
	}else{
		//RSPlayӿڽ
		RSPlayRemoveOsdstring(m_pChannelInfo->iPlayID, nIndex);
	}
}
