#include "StdAfx.h"
#include "ChLive.h"

static void RSNET_CALL AllDataCallback(void* data, void* userParam)
{
	ChLive* pThis = (ChLive*)userParam;
	RSNetNew_SoleLivingset_t *pData = (RSNetNew_SoleLivingset_t*)data;
	pThis->m_vec.push_back(*pData);
}

static void RSNET_CALL SingleDataCallback(void* data, void* userParam)
{
	ChLive* pThis = (ChLive*)userParam;
	RSNetNew_SoleLivingset_t *pData = (RSNetNew_SoleLivingset_t*)data;
	for(int i=0; i<pThis->m_vec.size(); i++)
	{
		if((pData->ChannelMask >> i & 0x1) == 1)
			pThis->m_vec[i] = *pData;
	}
}

std::string ChLive::QueryAll(bool bDefault)
{
	//
	std::string strRet = "err";

	RSNetQueryParamParam param;
	memset(&param, '\0', sizeof(param));

	m_vec.clear();

	ChannelParamReq req;
	TransformChannelParamReq_All(&req);

	param.ParamType = MsgParamModifyLiving;
	param.Req = &req;

	param.ListParamSize = sizeof(RSNetNew_SoleLivingset_t);
	param.ListParamCallback = AllDataCallback;
	param.UserParam = this;

	if(bDefault)
	{
		if(!RSNetQueryDefaultParam(m_pDevice->GetConnection(), &param, MsgDefaultParam))
			return strRet;
	}
	else
	{
		if(!RSNetQueryParam(m_pDevice->GetConnection(), &param))
			return strRet;
	}
	
	//
	Json::Value root(Json::arrayValue);
	for(int i=0; i<m_vec.size(); i++)
	{
		StructToJson(i);
		root.append(m_obj);
	}

	Json::FastWriter writer;
	strRet = writer.write(root);
	return strRet;
}

std::string ChLive::QueryOne(int n)
{
	std::string strRet = "err";

	RSNetQueryParamParam param;
	memset(&param, '\0', sizeof(param));

	ChannelParamReq req;
	TransformChannelParamReq_One(&req,n);

	param.ParamType = MsgParamModifyLiving;
	param.Req = &req;

	param.ListParamSize = sizeof(RSNetNew_SoleLivingset_t);
	param.ListParamCallback = SingleDataCallback;
	param.UserParam = this;

	if(!RSNetQueryParam(m_pDevice->GetConnection(), &param))
		return strRet;

	StructToJson(n);
	
	Json::FastWriter writer;
	strRet = writer.write(m_obj);
	return strRet;
}

void ChLive::StructToJson(int n)
{
	m_obj.clear();
	m_obj["ch"] = n;
	m_obj["ChnNamePos_X"] = m_vec[n].ChnNamePosX;
	m_obj["ChnNamePos_Y"] = m_vec[n].ChnNamePosY;
	m_obj["DateTimePos_X"] = m_vec[n].DateTimePosX;
	m_obj["DateTimePos_Y"] = m_vec[n].DateTimePosY;
	m_obj["ChnName"] = (char*)m_vec[n].ChnName;
	m_obj["ChnNameFlag"] = m_vec[n].ShowChnNameFlag;

		int tmp = m_vec[n].ShowDateTimeFlag;
		if(m_pDevice->GetDeviceType() == DEV_HDVR){
			tmp = m_vec[0].ShowDateTimeFlag;//ͨ޹أǿ0ͨ
		}
	m_obj["PreviewTimeFlag"] = tmp;

	m_obj["TimeMode"] = m_vec[n].TimeMode;
	m_obj["DateMode"] = m_vec[n].DateMode;
	m_obj["FlickerCtrl"] = m_vec[n].FlickerCtrl;
	m_obj["DisplayRule"] = m_vec[n].DisplayRule;
	m_obj["Covert"] = m_vec[n].Covert;
	m_obj["Transparent"] = m_vec[n].fgAlpha;
	m_obj["RecTimeFlag"] = m_vec[n].RecTimeFlag;
	m_obj["AHD_QESwitch"] = m_vec[n].AHD_QESwitch;
}

int ChLive::SaveAll(std::string strData)
{	
	if(strData == "null"){
		return false;
	}

	Json::Reader reader;
	Json::Value obj;
	if(!reader.parse(strData, obj)){
		return false;
	}

	for(int i=0; i<obj.size(); i++)
	{
		m_vec[i].ChnNamePosX = obj[i]["ChnNamePos_X"].asInt();
		m_vec[i].ChnNamePosY = obj[i]["ChnNamePos_Y"].asInt();
		m_vec[i].DateTimePosX = obj[i]["DateTimePos_X"].asInt();
		m_vec[i].DateTimePosY = obj[i]["DateTimePos_Y"].asInt();
		
		int maxLen = sizeof(m_vec[i].ChnName);
		memset(m_vec[i].ChnName, '\0', maxLen);
		m_str = obj[i]["ChnName"].asString();
		int len = m_str.length() < maxLen ? m_str.length() : maxLen;
		memcpy(m_vec[i].ChnName, m_str.c_str(), len);
		
		m_vec[i].ShowChnNameFlag = obj[i]["ChnNameFlag"].asInt();

		int tmp = obj[i]["PreviewTimeFlag"].asInt();
		if(m_pDevice->GetDeviceType() == DEV_HDVR){
			int ch = 0;
			tmp = obj[ch]["PreviewTimeFlag"].asInt();//ͨ޹أǿ0ͨ
		}
		m_vec[i].ShowDateTimeFlag = tmp;

		m_vec[i].TimeMode = obj[i]["TimeMode"].asInt();
		m_vec[i].DateMode = obj[i]["DateMode"].asInt();
		m_vec[i].FlickerCtrl = obj[i]["FlickerCtrl"].asInt();
		m_vec[i].DisplayRule = obj[i]["DisplayRule"].asInt();
		m_vec[i].Covert = obj[i]["Covert"].asInt();
		m_vec[i].fgAlpha = obj[i]["Transparent"].asInt();
		m_vec[i].RecTimeFlag = obj[i]["RecTimeFlag"].asInt();
		m_vec[i].AHD_QESwitch = obj[i]["AHD_QESwitch"].asInt();
		m_vec[i].StructSize = sizeof(RSNetNew_SoleLivingset_t);
	}

	RSNetSetParamParam param;
	memset(&param, '\0', sizeof(param));
	param.ParamType = MsgParamModifyLiving;
	param.Param = NULL;
	param.ListParams = &m_vec[0];
	param.ListParamNum = m_vec.size();
	if (RSNetSetParam(m_pDevice->GetConnection(), &param))
	{
		return true;
	}

	return false;
}