#include "StdAfx.h"
#include "EncodeStream.h"

static void RSNET_CALL ListParamMainCallback(void* data, void* userParam)
{
	MainEncode* pThis = (MainEncode*)userParam;
	RSNetNew_SoleStreamset_t* channelOsd = (RSNetNew_SoleStreamset_t*)data;
	pThis->m_vec.push_back(*channelOsd);
}

std::string MainEncode::QueryAll(bool bDefault)
{
	//
	std::string strRet = "err";

	RSNetQueryParamParam param;
	memset(&param, '\0', sizeof(param));

	m_vec.clear();

	ChannelParamReq req;
	TransformChannelParamReq_All(&req);

	param.ParamType = MsgParamModifyMainStream;
	param.Req = &req;

	param.ParamCallback = NULL;

	param.ListParamSize = sizeof(RSNetNew_SoleStreamset_t);
	param.ListParamCallback = ListParamMainCallback;
	param.UserParam = this;

	if(bDefault)
	{
		if (!RSNetQueryDefaultParam(m_pDevice->GetConnection(), &param,MsgDefaultParam))
			return strRet;
	}
	else
	{
		if (!RSNetQueryParam(m_pDevice->GetConnection(), &param))
			return strRet;
	}
	
	//
	Json::Value root(Json::arrayValue);
	for(int i=0; i<m_vec.size(); i++)
	{
		StructToJson(i);
		root.append(m_obj);
	}

	Json::FastWriter writer;
	strRet = writer.write(root);
	return strRet;
}	

void MainEncode::StructToJson(int n)
{
	m_obj.clear();
	m_obj["ch"] = n;

	m_obj["BitRateMode"] = m_vec[n].BitRateMode;
	m_obj["CustomBitrate"] = m_vec[n].CustomBitrate;
	m_obj["Bitrate"] = m_vec[n].Bitrate;
	m_obj["VideoQuality"] = m_vec[n].VideoQuality;
	m_obj["Fps"] = m_vec[n].Fps,
	m_obj["AudioSwitch"] = m_vec[n].AudioSwitch;
	m_obj["ResolutionsetIndex"] = m_vec[n].ResolutionsetIndex;
	m_obj["Num"] = m_vec[n].Num;
	m_obj["HaveAudio"] = m_vec[n].HaveAudio;
	m_obj["BitrateType"] = m_vec[n].BitrateType;
	m_obj["VideoEncType"] = m_vec[n].VideoEncType;
	m_obj["UsedEncType"] = m_vec[n].UsedEncType;
	m_obj["AMRSwitch"] = m_vec[n].AMRSwitch;
	m_obj["SoleResolutionMode"] = m_vec[n].SoleResolutionMode;
	m_obj["ProfileLevel"] = m_vec[n].ProfileLevel;

	Json::Value obj(Json::objectValue);

	for (int i=0; i<8;i++)
	{
		obj["item"] = m_vec[n].Range[i].BitrateRange;
		m_obj["BitrateRange"].append(obj);
	}

	for (int i=0; i<8;i++)
	{
		obj["item"] = m_vec[n].Range[i].FrameRateMin;
		m_obj["FrameRateMin"].append(obj);

	}

	for (int i=0; i<8;i++)
	{
		obj["item"] = m_vec[n].Range[i].FrameRateMax;
		m_obj["FrameRateMax"].append(obj);
	}

	for (int i=0; i<8;i++)
	{
		obj["item"] = m_vec[n].Range[i].ResolutionWidth;
		m_obj["ResolutionWidth"].append(obj);
	}

	for (int i=0; i<8;i++)
	{
		obj["item"] = m_vec[n].Range[i].ResolutionHight;
		m_obj["ResolutionHight"].append(obj);
	}
}


int MainEncode::SaveAll(std::string strData)
{
	if(strData == "null"){
		return false;
	}

	Json::Reader reader;
	Json::Value obj;
	if(!reader.parse(strData, obj)){
		return false;
	}

	for(int i=0; i<obj.size(); i++)
	{
		m_vec[i].BitRateMode = obj[i]["BitRateMode"].asInt();
		m_vec[i].CustomBitrate = obj[i]["CustomBitrate"].asInt();
		m_vec[i].Bitrate = obj[i]["Bitrate"].asInt();
		m_vec[i].VideoQuality = obj[i]["VideoQuality"].asInt();
		m_vec[i].Fps = obj[i]["Fps"].asInt();
		m_vec[i].AudioSwitch = obj[i]["AudioSwitch"].asInt();
		m_vec[i].ResolutionsetIndex = obj[i]["ResolutionsetIndex"].asInt();
		m_vec[i].BitrateType = obj[i]["BitrateType"].asInt();
		m_vec[i].IFrameInterval = obj[i]["IFrameInterval"].asInt();
		m_vec[i].AudioEncType = obj[i]["AudioEncType"].asInt();
		m_vec[i].VideoEncType = obj[i]["VideoEncType"].asInt();
		m_vec[i].ProfileLevel = obj[i]["ProfileLevel"].asInt();
		m_vec[i].UsedEncType = obj[i]["UsedEncType"].asInt();
		m_vec[i].AMRSwitch = obj[i]["AMRSwitch"].asInt();
		m_vec[i].StructSize = sizeof(RSNetNew_SoleStreamset_t);
	}

	RSNetSetParamParam param;
	memset(&param, '\0', sizeof(param));
	param.ParamType = MsgParamModifyMainStream;
	param.Param = NULL;
	param.ListParams = &m_vec[0];
	param.ListParamNum = m_vec.size();
	if (RSNetSetParam(m_pDevice->GetConnection(), &param))
	{
		return true;
	}
	return false;
}

/********************************************************************************************/
/*		
/*
/********************************************************************************************/


static void RSNET_CALL ListParamSubCallback(void* data, void* userParam)
{
	SubEncode* pThis = (SubEncode*)userParam;
	RSNetNew_SoleStreamset_t* channelOsd = (RSNetNew_SoleStreamset_t*)data;
	pThis->m_vec.push_back(*channelOsd);
}

std::string SubEncode::QueryAll(bool isDefault)
{
	//
	std::string strRet = "err";

	RSNetQueryParamParam param;
	memset(&param, '\0', sizeof(param));

	m_vec.clear();

	ChannelParamReq req;
	TransformChannelParamReq_All(&req);

	param.ParamType = MsgParamModifySubStream;
	param.Req = &req;

	param.ParamCallback = NULL;

	param.ListParamSize = sizeof(RSNetNew_SoleStreamset_t);
	param.ListParamCallback = ListParamSubCallback;
	param.UserParam = this;

	if(isDefault)
	{
		if (!RSNetQueryDefaultParam(m_pDevice->GetConnection(), &param, MsgDefaultParam))
			return strRet;
	}
	else
	{
		if (!RSNetQueryParam(m_pDevice->GetConnection(), &param))
			return strRet;
	}

	//
	Json::Value root(Json::arrayValue);
	for(int i=0; i<m_vec.size(); i++)
	{
		StructToJson(i);
		root.append(m_obj);
	}

	Json::FastWriter writer;
	strRet = writer.write(root);
	return strRet;
}

void SubEncode::StructToJson(int n)
{
	m_obj.clear();
	m_obj["ch"] = n;

	m_obj["BitRateMode"] = m_vec[n].BitRateMode;
	m_obj["CustomBitrate"] = m_vec[n].CustomBitrate;
	m_obj["Bitrate"] = m_vec[n].Bitrate;
	m_obj["VideoQuality"] = m_vec[n].VideoQuality;
	m_obj["Fps"] = m_vec[n].Fps;
	m_obj["AudioSwitch"] = m_vec[n].AudioSwitch;
	m_obj["ResolutionsetIndex"] = m_vec[n].ResolutionsetIndex;
	m_obj["Num"] = m_vec[n].Num;
	m_obj["HaveAudio"] = m_vec[n].HaveAudio;
	m_obj["BitrateType"] = m_vec[n].BitrateType,
	m_obj["VideoEncType"] = m_vec[n].VideoEncType;
	m_obj["UsedEncType"] = m_vec[n].UsedEncType;
	m_obj["ProfileLevel"] = m_vec[n].ProfileLevel;
	
	Json::Value obj(Json::objectValue);
	for (int i=0; i<8; i++)
	{
		obj["item"] = m_vec[n].Range[i].BitrateRange;
		m_obj["BitrateRange"].append(obj);
	}

	for (int i=0; i<8;i++)
	{
		obj["item"] = m_vec[n].Range[i].FrameRateMin;
		m_obj["FrameRateMin"].append(obj);
	}

	for (int i=0; i<8;i++)
	{
		obj["item"] = m_vec[n].Range[i].FrameRateMax;
		m_obj["FrameRateMax"].append(obj);
	}

	for (int i=0; i<8; i++)
	{
		obj["item"] = m_vec[n].Range[i].ResolutionWidth;
		m_obj["ResolutionWidth"].append(obj);
	}

	for (int i=0; i<8; i++)
	{
		obj["item"] = m_vec[n].Range[i].ResolutionHight;
		m_obj["ResolutionHight"].append(obj);
	}
}

int SubEncode::SaveAll(std::string strData)
{
	if(strData == "null"){
		return false;
	}

	Json::Reader reader;
	Json::Value obj;
	if(!reader.parse(strData, obj)){
		return false;
	}

	for(int i=0; i<obj.size(); i++)
	{
		m_vec[i].BitRateMode = obj[i]["BitRateMode"].asInt();
		m_vec[i].CustomBitrate = obj[i]["CustomBitrate"].asInt();
		m_vec[i].Bitrate = obj[i]["Bitrate"].asInt();
		m_vec[i].VideoQuality = obj[i]["VideoQuality"].asInt();
		m_vec[i].Fps = obj[i]["Fps"].asInt();
		m_vec[i].AudioSwitch = obj[i]["AudioSwitch"].asInt();
		m_vec[i].ResolutionsetIndex = obj[i]["ResolutionsetIndex"].asInt();
		m_vec[i].BitrateType = obj[i]["BitrateType"].asInt();
		m_vec[i].VideoEncType = obj[i]["VideoEncType"].asInt();
		m_vec[i].UsedEncType = obj[i]["UsedEncType"].asInt();
		m_vec[i].ProfileLevel = obj[i]["ProfileLevel"].asInt();
		m_vec[i].StructSize = sizeof(RSNetNew_SoleStreamset_t);
	}

	RSNetSetParamParam param;
	memset(&param, '\0', sizeof(param));
	param.ParamType = MsgParamModifySubStream;
	param.Param = NULL;
	param.ListParams = &m_vec[0];
	param.ListParamNum = m_vec.size();
	if (RSNetSetParam(m_pDevice->GetConnection(), &param))
	{
		return true;
	}
	return false;
}

/********************************************************************************************/
/*		ֻ
/*
/********************************************************************************************/

MobileEncode::MobileEncode(void)
{
	nArea = 0;
}

static void RSNET_CALL ListParamMobileCallback(void* data, void* userParam)
{
	MobileEncode* pThis = (MobileEncode*)userParam;
	RSNetNew_SoleStreamset_t* pData = (RSNetNew_SoleStreamset_t*)data;
	pThis->m_vec.push_back(*pData);
}

static void RSNET_CALL SoleParamThirdCallback(void* data, void* userParam)
{
	MobileEncode* pThis = (MobileEncode*)userParam;
	RSNetNew_AreaStreamset_t* pData = (RSNetNew_AreaStreamset_t*)data;
	pThis->m_vecArea.push_back(*pData);
}

std::string MobileEncode::QueryAll(bool isDefault)
{
	unsigned int PageControl = m_pDevice->GetLoginRsp()->PageControl;
	nArea = (PageControl >>4) & 1;

	if(nArea == 1)
	{
		//
		std::string strRet = "err";

		RSNetQueryParamParam param;
		memset(&param, '\0',sizeof(param));

		m_vecArea.clear();

		ChannelParamReq req;
		TransformChannelParamReq_All(&req);

		param.ParamType = MsgParamAreaStream;
		param.Req = &req;

		param.ListParamSize = sizeof(RSNetNew_AreaStreamset_t);
		param.ListParamCallback = SoleParamThirdCallback;
		param.UserParam = this;

		if(!RSNetQueryParam(m_pDevice->GetConnection(), &param))
			return strRet;

		//
		Json::Value root(Json::arrayValue);
		for(int i=0; i<m_vecArea.size(); i++)
		{
			StructToJson_Area(i);
			root.append(m_obj);
		}

		//
		Json::FastWriter writer;
		strRet = writer.write(root);
		return strRet;
	}
	else
	{
		//
		std::string strRet = "err";

		RSNetQueryParamParam param;
		memset(&param, '\0', sizeof(param));

		m_vec.clear();

		ChannelParamReq req;
		TransformChannelParamReq_All(&req);

		param.ParamType = MsgParamModifyMobileStream;
		param.Req = &req;

		param.ParamCallback = NULL;

		param.ListParamSize = sizeof(RSNetNew_SoleStreamset_t);
		param.ListParamCallback = ListParamMobileCallback;
		param.UserParam = this;

		if(isDefault)
		{
			if (!RSNetQueryDefaultParam(m_pDevice->GetConnection(), &param,MsgDefaultParam))
				return strRet;
		}
		else
		{
			if (!RSNetQueryParam(m_pDevice->GetConnection(), &param))
				return strRet;
		}

		//
		Json::Value root(Json::arrayValue);
		for(int i=0; i<m_vec.size(); i++)
		{
			StructToJson(i);
			root.append(m_obj);
		}

		//
		Json::FastWriter writer;
		strRet = writer.write(root);
		return strRet;
	}
}

void MobileEncode::StructToJson_Area(int n)
{
	m_obj.clear();
	m_obj["ch"] = n;

	m_obj["TvSystem"] = m_pDevice->GetLoginRsp()->VideoFormat;
	m_obj["BitRateMode"] = m_vecArea[n].rsAreaStreamSet.BitRateMode;
	m_obj["CustomBitrate"] = m_vecArea[n].rsAreaStreamSet.CustomBitrate;
	m_obj["Bitrate"] = m_vecArea[n].rsAreaStreamSet.Bitrate;
	m_obj["VideoQuality"] = m_vecArea[n].rsAreaStreamSet.VideoQuality;
	m_obj["Fps"] = m_vecArea[n].rsAreaStreamSet.Fps;
	m_obj["AudioSwitch"] = m_vecArea[n].rsAreaStreamSet.AudioSwitch;
	m_obj["VideoSwitch"] = m_vecArea[n].rsAreaStreamSet.VideoSwitch;
	m_obj["ResolutionsetIndex"] = m_vecArea[n].rsAreaStreamSet.ResolutionsetIndex;
	m_obj["Num"] = m_vecArea[n].rsAreaStreamSet.Num;
	m_obj["HaveAudio"] = m_vecArea[n].rsAreaStreamSet.HaveAudio;
	m_obj["BitrateType"] = m_vecArea[n].rsAreaStreamSet.BitrateType;
	m_obj["IFrameInterval"] = m_vecArea[n].rsAreaStreamSet.IFrameInterval;
	m_obj["AudioEncType"] = m_vecArea[n].rsAreaStreamSet.AudioEncType;
	m_obj["VideoEncType"] = m_vecArea[n].rsAreaStreamSet.VideoEncType;
	m_obj["ProfileLevel"] = m_vecArea[n].rsAreaStreamSet.ProfileLevel;
	m_obj["UsedEncType"] = m_vecArea[n].rsAreaStreamSet.UsedEncType;

	Json::Value obj(Json::objectValue);

	for(int i=0; i<8; i++)
	{
		obj["item"] = m_vecArea[n].rsAreaStreamSet.Range[i].BitrateRange;
		m_obj["BitrateRange"].append(obj);
	}

	for(int i=0; i<8; i++)
	{
		obj["item"] = m_vecArea[n].rsAreaStreamSet.Range[i].FrameRateMin;
		m_obj["FrameRateMin"].append(obj);
	}

	for(int i=0; i<8; i++)
	{
		obj["item"] = m_vecArea[n].rsAreaStreamSet.Range[i].FrameRateMax;
		m_obj["FrameRateMax"].append(obj);
	}

	for(int i=0; i<8; i++)
	{
		obj["item"] = m_vecArea[n].rsAreaStreamSet.Range[i].ResolutionWidth;
		m_obj["ResolutionWidth"].append(obj);
	}

	for(int i=0; i<8; i++)
	{
		obj["item"] = m_vecArea[n].rsAreaStreamSet.Range[i].ResolutionHight;
		m_obj["ResolutionHight"].append(obj);
	}

	m_obj["areaSwitch"] = m_vecArea[n].areaSwitch;
	m_obj["rect"]["h"] = m_vecArea[n].rect.h;
	m_obj["rect"]["w"] = m_vecArea[n].rect.w;
	m_obj["rect"]["x"] = m_vecArea[n].rect.x;
	m_obj["rect"]["y"] = m_vecArea[n].rect.y;
	m_obj["res_w"] = m_vecArea[n].res_w;
	m_obj["res_h"] = m_vecArea[n].res_h;
}

void MobileEncode::StructToJson(int n)
{
	m_obj.clear();
	m_obj["ch"] = n;

	m_obj["TvSystem"] = m_pDevice->GetLoginRsp()->VideoFormat;
	m_obj["BitRateMode"] = m_vec[n].BitRateMode;
	m_obj["CustomBitrate"] = m_vec[n].CustomBitrate;
	m_obj["Bitrate"] = m_vec[n].Bitrate;
	m_obj["VideoQuality"] = m_vec[n].VideoQuality;
	m_obj["Fps"] = m_vec[n].Fps;
	m_obj["AudioSwitch"] = m_vec[n].AudioSwitch;
	m_obj["ResolutionsetIndex"] = m_vec[n].ResolutionsetIndex;
	m_obj["Num"] = m_vec[n].Num;
	m_obj["HaveAudio"] = m_vec[n].HaveAudio;
	m_obj["BitrateType"] = m_vec[n].BitrateType;
	m_obj["IFrameInterval"] = m_vec[n].IFrameInterval;
	m_obj["AudioEncType"] = m_vec[n].AudioEncType;
	m_obj["VideoEncType"] = m_vec[n].VideoEncType;
	m_obj["ProfileLevel"] = m_vec[n].ProfileLevel;
	m_obj["UsedEncType"] = m_vec[n].UsedEncType;
	m_obj["VideoSwitch"] = m_vec[n].VideoSwitch;

	Json::Value obj(Json::objectValue);

	for (int i=0; i<8;i++)
	{
		obj["item"] = m_vec[n].Range[i].BitrateRange;
		m_obj["BitrateRange"].append(obj);
	}

	for (int i=0; i<8;i++)
	{
		obj["item"] = m_vec[n].Range[i].FrameRateMin;
		m_obj["FrameRateMin"].append(obj);
	}

	for (int i=0; i<8;i++)
	{
		obj["item"] = m_vec[n].Range[i].FrameRateMax;
		m_obj["FrameRateMax"].append(obj);
	}

	for (int i=0; i<8; i++)
	{
		obj["item"] = m_vec[n].Range[i].ResolutionWidth;
		m_obj["ResolutionWidth"].append(obj);
	}

	for (int i=0; i<8; i++)
	{
		obj["item"] = m_vec[n].Range[i].ResolutionHight;
		m_obj["ResolutionHight"].append(obj);
	}
}


int MobileEncode::SaveAll(std::string strData)
{
	if(nArea == 1)
	{
		if(strData == "null"){
			return false;
		}

		Json::Reader reader;
		Json::Value obj(Json::objectValue);
		if(!reader.parse(strData,obj)){
			return false;
		}

		for(int i=0; i<obj.size(); i++)
		{
			m_vecArea[i].rsAreaStreamSet.BitrateType = obj[i]["BitrateType"].asInt();
			m_vecArea[i].rsAreaStreamSet.IFrameInterval = obj[i]["IFrameInterval"].asInt();
			m_vecArea[i].rsAreaStreamSet.BitRateMode = obj[i]["BitRateMode"].asInt();
			m_vecArea[i].rsAreaStreamSet.CustomBitrate = obj[i]["CustomBitrate"].asInt();
			m_vecArea[i].rsAreaStreamSet.Bitrate = obj[i]["Bitrate"].asInt();
			m_vecArea[i].rsAreaStreamSet.VideoQuality = obj[i]["VideoQuality"].asInt();
			m_vecArea[i].rsAreaStreamSet.Fps = obj[i]["Fps"].asInt();
			m_vecArea[i].rsAreaStreamSet.AudioSwitch = obj[i]["AudioSwitch"].asInt();
			m_vecArea[i].rsAreaStreamSet.ResolutionsetIndex = obj[i]["ResolutionsetIndex"].asInt();
			m_vecArea[i].rsAreaStreamSet.VideoSwitch = obj[i]["VideoSwitch"].asInt();
			m_vecArea[i].rsAreaStreamSet.AudioEncType = obj[i]["AudioEncType"].asInt();
			m_vecArea[i].rsAreaStreamSet.VideoEncType = obj[i]["VideoEncType"].asInt();
			m_vecArea[i].rsAreaStreamSet.ProfileLevel = obj[i]["ProfileLevel"].asInt();
			m_vecArea[i].rsAreaStreamSet.UsedEncType = obj[i]["UsedEncType"].asInt();
			m_vecArea[i].areaSwitch = obj[i]["areaSwitch"].asInt();
			m_vecArea[i].rect.h = obj[i]["rect"]["h"].asUInt();
			m_vecArea[i].rect.w = obj[i]["rect"]["w"].asUInt();
			m_vecArea[i].rect.x = obj[i]["rect"]["x"].asUInt();
			m_vecArea[i].rect.y = obj[i]["rect"]["y"].asUInt();
			m_vecArea[i].StructSize = sizeof(RSNetNew_AreaStreamset_t);
		}

		RSNetSetParamParam param;
		memset(&param,'\0', sizeof(param));
		param.ParamType = MsgParamAreaStream;
		param.Param = NULL;
		param.ListParams = &m_vecArea[0];
		param.ListParamNum = m_vecArea.size();

		if (RSNetSetParam(m_pDevice->GetConnection(), &param))
		{
			return true;
		}

		return false;
	}
	else
	{
		if(strData == "null"){
			return false;
		}

		Json::Reader reader;
		Json::Value obj;
		if(!reader.parse(strData, obj)){
			return false;
		}

		for(int i=0; i<obj.size(); i++)
		{
			m_vec[i].BitRateMode = obj[i]["BitRateMode"].asInt();
			m_vec[i].CustomBitrate = obj[i]["CustomBitrate"].asInt();
			m_vec[i].Bitrate = obj[i]["Bitrate"].asInt();
			m_vec[i].VideoQuality = obj[i]["VideoQuality"].asInt();
			m_vec[i].Fps = obj[i]["Fps"].asInt();
			m_vec[i].AudioSwitch = obj[i]["AudioSwitch"].asInt();
			m_vec[i].ResolutionsetIndex = obj[i]["ResolutionsetIndex"].asInt();
			m_vec[i].VideoSwitch = obj[i]["VideoSwitch"].asInt();
			m_vec[i].BitrateType = obj[i]["BitrateType"].asInt();
			m_vec[i].VideoEncType = obj[i]["VideoEncType"].asInt();
			m_vec[i].IFrameInterval = obj[i]["IFrameInterval"].asInt();
			m_vec[i].AudioEncType = obj[i]["AudioEncType"].asInt();
			m_vec[i].ProfileLevel = obj[i]["ProfileLevel"].asInt();
			m_vec[i].UsedEncType = obj[i]["UsedEncType"].asInt();
			m_vec[i].StructSize = sizeof(RSNetNew_SoleStreamset_t);
		}

		RSNetSetParamParam param;
		memset(&param, '\0', sizeof(param));
		param.ParamType = MsgParamModifyMobileStream;
		param.Param = NULL;
		param.ListParams = &m_vec[0];
		param.ListParamNum = m_vec.size();
		if (RSNetSetParam(m_pDevice->GetConnection(), &param))
		{
			return true;
		}
		return false;
	}
}