#include "StdAfx.h"
#include "FTP.h"

static void RSNET_CALL ParamDataCallback(void* data, void* userParam)
{
	FTP* pThis = (FTP*)userParam;
	RSNet_FtpSet_t* ftp = (RSNet_FtpSet_t*)data;
	pThis->m_Ftp = *ftp;
}

static void RSNET_CALL SoleParamDataCallback(void* data, void* userParam)
{
	FTP* pThis = (FTP*)userParam;
	RSNet_SoleFtpSet_t* soleftp = (RSNet_SoleFtpSet_t*)data;
	pThis->m_SoleFtp = *soleftp;
}

std::string  FTP::QueryAll(bool isDefault)
{
	//
	std::string strRet = "err";

	RSNetQueryParamParam param;
	memset(&param,'\0',  sizeof(param));

	memset(&m_Ftp,'\0', sizeof(RSNet_FtpSet_t));

	ChannelParamReq req;
	TransformChannelParamReq_All(&req);

	param.ParamType = MsgParamFtp;
	param.Req = &req;

	param.ParamSize = sizeof(RSNet_FtpSet_t);;
	param.ParamCallback = ParamDataCallback;

	param.ListParamSize = sizeof(RSNet_SoleFtpSet_t);
	param.ListParamCallback = SoleParamDataCallback;

	param.UserParam = this;

	if(isDefault)
	{
		if (!RSNetQueryDefaultParam(m_pDevice->GetConnection(), &param,MsgDefaultParam))
			return strRet;
	}
	else
	{
		if (!RSNetQueryParam(m_pDevice->GetConnection(), &param))
			return strRet;
	}	

	//
	m_obj.clear();
	m_obj["UseFtp"] = m_Ftp.UseFtp;
	m_obj["FtpLoginName"] = (char*)m_Ftp.FtpLoginName;
	m_obj["FtpLoginPwd"] = (char*)m_Ftp.FtpLoginPwd;
	m_obj["FtpIpAddr"] = (char*)m_Ftp.FtpIpAddr;
	m_obj["FtpPort"] = m_Ftp.FtpPort;
	m_obj["SendFileSize"] = m_Ftp.SendFileSize;
	m_obj["FilePath"] = (char*)m_Ftp.FilePath;
	m_obj["ReqTypeMask"] = m_SoleFtp.ReqTypeMask;
	
	//
	Json::FastWriter writer;
	strRet = writer.write(m_obj);
	return strRet;
}

int FTP::SaveAll(std::string strData)
{	
	if(strData == "null"){
		return false;
	}

	Json::Reader reader;
	Json::Value obj;
	if(!reader.parse(strData, obj)){
		return false;
	}

	//
		m_Ftp.UseFtp = obj["UseFtp"].asInt();
		m_Ftp.FtpPort = obj["FtpPort"].asInt();
		m_Ftp.SendFileSize = obj["SendFileSize"].asInt();

		int maxLen = sizeof(m_Ftp.FtpLoginName);
		memset(m_Ftp.FtpLoginName, '\0', maxLen);
		m_str = obj["FtpLoginName"].asString();
		int len = m_str.length() < maxLen ? m_str.length() : maxLen;
		memcpy(m_Ftp.FtpLoginName, m_str.c_str(), len);

		maxLen = sizeof(m_Ftp.FtpLoginPwd);
		memset(m_Ftp.FtpLoginPwd, '\0', maxLen);
		m_str = obj["FtpLoginPwd"].asString();
		len = m_str.length() < maxLen ? m_str.length() : maxLen;
		memcpy(m_Ftp.FtpLoginPwd, m_str.c_str(), len);

		maxLen = sizeof(m_Ftp.FtpIpAddr);
		memset(m_Ftp.FtpIpAddr, '\0', maxLen);
		m_str = obj["FtpIpAddr"].asString();
		len = m_str.length() < maxLen ? m_str.length() : maxLen;
		memcpy(m_Ftp.FtpIpAddr, m_str.c_str(), len);

		maxLen = sizeof(m_Ftp.FilePath);
		memset(m_Ftp.FilePath, '\0', maxLen);
		m_str = obj["FilePath"].asString();
		len = m_str.length() < maxLen ? m_str.length() : maxLen;
		memcpy(m_Ftp.FilePath, m_str.c_str(), len);

		m_SoleFtp.ReqTypeMask = obj["ReqTypeMask"].asInt();
	
	//
		RSNetSetParamParam param;
		memset(&param, '\0', sizeof(param));
		param.ParamType = MsgParamFtp;
		param.Param = &m_Ftp;
		param.ListParams = &m_SoleFtp;
		param.ListParamNum = 1;
		if (RSNetSetParam(m_pDevice->GetConnection(), &param))
		{
			return true;
		}

		return false;
}