#include "StdAfx.h"
#include "ImgCtrl.h"

static void RSNET_CALL ListParamCallback(void* data, void* userParam)
{
	ImgCtrl* pThis = (ImgCtrl*)userParam;
	RSNetNew_CameraSet_t* channelCam = (RSNetNew_CameraSet_t*)data;
	pThis->m_vec.push_back(*channelCam);
}

static void RSNET_CALL ListParamSingleCallback(void* data, void* userParam)
{
	ImgCtrl* pThis = (ImgCtrl*)userParam;
	RSNetNew_CameraSet_t* channelCam = (RSNetNew_CameraSet_t*)data;
	for(int i = 0;i < pThis->m_vec.size(); ++i)
	{
		if((channelCam->ChannelMask >> i & 0x1) == 1)
			pThis->m_vec[i] = *channelCam;
	}
}

std::string ImgCtrl::QueryAll(bool isDefault)
{
	//
	std::string strRet = "err";

	RSNetQueryParamParam param;
	memset(&param, '\0', sizeof(param));

	m_vec.clear();

	ChannelParamReq req;
	TransformChannelParamReq_All(&req);

	param.ParamType = MsgParamIPCImageSet;
	param.Req = &req;
	
	param.ListParamSize = sizeof(RSNetNew_CameraSet_t);
	param.ListParamCallback = ListParamCallback;
	param.UserParam = this;

	if(isDefault)
	{
		if (!RSNetQueryDefaultParam(m_pDevice->GetConnection(), &param, MsgDefaultParam))
			return strRet;
	}
	else
	{
		if (!RSNetQueryParam(m_pDevice->GetConnection(), &param))
			return strRet;
	}

	//
	Json::Value root(Json::arrayValue);
	for(int i=0; i<m_vec.size(); i++)
	{
		StructToJson(i);
		root.append(m_obj);
	}

	Json::FastWriter writer;
	strRet = writer.write(root);

	return strRet;

}

std::string ImgCtrl::QueryOne(int n)
{
	//
	std::string strRet = "err";

	RSNetQueryParamParam param;
	memset(&param, '\0', sizeof(param));

	ChannelParamReq req;
	TransformChannelParamReq_One(&req,n);

	param.ParamType = MsgParamIPCImageSet;
	param.Req = &req;

	param.ListParamSize = sizeof(RSNetNew_CameraSet_t);
	param.ListParamCallback = ListParamSingleCallback;
	param.UserParam = this;

	if(!RSNetQueryParam(m_pDevice->GetConnection(), &param))
		return strRet;

	//
	StructToJson(n);

	Json::FastWriter writer;
	strRet = writer.write(m_obj);
	return strRet;
}

void ImgCtrl::StructToJson(int n)
{
	m_obj.clear();
	m_obj["ch"] = n;

	m_obj["IRCutMode"] = m_vec[n].IRCutMode;
	m_obj["IRCutDelay"] = m_vec[n].IRCutDelay;
	m_obj["IRCutSensitive"] = m_vec[n].IRCutSensitive;
	m_obj["Mirror"] = m_vec[n].Mirror;
	m_obj["Flip"] = m_vec[n].Flip;
	m_obj["Rotate"] = m_vec[n].Rotate;
	m_obj["BackLightMode"] = m_vec[n].BackLightMode;
	m_obj["BackLightLevel"] = m_vec[n].BackLightLevel;
	m_obj["R3dnrMode"] = m_vec[n].R3dnrMode;
	m_obj["R3dnrThreshTarget"] = m_vec[n].R3dnrThreshTarget;
	m_obj["DwdrMode"] = m_vec[n].DwdrMode;
	m_obj["DwdrStrength"] = m_vec[n].DwdrStrength;
	m_obj["GainControlMode"] = m_vec[n].GainControlMode;
	m_obj["WBMode"] = m_vec[n].WBMode;
	m_obj["Rgain"] = m_vec[n].Rgain;
	m_obj["Ggain"] = m_vec[n].Ggain;
	m_obj["Bgain"] = m_vec[n].Bgain;
	m_obj["ShutterMode"] = m_vec[n].ShutterMode;
	m_obj["eShutterSpeed"] = m_vec[n].eShutterSpeed;
	m_obj["FlickerCtrl"] = m_vec[n].FlickerCtrl;
	m_obj["DefogMode"] = m_vec[n].DefogMode;
	m_obj["DefogStrength"] = m_vec[n].DefogStrength;
}

//
int ImgCtrl::SaveAll(std::string strData)
{	
	int ret = false;
	if(strData == "null"){
		return ret;
	}

	Json::Reader reader;
	Json::Value obj;
	if(!reader.parse(strData, obj)){
		return ret;
	}

	if(obj.size() > 1)
	{
		//ImgCtrlҳ棬ûCopySaveҪͨ

		//
		for(int i=0; i<obj.size(); i++)
		{
			m_vec[i].IRCutMode = obj[i]["IRCutMode"].asInt();
			m_vec[i].IRCutSensitive = obj[i]["IRCutSensitive"].asInt();
			m_vec[i].IRCutDelay = obj[i]["IRCutDelay"].asInt();
			m_vec[i].Flip = obj[i]["Flip"].asInt();
			m_vec[i].Mirror = obj[i]["Mirror"].asInt();
			m_vec[i].BackLightMode = obj[i]["BackLightMode"].asInt();
			m_vec[i].BackLightLevel = obj[i]["BackLightLevel"].asInt();
			m_vec[i].R3dnrMode = obj[i]["R3dnrMode"].asInt();
			m_vec[i].R3dnrThreshTarget = obj[i]["R3dnrThreshTarget"].asInt();
			m_vec[i].DwdrMode = obj[i]["DwdrMode"].asInt();
			m_vec[i].DwdrStrength = obj[i]["DwdrStrength"].asInt();
			m_vec[i].GainControlMode = obj[i]["GainControlMode"].asInt();
			m_vec[i].WBMode = obj[i]["WBMode"].asInt();
			m_vec[i].Rgain = obj[i]["Rgain"].asInt();
			m_vec[i].Ggain = obj[i]["Ggain"].asInt();
			m_vec[i].Bgain = obj[i]["Bgain"].asInt();
			m_vec[i].ShutterMode = obj[i]["ShutterMode"].asInt();
			m_vec[i].eShutterSpeed = obj[i]["eShutterSpeed"].asInt();
			m_vec[i].FlickerCtrl = obj[i]["FlickerCtrl"].asInt();
			m_vec[i].DefogMode = obj[i]["DefogMode"].asInt();
			m_vec[i].DefogStrength = obj[i]["DefogStrength"].asInt();
			m_vec[i].Rotate = obj[i]["Rotate"].asInt();
			m_vec[i].StructSize = sizeof(RSNetNew_CameraSet_t);
		}

		//
		RSNetSetParamParam param;
		memset(&param, '\0', sizeof(param));
		param.ParamType = MsgParamIPCImageSet;
		param.ListParams = &m_vec[0];
		param.ListParamNum = m_vec.size();

		if (RSNetSetParam(m_pDevice->GetConnection(), &param))
		{
			ret = true;
		}
		return ret;
	}
	else
	{
		//ImgCtrlҳ棬޸Ĳ档һαһͨ

		//
		int i = 0;
		int sel = obj[i]["ch"].asInt();
		if(sel >= m_vec.size() || m_vec.size() <= 0)
			return ret;
		
		m_vec[sel].IRCutMode = obj[i]["IRCutMode"].asInt();
		m_vec[sel].IRCutSensitive = obj[i]["IRCutSensitive"].asInt();
		m_vec[sel].IRCutDelay = obj[i]["IRCutDelay"].asInt();
		m_vec[sel].Flip = obj[i]["Flip"].asInt();
		m_vec[sel].Mirror = obj[i]["Mirror"].asInt();
		m_vec[sel].BackLightMode = obj[i]["BackLightMode"].asInt();
		m_vec[sel].BackLightLevel = obj[i]["BackLightLevel"].asInt();
		m_vec[sel].R3dnrMode = obj[i]["R3dnrMode"].asInt();
		m_vec[sel].R3dnrThreshTarget = obj[i]["R3dnrThreshTarget"].asInt();
		m_vec[sel].DwdrMode = obj[i]["DwdrMode"].asInt();
		m_vec[sel].DwdrStrength = obj[i]["DwdrStrength"].asInt();
		m_vec[sel].GainControlMode = obj[i]["GainControlMode"].asInt();
		m_vec[sel].WBMode = obj[i]["WBMode"].asInt();
		m_vec[sel].Rgain = obj[i]["Rgain"].asInt();
		m_vec[sel].Ggain = obj[i]["Ggain"].asInt();
		m_vec[sel].Bgain = obj[i]["Bgain"].asInt();
		m_vec[sel].ShutterMode = obj[i]["ShutterMode"].asInt();
		m_vec[sel].eShutterSpeed = obj[i]["eShutterSpeed"].asInt();
		m_vec[sel].FlickerCtrl = obj[i]["FlickerCtrl"].asInt();
		m_vec[sel].DefogMode = obj[i]["DefogMode"].asInt();
		m_vec[sel].DefogStrength = obj[i]["DefogStrength"].asInt();
		m_vec[sel].Rotate = obj[i]["Rotate"].asInt();
		m_vec[sel].StructSize = sizeof(RSNetNew_CameraSet_t);

		//
		RSNetSetParamParam param;
		memset(&param, '\0', sizeof(param));
		param.ParamType = MsgParamIPCImageSet;
		param.ListParams = &m_vec[sel];
		param.ListParamNum = 1;

		if (RSNetSetParam(m_pDevice->GetConnection(), &param))
		{
			ret = true;
		}
		return ret;
	}
}