#include "StdAfx.h"
#include "IntelligentPlan.h"

static void RSNET_CALL AllDataCallback(void* data, void* userParam)
{
	IntelligentPlan* pThis = (IntelligentPlan*)userParam;
	RSNet_SoleScheduleSet_t* RecordSet_t = (RSNet_SoleScheduleSet_t*)data;
	pThis->m_vec.push_back(*RecordSet_t);
}

std::string IntelligentPlan::QueryAll(bool bDefault)
{
	//
	std::string strRet = "err";

	RSNetQueryParamParam param;
	memset(&param, '\0', sizeof(param));

	m_vec.clear();

	ChannelParamReq req;
	TransformChannelParamReq_All(&req);

	param.ParamType = MsgParamSchedule;
	param.Req = &req;

	param.ParamSize = 0;
	param.ParamCallback = NULL;

	param.ListParamSize = sizeof(RSNet_SoleScheduleSet_t);
	param.ListParamCallback = AllDataCallback;

	param.UserParam = this;

	if(bDefault)
	{
		if (!RSNetQueryDefaultParam(m_pDevice->GetConnection(), &param,MsgDefaultParam))
			return strRet;
	}
	else
	{
		if (!RSNetQueryParam(m_pDevice->GetConnection(), &param))
			return strRet;
	}

	//
	Json::Value root(Json::arrayValue);
	for(int i=0; i<m_vec.size(); i++)
	{
		StructToJson(i);
		root.append(m_obj);
	}

	Json::FastWriter writer;
	strRet = writer.write(root);
	return strRet;
}

void IntelligentPlan::StructToJson(int n)
{
	m_obj.clear();
	m_obj["ch"] = n;

	for(int i=0; i<7; i++)
	{
		unsigned long long ull = 0;
		for(int j=0; j<48; j++)
		{
			ull |= (((unsigned long long)m_vec[n].HalfHour[i][j])>>3 & 1) << j;
		}

		Json::Value tmpObj(Json::objectValue);
		tmpObj["NormalLo"] = (unsigned int)ull;
		tmpObj["NormalHi"] = (unsigned int)(ull>>32);
		m_obj["Normal"].append(tmpObj);
	}

	for(int i=0; i<7; i++)
	{
		unsigned long long ull = 0;
		for(int j=0; j<48; j++)
		{
			ull |= (((unsigned long long)m_vec[n].HalfHour[i][j])>>4 & 1) << j;
		}

		Json::Value tmpObj(Json::objectValue);
		tmpObj["MotionLo"] = (unsigned int)ull;
		tmpObj["MotionHi"] = (unsigned int)(ull>>32);
		m_obj["Motion"].append(tmpObj);
	}

	for(int i=0; i<7; i++)
	{
		unsigned long long ull = 0;
		for(int j=0; j<48; j++)
		{
			ull |= (((unsigned long long)m_vec[n].HalfHour[i][j])>>5 & 1) << j;
		}

		Json::Value tmpObj(Json::objectValue);
		tmpObj["AlarmLo"] = (unsigned int)ull;
		tmpObj["AlarmHi"] = (unsigned int)(ull>>32);
		m_obj["Alarm"].append(tmpObj);
	}
}

int IntelligentPlan::SaveAll(std::string strData)
{	
	if(strData == "null"){
		return false;
	}

	Json::Reader reader;
	Json::Value obj;
	if(!reader.parse(strData, obj)){
		return false;
	}

	for(int i=0; i<obj.size(); i++)
	{
		unsigned int Lo;
		unsigned int Hi;

		for (int xq=0; xq<7; xq++)
		{
			Lo = (unsigned int)obj[i]["Normal"][xq]["NormalLo"].asDouble();
			Hi = (unsigned int)obj[i]["Normal"][xq]["NormalHi"].asDouble();
			stdcUint64 ull = (((stdcUint64)Hi)<<32) | ((stdcUint64)Lo & 0xffffffff);

			for(int j=0; j<48; j++)
			{
				m_vec[i].HalfHour[xq][j] &= 0x07;
				m_vec[i].HalfHour[xq][j] |= (ull>>j&1)<<3;
			}
		}

		for (int xq=0; xq<7; xq++)
		{
			Lo = (unsigned int)obj[i]["Motion"][xq]["MotionLo"].asDouble();
			Hi = (unsigned int)obj[i]["Motion"][xq]["MotionHi"].asDouble();
			stdcUint64 ull = (((stdcUint64)Hi)<<32) | ((stdcUint64)Lo & 0xffffffff);

			for(int j=0; j<48; j++)
			{
				m_vec[i].HalfHour[xq][j] |= (ull>>j&1)<<4;
			}
		}

		for (int xq=0; xq<7; xq++)
		{
			Lo = (unsigned int)obj[i]["Alarm"][xq]["AlarmLo"].asDouble();
			Hi = (unsigned int)obj[i]["Alarm"][xq]["AlarmHi"].asDouble();
			stdcUint64 ull = (((stdcUint64)Hi)<<32) | ((stdcUint64)Lo & 0xffffffff);

			for(int j=0; j<48; j++)
			{
				m_vec[i].HalfHour[xq][j] |= (ull>>j&1)<<5;
			}
		}

		m_vec[i].StructSize = sizeof(RSNet_SoleScheduleSet_t);
	}

	///////////////////////////////////////////////////////////////////////
	RSNetSetParamParam param;
	memset(&param, '\0', sizeof(param));
	param.ParamType = MsgParamSchedule;
	param.Param = NULL;
	param.ListParams = &m_vec[0];
	param.ListParamNum = m_vec.size();
	if (RSNetSetParam(m_pDevice->GetConnection(), &param))
	{
		return true;
	}
	return false;
}