#include "StdAfx.h"
#include "LensShade.h"

static void RSNET_CALL ParamDataCallback(void* data, void* userParam)
{
	LensShade * pThis = (LensShade*)userParam;
	memcpy(&pThis->m_Struct, data, sizeof(RSNet_SoleODParam_t));
}

std::string LensShade::QueryAll(bool bDefault)
{
	//
	std::string strRet = "err";

	RSNetQueryParamParam param;
	memset(&param, '\0', sizeof(param));

	memset(&m_Struct, '\0', sizeof(RSNet_SoleODParam_t));
	m_Struct.StructSize = sizeof(RSNet_SoleODParam_t);

	param.ParamType = MsgParamOD;

	ChannelParamReq req;
	TransformChannelParamReq_All(&req);

	param.Req = &req;

	param.ListParamSize = sizeof(RSNet_SoleODParam_t);
	param.ListParamCallback = ParamDataCallback;
	param.UserParam = this;

	if(!RSNetQueryParam(m_pDevice->GetConnection(), &param))
		return strRet;

	//
	m_obj.clear();
	m_obj["EmailLink"] = m_Struct.EmailLink;
	m_obj["ODSwitch"] = m_Struct.ODSwitch;
	m_obj["Sensitivity"] = m_Struct.Sensitivity;

	//
	Json::FastWriter writer;
	strRet = writer.write(m_obj);
	return strRet;
}

int LensShade::SaveAll(std::string strData)
{	
	if(strData == "null"){
		return false;
	}

	Json::Reader reader;
	Json::Value obj;
	if(!reader.parse(strData, obj)){
		return false;
	}

	//
		m_Struct.StructSize = sizeof(RSNet_SoleODParam_t);
		m_Struct.ChannelMask = UINT_MAX;
		m_Struct.EmailLink = obj["EmailLink"].asInt();
		m_Struct.ODSwitch = obj["ODSwitch"].asInt();
		m_Struct.Sensitivity = obj["Sensitivity"].asInt();
	
	//
		RSNetSetParamParam param;
		memset(&param, '\0', sizeof(param));
		param.ParamType = MsgParamOD;
		param.ListParams = &m_Struct;
		param.ListParamNum = 1;

		if(RSNetSetParam(m_pDevice->GetConnection(), &param))
		{
			return true;
		}

		return false;
}
