#include "StdAfx.h"
#include "NetBase.h"

std::string NetBase::QueryAll(bool isDefault)
{
	//
	std::string strRet = "err";

	RSNetQueryParamParamEx param;
	memset(&param,'\0',  sizeof(param));

	memset(&m_Net,'\0',  sizeof(RSNet_NetworkBaseSet_t));
	m_Net.StructSize = sizeof(RSNet_NetworkBaseSet_t);
	param.Param = &m_Net;

	param.ParamSize = sizeof(RSNet_NetworkBaseSet_t);
	param.ParamType = MsgParamNetworkBase;

	if(isDefault)
	{
		if (!RSNetQueryDefaultParamEx(m_pDevice->GetConnection(), &param, MsgDefaultParam))
			return strRet;
	}
	else
	{
		if (!RSNetQueryParamEx(m_pDevice->GetConnection(), &param))
			return strRet;
	}

	//IPv4 
	StructToJson();
	
	//IPv6ѯ
		RSNetQueryParamParamEx param2;
		ZeroMemory(&param2, sizeof(param2));

		ZeroMemory(&m_NetIPv6, sizeof(RSNet_IPV6_t));
		m_NetIPv6.StructSize = sizeof(RSNet_IPV6_t);
		param2.Param = &m_NetIPv6;

		param2.ParamSize = sizeof(RSNet_IPV6_t);
		param2.ParamType = MsgParamIPV6Info;

		if (RSNetQueryParamEx(m_pDevice->GetConnection(), &param2))
		{
			m_obj["Local_ipv6_addr"] = (char*)m_NetIPv6.Local_ipv6_addr;
			m_obj["Global_ipv6_addr"] = (char*)m_NetIPv6.Global_ipv6_addr;
			m_obj["ipv6_dns_addr"] = (char*)m_NetIPv6.ipv6_dns_addr;
			m_obj["prefixlen"] = m_NetIPv6.prefixlen;
		}

	Json::FastWriter writer;
	strRet = writer.write(m_obj);
	return strRet;
}

void NetBase::StructToJson()
{
	m_obj.clear();

	Json::Value obj(Json::objectValue);

	for(int i=0; i<4; i++)
	{
		obj["item"] = m_Net.IPAddr[i];
		m_obj["IPAddr"].append(obj);
	}

	for(int i=0; i<4; i++)
	{
		obj["item"] = m_Net.NetMask[i];
		m_obj["NetMask"].append(obj);
	}

	for(int i=0; i<4; i++)
	{
		obj["item"] = m_Net.GateWay[i];
		m_obj["GateWay"].append(obj);
	}

	for(int i=0; i<4; i++)
	{
		obj["item"] = m_Net.dns1[i];
		m_obj["dns1"].append(obj);
	}

	for(int i=0; i<4; i++)
	{
		obj["item"] = m_Net.dns2[i];
		m_obj["dns2"].append(obj);
	}

	for(int i=0; i<4; i++)
	{
		obj["item"] = m_Net.PPPoEIPaddr[i];
		m_obj["PPPoEIPaddr"].append(obj);
	}

	m_obj["Port"] = m_Net.Port;
	m_obj["WebPort"] = m_Net.WebPort;
	m_obj["NetworkMode"] = m_Net.NetworkMode;
	m_obj["UseUPNP"] = m_Net.UseUPNP;
	m_obj["PPPOEuser"] = (char*)m_Net.PPPOEuser;
	m_obj["Password"] = (char*)m_Net.Password;
	m_obj["MobilePort"] = m_Net.MobilePort;
	m_obj["APN"] = (char*)m_Net.APN;
	m_obj["DialCode"] = (char*)m_Net.DialCode;
	m_obj["WirelessUser"] = (char*)m_Net.WirelessUser;
	m_obj["WirelessPwd"] = (char*)m_Net.WirelessPwd;
	m_obj["EncodeFlag"] = m_Net.EncodeFlag;
	m_obj["PPPoEState"] = m_Net.PPPoEState;
	m_obj["BandWidth"] = m_Net.BandWidth;
	m_obj["IpKBPort"] = m_Net.IpKBPort;
}

int NetBase::SaveAll(std::string strData)
{
	if(strData == "null"){
		return false;
	}

	Json::Reader reader;
	Json::Value obj;
	if(!reader.parse(strData, obj)){
		return false;
	}

	//IPv4 
		for(int i=0; i<4; i++)
		{
			m_Net.dns1[i] = obj["dns1"][i]["item"].asInt();
			m_Net.dns2[i] = obj["dns2"][i]["item"].asInt();
			m_Net.GateWay[i] = obj["GateWay"][i]["item"].asInt();
			m_Net.IPAddr[i] = obj["IPAddr"][i]["item"].asInt();
			m_Net.NetMask[i] = obj["NetMask"][i]["item"].asInt();
		}

		m_Net.NetworkMode = obj["NetworkMode"].asInt();

		if (m_Net.NetworkMode == 1)//PPPOE
		{
			int maxLen = sizeof(m_Net.Password);
			memset(m_Net.Password, '\0', maxLen);
			m_str = obj["Password"].asString();
			int len = m_str.length() < maxLen ? m_str.length() : maxLen;
			memcpy(m_Net.Password, m_str.c_str(), len);

			maxLen = sizeof(m_Net.PPPOEuser);
			memset(m_Net.PPPOEuser, '\0', maxLen);
			m_str = obj["PPPOEuser"].asString();
			len = m_str.length() < maxLen ? m_str.length() : maxLen;
			memcpy(m_Net.PPPOEuser, m_str.c_str(), len);
		}
		else if (m_Net.NetworkMode == 3)//3G
		{
			int maxLen = sizeof(m_Net.APN);
			memset(m_Net.APN, '\0', maxLen);
			m_str = obj["APN"].asString();
			int len = m_str.length() < maxLen ? m_str.length() : maxLen;
			memcpy(m_Net.APN, m_str.c_str(), len);

			maxLen = sizeof(m_Net.DialCode);
			memset(m_Net.DialCode, '\0', maxLen);
			m_str = obj["DialCode"].asString();
			len = m_str.length() < maxLen ? m_str.length() : maxLen;
			memcpy(m_Net.DialCode, m_str.c_str(), len);

			maxLen = sizeof(m_Net.WirelessUser);
			memset(m_Net.WirelessUser, '\0', maxLen);
			m_str = obj["WirelessUser"].asString();
			len = m_str.length() < maxLen ? m_str.length() : maxLen;
			memcpy(m_Net.WirelessUser, m_str.c_str(), len);

			maxLen = sizeof(m_Net.WirelessPwd);
			memset(m_Net.WirelessPwd, '\0', maxLen);
			m_str = obj["WirelessPwd"].asString();
			len = m_str.length() < maxLen ? m_str.length() : maxLen;
			memcpy(m_Net.WirelessPwd, m_str.c_str(), len);
		}

		m_Net.Port = obj["Port"].asInt();
		m_Net.UseUPNP = obj["UseUPNP"].asInt();
		m_Net.WebPort = obj["WebPort"].asInt();
		m_Net.MobilePort = obj["MobilePort"].asInt();
		m_Net.EncodeFlag = obj["EncodeFlag"].asInt();
		m_Net.BandWidth = obj["BandWidth"].asInt();
		m_Net.IpKBPort = obj["IpKBPort"].asInt();

		m_Net.StructSize = sizeof(RSNet_NetworkBaseSet_t);
	//IPv4 

	//IPv6 
		if(m_Net.UseIPV6)
		{
			int maxLen = sizeof(m_NetIPv6.Local_ipv6_addr);
			memset(m_NetIPv6.Local_ipv6_addr, '\0', maxLen);
			m_str = obj["Local_ipv6_addr"].asString();
			int len = m_str.length() < maxLen ? m_str.length() : maxLen;
			memcpy(m_NetIPv6.Local_ipv6_addr, m_str.c_str(), len);

			maxLen = sizeof(m_NetIPv6.Global_ipv6_addr);
			memset(m_NetIPv6.Global_ipv6_addr, '\0', maxLen);
			m_str = obj["Global_ipv6_addr"].asString();
			len = m_str.length() < maxLen ? m_str.length() : maxLen;
			memcpy(m_NetIPv6.Global_ipv6_addr, m_str.c_str(), len);

			maxLen = sizeof(m_NetIPv6.ipv6_dns_addr);
			memset(m_NetIPv6.ipv6_dns_addr, '\0', maxLen);
			m_str = obj["ipv6_dns_addr"].asString();
			len = m_str.length() < maxLen ? m_str.length() : maxLen;
			memcpy(m_NetIPv6.ipv6_dns_addr, m_str.c_str(), len);

			m_NetIPv6.prefixlen = obj["prefixlen"].asInt();
			m_NetIPv6.StructSize = sizeof(RSNet_IPV6_t);
		}
	//IPv6 

	// IPv4
		bool retV4 = false;
		RSNetSetParamParam param;
		memset(&param, '\0', sizeof(param));
		param.ParamType = MsgParamNetworkBase;
		param.Param = &m_Net;
		if (RSNetSetParam(m_pDevice->GetConnection(), &param))
			retV4 = true;

	// IPv6
		bool retV6 = false;
		if(m_Net.UseIPV6)
		{
			RSNetSetParamParam param2;
			memset(&param2, '\0', sizeof(param2));
			param2.ParamType = MsgParamIPV6Info;
			param2.Param = &m_NetIPv6;
			if (RSNetSetParam(m_pDevice->GetConnection(), &param2))
				retV6 = true;
		}

	//ؽ
		if(m_Net.UseIPV6)
		{
			return (retV4 && retV6);
		}
		else
		{
			return (retV4);
		}
}