#include "StdAfx.h"
#include "ParamRemoteUpgrade.h"

CParamRemoteUpgrade::CParamRemoteUpgrade(void)
{
	m_pDevice = NULL;
	m_gUpgrade = NULL;
}

CParamRemoteUpgrade::~CParamRemoteUpgrade(void)
{
}

BOOL CParamRemoteUpgrade::RemoteUpgradeEventProcess(UINT type, long percent)
{
	int status = -1;
    CString str;
	switch(type)
	{
	case RSNetMsgRemoteUpgradeClosed://Ͽ
		{
			status = RSNetMsgRemoteUpgradeClosed;
            str = "RSNetMsgRemoteUpgradeClosed";
			//StopRemoteUpgrade();
		}
		break;
	case RSNetMsgRemoteUpgradeOK://
		{
			status = RSNetMsgRemoteUpgradeOK;
            str = "RSNetMsgRemoteUpgradeOK";
            //StopRemoteUpgrade();
		}
		break;
	case RSNetMsgRemoteUpgradeReadFileFail://ȡļʧ
		{
			status = RSNetMsgRemoteUpgradeReadFileFail;
            str = "RSNetMsgRemoteUpgradeReadFileFail";
            //StopRemoteUpgrade();
		}
		break;
	case RSNetMsgRemoteUpgradeInvalidFile://Ϸļ
		{
			status = RSNetMsgRemoteUpgradeInvalidFile;
            str = "RSNetMsgRemoteUpgradeInvalidFile";
            //StopRemoteUpgrade();
		}
		break;
	case RSNetMsgRemoteUpgradePercent:
		{
			status = percent;
            str = "RSNetMsgRemoteUpgradePercent";
        }
		break;
	case RSNetMsgRemoteUpgradeVerError://ļ豸ƥǰ汾̫
		{
			status = RSNetMsgRemoteUpgradeVerError;
            str = "RSNetMsgRemoteUpgradeVerError";
            //StopRemoteUpgrade();
		}
		break;
	case RSNetMsgRemoteUpgrading://豸
		{
			status = RSNetMsgRemoteUpgrading;
            str = "RSNetMsgRemoteUpgrading";
            //StopRemoteUpgrade();
		}
		break;
	case RSNetMsgRemoteUpgradeVerSame://汾µģûҪ
		{
			status = RSNetMsgRemoteUpgradeVerSame;
            str = "RSNetMsgRemoteUpgradeVerSame";
            //StopRemoteUpgrade();
		}
		break;
	case RSNetMsgRemoteUpgradeLanguageError://޷Ϊ
		{
			status = RSNetMsgRemoteUpgradeLanguageError;
            str = "RSNetMsgRemoteUpgradeLanguageError";
            //StopRemoteUpgrade();
		}
		break;
	case RSNetMsgRemoteInUserInterface: //ûڲ
		{
			status = RSNetMsgRemoteInUserInterface;
            str = "RSNetMsgRemoteInUserInterface";
            //StopRemoteUpgrade();
		}
		break;
	case MsgRemoteUpgradeWriteFlashInProgress://ʼдflash
		{
			status = MsgRemoteUpgradeWriteFlashInProgress;
            str = "MsgRemoteUpgradeWriteFlashInProgress";
        }
		break;
	default:
        str = "unknown type";
        break;
	}	

	if( m_pDevice != NULL){
        CString strmsg;
        strmsg.Format("======%s, percent:%ld\n", str, percent);
        OutputDebugString(strmsg);
	}
	return TRUE;
}

void  RSNET_CALL CParamRemoteUpgrade::RemoteUpgradeCallback(UINT type, void* param, void* userParam)
{
	CParamRemoteUpgrade* pThis = (CParamRemoteUpgrade*)userParam;
	if (pThis != NULL){
		pThis->RemoteUpgradeEventProcess(type,(long)param);
	}
}

LONG CParamRemoteUpgrade::StartRemoteUpgrade( std::string strPath )
{
	if (m_gUpgrade == NULL){

		RSNetRemoteUpgradeParam param = {0};
		param.FileName = strPath.c_str();
		param.UserParam = this;
		param.Callback = RemoteUpgradeCallback;
		if(m_pDevice != NULL){
			LoginRsp* logRsp = m_pDevice->GetLoginRsp();
			if(logRsp != NULL && logRsp->UpgradeType){//IPC?NVR??o?DVR????a?
				param.filetype = 3;
			}
			m_gUpgrade = RSNetStartRemoteUpgrade(m_pDevice->GetConnection(), &param);
			if (m_gUpgrade != NULL){
				return 0;
			}
		}
	}
	return -1;
}

LONG CParamRemoteUpgrade::StopRemoteUpgrade()
{
	if (m_gUpgrade != NULL){
		RSNetStopRemoteUpgrade(&m_gUpgrade);
		m_gUpgrade = NULL;
	}
	return 0;
}
